package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
sealed trait RecordFormatType { def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType }
object RecordFormatType {
  def wrap(value: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType): RecordFormatType = value match {
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion extends RecordFormatType { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType = software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.UNKNOWN_TO_SDK_VERSION }
  case object JSON extends RecordFormatType { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType = software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.JSON }
  case object CSV extends RecordFormatType { override def unwrap: software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType = software.amazon.awssdk.services.kinesisanalytics.model.RecordFormatType.CSV }
}