package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReferenceDataSource(tableName: primitives.InAppTableName, s3ReferenceDataSource: scala.Option[S3ReferenceDataSource] = None, referenceSchema: SourceSchema) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource = {
    import ReferenceDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource.builder().tableName(tableName: java.lang.String).optionallyWith(s3ReferenceDataSource.map(value => value.buildAwsValue()))(_.s3ReferenceDataSource).referenceSchema(referenceSchema.buildAwsValue()).build()
  }
  def asReadOnly: ReferenceDataSource.ReadOnly = ReferenceDataSource.wrap(buildAwsValue())
}
object ReferenceDataSource {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReferenceDataSource = ReferenceDataSource(tableNameValue, s3ReferenceDataSourceValue.map(value => value.editable), referenceSchemaValue.editable)
    def tableNameValue: primitives.InAppTableName
    def s3ReferenceDataSourceValue: scala.Option[S3ReferenceDataSource.ReadOnly]
    def referenceSchemaValue: SourceSchema.ReadOnly
    def tableName: ZIO[Any, Nothing, primitives.InAppTableName] = ZIO.succeed(tableNameValue)
    def s3ReferenceDataSource: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, S3ReferenceDataSource.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3ReferenceDataSource", s3ReferenceDataSourceValue)
    def referenceSchema: ZIO[Any, Nothing, SourceSchema.ReadOnly] = ZIO.succeed(referenceSchemaValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource) extends ReferenceDataSource.ReadOnly {
    override def tableNameValue: primitives.InAppTableName = impl.tableName(): primitives.InAppTableName
    override def s3ReferenceDataSourceValue: scala.Option[S3ReferenceDataSource.ReadOnly] = scala.Option(impl.s3ReferenceDataSource()).map(value => S3ReferenceDataSource.wrap(value))
    override def referenceSchemaValue: SourceSchema.ReadOnly = SourceSchema.wrap(impl.referenceSchema())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSource): ReadOnly = new Wrapper(impl)
}