package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReferenceDataSourceDescription(referenceId: primitives.Id, tableName: primitives.InAppTableName, s3ReferenceDataSourceDescription: S3ReferenceDataSourceDescription, referenceSchema: scala.Option[SourceSchema] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription = {
    import ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription.builder().referenceId(referenceId: java.lang.String).tableName(tableName: java.lang.String).s3ReferenceDataSourceDescription(s3ReferenceDataSourceDescription.buildAwsValue()).optionallyWith(referenceSchema.map(value => value.buildAwsValue()))(_.referenceSchema).build()
  }
  def asReadOnly: ReferenceDataSourceDescription.ReadOnly = ReferenceDataSourceDescription.wrap(buildAwsValue())
}
object ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReferenceDataSourceDescription = ReferenceDataSourceDescription(referenceIdValue, tableNameValue, s3ReferenceDataSourceDescriptionValue.editable, referenceSchemaValue.map(value => value.editable))
    def referenceIdValue: primitives.Id
    def tableNameValue: primitives.InAppTableName
    def s3ReferenceDataSourceDescriptionValue: S3ReferenceDataSourceDescription.ReadOnly
    def referenceSchemaValue: scala.Option[SourceSchema.ReadOnly]
    def referenceId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(referenceIdValue)
    def tableName: ZIO[Any, Nothing, primitives.InAppTableName] = ZIO.succeed(tableNameValue)
    def s3ReferenceDataSourceDescription: ZIO[Any, Nothing, S3ReferenceDataSourceDescription.ReadOnly] = ZIO.succeed(s3ReferenceDataSourceDescriptionValue)
    def referenceSchema: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("referenceSchema", referenceSchemaValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription) extends ReferenceDataSourceDescription.ReadOnly {
    override def referenceIdValue: primitives.Id = impl.referenceId(): primitives.Id
    override def tableNameValue: primitives.InAppTableName = impl.tableName(): primitives.InAppTableName
    override def s3ReferenceDataSourceDescriptionValue: S3ReferenceDataSourceDescription.ReadOnly = S3ReferenceDataSourceDescription.wrap(impl.s3ReferenceDataSourceDescription())
    override def referenceSchemaValue: scala.Option[SourceSchema.ReadOnly] = scala.Option(impl.referenceSchema()).map(value => SourceSchema.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceDescription): ReadOnly = new Wrapper(impl)
}