package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ReferenceDataSourceUpdate(referenceId: primitives.Id, tableNameUpdate: scala.Option[primitives.InAppTableName] = None, s3ReferenceDataSourceUpdate: scala.Option[S3ReferenceDataSourceUpdate] = None, referenceSchemaUpdate: scala.Option[SourceSchema] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate = {
    import ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate.builder().referenceId(referenceId: java.lang.String).optionallyWith(tableNameUpdate.map(value => value: java.lang.String))(_.tableNameUpdate).optionallyWith(s3ReferenceDataSourceUpdate.map(value => value.buildAwsValue()))(_.s3ReferenceDataSourceUpdate).optionallyWith(referenceSchemaUpdate.map(value => value.buildAwsValue()))(_.referenceSchemaUpdate).build()
  }
  def asReadOnly: ReferenceDataSourceUpdate.ReadOnly = ReferenceDataSourceUpdate.wrap(buildAwsValue())
}
object ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ReferenceDataSourceUpdate = ReferenceDataSourceUpdate(referenceIdValue, tableNameUpdateValue.map(value => value), s3ReferenceDataSourceUpdateValue.map(value => value.editable), referenceSchemaUpdateValue.map(value => value.editable))
    def referenceIdValue: primitives.Id
    def tableNameUpdateValue: scala.Option[primitives.InAppTableName]
    def s3ReferenceDataSourceUpdateValue: scala.Option[S3ReferenceDataSourceUpdate.ReadOnly]
    def referenceSchemaUpdateValue: scala.Option[SourceSchema.ReadOnly]
    def referenceId: ZIO[Any, Nothing, primitives.Id] = ZIO.succeed(referenceIdValue)
    def tableNameUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.InAppTableName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tableNameUpdate", tableNameUpdateValue)
    def s3ReferenceDataSourceUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, S3ReferenceDataSourceUpdate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3ReferenceDataSourceUpdate", s3ReferenceDataSourceUpdateValue)
    def referenceSchemaUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceSchema.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("referenceSchemaUpdate", referenceSchemaUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate) extends ReferenceDataSourceUpdate.ReadOnly {
    override def referenceIdValue: primitives.Id = impl.referenceId(): primitives.Id
    override def tableNameUpdateValue: scala.Option[primitives.InAppTableName] = scala.Option(impl.tableNameUpdate()).map(value => value: primitives.InAppTableName)
    override def s3ReferenceDataSourceUpdateValue: scala.Option[S3ReferenceDataSourceUpdate.ReadOnly] = scala.Option(impl.s3ReferenceDataSourceUpdate()).map(value => S3ReferenceDataSourceUpdate.wrap(value))
    override def referenceSchemaUpdateValue: scala.Option[SourceSchema.ReadOnly] = scala.Option(impl.referenceSchemaUpdate()).map(value => SourceSchema.wrap(value))
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.ReferenceDataSourceUpdate): ReadOnly = new Wrapper(impl)
}