package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class S3Configuration(roleARN: primitives.RoleARN, bucketARN: primitives.BucketARN, fileKey: primitives.FileKey) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration = {
    import S3Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration.builder().roleARN(roleARN: java.lang.String).bucketARN(bucketARN: java.lang.String).fileKey(fileKey: java.lang.String).build()
  }
  def asReadOnly: S3Configuration.ReadOnly = S3Configuration.wrap(buildAwsValue())
}
object S3Configuration {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: S3Configuration = S3Configuration(roleARNValue, bucketARNValue, fileKeyValue)
    def roleARNValue: primitives.RoleARN
    def bucketARNValue: primitives.BucketARN
    def fileKeyValue: primitives.FileKey
    def roleARN: ZIO[Any, Nothing, primitives.RoleARN] = ZIO.succeed(roleARNValue)
    def bucketARN: ZIO[Any, Nothing, primitives.BucketARN] = ZIO.succeed(bucketARNValue)
    def fileKey: ZIO[Any, Nothing, primitives.FileKey] = ZIO.succeed(fileKeyValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration) extends S3Configuration.ReadOnly {
    override def roleARNValue: primitives.RoleARN = impl.roleARN(): primitives.RoleARN
    override def bucketARNValue: primitives.BucketARN = impl.bucketARN(): primitives.BucketARN
    override def fileKeyValue: primitives.FileKey = impl.fileKey(): primitives.FileKey
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3Configuration): ReadOnly = new Wrapper(impl)
}