package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class S3ReferenceDataSourceDescription(bucketARN: primitives.BucketARN, fileKey: primitives.FileKey, referenceRoleARN: primitives.RoleARN) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription = {
    import S3ReferenceDataSourceDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription.builder().bucketARN(bucketARN: java.lang.String).fileKey(fileKey: java.lang.String).referenceRoleARN(referenceRoleARN: java.lang.String).build()
  }
  def asReadOnly: S3ReferenceDataSourceDescription.ReadOnly = S3ReferenceDataSourceDescription.wrap(buildAwsValue())
}
object S3ReferenceDataSourceDescription {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: S3ReferenceDataSourceDescription = S3ReferenceDataSourceDescription(bucketARNValue, fileKeyValue, referenceRoleARNValue)
    def bucketARNValue: primitives.BucketARN
    def fileKeyValue: primitives.FileKey
    def referenceRoleARNValue: primitives.RoleARN
    def bucketARN: ZIO[Any, Nothing, primitives.BucketARN] = ZIO.succeed(bucketARNValue)
    def fileKey: ZIO[Any, Nothing, primitives.FileKey] = ZIO.succeed(fileKeyValue)
    def referenceRoleARN: ZIO[Any, Nothing, primitives.RoleARN] = ZIO.succeed(referenceRoleARNValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription) extends S3ReferenceDataSourceDescription.ReadOnly {
    override def bucketARNValue: primitives.BucketARN = impl.bucketARN(): primitives.BucketARN
    override def fileKeyValue: primitives.FileKey = impl.fileKey(): primitives.FileKey
    override def referenceRoleARNValue: primitives.RoleARN = impl.referenceRoleARN(): primitives.RoleARN
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceDescription): ReadOnly = new Wrapper(impl)
}