package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class S3ReferenceDataSourceUpdate(bucketARNUpdate: scala.Option[primitives.BucketARN] = None, fileKeyUpdate: scala.Option[primitives.FileKey] = None, referenceRoleARNUpdate: scala.Option[primitives.RoleARN] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate = {
    import S3ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate.builder().optionallyWith(bucketARNUpdate.map(value => value: java.lang.String))(_.bucketARNUpdate).optionallyWith(fileKeyUpdate.map(value => value: java.lang.String))(_.fileKeyUpdate).optionallyWith(referenceRoleARNUpdate.map(value => value: java.lang.String))(_.referenceRoleARNUpdate).build()
  }
  def asReadOnly: S3ReferenceDataSourceUpdate.ReadOnly = S3ReferenceDataSourceUpdate.wrap(buildAwsValue())
}
object S3ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: S3ReferenceDataSourceUpdate = S3ReferenceDataSourceUpdate(bucketARNUpdateValue.map(value => value), fileKeyUpdateValue.map(value => value), referenceRoleARNUpdateValue.map(value => value))
    def bucketARNUpdateValue: scala.Option[primitives.BucketARN]
    def fileKeyUpdateValue: scala.Option[primitives.FileKey]
    def referenceRoleARNUpdateValue: scala.Option[primitives.RoleARN]
    def bucketARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BucketARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdateValue)
    def fileKeyUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.FileKey] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fileKeyUpdate", fileKeyUpdateValue)
    def referenceRoleARNUpdate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleARN] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("referenceRoleARNUpdate", referenceRoleARNUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate) extends S3ReferenceDataSourceUpdate.ReadOnly {
    override def bucketARNUpdateValue: scala.Option[primitives.BucketARN] = scala.Option(impl.bucketARNUpdate()).map(value => value: primitives.BucketARN)
    override def fileKeyUpdateValue: scala.Option[primitives.FileKey] = scala.Option(impl.fileKeyUpdate()).map(value => value: primitives.FileKey)
    override def referenceRoleARNUpdateValue: scala.Option[primitives.RoleARN] = scala.Option(impl.referenceRoleARNUpdate()).map(value => value: primitives.RoleARN)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.S3ReferenceDataSourceUpdate): ReadOnly = new Wrapper(impl)
}