package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class SourceSchema(recordFormat: RecordFormat, recordEncoding: scala.Option[primitives.RecordEncoding] = None, recordColumns: Iterable[RecordColumn]) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema = {
    import SourceSchema.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema.builder().recordFormat(recordFormat.buildAwsValue()).optionallyWith(recordEncoding.map(value => value: java.lang.String))(_.recordEncoding).recordColumns(recordColumns.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: SourceSchema.ReadOnly = SourceSchema.wrap(buildAwsValue())
}
object SourceSchema {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: SourceSchema = SourceSchema(recordFormatValue.editable, recordEncodingValue.map(value => value), recordColumnsValue.map { item => 
      item.editable
    })
    def recordFormatValue: RecordFormat.ReadOnly
    def recordEncodingValue: scala.Option[primitives.RecordEncoding]
    def recordColumnsValue: List[RecordColumn.ReadOnly]
    def recordFormat: ZIO[Any, Nothing, RecordFormat.ReadOnly] = ZIO.succeed(recordFormatValue)
    def recordEncoding: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RecordEncoding] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("recordEncoding", recordEncodingValue)
    def recordColumns: ZIO[Any, Nothing, List[RecordColumn.ReadOnly]] = ZIO.succeed(recordColumnsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema) extends SourceSchema.ReadOnly {
    override def recordFormatValue: RecordFormat.ReadOnly = RecordFormat.wrap(impl.recordFormat())
    override def recordEncodingValue: scala.Option[primitives.RecordEncoding] = scala.Option(impl.recordEncoding()).map(value => value: primitives.RecordEncoding)
    override def recordColumnsValue: List[RecordColumn.ReadOnly] = impl.recordColumns().asScala.map { item => 
      RecordColumn.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.SourceSchema): ReadOnly = new Wrapper(impl)
}