package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StartApplicationRequest(applicationName: primitives.ApplicationName, inputConfigurations: Iterable[InputConfiguration]) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest = {
    import StartApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest.builder().applicationName(applicationName: java.lang.String).inputConfigurations(inputConfigurations.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: StartApplicationRequest.ReadOnly = StartApplicationRequest.wrap(buildAwsValue())
}
object StartApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StartApplicationRequest = StartApplicationRequest(applicationNameValue, inputConfigurationsValue.map { item => 
      item.editable
    })
    def applicationNameValue: primitives.ApplicationName
    def inputConfigurationsValue: List[InputConfiguration.ReadOnly]
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def inputConfigurations: ZIO[Any, Nothing, List[InputConfiguration.ReadOnly]] = ZIO.succeed(inputConfigurationsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest) extends StartApplicationRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def inputConfigurationsValue: List[InputConfiguration.ReadOnly] = impl.inputConfigurations().asScala.map { item => 
      InputConfiguration.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest): ReadOnly = new Wrapper(impl)
}