package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class StopApplicationRequest(applicationName: primitives.ApplicationName) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest = {
    import StopApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest.builder().applicationName(applicationName: java.lang.String).build()
  }
  def asReadOnly: StopApplicationRequest.ReadOnly = StopApplicationRequest.wrap(buildAwsValue())
}
object StopApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: StopApplicationRequest = StopApplicationRequest(applicationNameValue)
    def applicationNameValue: primitives.ApplicationName
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest) extends StopApplicationRequest.ReadOnly { override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest): ReadOnly = new Wrapper(impl)
}