package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class Tag(key: primitives.TagKey, value: scala.Option[primitives.TagValue] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.Tag.builder().key(key: java.lang.String).optionallyWith(value.map(value => value: java.lang.String))(_.value).build()
  }
  def asReadOnly: Tag.ReadOnly = Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.Tag] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: Tag = Tag(keyValue, valueValue.map(value => value))
    def keyValue: primitives.TagKey
    def valueValue: scala.Option[primitives.TagValue]
    def key: ZIO[Any, Nothing, primitives.TagKey] = ZIO.succeed(keyValue)
    def value: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TagValue] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.Tag) extends Tag.ReadOnly {
    override def keyValue: primitives.TagKey = impl.key(): primitives.TagKey
    override def valueValue: scala.Option[primitives.TagValue] = scala.Option(impl.value()).map(value => value: primitives.TagValue)
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.Tag): ReadOnly = new Wrapper(impl)
}