package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class TagResourceRequest(resourceARN: primitives.KinesisAnalyticsARN, tags: Iterable[Tag]) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest.builder().resourceARN(resourceARN: java.lang.String).tags(tags.map { item => 
      item.buildAwsValue()
    }.asJavaCollection).build()
  }
  def asReadOnly: TagResourceRequest.ReadOnly = TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: TagResourceRequest = TagResourceRequest(resourceARNValue, tagsValue.map { item => 
      item.editable
    })
    def resourceARNValue: primitives.KinesisAnalyticsARN
    def tagsValue: List[Tag.ReadOnly]
    def resourceARN: ZIO[Any, Nothing, primitives.KinesisAnalyticsARN] = ZIO.succeed(resourceARNValue)
    def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest) extends TagResourceRequest.ReadOnly {
    override def resourceARNValue: primitives.KinesisAnalyticsARN = impl.resourceARN(): primitives.KinesisAnalyticsARN
    override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
      Tag.wrap(item)
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest): ReadOnly = new Wrapper(impl)
}