package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UntagResourceRequest(resourceARN: primitives.KinesisAnalyticsARN, tagKeys: Iterable[primitives.TagKey]) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest.builder().resourceARN(resourceARN: java.lang.String).tagKeys(tagKeys.map { item => 
      item: java.lang.String
    }.asJavaCollection).build()
  }
  def asReadOnly: UntagResourceRequest.ReadOnly = UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UntagResourceRequest = UntagResourceRequest(resourceARNValue, tagKeysValue)
    def resourceARNValue: primitives.KinesisAnalyticsARN
    def tagKeysValue: List[primitives.TagKey]
    def resourceARN: ZIO[Any, Nothing, primitives.KinesisAnalyticsARN] = ZIO.succeed(resourceARNValue)
    def tagKeys: ZIO[Any, Nothing, List[primitives.TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest) extends UntagResourceRequest.ReadOnly {
    override def resourceARNValue: primitives.KinesisAnalyticsARN = impl.resourceARN(): primitives.KinesisAnalyticsARN
    override def tagKeysValue: List[primitives.TagKey] = impl.tagKeys().asScala.map { item => 
      item: primitives.TagKey
    }.toList
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest): ReadOnly = new Wrapper(impl)
}