package io.github.vigoo.zioaws.kinesisanalytics.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class UpdateApplicationRequest(applicationName: primitives.ApplicationName, currentApplicationVersionId: primitives.ApplicationVersionId, applicationUpdate: ApplicationUpdate) {
  def buildAwsValue(): software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest.builder().applicationName(applicationName: java.lang.String).currentApplicationVersionId(currentApplicationVersionId: java.lang.Long).applicationUpdate(applicationUpdate.buildAwsValue()).build()
  }
  def asReadOnly: UpdateApplicationRequest.ReadOnly = UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: UpdateApplicationRequest = UpdateApplicationRequest(applicationNameValue, currentApplicationVersionIdValue, applicationUpdateValue.editable)
    def applicationNameValue: primitives.ApplicationName
    def currentApplicationVersionIdValue: primitives.ApplicationVersionId
    def applicationUpdateValue: ApplicationUpdate.ReadOnly
    def applicationName: ZIO[Any, Nothing, primitives.ApplicationName] = ZIO.succeed(applicationNameValue)
    def currentApplicationVersionId: ZIO[Any, Nothing, primitives.ApplicationVersionId] = ZIO.succeed(currentApplicationVersionIdValue)
    def applicationUpdate: ZIO[Any, Nothing, ApplicationUpdate.ReadOnly] = ZIO.succeed(applicationUpdateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest) extends UpdateApplicationRequest.ReadOnly {
    override def applicationNameValue: primitives.ApplicationName = impl.applicationName(): primitives.ApplicationName
    override def currentApplicationVersionIdValue: primitives.ApplicationVersionId = impl.currentApplicationVersionId(): primitives.ApplicationVersionId
    override def applicationUpdateValue: ApplicationUpdate.ReadOnly = ApplicationUpdate.wrap(impl.applicationUpdate())
  }
  def wrap(impl: software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest): ReadOnly = new Wrapper(impl)
}