package io.github.vigoo.zioaws.kinesisanalytics
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type ApplicationCode = String
    type ApplicationDescription = String
    type ApplicationName = String
    type ApplicationVersionId = Long
    type BooleanObject = Boolean
    type BucketARN = String
    type FileKey = String
    type Id = String
    type InAppStreamName = String
    type InAppTableName = String
    type InputParallelismCount = Int
    type KinesisAnalyticsARN = String
    type ListApplicationsInputLimit = Int
    type LogStreamARN = String
    type ParsedInputRecordField = String
    type ProcessedInputRecord = String
    type RawInputRecord = String
    type RecordColumnDelimiter = String
    type RecordColumnMapping = String
    type RecordColumnName = String
    type RecordColumnSqlType = String
    type RecordEncoding = String
    type RecordRowDelimiter = String
    type RecordRowPath = String
    type ResourceARN = String
    type RoleARN = String
    type TagKey = String
    type TagValue = String
    type Timestamp = Instant
  }
  type ApplicationSummaries = List[ApplicationSummary]
  type CloudWatchLoggingOptionDescriptions = List[CloudWatchLoggingOptionDescription]
  type CloudWatchLoggingOptionUpdates = List[CloudWatchLoggingOptionUpdate]
  type CloudWatchLoggingOptions = List[CloudWatchLoggingOption]
  type InAppStreamNames = List[primitives.InAppStreamName]
  type InputConfigurations = List[InputConfiguration]
  type InputDescriptions = List[InputDescription]
  type InputUpdates = List[InputUpdate]
  type Inputs = List[Input]
  type OutputDescriptions = List[OutputDescription]
  type OutputUpdates = List[OutputUpdate]
  type Outputs = List[Output]
  type ParsedInputRecord = List[primitives.ParsedInputRecordField]
  type ParsedInputRecords = List[Iterable[primitives.ParsedInputRecordField]]
  type ProcessedInputRecords = List[primitives.ProcessedInputRecord]
  type RawInputRecords = List[primitives.RawInputRecord]
  type RecordColumns = List[RecordColumn]
  type ReferenceDataSourceDescriptions = List[ReferenceDataSourceDescription]
  type ReferenceDataSourceUpdates = List[ReferenceDataSourceUpdate]
  type TagKeys = List[primitives.TagKey]
  type Tags = List[Tag]
}