package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.kinesisanalytics.{ KinesisAnalyticsAsyncClient, KinesisAnalyticsAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object kinesisanalytics {
  type KinesisAnalytics = Has[KinesisAnalytics.Service]
  object KinesisAnalytics {
    trait Service extends AspectSupport[Service] {
      val api: KinesisAnalyticsAsyncClient
      def deleteApplication(request: model.DeleteApplicationRequest): IO[AwsError, model.DeleteApplicationResponse.ReadOnly]
      def addApplicationReferenceDataSource(request: model.AddApplicationReferenceDataSourceRequest): IO[AwsError, model.AddApplicationReferenceDataSourceResponse.ReadOnly]
      def describeApplication(request: model.DescribeApplicationRequest): IO[AwsError, model.DescribeApplicationResponse.ReadOnly]
      def deleteApplicationOutput(request: model.DeleteApplicationOutputRequest): IO[AwsError, model.DeleteApplicationOutputResponse.ReadOnly]
      def createApplication(request: model.CreateApplicationRequest): IO[AwsError, model.CreateApplicationResponse.ReadOnly]
      def discoverInputSchema(request: model.DiscoverInputSchemaRequest): IO[AwsError, model.DiscoverInputSchemaResponse.ReadOnly]
      def deleteApplicationInputProcessingConfiguration(request: model.DeleteApplicationInputProcessingConfigurationRequest): IO[AwsError, model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly]
      def addApplicationCloudWatchLoggingOption(request: model.AddApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly]
      def addApplicationOutput(request: model.AddApplicationOutputRequest): IO[AwsError, model.AddApplicationOutputResponse.ReadOnly]
      def startApplication(request: model.StartApplicationRequest): IO[AwsError, model.StartApplicationResponse.ReadOnly]
      def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly]
      def deleteApplicationCloudWatchLoggingOption(request: model.DeleteApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly]
      def addApplicationInputProcessingConfiguration(request: model.AddApplicationInputProcessingConfigurationRequest): IO[AwsError, model.AddApplicationInputProcessingConfigurationResponse.ReadOnly]
      def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly]
      def addApplicationInput(request: model.AddApplicationInputRequest): IO[AwsError, model.AddApplicationInputResponse.ReadOnly]
      def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly]
      def listApplications(request: model.ListApplicationsRequest): IO[AwsError, model.ListApplicationsResponse.ReadOnly]
      def updateApplication(request: model.UpdateApplicationRequest): IO[AwsError, model.UpdateApplicationResponse.ReadOnly]
      def deleteApplicationReferenceDataSource(request: model.DeleteApplicationReferenceDataSourceRequest): IO[AwsError, model.DeleteApplicationReferenceDataSourceResponse.ReadOnly]
      def stopApplication(request: model.StopApplicationRequest): IO[AwsError, model.StopApplicationResponse.ReadOnly]
    }
    object KinesisAnalyticsMock extends zio.test.mock.Mock[KinesisAnalytics] {
      object DeleteApplication extends Effect[model.DeleteApplicationRequest, AwsError, model.DeleteApplicationResponse.ReadOnly]
      object AddApplicationReferenceDataSource extends Effect[model.AddApplicationReferenceDataSourceRequest, AwsError, model.AddApplicationReferenceDataSourceResponse.ReadOnly]
      object DescribeApplication extends Effect[model.DescribeApplicationRequest, AwsError, model.DescribeApplicationResponse.ReadOnly]
      object DeleteApplicationOutput extends Effect[model.DeleteApplicationOutputRequest, AwsError, model.DeleteApplicationOutputResponse.ReadOnly]
      object CreateApplication extends Effect[model.CreateApplicationRequest, AwsError, model.CreateApplicationResponse.ReadOnly]
      object DiscoverInputSchema extends Effect[model.DiscoverInputSchemaRequest, AwsError, model.DiscoverInputSchemaResponse.ReadOnly]
      object DeleteApplicationInputProcessingConfiguration extends Effect[model.DeleteApplicationInputProcessingConfigurationRequest, AwsError, model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly]
      object AddApplicationCloudWatchLoggingOption extends Effect[model.AddApplicationCloudWatchLoggingOptionRequest, AwsError, model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly]
      object AddApplicationOutput extends Effect[model.AddApplicationOutputRequest, AwsError, model.AddApplicationOutputResponse.ReadOnly]
      object StartApplication extends Effect[model.StartApplicationRequest, AwsError, model.StartApplicationResponse.ReadOnly]
      object UntagResource extends Effect[model.UntagResourceRequest, AwsError, model.UntagResourceResponse.ReadOnly]
      object DeleteApplicationCloudWatchLoggingOption extends Effect[model.DeleteApplicationCloudWatchLoggingOptionRequest, AwsError, model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly]
      object AddApplicationInputProcessingConfiguration extends Effect[model.AddApplicationInputProcessingConfigurationRequest, AwsError, model.AddApplicationInputProcessingConfigurationResponse.ReadOnly]
      object ListTagsForResource extends Effect[model.ListTagsForResourceRequest, AwsError, model.ListTagsForResourceResponse.ReadOnly]
      object AddApplicationInput extends Effect[model.AddApplicationInputRequest, AwsError, model.AddApplicationInputResponse.ReadOnly]
      object TagResource extends Effect[model.TagResourceRequest, AwsError, model.TagResourceResponse.ReadOnly]
      object ListApplications extends Effect[model.ListApplicationsRequest, AwsError, model.ListApplicationsResponse.ReadOnly]
      object UpdateApplication extends Effect[model.UpdateApplicationRequest, AwsError, model.UpdateApplicationResponse.ReadOnly]
      object DeleteApplicationReferenceDataSource extends Effect[model.DeleteApplicationReferenceDataSourceRequest, AwsError, model.DeleteApplicationReferenceDataSourceResponse.ReadOnly]
      object StopApplication extends Effect[model.StopApplicationRequest, AwsError, model.StopApplicationResponse.ReadOnly]
      val compose: URLayer[Has[zio.test.mock.Proxy], KinesisAnalytics] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new KinesisAnalytics.Service {
            val api: KinesisAnalyticsAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): KinesisAnalytics.Service = this
            def deleteApplication(request: model.DeleteApplicationRequest): IO[AwsError, model.DeleteApplicationResponse.ReadOnly] = proxy(DeleteApplication, request)
            def addApplicationReferenceDataSource(request: model.AddApplicationReferenceDataSourceRequest): IO[AwsError, model.AddApplicationReferenceDataSourceResponse.ReadOnly] = proxy(AddApplicationReferenceDataSource, request)
            def describeApplication(request: model.DescribeApplicationRequest): IO[AwsError, model.DescribeApplicationResponse.ReadOnly] = proxy(DescribeApplication, request)
            def deleteApplicationOutput(request: model.DeleteApplicationOutputRequest): IO[AwsError, model.DeleteApplicationOutputResponse.ReadOnly] = proxy(DeleteApplicationOutput, request)
            def createApplication(request: model.CreateApplicationRequest): IO[AwsError, model.CreateApplicationResponse.ReadOnly] = proxy(CreateApplication, request)
            def discoverInputSchema(request: model.DiscoverInputSchemaRequest): IO[AwsError, model.DiscoverInputSchemaResponse.ReadOnly] = proxy(DiscoverInputSchema, request)
            def deleteApplicationInputProcessingConfiguration(request: model.DeleteApplicationInputProcessingConfigurationRequest): IO[AwsError, model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly] = proxy(DeleteApplicationInputProcessingConfiguration, request)
            def addApplicationCloudWatchLoggingOption(request: model.AddApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly] = proxy(AddApplicationCloudWatchLoggingOption, request)
            def addApplicationOutput(request: model.AddApplicationOutputRequest): IO[AwsError, model.AddApplicationOutputResponse.ReadOnly] = proxy(AddApplicationOutput, request)
            def startApplication(request: model.StartApplicationRequest): IO[AwsError, model.StartApplicationResponse.ReadOnly] = proxy(StartApplication, request)
            def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = proxy(UntagResource, request)
            def deleteApplicationCloudWatchLoggingOption(request: model.DeleteApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly] = proxy(DeleteApplicationCloudWatchLoggingOption, request)
            def addApplicationInputProcessingConfiguration(request: model.AddApplicationInputProcessingConfigurationRequest): IO[AwsError, model.AddApplicationInputProcessingConfigurationResponse.ReadOnly] = proxy(AddApplicationInputProcessingConfiguration, request)
            def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = proxy(ListTagsForResource, request)
            def addApplicationInput(request: model.AddApplicationInputRequest): IO[AwsError, model.AddApplicationInputResponse.ReadOnly] = proxy(AddApplicationInput, request)
            def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = proxy(TagResource, request)
            def listApplications(request: model.ListApplicationsRequest): IO[AwsError, model.ListApplicationsResponse.ReadOnly] = proxy(ListApplications, request)
            def updateApplication(request: model.UpdateApplicationRequest): IO[AwsError, model.UpdateApplicationResponse.ReadOnly] = proxy(UpdateApplication, request)
            def deleteApplicationReferenceDataSource(request: model.DeleteApplicationReferenceDataSourceRequest): IO[AwsError, model.DeleteApplicationReferenceDataSourceResponse.ReadOnly] = proxy(DeleteApplicationReferenceDataSource, request)
            def stopApplication(request: model.StopApplicationRequest): IO[AwsError, model.StopApplicationResponse.ReadOnly] = proxy(StopApplication, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, KinesisAnalytics] = customized(identity)
  def customized(customization: KinesisAnalyticsAsyncClientBuilder => KinesisAnalyticsAsyncClientBuilder): ZLayer[AwsConfig, Throwable, KinesisAnalytics] = managed(customization).toLayer
  def managed(customization: KinesisAnalyticsAsyncClientBuilder => KinesisAnalyticsAsyncClientBuilder): ZManaged[AwsConfig, Throwable, KinesisAnalytics.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = KinesisAnalyticsAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[KinesisAnalyticsAsyncClient, KinesisAnalyticsAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[KinesisAnalyticsAsyncClient, KinesisAnalyticsAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new KinesisAnalyticsImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class KinesisAnalyticsImpl[R](override val api: KinesisAnalyticsAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends KinesisAnalytics.Service with AwsServiceBase[R, KinesisAnalyticsImpl] {
    override val serviceName: String = "KinesisAnalytics"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): KinesisAnalyticsImpl[R1] = new KinesisAnalyticsImpl(api, newAspect, r)
    def deleteApplication(request: model.DeleteApplicationRequest): IO[AwsError, model.DeleteApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationResponse]("deleteApplication", api.deleteApplication)(request.buildAwsValue()).map(model.DeleteApplicationResponse.wrap).provide(r)
    def addApplicationReferenceDataSource(request: model.AddApplicationReferenceDataSourceRequest): IO[AwsError, model.AddApplicationReferenceDataSourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceRequest, software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationReferenceDataSourceResponse]("addApplicationReferenceDataSource", api.addApplicationReferenceDataSource)(request.buildAwsValue()).map(model.AddApplicationReferenceDataSourceResponse.wrap).provide(r)
    def describeApplication(request: model.DescribeApplicationRequest): IO[AwsError, model.DescribeApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.DescribeApplicationResponse]("describeApplication", api.describeApplication)(request.buildAwsValue()).map(model.DescribeApplicationResponse.wrap).provide(r)
    def deleteApplicationOutput(request: model.DeleteApplicationOutputRequest): IO[AwsError, model.DeleteApplicationOutputResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputRequest, software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationOutputResponse]("deleteApplicationOutput", api.deleteApplicationOutput)(request.buildAwsValue()).map(model.DeleteApplicationOutputResponse.wrap).provide(r)
    def createApplication(request: model.CreateApplicationRequest): IO[AwsError, model.CreateApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.CreateApplicationResponse]("createApplication", api.createApplication)(request.buildAwsValue()).map(model.CreateApplicationResponse.wrap).provide(r)
    def discoverInputSchema(request: model.DiscoverInputSchemaRequest): IO[AwsError, model.DiscoverInputSchemaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaRequest, software.amazon.awssdk.services.kinesisanalytics.model.DiscoverInputSchemaResponse]("discoverInputSchema", api.discoverInputSchema)(request.buildAwsValue()).map(model.DiscoverInputSchemaResponse.wrap).provide(r)
    def deleteApplicationInputProcessingConfiguration(request: model.DeleteApplicationInputProcessingConfigurationRequest): IO[AwsError, model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationRequest, software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationInputProcessingConfigurationResponse]("deleteApplicationInputProcessingConfiguration", api.deleteApplicationInputProcessingConfiguration)(request.buildAwsValue()).map(model.DeleteApplicationInputProcessingConfigurationResponse.wrap).provide(r)
    def addApplicationCloudWatchLoggingOption(request: model.AddApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionRequest, software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationCloudWatchLoggingOptionResponse]("addApplicationCloudWatchLoggingOption", api.addApplicationCloudWatchLoggingOption)(request.buildAwsValue()).map(model.AddApplicationCloudWatchLoggingOptionResponse.wrap).provide(r)
    def addApplicationOutput(request: model.AddApplicationOutputRequest): IO[AwsError, model.AddApplicationOutputResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputRequest, software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationOutputResponse]("addApplicationOutput", api.addApplicationOutput)(request.buildAwsValue()).map(model.AddApplicationOutputResponse.wrap).provide(r)
    def startApplication(request: model.StartApplicationRequest): IO[AwsError, model.StartApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.StartApplicationResponse]("startApplication", api.startApplication)(request.buildAwsValue()).map(model.StartApplicationResponse.wrap).provide(r)
    def untagResource(request: model.UntagResourceRequest): IO[AwsError, model.UntagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceRequest, software.amazon.awssdk.services.kinesisanalytics.model.UntagResourceResponse]("untagResource", api.untagResource)(request.buildAwsValue()).map(model.UntagResourceResponse.wrap).provide(r)
    def deleteApplicationCloudWatchLoggingOption(request: model.DeleteApplicationCloudWatchLoggingOptionRequest): IO[AwsError, model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionRequest, software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationCloudWatchLoggingOptionResponse]("deleteApplicationCloudWatchLoggingOption", api.deleteApplicationCloudWatchLoggingOption)(request.buildAwsValue()).map(model.DeleteApplicationCloudWatchLoggingOptionResponse.wrap).provide(r)
    def addApplicationInputProcessingConfiguration(request: model.AddApplicationInputProcessingConfigurationRequest): IO[AwsError, model.AddApplicationInputProcessingConfigurationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationRequest, software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputProcessingConfigurationResponse]("addApplicationInputProcessingConfiguration", api.addApplicationInputProcessingConfiguration)(request.buildAwsValue()).map(model.AddApplicationInputProcessingConfigurationResponse.wrap).provide(r)
    def listTagsForResource(request: model.ListTagsForResourceRequest): IO[AwsError, model.ListTagsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceRequest, software.amazon.awssdk.services.kinesisanalytics.model.ListTagsForResourceResponse]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue()).map(model.ListTagsForResourceResponse.wrap).provide(r)
    def addApplicationInput(request: model.AddApplicationInputRequest): IO[AwsError, model.AddApplicationInputResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputRequest, software.amazon.awssdk.services.kinesisanalytics.model.AddApplicationInputResponse]("addApplicationInput", api.addApplicationInput)(request.buildAwsValue()).map(model.AddApplicationInputResponse.wrap).provide(r)
    def tagResource(request: model.TagResourceRequest): IO[AwsError, model.TagResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.TagResourceRequest, software.amazon.awssdk.services.kinesisanalytics.model.TagResourceResponse]("tagResource", api.tagResource)(request.buildAwsValue()).map(model.TagResourceResponse.wrap).provide(r)
    def listApplications(request: model.ListApplicationsRequest): IO[AwsError, model.ListApplicationsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsRequest, software.amazon.awssdk.services.kinesisanalytics.model.ListApplicationsResponse]("listApplications", api.listApplications)(request.buildAwsValue()).map(model.ListApplicationsResponse.wrap).provide(r)
    def updateApplication(request: model.UpdateApplicationRequest): IO[AwsError, model.UpdateApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.UpdateApplicationResponse]("updateApplication", api.updateApplication)(request.buildAwsValue()).map(model.UpdateApplicationResponse.wrap).provide(r)
    def deleteApplicationReferenceDataSource(request: model.DeleteApplicationReferenceDataSourceRequest): IO[AwsError, model.DeleteApplicationReferenceDataSourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest, software.amazon.awssdk.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceResponse]("deleteApplicationReferenceDataSource", api.deleteApplicationReferenceDataSource)(request.buildAwsValue()).map(model.DeleteApplicationReferenceDataSourceResponse.wrap).provide(r)
    def stopApplication(request: model.StopApplicationRequest): IO[AwsError, model.StopApplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationRequest, software.amazon.awssdk.services.kinesisanalytics.model.StopApplicationResponse]("stopApplication", api.stopApplication)(request.buildAwsValue()).map(model.StopApplicationResponse.wrap).provide(r)
  }
  def deleteApplication(request: model.DeleteApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.DeleteApplicationResponse.ReadOnly] = ZIO.accessM(_.get.deleteApplication(request))
  def addApplicationReferenceDataSource(request: model.AddApplicationReferenceDataSourceRequest): ZIO[KinesisAnalytics, AwsError, model.AddApplicationReferenceDataSourceResponse.ReadOnly] = ZIO.accessM(_.get.addApplicationReferenceDataSource(request))
  def describeApplication(request: model.DescribeApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.DescribeApplicationResponse.ReadOnly] = ZIO.accessM(_.get.describeApplication(request))
  def deleteApplicationOutput(request: model.DeleteApplicationOutputRequest): ZIO[KinesisAnalytics, AwsError, model.DeleteApplicationOutputResponse.ReadOnly] = ZIO.accessM(_.get.deleteApplicationOutput(request))
  def createApplication(request: model.CreateApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.CreateApplicationResponse.ReadOnly] = ZIO.accessM(_.get.createApplication(request))
  def discoverInputSchema(request: model.DiscoverInputSchemaRequest): ZIO[KinesisAnalytics, AwsError, model.DiscoverInputSchemaResponse.ReadOnly] = ZIO.accessM(_.get.discoverInputSchema(request))
  def deleteApplicationInputProcessingConfiguration(request: model.DeleteApplicationInputProcessingConfigurationRequest): ZIO[KinesisAnalytics, AwsError, model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.deleteApplicationInputProcessingConfiguration(request))
  def addApplicationCloudWatchLoggingOption(request: model.AddApplicationCloudWatchLoggingOptionRequest): ZIO[KinesisAnalytics, AwsError, model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly] = ZIO.accessM(_.get.addApplicationCloudWatchLoggingOption(request))
  def addApplicationOutput(request: model.AddApplicationOutputRequest): ZIO[KinesisAnalytics, AwsError, model.AddApplicationOutputResponse.ReadOnly] = ZIO.accessM(_.get.addApplicationOutput(request))
  def startApplication(request: model.StartApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.StartApplicationResponse.ReadOnly] = ZIO.accessM(_.get.startApplication(request))
  def untagResource(request: model.UntagResourceRequest): ZIO[KinesisAnalytics, AwsError, model.UntagResourceResponse.ReadOnly] = ZIO.accessM(_.get.untagResource(request))
  def deleteApplicationCloudWatchLoggingOption(request: model.DeleteApplicationCloudWatchLoggingOptionRequest): ZIO[KinesisAnalytics, AwsError, model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly] = ZIO.accessM(_.get.deleteApplicationCloudWatchLoggingOption(request))
  def addApplicationInputProcessingConfiguration(request: model.AddApplicationInputProcessingConfigurationRequest): ZIO[KinesisAnalytics, AwsError, model.AddApplicationInputProcessingConfigurationResponse.ReadOnly] = ZIO.accessM(_.get.addApplicationInputProcessingConfiguration(request))
  def listTagsForResource(request: model.ListTagsForResourceRequest): ZIO[KinesisAnalytics, AwsError, model.ListTagsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.listTagsForResource(request))
  def addApplicationInput(request: model.AddApplicationInputRequest): ZIO[KinesisAnalytics, AwsError, model.AddApplicationInputResponse.ReadOnly] = ZIO.accessM(_.get.addApplicationInput(request))
  def tagResource(request: model.TagResourceRequest): ZIO[KinesisAnalytics, AwsError, model.TagResourceResponse.ReadOnly] = ZIO.accessM(_.get.tagResource(request))
  def listApplications(request: model.ListApplicationsRequest): ZIO[KinesisAnalytics, AwsError, model.ListApplicationsResponse.ReadOnly] = ZIO.accessM(_.get.listApplications(request))
  def updateApplication(request: model.UpdateApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.UpdateApplicationResponse.ReadOnly] = ZIO.accessM(_.get.updateApplication(request))
  def deleteApplicationReferenceDataSource(request: model.DeleteApplicationReferenceDataSourceRequest): ZIO[KinesisAnalytics, AwsError, model.DeleteApplicationReferenceDataSourceResponse.ReadOnly] = ZIO.accessM(_.get.deleteApplicationReferenceDataSource(request))
  def stopApplication(request: model.StopApplicationRequest): ZIO[KinesisAnalytics, AwsError, model.StopApplicationResponse.ReadOnly] = ZIO.accessM(_.get.stopApplication(request))
}