package io.github.vigoo.zioaws.rds
import scala.jdk.CollectionConverters._
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
package object model {
  object primitives {
    type AwsBackupRecoveryPointArn = String
    type BooleanOptional = Boolean
    type DBClusterIdentifier = String
    type DBProxyEndpointName = String
    type DBProxyName = String
    type DoubleOptional = Double
    type GlobalClusterIdentifier = String
    type Integer = Int
    type IntegerOptional = Int
    type LongOptional = Long
    type MaxRecords = Int
    type StringSensitive = String
    type TStamp = Instant
  }
  case class AccountQuota(accountQuotaName: scala.Option[String] = None, used: scala.Option[Long] = None, max: scala.Option[Long] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AccountQuota = {
      import AccountQuota.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AccountQuota.builder().optionallyWith(accountQuotaName.map(value => value: java.lang.String))(_.accountQuotaName).optionallyWith(used.map(value => value: java.lang.Long))(_.used).optionallyWith(max.map(value => value: java.lang.Long))(_.max).build()
    }
    def asReadOnly: AccountQuota.ReadOnly = AccountQuota.wrap(buildAwsValue())
  }
  object AccountQuota {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AccountQuota] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AccountQuota = AccountQuota(accountQuotaNameValue.map(value => value), usedValue.map(value => value), maxValue.map(value => value))
      def accountQuotaNameValue: scala.Option[String]
      def usedValue: scala.Option[Long]
      def maxValue: scala.Option[Long]
      def accountQuotaName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountQuotaName", accountQuotaNameValue)
      def used: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("used", usedValue)
      def max: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("max", maxValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AccountQuota) extends AccountQuota.ReadOnly {
      override def accountQuotaNameValue: scala.Option[String] = scala.Option(impl.accountQuotaName()).map(value => value: String)
      override def usedValue: scala.Option[Long] = scala.Option(impl.used()).map(value => value: Long)
      override def maxValue: scala.Option[Long] = scala.Option(impl.max()).map(value => value: Long)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AccountQuota): ReadOnly = new Wrapper(impl)
  }
  type AccountQuotaList = List[AccountQuota]
  sealed trait ActivityStreamMode { def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamMode }
  object ActivityStreamMode {
    def wrap(value: software.amazon.awssdk.services.rds.model.ActivityStreamMode): ActivityStreamMode = value match {
      case software.amazon.awssdk.services.rds.model.ActivityStreamMode.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.ActivityStreamMode.SYNC => sync
      case software.amazon.awssdk.services.rds.model.ActivityStreamMode.ASYNC => async
    }
    final case object unknownToSdkVersion extends ActivityStreamMode { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamMode = software.amazon.awssdk.services.rds.model.ActivityStreamMode.UNKNOWN_TO_SDK_VERSION }
    final case object sync extends ActivityStreamMode { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamMode = software.amazon.awssdk.services.rds.model.ActivityStreamMode.SYNC }
    final case object async extends ActivityStreamMode { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamMode = software.amazon.awssdk.services.rds.model.ActivityStreamMode.ASYNC }
  }
  sealed trait ActivityStreamStatus { def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus }
  object ActivityStreamStatus {
    def wrap(value: software.amazon.awssdk.services.rds.model.ActivityStreamStatus): ActivityStreamStatus = value match {
      case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPED => stopped
      case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTING => starting
      case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTED => started
      case software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPING => stopping
    }
    final case object unknownToSdkVersion extends ActivityStreamStatus { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus = software.amazon.awssdk.services.rds.model.ActivityStreamStatus.UNKNOWN_TO_SDK_VERSION }
    final case object stopped extends ActivityStreamStatus { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus = software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPED }
    final case object starting extends ActivityStreamStatus { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus = software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTING }
    final case object started extends ActivityStreamStatus { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus = software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STARTED }
    final case object stopping extends ActivityStreamStatus { override def unwrap: software.amazon.awssdk.services.rds.model.ActivityStreamStatus = software.amazon.awssdk.services.rds.model.ActivityStreamStatus.STOPPING }
  }
  case class AddRoleToDbClusterRequest(dbClusterIdentifier: String, roleArn: String, featureName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest = {
      import AddRoleToDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).roleArn(roleArn: java.lang.String).optionallyWith(featureName.map(value => value: java.lang.String))(_.featureName).build()
    }
    def asReadOnly: AddRoleToDbClusterRequest.ReadOnly = AddRoleToDbClusterRequest.wrap(buildAwsValue())
  }
  object AddRoleToDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AddRoleToDbClusterRequest = AddRoleToDbClusterRequest(dbClusterIdentifierValue, roleArnValue, featureNameValue.map(value => value))
      def dbClusterIdentifierValue: String
      def roleArnValue: String
      def featureNameValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def roleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArnValue)
      def featureName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("featureName", featureNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest) extends AddRoleToDbClusterRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def roleArnValue: String = impl.roleArn(): String
      override def featureNameValue: scala.Option[String] = scala.Option(impl.featureName()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class AddRoleToDbInstanceRequest(dbInstanceIdentifier: String, roleArn: String, featureName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest = {
      import AddRoleToDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).roleArn(roleArn: java.lang.String).featureName(featureName: java.lang.String).build()
    }
    def asReadOnly: AddRoleToDbInstanceRequest.ReadOnly = AddRoleToDbInstanceRequest.wrap(buildAwsValue())
  }
  object AddRoleToDbInstanceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AddRoleToDbInstanceRequest = AddRoleToDbInstanceRequest(dbInstanceIdentifierValue, roleArnValue, featureNameValue)
      def dbInstanceIdentifierValue: String
      def roleArnValue: String
      def featureNameValue: String
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def roleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArnValue)
      def featureName: ZIO[Any, Nothing, String] = ZIO.succeed(featureNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest) extends AddRoleToDbInstanceRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def roleArnValue: String = impl.roleArn(): String
      override def featureNameValue: String = impl.featureName(): String
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest): ReadOnly = new Wrapper(impl)
  }
  case class AddSourceIdentifierToSubscriptionRequest(subscriptionName: String, sourceIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest = {
      import AddSourceIdentifierToSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).sourceIdentifier(sourceIdentifier: java.lang.String).build()
    }
    def asReadOnly: AddSourceIdentifierToSubscriptionRequest.ReadOnly = AddSourceIdentifierToSubscriptionRequest.wrap(buildAwsValue())
  }
  object AddSourceIdentifierToSubscriptionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AddSourceIdentifierToSubscriptionRequest = AddSourceIdentifierToSubscriptionRequest(subscriptionNameValue, sourceIdentifierValue)
      def subscriptionNameValue: String
      def sourceIdentifierValue: String
      def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
      def sourceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest) extends AddSourceIdentifierToSubscriptionRequest.ReadOnly {
      override def subscriptionNameValue: String = impl.subscriptionName(): String
      override def sourceIdentifierValue: String = impl.sourceIdentifier(): String
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest): ReadOnly = new Wrapper(impl)
  }
  case class AddSourceIdentifierToSubscriptionResponse(eventSubscription: scala.Option[EventSubscription] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse = {
      import AddSourceIdentifierToSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse.builder().optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(_.eventSubscription).build()
    }
    def asReadOnly: AddSourceIdentifierToSubscriptionResponse.ReadOnly = AddSourceIdentifierToSubscriptionResponse.wrap(buildAwsValue())
  }
  object AddSourceIdentifierToSubscriptionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AddSourceIdentifierToSubscriptionResponse = AddSourceIdentifierToSubscriptionResponse(eventSubscriptionValue.map(value => value.editable))
      def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly]
      def eventSubscription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EventSubscription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscription", eventSubscriptionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse) extends AddSourceIdentifierToSubscriptionResponse.ReadOnly { override def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly] = scala.Option(impl.eventSubscription()).map(value => EventSubscription.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse): ReadOnly = new Wrapper(impl)
  }
  case class AddTagsToResourceRequest(resourceName: String, tags: Iterable[Tag]) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest = {
      import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest.builder().resourceName(resourceName: java.lang.String).tags(tags.map { item => 
        item.buildAwsValue()
      }.asJavaCollection).build()
    }
    def asReadOnly: AddTagsToResourceRequest.ReadOnly = AddTagsToResourceRequest.wrap(buildAwsValue())
  }
  object AddTagsToResourceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AddTagsToResourceRequest = AddTagsToResourceRequest(resourceNameValue, tagsValue.map { item => 
        item.editable
      })
      def resourceNameValue: String
      def tagsValue: List[Tag.ReadOnly]
      def resourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceNameValue)
      def tags: ZIO[Any, Nothing, List[Tag.ReadOnly]] = ZIO.succeed(tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest) extends AddTagsToResourceRequest.ReadOnly {
      override def resourceNameValue: String = impl.resourceName(): String
      override def tagsValue: List[Tag.ReadOnly] = impl.tags().asScala.map { item => 
        Tag.wrap(item)
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest): ReadOnly = new Wrapper(impl)
  }
  sealed trait ApplyMethod { def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod }
  object ApplyMethod {
    def wrap(value: software.amazon.awssdk.services.rds.model.ApplyMethod): ApplyMethod = value match {
      case software.amazon.awssdk.services.rds.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.ApplyMethod.IMMEDIATE => immediate
      case software.amazon.awssdk.services.rds.model.ApplyMethod.PENDING_REBOOT => `pending-reboot`
    }
    final case object unknownToSdkVersion extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod = software.amazon.awssdk.services.rds.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION }
    final case object immediate extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod = software.amazon.awssdk.services.rds.model.ApplyMethod.IMMEDIATE }
    final case object `pending-reboot` extends ApplyMethod { override def unwrap: software.amazon.awssdk.services.rds.model.ApplyMethod = software.amazon.awssdk.services.rds.model.ApplyMethod.PENDING_REBOOT }
  }
  case class ApplyPendingMaintenanceActionRequest(resourceIdentifier: String, applyAction: String, optInType: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest = {
      import ApplyPendingMaintenanceActionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest.builder().resourceIdentifier(resourceIdentifier: java.lang.String).applyAction(applyAction: java.lang.String).optInType(optInType: java.lang.String).build()
    }
    def asReadOnly: ApplyPendingMaintenanceActionRequest.ReadOnly = ApplyPendingMaintenanceActionRequest.wrap(buildAwsValue())
  }
  object ApplyPendingMaintenanceActionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ApplyPendingMaintenanceActionRequest = ApplyPendingMaintenanceActionRequest(resourceIdentifierValue, applyActionValue, optInTypeValue)
      def resourceIdentifierValue: String
      def applyActionValue: String
      def optInTypeValue: String
      def resourceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(resourceIdentifierValue)
      def applyAction: ZIO[Any, Nothing, String] = ZIO.succeed(applyActionValue)
      def optInType: ZIO[Any, Nothing, String] = ZIO.succeed(optInTypeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest) extends ApplyPendingMaintenanceActionRequest.ReadOnly {
      override def resourceIdentifierValue: String = impl.resourceIdentifier(): String
      override def applyActionValue: String = impl.applyAction(): String
      override def optInTypeValue: String = impl.optInType(): String
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest): ReadOnly = new Wrapper(impl)
  }
  case class ApplyPendingMaintenanceActionResponse(resourcePendingMaintenanceActions: scala.Option[ResourcePendingMaintenanceActions] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse = {
      import ApplyPendingMaintenanceActionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse.builder().optionallyWith(resourcePendingMaintenanceActions.map(value => value.buildAwsValue()))(_.resourcePendingMaintenanceActions).build()
    }
    def asReadOnly: ApplyPendingMaintenanceActionResponse.ReadOnly = ApplyPendingMaintenanceActionResponse.wrap(buildAwsValue())
  }
  object ApplyPendingMaintenanceActionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ApplyPendingMaintenanceActionResponse = ApplyPendingMaintenanceActionResponse(resourcePendingMaintenanceActionsValue.map(value => value.editable))
      def resourcePendingMaintenanceActionsValue: scala.Option[ResourcePendingMaintenanceActions.ReadOnly]
      def resourcePendingMaintenanceActions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ResourcePendingMaintenanceActions.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourcePendingMaintenanceActions", resourcePendingMaintenanceActionsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse) extends ApplyPendingMaintenanceActionResponse.ReadOnly { override def resourcePendingMaintenanceActionsValue: scala.Option[ResourcePendingMaintenanceActions.ReadOnly] = scala.Option(impl.resourcePendingMaintenanceActions()).map(value => ResourcePendingMaintenanceActions.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse): ReadOnly = new Wrapper(impl)
  }
  type AttributeValueList = List[String]
  sealed trait AuthScheme { def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme }
  object AuthScheme {
    def wrap(value: software.amazon.awssdk.services.rds.model.AuthScheme): AuthScheme = value match {
      case software.amazon.awssdk.services.rds.model.AuthScheme.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.AuthScheme.SECRETS => SECRETS
    }
    final case object unknownToSdkVersion extends AuthScheme { override def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme = software.amazon.awssdk.services.rds.model.AuthScheme.UNKNOWN_TO_SDK_VERSION }
    final case object SECRETS extends AuthScheme { override def unwrap: software.amazon.awssdk.services.rds.model.AuthScheme = software.amazon.awssdk.services.rds.model.AuthScheme.SECRETS }
  }
  case class AuthorizeDbSecurityGroupIngressRequest(dbSecurityGroupName: String, cidrip: scala.Option[String] = None, ec2SecurityGroupName: scala.Option[String] = None, ec2SecurityGroupId: scala.Option[String] = None, ec2SecurityGroupOwnerId: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest = {
      import AuthorizeDbSecurityGroupIngressRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest.builder().dbSecurityGroupName(dbSecurityGroupName: java.lang.String).optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip).optionallyWith(ec2SecurityGroupName.map(value => value: java.lang.String))(_.ec2SecurityGroupName).optionallyWith(ec2SecurityGroupId.map(value => value: java.lang.String))(_.ec2SecurityGroupId).optionallyWith(ec2SecurityGroupOwnerId.map(value => value: java.lang.String))(_.ec2SecurityGroupOwnerId).build()
    }
    def asReadOnly: AuthorizeDbSecurityGroupIngressRequest.ReadOnly = AuthorizeDbSecurityGroupIngressRequest.wrap(buildAwsValue())
  }
  object AuthorizeDbSecurityGroupIngressRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AuthorizeDbSecurityGroupIngressRequest = AuthorizeDbSecurityGroupIngressRequest(dbSecurityGroupNameValue, cidripValue.map(value => value), ec2SecurityGroupNameValue.map(value => value), ec2SecurityGroupIdValue.map(value => value), ec2SecurityGroupOwnerIdValue.map(value => value))
      def dbSecurityGroupNameValue: String
      def cidripValue: scala.Option[String]
      def ec2SecurityGroupNameValue: scala.Option[String]
      def ec2SecurityGroupIdValue: scala.Option[String]
      def ec2SecurityGroupOwnerIdValue: scala.Option[String]
      def dbSecurityGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSecurityGroupNameValue)
      def cidrip: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrip", cidripValue)
      def ec2SecurityGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupNameValue)
      def ec2SecurityGroupId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupId", ec2SecurityGroupIdValue)
      def ec2SecurityGroupOwnerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest) extends AuthorizeDbSecurityGroupIngressRequest.ReadOnly {
      override def dbSecurityGroupNameValue: String = impl.dbSecurityGroupName(): String
      override def cidripValue: scala.Option[String] = scala.Option(impl.cidrip()).map(value => value: String)
      override def ec2SecurityGroupNameValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
      override def ec2SecurityGroupIdValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupId()).map(value => value: String)
      override def ec2SecurityGroupOwnerIdValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest): ReadOnly = new Wrapper(impl)
  }
  case class AuthorizeDbSecurityGroupIngressResponse(dbSecurityGroup: scala.Option[DBSecurityGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse = {
      import AuthorizeDbSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse.builder().optionallyWith(dbSecurityGroup.map(value => value.buildAwsValue()))(_.dbSecurityGroup).build()
    }
    def asReadOnly: AuthorizeDbSecurityGroupIngressResponse.ReadOnly = AuthorizeDbSecurityGroupIngressResponse.wrap(buildAwsValue())
  }
  object AuthorizeDbSecurityGroupIngressResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AuthorizeDbSecurityGroupIngressResponse = AuthorizeDbSecurityGroupIngressResponse(dbSecurityGroupValue.map(value => value.editable))
      def dbSecurityGroupValue: scala.Option[DBSecurityGroup.ReadOnly]
      def dbSecurityGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSecurityGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroup", dbSecurityGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse) extends AuthorizeDbSecurityGroupIngressResponse.ReadOnly { override def dbSecurityGroupValue: scala.Option[DBSecurityGroup.ReadOnly] = scala.Option(impl.dbSecurityGroup()).map(value => DBSecurityGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse): ReadOnly = new Wrapper(impl)
  }
  case class AvailabilityZone(name: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AvailabilityZone = {
      import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AvailabilityZone.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).build()
    }
    def asReadOnly: AvailabilityZone.ReadOnly = AvailabilityZone.wrap(buildAwsValue())
  }
  object AvailabilityZone {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AvailabilityZone] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AvailabilityZone = AvailabilityZone(nameValue.map(value => value))
      def nameValue: scala.Option[String]
      def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AvailabilityZone) extends AvailabilityZone.ReadOnly { override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AvailabilityZone): ReadOnly = new Wrapper(impl)
  }
  type AvailabilityZoneList = List[AvailabilityZone]
  type AvailabilityZones = List[String]
  case class AvailableProcessorFeature(name: scala.Option[String] = None, defaultValue: scala.Option[String] = None, allowedValues: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.AvailableProcessorFeature = {
      import AvailableProcessorFeature.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.AvailableProcessorFeature.builder().optionallyWith(name.map(value => value: java.lang.String))(_.name).optionallyWith(defaultValue.map(value => value: java.lang.String))(_.defaultValue).optionallyWith(allowedValues.map(value => value: java.lang.String))(_.allowedValues).build()
    }
    def asReadOnly: AvailableProcessorFeature.ReadOnly = AvailableProcessorFeature.wrap(buildAwsValue())
  }
  object AvailableProcessorFeature {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.AvailableProcessorFeature] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: AvailableProcessorFeature = AvailableProcessorFeature(nameValue.map(value => value), defaultValueValue.map(value => value), allowedValuesValue.map(value => value))
      def nameValue: scala.Option[String]
      def defaultValueValue: scala.Option[String]
      def allowedValuesValue: scala.Option[String]
      def name: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("name", nameValue)
      def defaultValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultValue", defaultValueValue)
      def allowedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedValues", allowedValuesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature) extends AvailableProcessorFeature.ReadOnly {
      override def nameValue: scala.Option[String] = scala.Option(impl.name()).map(value => value: String)
      override def defaultValueValue: scala.Option[String] = scala.Option(impl.defaultValue()).map(value => value: String)
      override def allowedValuesValue: scala.Option[String] = scala.Option(impl.allowedValues()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.AvailableProcessorFeature): ReadOnly = new Wrapper(impl)
  }
  type AvailableProcessorFeatureList = List[AvailableProcessorFeature]
  case class BacktrackDbClusterRequest(dbClusterIdentifier: String, backtrackTo: primitives.TStamp, force: scala.Option[primitives.BooleanOptional] = None, useEarliestTimeOnPointInTimeUnavailable: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest = {
      import BacktrackDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).backtrackTo(backtrackTo: java.time.Instant).optionallyWith(force.map(value => value: java.lang.Boolean))(_.force).optionallyWith(useEarliestTimeOnPointInTimeUnavailable.map(value => value: java.lang.Boolean))(_.useEarliestTimeOnPointInTimeUnavailable).build()
    }
    def asReadOnly: BacktrackDbClusterRequest.ReadOnly = BacktrackDbClusterRequest.wrap(buildAwsValue())
  }
  object BacktrackDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: BacktrackDbClusterRequest = BacktrackDbClusterRequest(dbClusterIdentifierValue, backtrackToValue, forceValue.map(value => value), useEarliestTimeOnPointInTimeUnavailableValue.map(value => value))
      def dbClusterIdentifierValue: String
      def backtrackToValue: primitives.TStamp
      def forceValue: scala.Option[primitives.BooleanOptional]
      def useEarliestTimeOnPointInTimeUnavailableValue: scala.Option[primitives.BooleanOptional]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def backtrackTo: ZIO[Any, Nothing, primitives.TStamp] = ZIO.succeed(backtrackToValue)
      def force: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("force", forceValue)
      def useEarliestTimeOnPointInTimeUnavailable: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useEarliestTimeOnPointInTimeUnavailable", useEarliestTimeOnPointInTimeUnavailableValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest) extends BacktrackDbClusterRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def backtrackToValue: primitives.TStamp = impl.backtrackTo(): primitives.TStamp
      override def forceValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.force()).map(value => value: primitives.BooleanOptional)
      override def useEarliestTimeOnPointInTimeUnavailableValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.useEarliestTimeOnPointInTimeUnavailable()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class BacktrackDbClusterResponse(dbClusterIdentifier: scala.Option[String] = None, backtrackIdentifier: scala.Option[String] = None, backtrackTo: scala.Option[primitives.TStamp] = None, backtrackedFrom: scala.Option[primitives.TStamp] = None, backtrackRequestCreationTime: scala.Option[primitives.TStamp] = None, status: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse = {
      import BacktrackDbClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(backtrackIdentifier.map(value => value: java.lang.String))(_.backtrackIdentifier).optionallyWith(backtrackTo.map(value => value: java.time.Instant))(_.backtrackTo).optionallyWith(backtrackedFrom.map(value => value: java.time.Instant))(_.backtrackedFrom).optionallyWith(backtrackRequestCreationTime.map(value => value: java.time.Instant))(_.backtrackRequestCreationTime).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
    }
    def asReadOnly: BacktrackDbClusterResponse.ReadOnly = BacktrackDbClusterResponse.wrap(buildAwsValue())
  }
  object BacktrackDbClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: BacktrackDbClusterResponse = BacktrackDbClusterResponse(dbClusterIdentifierValue.map(value => value), backtrackIdentifierValue.map(value => value), backtrackToValue.map(value => value), backtrackedFromValue.map(value => value), backtrackRequestCreationTimeValue.map(value => value), statusValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def backtrackIdentifierValue: scala.Option[String]
      def backtrackToValue: scala.Option[primitives.TStamp]
      def backtrackedFromValue: scala.Option[primitives.TStamp]
      def backtrackRequestCreationTimeValue: scala.Option[primitives.TStamp]
      def statusValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def backtrackIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackIdentifier", backtrackIdentifierValue)
      def backtrackTo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackTo", backtrackToValue)
      def backtrackedFrom: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackedFrom", backtrackedFromValue)
      def backtrackRequestCreationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackRequestCreationTime", backtrackRequestCreationTimeValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse) extends BacktrackDbClusterResponse.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def backtrackIdentifierValue: scala.Option[String] = scala.Option(impl.backtrackIdentifier()).map(value => value: String)
      override def backtrackToValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackTo()).map(value => value: primitives.TStamp)
      override def backtrackedFromValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackedFrom()).map(value => value: primitives.TStamp)
      override def backtrackRequestCreationTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackRequestCreationTime()).map(value => value: primitives.TStamp)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class CancelExportTaskRequest(exportTaskIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CancelExportTaskRequest = {
      import CancelExportTaskRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CancelExportTaskRequest.builder().exportTaskIdentifier(exportTaskIdentifier: java.lang.String).build()
    }
    def asReadOnly: CancelExportTaskRequest.ReadOnly = CancelExportTaskRequest.wrap(buildAwsValue())
  }
  object CancelExportTaskRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CancelExportTaskRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CancelExportTaskRequest = CancelExportTaskRequest(exportTaskIdentifierValue)
      def exportTaskIdentifierValue: String
      def exportTaskIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(exportTaskIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CancelExportTaskRequest) extends CancelExportTaskRequest.ReadOnly { override def exportTaskIdentifierValue: String = impl.exportTaskIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CancelExportTaskRequest): ReadOnly = new Wrapper(impl)
  }
  case class CancelExportTaskResponse(exportTaskIdentifier: scala.Option[String] = None, sourceArn: scala.Option[String] = None, exportOnly: scala.Option[Iterable[String]] = None, snapshotTime: scala.Option[primitives.TStamp] = None, taskStartTime: scala.Option[primitives.TStamp] = None, taskEndTime: scala.Option[primitives.TStamp] = None, s3Bucket: scala.Option[String] = None, s3Prefix: scala.Option[String] = None, iamRoleArn: scala.Option[String] = None, kmsKeyId: scala.Option[String] = None, status: scala.Option[String] = None, percentProgress: scala.Option[primitives.Integer] = None, totalExtractedDataInGB: scala.Option[primitives.Integer] = None, failureCause: scala.Option[String] = None, warningMessage: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CancelExportTaskResponse = {
      import CancelExportTaskResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CancelExportTaskResponse.builder().optionallyWith(exportTaskIdentifier.map(value => value: java.lang.String))(_.exportTaskIdentifier).optionallyWith(sourceArn.map(value => value: java.lang.String))(_.sourceArn).optionallyWith(exportOnly.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.exportOnly).optionallyWith(snapshotTime.map(value => value: java.time.Instant))(_.snapshotTime).optionallyWith(taskStartTime.map(value => value: java.time.Instant))(_.taskStartTime).optionallyWith(taskEndTime.map(value => value: java.time.Instant))(_.taskEndTime).optionallyWith(s3Bucket.map(value => value: java.lang.String))(_.s3Bucket).optionallyWith(s3Prefix.map(value => value: java.lang.String))(_.s3Prefix).optionallyWith(iamRoleArn.map(value => value: java.lang.String))(_.iamRoleArn).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(percentProgress.map(value => value: java.lang.Integer))(_.percentProgress).optionallyWith(totalExtractedDataInGB.map(value => value: java.lang.Integer))(_.totalExtractedDataInGB).optionallyWith(failureCause.map(value => value: java.lang.String))(_.failureCause).optionallyWith(warningMessage.map(value => value: java.lang.String))(_.warningMessage).build()
    }
    def asReadOnly: CancelExportTaskResponse.ReadOnly = CancelExportTaskResponse.wrap(buildAwsValue())
  }
  object CancelExportTaskResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CancelExportTaskResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CancelExportTaskResponse = CancelExportTaskResponse(exportTaskIdentifierValue.map(value => value), sourceArnValue.map(value => value), exportOnlyValue.map(value => value), snapshotTimeValue.map(value => value), taskStartTimeValue.map(value => value), taskEndTimeValue.map(value => value), s3BucketValue.map(value => value), s3PrefixValue.map(value => value), iamRoleArnValue.map(value => value), kmsKeyIdValue.map(value => value), statusValue.map(value => value), percentProgressValue.map(value => value), totalExtractedDataInGBValue.map(value => value), failureCauseValue.map(value => value), warningMessageValue.map(value => value))
      def exportTaskIdentifierValue: scala.Option[String]
      def sourceArnValue: scala.Option[String]
      def exportOnlyValue: scala.Option[List[String]]
      def snapshotTimeValue: scala.Option[primitives.TStamp]
      def taskStartTimeValue: scala.Option[primitives.TStamp]
      def taskEndTimeValue: scala.Option[primitives.TStamp]
      def s3BucketValue: scala.Option[String]
      def s3PrefixValue: scala.Option[String]
      def iamRoleArnValue: scala.Option[String]
      def kmsKeyIdValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def percentProgressValue: scala.Option[primitives.Integer]
      def totalExtractedDataInGBValue: scala.Option[primitives.Integer]
      def failureCauseValue: scala.Option[String]
      def warningMessageValue: scala.Option[String]
      def exportTaskIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifierValue)
      def sourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceArn", sourceArnValue)
      def exportOnly: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportOnly", exportOnlyValue)
      def snapshotTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotTime", snapshotTimeValue)
      def taskStartTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("taskStartTime", taskStartTimeValue)
      def taskEndTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("taskEndTime", taskEndTimeValue)
      def s3Bucket: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Bucket", s3BucketValue)
      def s3Prefix: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Prefix", s3PrefixValue)
      def iamRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamRoleArn", iamRoleArnValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
      def totalExtractedDataInGB: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalExtractedDataInGB", totalExtractedDataInGBValue)
      def failureCause: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureCause", failureCauseValue)
      def warningMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("warningMessage", warningMessageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CancelExportTaskResponse) extends CancelExportTaskResponse.ReadOnly {
      override def exportTaskIdentifierValue: scala.Option[String] = scala.Option(impl.exportTaskIdentifier()).map(value => value: String)
      override def sourceArnValue: scala.Option[String] = scala.Option(impl.sourceArn()).map(value => value: String)
      override def exportOnlyValue: scala.Option[List[String]] = scala.Option(impl.exportOnly()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def snapshotTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.snapshotTime()).map(value => value: primitives.TStamp)
      override def taskStartTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.taskStartTime()).map(value => value: primitives.TStamp)
      override def taskEndTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.taskEndTime()).map(value => value: primitives.TStamp)
      override def s3BucketValue: scala.Option[String] = scala.Option(impl.s3Bucket()).map(value => value: String)
      override def s3PrefixValue: scala.Option[String] = scala.Option(impl.s3Prefix()).map(value => value: String)
      override def iamRoleArnValue: scala.Option[String] = scala.Option(impl.iamRoleArn()).map(value => value: String)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def percentProgressValue: scala.Option[primitives.Integer] = scala.Option(impl.percentProgress()).map(value => value: primitives.Integer)
      override def totalExtractedDataInGBValue: scala.Option[primitives.Integer] = scala.Option(impl.totalExtractedDataInGB()).map(value => value: primitives.Integer)
      override def failureCauseValue: scala.Option[String] = scala.Option(impl.failureCause()).map(value => value: String)
      override def warningMessageValue: scala.Option[String] = scala.Option(impl.warningMessage()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CancelExportTaskResponse): ReadOnly = new Wrapper(impl)
  }
  case class Certificate(certificateIdentifier: scala.Option[String] = None, certificateType: scala.Option[String] = None, thumbprint: scala.Option[String] = None, validFrom: scala.Option[primitives.TStamp] = None, validTill: scala.Option[primitives.TStamp] = None, certificateArn: scala.Option[String] = None, customerOverride: scala.Option[primitives.BooleanOptional] = None, customerOverrideValidTill: scala.Option[primitives.TStamp] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.Certificate = {
      import Certificate.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.Certificate.builder().optionallyWith(certificateIdentifier.map(value => value: java.lang.String))(_.certificateIdentifier).optionallyWith(certificateType.map(value => value: java.lang.String))(_.certificateType).optionallyWith(thumbprint.map(value => value: java.lang.String))(_.thumbprint).optionallyWith(validFrom.map(value => value: java.time.Instant))(_.validFrom).optionallyWith(validTill.map(value => value: java.time.Instant))(_.validTill).optionallyWith(certificateArn.map(value => value: java.lang.String))(_.certificateArn).optionallyWith(customerOverride.map(value => value: java.lang.Boolean))(_.customerOverride).optionallyWith(customerOverrideValidTill.map(value => value: java.time.Instant))(_.customerOverrideValidTill).build()
    }
    def asReadOnly: Certificate.ReadOnly = Certificate.wrap(buildAwsValue())
  }
  object Certificate {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.Certificate] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Certificate = Certificate(certificateIdentifierValue.map(value => value), certificateTypeValue.map(value => value), thumbprintValue.map(value => value), validFromValue.map(value => value), validTillValue.map(value => value), certificateArnValue.map(value => value), customerOverrideValue.map(value => value), customerOverrideValidTillValue.map(value => value))
      def certificateIdentifierValue: scala.Option[String]
      def certificateTypeValue: scala.Option[String]
      def thumbprintValue: scala.Option[String]
      def validFromValue: scala.Option[primitives.TStamp]
      def validTillValue: scala.Option[primitives.TStamp]
      def certificateArnValue: scala.Option[String]
      def customerOverrideValue: scala.Option[primitives.BooleanOptional]
      def customerOverrideValidTillValue: scala.Option[primitives.TStamp]
      def certificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifierValue)
      def certificateType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateType", certificateTypeValue)
      def thumbprint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("thumbprint", thumbprintValue)
      def validFrom: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validFrom", validFromValue)
      def validTill: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validTill", validTillValue)
      def certificateArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateArn", certificateArnValue)
      def customerOverride: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerOverride", customerOverrideValue)
      def customerOverrideValidTill: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerOverrideValidTill", customerOverrideValidTillValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.Certificate) extends Certificate.ReadOnly {
      override def certificateIdentifierValue: scala.Option[String] = scala.Option(impl.certificateIdentifier()).map(value => value: String)
      override def certificateTypeValue: scala.Option[String] = scala.Option(impl.certificateType()).map(value => value: String)
      override def thumbprintValue: scala.Option[String] = scala.Option(impl.thumbprint()).map(value => value: String)
      override def validFromValue: scala.Option[primitives.TStamp] = scala.Option(impl.validFrom()).map(value => value: primitives.TStamp)
      override def validTillValue: scala.Option[primitives.TStamp] = scala.Option(impl.validTill()).map(value => value: primitives.TStamp)
      override def certificateArnValue: scala.Option[String] = scala.Option(impl.certificateArn()).map(value => value: String)
      override def customerOverrideValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.customerOverride()).map(value => value: primitives.BooleanOptional)
      override def customerOverrideValidTillValue: scala.Option[primitives.TStamp] = scala.Option(impl.customerOverrideValidTill()).map(value => value: primitives.TStamp)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.Certificate): ReadOnly = new Wrapper(impl)
  }
  type CertificateList = List[Certificate]
  case class CharacterSet(characterSetName: scala.Option[String] = None, characterSetDescription: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CharacterSet = {
      import CharacterSet.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CharacterSet.builder().optionallyWith(characterSetName.map(value => value: java.lang.String))(_.characterSetName).optionallyWith(characterSetDescription.map(value => value: java.lang.String))(_.characterSetDescription).build()
    }
    def asReadOnly: CharacterSet.ReadOnly = CharacterSet.wrap(buildAwsValue())
  }
  object CharacterSet {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CharacterSet] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CharacterSet = CharacterSet(characterSetNameValue.map(value => value), characterSetDescriptionValue.map(value => value))
      def characterSetNameValue: scala.Option[String]
      def characterSetDescriptionValue: scala.Option[String]
      def characterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetName", characterSetNameValue)
      def characterSetDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetDescription", characterSetDescriptionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CharacterSet) extends CharacterSet.ReadOnly {
      override def characterSetNameValue: scala.Option[String] = scala.Option(impl.characterSetName()).map(value => value: String)
      override def characterSetDescriptionValue: scala.Option[String] = scala.Option(impl.characterSetDescription()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CharacterSet): ReadOnly = new Wrapper(impl)
  }
  case class CloudwatchLogsExportConfiguration(enableLogTypes: scala.Option[Iterable[String]] = None, disableLogTypes: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration = {
      import CloudwatchLogsExportConfiguration.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration.builder().optionallyWith(enableLogTypes.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enableLogTypes).optionallyWith(disableLogTypes.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.disableLogTypes).build()
    }
    def asReadOnly: CloudwatchLogsExportConfiguration.ReadOnly = CloudwatchLogsExportConfiguration.wrap(buildAwsValue())
  }
  object CloudwatchLogsExportConfiguration {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration(enableLogTypesValue.map(value => value), disableLogTypesValue.map(value => value))
      def enableLogTypesValue: scala.Option[List[String]]
      def disableLogTypesValue: scala.Option[List[String]]
      def enableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableLogTypes", enableLogTypesValue)
      def disableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("disableLogTypes", disableLogTypesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration) extends CloudwatchLogsExportConfiguration.ReadOnly {
      override def enableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.enableLogTypes()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def disableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.disableLogTypes()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration): ReadOnly = new Wrapper(impl)
  }
  case class ClusterPendingModifiedValues(pendingCloudwatchLogsExports: scala.Option[PendingCloudwatchLogsExports] = None, dbClusterIdentifier: scala.Option[String] = None, masterUserPassword: scala.Option[String] = None, iamDatabaseAuthenticationEnabled: scala.Option[primitives.BooleanOptional] = None, engineVersion: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues = {
      import ClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues.builder().optionallyWith(pendingCloudwatchLogsExports.map(value => value.buildAwsValue()))(_.pendingCloudwatchLogsExports).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).build()
    }
    def asReadOnly: ClusterPendingModifiedValues.ReadOnly = ClusterPendingModifiedValues.wrap(buildAwsValue())
  }
  object ClusterPendingModifiedValues {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ClusterPendingModifiedValues = ClusterPendingModifiedValues(pendingCloudwatchLogsExportsValue.map(value => value.editable), dbClusterIdentifierValue.map(value => value), masterUserPasswordValue.map(value => value), iamDatabaseAuthenticationEnabledValue.map(value => value), engineVersionValue.map(value => value))
      def pendingCloudwatchLogsExportsValue: scala.Option[PendingCloudwatchLogsExports.ReadOnly]
      def dbClusterIdentifierValue: scala.Option[String]
      def masterUserPasswordValue: scala.Option[String]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[primitives.BooleanOptional]
      def engineVersionValue: scala.Option[String]
      def pendingCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PendingCloudwatchLogsExports.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingCloudwatchLogsExports", pendingCloudwatchLogsExportsValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues) extends ClusterPendingModifiedValues.ReadOnly {
      override def pendingCloudwatchLogsExportsValue: scala.Option[PendingCloudwatchLogsExports.ReadOnly] = scala.Option(impl.pendingCloudwatchLogsExports()).map(value => PendingCloudwatchLogsExports.wrap(value))
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: primitives.BooleanOptional)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ClusterPendingModifiedValues): ReadOnly = new Wrapper(impl)
  }
  case class ConnectionPoolConfiguration(maxConnectionsPercent: scala.Option[primitives.IntegerOptional] = None, maxIdleConnectionsPercent: scala.Option[primitives.IntegerOptional] = None, connectionBorrowTimeout: scala.Option[primitives.IntegerOptional] = None, sessionPinningFilters: scala.Option[Iterable[String]] = None, initQuery: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration = {
      import ConnectionPoolConfiguration.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration.builder().optionallyWith(maxConnectionsPercent.map(value => value: java.lang.Integer))(_.maxConnectionsPercent).optionallyWith(maxIdleConnectionsPercent.map(value => value: java.lang.Integer))(_.maxIdleConnectionsPercent).optionallyWith(connectionBorrowTimeout.map(value => value: java.lang.Integer))(_.connectionBorrowTimeout).optionallyWith(sessionPinningFilters.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.sessionPinningFilters).optionallyWith(initQuery.map(value => value: java.lang.String))(_.initQuery).build()
    }
    def asReadOnly: ConnectionPoolConfiguration.ReadOnly = ConnectionPoolConfiguration.wrap(buildAwsValue())
  }
  object ConnectionPoolConfiguration {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConnectionPoolConfiguration = ConnectionPoolConfiguration(maxConnectionsPercentValue.map(value => value), maxIdleConnectionsPercentValue.map(value => value), connectionBorrowTimeoutValue.map(value => value), sessionPinningFiltersValue.map(value => value), initQueryValue.map(value => value))
      def maxConnectionsPercentValue: scala.Option[primitives.IntegerOptional]
      def maxIdleConnectionsPercentValue: scala.Option[primitives.IntegerOptional]
      def connectionBorrowTimeoutValue: scala.Option[primitives.IntegerOptional]
      def sessionPinningFiltersValue: scala.Option[List[String]]
      def initQueryValue: scala.Option[String]
      def maxConnectionsPercent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercentValue)
      def maxIdleConnectionsPercent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxIdleConnectionsPercent", maxIdleConnectionsPercentValue)
      def connectionBorrowTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionBorrowTimeout", connectionBorrowTimeoutValue)
      def sessionPinningFilters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFiltersValue)
      def initQuery: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("initQuery", initQueryValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration) extends ConnectionPoolConfiguration.ReadOnly {
      override def maxConnectionsPercentValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxConnectionsPercent()).map(value => value: primitives.IntegerOptional)
      override def maxIdleConnectionsPercentValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxIdleConnectionsPercent()).map(value => value: primitives.IntegerOptional)
      override def connectionBorrowTimeoutValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.connectionBorrowTimeout()).map(value => value: primitives.IntegerOptional)
      override def sessionPinningFiltersValue: scala.Option[List[String]] = scala.Option(impl.sessionPinningFilters()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def initQueryValue: scala.Option[String] = scala.Option(impl.initQuery()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfiguration): ReadOnly = new Wrapper(impl)
  }
  case class ConnectionPoolConfigurationInfo(maxConnectionsPercent: scala.Option[primitives.Integer] = None, maxIdleConnectionsPercent: scala.Option[primitives.Integer] = None, connectionBorrowTimeout: scala.Option[primitives.Integer] = None, sessionPinningFilters: scala.Option[Iterable[String]] = None, initQuery: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo = {
      import ConnectionPoolConfigurationInfo.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo.builder().optionallyWith(maxConnectionsPercent.map(value => value: java.lang.Integer))(_.maxConnectionsPercent).optionallyWith(maxIdleConnectionsPercent.map(value => value: java.lang.Integer))(_.maxIdleConnectionsPercent).optionallyWith(connectionBorrowTimeout.map(value => value: java.lang.Integer))(_.connectionBorrowTimeout).optionallyWith(sessionPinningFilters.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.sessionPinningFilters).optionallyWith(initQuery.map(value => value: java.lang.String))(_.initQuery).build()
    }
    def asReadOnly: ConnectionPoolConfigurationInfo.ReadOnly = ConnectionPoolConfigurationInfo.wrap(buildAwsValue())
  }
  object ConnectionPoolConfigurationInfo {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ConnectionPoolConfigurationInfo = ConnectionPoolConfigurationInfo(maxConnectionsPercentValue.map(value => value), maxIdleConnectionsPercentValue.map(value => value), connectionBorrowTimeoutValue.map(value => value), sessionPinningFiltersValue.map(value => value), initQueryValue.map(value => value))
      def maxConnectionsPercentValue: scala.Option[primitives.Integer]
      def maxIdleConnectionsPercentValue: scala.Option[primitives.Integer]
      def connectionBorrowTimeoutValue: scala.Option[primitives.Integer]
      def sessionPinningFiltersValue: scala.Option[List[String]]
      def initQueryValue: scala.Option[String]
      def maxConnectionsPercent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxConnectionsPercent", maxConnectionsPercentValue)
      def maxIdleConnectionsPercent: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxIdleConnectionsPercent", maxIdleConnectionsPercentValue)
      def connectionBorrowTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionBorrowTimeout", connectionBorrowTimeoutValue)
      def sessionPinningFilters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionPinningFilters", sessionPinningFiltersValue)
      def initQuery: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("initQuery", initQueryValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo) extends ConnectionPoolConfigurationInfo.ReadOnly {
      override def maxConnectionsPercentValue: scala.Option[primitives.Integer] = scala.Option(impl.maxConnectionsPercent()).map(value => value: primitives.Integer)
      override def maxIdleConnectionsPercentValue: scala.Option[primitives.Integer] = scala.Option(impl.maxIdleConnectionsPercent()).map(value => value: primitives.Integer)
      override def connectionBorrowTimeoutValue: scala.Option[primitives.Integer] = scala.Option(impl.connectionBorrowTimeout()).map(value => value: primitives.Integer)
      override def sessionPinningFiltersValue: scala.Option[List[String]] = scala.Option(impl.sessionPinningFilters()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def initQueryValue: scala.Option[String] = scala.Option(impl.initQuery()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ConnectionPoolConfigurationInfo): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbClusterParameterGroupRequest(sourceDBClusterParameterGroupIdentifier: String, targetDBClusterParameterGroupIdentifier: String, targetDBClusterParameterGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest = {
      import CopyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest.builder().sourceDBClusterParameterGroupIdentifier(sourceDBClusterParameterGroupIdentifier: java.lang.String).targetDBClusterParameterGroupIdentifier(targetDBClusterParameterGroupIdentifier: java.lang.String).targetDBClusterParameterGroupDescription(targetDBClusterParameterGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CopyDbClusterParameterGroupRequest.ReadOnly = CopyDbClusterParameterGroupRequest.wrap(buildAwsValue())
  }
  object CopyDbClusterParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbClusterParameterGroupRequest = CopyDbClusterParameterGroupRequest(sourceDBClusterParameterGroupIdentifierValue, targetDBClusterParameterGroupIdentifierValue, targetDBClusterParameterGroupDescriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def sourceDBClusterParameterGroupIdentifierValue: String
      def targetDBClusterParameterGroupIdentifierValue: String
      def targetDBClusterParameterGroupDescriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def sourceDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBClusterParameterGroupIdentifierValue)
      def targetDBClusterParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterParameterGroupIdentifierValue)
      def targetDBClusterParameterGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterParameterGroupDescriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest) extends CopyDbClusterParameterGroupRequest.ReadOnly {
      override def sourceDBClusterParameterGroupIdentifierValue: String = impl.sourceDBClusterParameterGroupIdentifier(): String
      override def targetDBClusterParameterGroupIdentifierValue: String = impl.targetDBClusterParameterGroupIdentifier(): String
      override def targetDBClusterParameterGroupDescriptionValue: String = impl.targetDBClusterParameterGroupDescription(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbClusterParameterGroupResponse(dbClusterParameterGroup: scala.Option[DBClusterParameterGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse = {
      import CopyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse.builder().optionallyWith(dbClusterParameterGroup.map(value => value.buildAwsValue()))(_.dbClusterParameterGroup).build()
    }
    def asReadOnly: CopyDbClusterParameterGroupResponse.ReadOnly = CopyDbClusterParameterGroupResponse.wrap(buildAwsValue())
  }
  object CopyDbClusterParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbClusterParameterGroupResponse = CopyDbClusterParameterGroupResponse(dbClusterParameterGroupValue.map(value => value.editable))
      def dbClusterParameterGroupValue: scala.Option[DBClusterParameterGroup.ReadOnly]
      def dbClusterParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterParameterGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse) extends CopyDbClusterParameterGroupResponse.ReadOnly { override def dbClusterParameterGroupValue: scala.Option[DBClusterParameterGroup.ReadOnly] = scala.Option(impl.dbClusterParameterGroup()).map(value => DBClusterParameterGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbClusterSnapshotRequest(sourceDBClusterSnapshotIdentifier: String, targetDBClusterSnapshotIdentifier: String, kmsKeyId: scala.Option[String] = None, preSignedUrl: scala.Option[String] = None, copyTags: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest = {
      import CopyDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest.builder().sourceDBClusterSnapshotIdentifier(sourceDBClusterSnapshotIdentifier: java.lang.String).targetDBClusterSnapshotIdentifier(targetDBClusterSnapshotIdentifier: java.lang.String).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(copyTags.map(value => value: java.lang.Boolean))(_.copyTags).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CopyDbClusterSnapshotRequest.ReadOnly = CopyDbClusterSnapshotRequest.wrap(buildAwsValue())
  }
  object CopyDbClusterSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbClusterSnapshotRequest = CopyDbClusterSnapshotRequest(sourceDBClusterSnapshotIdentifierValue, targetDBClusterSnapshotIdentifierValue, kmsKeyIdValue.map(value => value), preSignedUrlValue.map(value => value), copyTagsValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def sourceDBClusterSnapshotIdentifierValue: String
      def targetDBClusterSnapshotIdentifierValue: String
      def kmsKeyIdValue: scala.Option[String]
      def preSignedUrlValue: scala.Option[String]
      def copyTagsValue: scala.Option[primitives.BooleanOptional]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def sourceDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBClusterSnapshotIdentifierValue)
      def targetDBClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBClusterSnapshotIdentifierValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
      def copyTags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTags", copyTagsValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest) extends CopyDbClusterSnapshotRequest.ReadOnly {
      override def sourceDBClusterSnapshotIdentifierValue: String = impl.sourceDBClusterSnapshotIdentifier(): String
      override def targetDBClusterSnapshotIdentifierValue: String = impl.targetDBClusterSnapshotIdentifier(): String
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
      override def copyTagsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTags()).map(value => value: primitives.BooleanOptional)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbClusterSnapshotResponse(dbClusterSnapshot: scala.Option[DBClusterSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse = {
      import CopyDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse.builder().optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(_.dbClusterSnapshot).build()
    }
    def asReadOnly: CopyDbClusterSnapshotResponse.ReadOnly = CopyDbClusterSnapshotResponse.wrap(buildAwsValue())
  }
  object CopyDbClusterSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbClusterSnapshotResponse = CopyDbClusterSnapshotResponse(dbClusterSnapshotValue.map(value => value.editable))
      def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly]
      def dbClusterSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse) extends CopyDbClusterSnapshotResponse.ReadOnly { override def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly] = scala.Option(impl.dbClusterSnapshot()).map(value => DBClusterSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbParameterGroupRequest(sourceDBParameterGroupIdentifier: String, targetDBParameterGroupIdentifier: String, targetDBParameterGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest = {
      import CopyDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest.builder().sourceDBParameterGroupIdentifier(sourceDBParameterGroupIdentifier: java.lang.String).targetDBParameterGroupIdentifier(targetDBParameterGroupIdentifier: java.lang.String).targetDBParameterGroupDescription(targetDBParameterGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CopyDbParameterGroupRequest.ReadOnly = CopyDbParameterGroupRequest.wrap(buildAwsValue())
  }
  object CopyDbParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbParameterGroupRequest = CopyDbParameterGroupRequest(sourceDBParameterGroupIdentifierValue, targetDBParameterGroupIdentifierValue, targetDBParameterGroupDescriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def sourceDBParameterGroupIdentifierValue: String
      def targetDBParameterGroupIdentifierValue: String
      def targetDBParameterGroupDescriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def sourceDBParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBParameterGroupIdentifierValue)
      def targetDBParameterGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBParameterGroupIdentifierValue)
      def targetDBParameterGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBParameterGroupDescriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest) extends CopyDbParameterGroupRequest.ReadOnly {
      override def sourceDBParameterGroupIdentifierValue: String = impl.sourceDBParameterGroupIdentifier(): String
      override def targetDBParameterGroupIdentifierValue: String = impl.targetDBParameterGroupIdentifier(): String
      override def targetDBParameterGroupDescriptionValue: String = impl.targetDBParameterGroupDescription(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbParameterGroupResponse(dbParameterGroup: scala.Option[DBParameterGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse = {
      import CopyDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse.builder().optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(_.dbParameterGroup).build()
    }
    def asReadOnly: CopyDbParameterGroupResponse.ReadOnly = CopyDbParameterGroupResponse.wrap(buildAwsValue())
  }
  object CopyDbParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbParameterGroupResponse = CopyDbParameterGroupResponse(dbParameterGroupValue.map(value => value.editable))
      def dbParameterGroupValue: scala.Option[DBParameterGroup.ReadOnly]
      def dbParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBParameterGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse) extends CopyDbParameterGroupResponse.ReadOnly { override def dbParameterGroupValue: scala.Option[DBParameterGroup.ReadOnly] = scala.Option(impl.dbParameterGroup()).map(value => DBParameterGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbSnapshotRequest(sourceDBSnapshotIdentifier: String, targetDBSnapshotIdentifier: String, kmsKeyId: scala.Option[String] = None, tags: scala.Option[Iterable[Tag]] = None, copyTags: scala.Option[primitives.BooleanOptional] = None, preSignedUrl: scala.Option[String] = None, optionGroupName: scala.Option[String] = None, targetCustomAvailabilityZone: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest = {
      import CopyDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest.builder().sourceDBSnapshotIdentifier(sourceDBSnapshotIdentifier: java.lang.String).targetDBSnapshotIdentifier(targetDBSnapshotIdentifier: java.lang.String).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(copyTags.map(value => value: java.lang.Boolean))(_.copyTags).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(targetCustomAvailabilityZone.map(value => value: java.lang.String))(_.targetCustomAvailabilityZone).build()
    }
    def asReadOnly: CopyDbSnapshotRequest.ReadOnly = CopyDbSnapshotRequest.wrap(buildAwsValue())
  }
  object CopyDbSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbSnapshotRequest = CopyDbSnapshotRequest(sourceDBSnapshotIdentifierValue, targetDBSnapshotIdentifierValue, kmsKeyIdValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), copyTagsValue.map(value => value), preSignedUrlValue.map(value => value), optionGroupNameValue.map(value => value), targetCustomAvailabilityZoneValue.map(value => value))
      def sourceDBSnapshotIdentifierValue: String
      def targetDBSnapshotIdentifierValue: String
      def kmsKeyIdValue: scala.Option[String]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def copyTagsValue: scala.Option[primitives.BooleanOptional]
      def preSignedUrlValue: scala.Option[String]
      def optionGroupNameValue: scala.Option[String]
      def targetCustomAvailabilityZoneValue: scala.Option[String]
      def sourceDBSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBSnapshotIdentifierValue)
      def targetDBSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetDBSnapshotIdentifierValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def copyTags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTags", copyTagsValue)
      def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def targetCustomAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetCustomAvailabilityZone", targetCustomAvailabilityZoneValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest) extends CopyDbSnapshotRequest.ReadOnly {
      override def sourceDBSnapshotIdentifierValue: String = impl.sourceDBSnapshotIdentifier(): String
      override def targetDBSnapshotIdentifierValue: String = impl.targetDBSnapshotIdentifier(): String
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def copyTagsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTags()).map(value => value: primitives.BooleanOptional)
      override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def targetCustomAvailabilityZoneValue: scala.Option[String] = scala.Option(impl.targetCustomAvailabilityZone()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class CopyDbSnapshotResponse(dbSnapshot: scala.Option[DBSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse = {
      import CopyDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse.builder().optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(_.dbSnapshot).build()
    }
    def asReadOnly: CopyDbSnapshotResponse.ReadOnly = CopyDbSnapshotResponse.wrap(buildAwsValue())
  }
  object CopyDbSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyDbSnapshotResponse = CopyDbSnapshotResponse(dbSnapshotValue.map(value => value.editable))
      def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly]
      def dbSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshot", dbSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse) extends CopyDbSnapshotResponse.ReadOnly { override def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly] = scala.Option(impl.dbSnapshot()).map(value => DBSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class CopyOptionGroupRequest(sourceOptionGroupIdentifier: String, targetOptionGroupIdentifier: String, targetOptionGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest = {
      import CopyOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest.builder().sourceOptionGroupIdentifier(sourceOptionGroupIdentifier: java.lang.String).targetOptionGroupIdentifier(targetOptionGroupIdentifier: java.lang.String).targetOptionGroupDescription(targetOptionGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CopyOptionGroupRequest.ReadOnly = CopyOptionGroupRequest.wrap(buildAwsValue())
  }
  object CopyOptionGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyOptionGroupRequest = CopyOptionGroupRequest(sourceOptionGroupIdentifierValue, targetOptionGroupIdentifierValue, targetOptionGroupDescriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def sourceOptionGroupIdentifierValue: String
      def targetOptionGroupIdentifierValue: String
      def targetOptionGroupDescriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def sourceOptionGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceOptionGroupIdentifierValue)
      def targetOptionGroupIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(targetOptionGroupIdentifierValue)
      def targetOptionGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(targetOptionGroupDescriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest) extends CopyOptionGroupRequest.ReadOnly {
      override def sourceOptionGroupIdentifierValue: String = impl.sourceOptionGroupIdentifier(): String
      override def targetOptionGroupIdentifierValue: String = impl.targetOptionGroupIdentifier(): String
      override def targetOptionGroupDescriptionValue: String = impl.targetOptionGroupDescription(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CopyOptionGroupResponse(optionGroup: scala.Option[OptionGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse = {
      import CopyOptionGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse.builder().optionallyWith(optionGroup.map(value => value.buildAwsValue()))(_.optionGroup).build()
    }
    def asReadOnly: CopyOptionGroupResponse.ReadOnly = CopyOptionGroupResponse.wrap(buildAwsValue())
  }
  object CopyOptionGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CopyOptionGroupResponse = CopyOptionGroupResponse(optionGroupValue.map(value => value.editable))
      def optionGroupValue: scala.Option[OptionGroup.ReadOnly]
      def optionGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OptionGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroup", optionGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse) extends CopyOptionGroupResponse.ReadOnly { override def optionGroupValue: scala.Option[OptionGroup.ReadOnly] = scala.Option(impl.optionGroup()).map(value => OptionGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateCustomAvailabilityZoneRequest(customAvailabilityZoneName: String, existingVpnId: scala.Option[String] = None, newVpnTunnelName: scala.Option[String] = None, vpnTunnelOriginatorIP: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest = {
      import CreateCustomAvailabilityZoneRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest.builder().customAvailabilityZoneName(customAvailabilityZoneName: java.lang.String).optionallyWith(existingVpnId.map(value => value: java.lang.String))(_.existingVpnId).optionallyWith(newVpnTunnelName.map(value => value: java.lang.String))(_.newVpnTunnelName).optionallyWith(vpnTunnelOriginatorIP.map(value => value: java.lang.String))(_.vpnTunnelOriginatorIP).build()
    }
    def asReadOnly: CreateCustomAvailabilityZoneRequest.ReadOnly = CreateCustomAvailabilityZoneRequest.wrap(buildAwsValue())
  }
  object CreateCustomAvailabilityZoneRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateCustomAvailabilityZoneRequest = CreateCustomAvailabilityZoneRequest(customAvailabilityZoneNameValue, existingVpnIdValue.map(value => value), newVpnTunnelNameValue.map(value => value), vpnTunnelOriginatorIPValue.map(value => value))
      def customAvailabilityZoneNameValue: String
      def existingVpnIdValue: scala.Option[String]
      def newVpnTunnelNameValue: scala.Option[String]
      def vpnTunnelOriginatorIPValue: scala.Option[String]
      def customAvailabilityZoneName: ZIO[Any, Nothing, String] = ZIO.succeed(customAvailabilityZoneNameValue)
      def existingVpnId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("existingVpnId", existingVpnIdValue)
      def newVpnTunnelName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newVpnTunnelName", newVpnTunnelNameValue)
      def vpnTunnelOriginatorIP: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpnTunnelOriginatorIP", vpnTunnelOriginatorIPValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest) extends CreateCustomAvailabilityZoneRequest.ReadOnly {
      override def customAvailabilityZoneNameValue: String = impl.customAvailabilityZoneName(): String
      override def existingVpnIdValue: scala.Option[String] = scala.Option(impl.existingVpnId()).map(value => value: String)
      override def newVpnTunnelNameValue: scala.Option[String] = scala.Option(impl.newVpnTunnelName()).map(value => value: String)
      override def vpnTunnelOriginatorIPValue: scala.Option[String] = scala.Option(impl.vpnTunnelOriginatorIP()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateCustomAvailabilityZoneResponse(customAvailabilityZone: scala.Option[CustomAvailabilityZone] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse = {
      import CreateCustomAvailabilityZoneResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse.builder().optionallyWith(customAvailabilityZone.map(value => value.buildAwsValue()))(_.customAvailabilityZone).build()
    }
    def asReadOnly: CreateCustomAvailabilityZoneResponse.ReadOnly = CreateCustomAvailabilityZoneResponse.wrap(buildAwsValue())
  }
  object CreateCustomAvailabilityZoneResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateCustomAvailabilityZoneResponse = CreateCustomAvailabilityZoneResponse(customAvailabilityZoneValue.map(value => value.editable))
      def customAvailabilityZoneValue: scala.Option[CustomAvailabilityZone.ReadOnly]
      def customAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CustomAvailabilityZone.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZone", customAvailabilityZoneValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse) extends CreateCustomAvailabilityZoneResponse.ReadOnly { override def customAvailabilityZoneValue: scala.Option[CustomAvailabilityZone.ReadOnly] = scala.Option(impl.customAvailabilityZone()).map(value => CustomAvailabilityZone.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterEndpointRequest(dbClusterIdentifier: String, dbClusterEndpointIdentifier: String, endpointType: String, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest = {
      import CreateDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).dbClusterEndpointIdentifier(dbClusterEndpointIdentifier: java.lang.String).endpointType(endpointType: java.lang.String).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbClusterEndpointRequest.ReadOnly = CreateDbClusterEndpointRequest.wrap(buildAwsValue())
  }
  object CreateDbClusterEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterEndpointRequest = CreateDbClusterEndpointRequest(dbClusterIdentifierValue, dbClusterEndpointIdentifierValue, endpointTypeValue, staticMembersValue.map(value => value), excludedMembersValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbClusterIdentifierValue: String
      def dbClusterEndpointIdentifierValue: String
      def endpointTypeValue: String
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def dbClusterEndpointIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterEndpointIdentifierValue)
      def endpointType: ZIO[Any, Nothing, String] = ZIO.succeed(endpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest) extends CreateDbClusterEndpointRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def dbClusterEndpointIdentifierValue: String = impl.dbClusterEndpointIdentifier(): String
      override def endpointTypeValue: String = impl.endpointType(): String
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterEndpointResponse(dbClusterEndpointIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterEndpointResourceIdentifier: scala.Option[String] = None, endpoint: scala.Option[String] = None, status: scala.Option[String] = None, endpointType: scala.Option[String] = None, customEndpointType: scala.Option[String] = None, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None, dbClusterEndpointArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse = {
      import CreateDbClusterEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse.builder().optionallyWith(dbClusterEndpointIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterEndpointResourceIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointResourceIdentifier).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(endpointType.map(value => value: java.lang.String))(_.endpointType).optionallyWith(customEndpointType.map(value => value: java.lang.String))(_.customEndpointType).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).optionallyWith(dbClusterEndpointArn.map(value => value: java.lang.String))(_.dbClusterEndpointArn).build()
    }
    def asReadOnly: CreateDbClusterEndpointResponse.ReadOnly = CreateDbClusterEndpointResponse.wrap(buildAwsValue())
  }
  object CreateDbClusterEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterEndpointResponse = CreateDbClusterEndpointResponse(dbClusterEndpointIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterEndpointResourceIdentifierValue.map(value => value), endpointValue.map(value => value), statusValue.map(value => value), endpointTypeValue.map(value => value), customEndpointTypeValue.map(value => value), staticMembersValue.map(value => value), excludedMembersValue.map(value => value), dbClusterEndpointArnValue.map(value => value))
      def dbClusterEndpointIdentifierValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterEndpointResourceIdentifierValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def endpointTypeValue: scala.Option[String]
      def customEndpointTypeValue: scala.Option[String]
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def dbClusterEndpointArnValue: scala.Option[String]
      def dbClusterEndpointIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointIdentifier", dbClusterEndpointIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterEndpointResourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointResourceIdentifier", dbClusterEndpointResourceIdentifierValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def endpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpointType", endpointTypeValue)
      def customEndpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customEndpointType", customEndpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
      def dbClusterEndpointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse) extends CreateDbClusterEndpointResponse.ReadOnly {
      override def dbClusterEndpointIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointIdentifier()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterEndpointResourceIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointResourceIdentifier()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def endpointTypeValue: scala.Option[String] = scala.Option(impl.endpointType()).map(value => value: String)
      override def customEndpointTypeValue: scala.Option[String] = scala.Option(impl.customEndpointType()).map(value => value: String)
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterEndpointArnValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterParameterGroupRequest(dbClusterParameterGroupName: String, dbParameterGroupFamily: String, description: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest = {
      import CreateDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).description(description: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbClusterParameterGroupRequest.ReadOnly = CreateDbClusterParameterGroupRequest.wrap(buildAwsValue())
  }
  object CreateDbClusterParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterParameterGroupRequest = CreateDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue, dbParameterGroupFamilyValue, descriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbClusterParameterGroupNameValue: String
      def dbParameterGroupFamilyValue: String
      def descriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
      def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
      def description: ZIO[Any, Nothing, String] = ZIO.succeed(descriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest) extends CreateDbClusterParameterGroupRequest.ReadOnly {
      override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
      override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
      override def descriptionValue: String = impl.description(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterParameterGroupResponse(dbClusterParameterGroup: scala.Option[DBClusterParameterGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse = {
      import CreateDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse.builder().optionallyWith(dbClusterParameterGroup.map(value => value.buildAwsValue()))(_.dbClusterParameterGroup).build()
    }
    def asReadOnly: CreateDbClusterParameterGroupResponse.ReadOnly = CreateDbClusterParameterGroupResponse.wrap(buildAwsValue())
  }
  object CreateDbClusterParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterParameterGroupResponse = CreateDbClusterParameterGroupResponse(dbClusterParameterGroupValue.map(value => value.editable))
      def dbClusterParameterGroupValue: scala.Option[DBClusterParameterGroup.ReadOnly]
      def dbClusterParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterParameterGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse) extends CreateDbClusterParameterGroupResponse.ReadOnly { override def dbClusterParameterGroupValue: scala.Option[DBClusterParameterGroup.ReadOnly] = scala.Option(impl.dbClusterParameterGroup()).map(value => DBClusterParameterGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterRequest(availabilityZones: scala.Option[Iterable[String]] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, characterSetName: scala.Option[String] = None, databaseName: scala.Option[String] = None, dbClusterIdentifier: String, dbClusterParameterGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, dbSubnetGroupName: scala.Option[String] = None, engine: String, engineVersion: scala.Option[String] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUsername: scala.Option[String] = None, masterUserPassword: scala.Option[String] = None, optionGroupName: scala.Option[String] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, replicationSourceIdentifier: scala.Option[String] = None, tags: scala.Option[Iterable[Tag]] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None, kmsKeyId: scala.Option[String] = None, preSignedUrl: scala.Option[String] = None, enableIAMDatabaseAuthentication: scala.Option[primitives.BooleanOptional] = None, backtrackWindow: scala.Option[primitives.LongOptional] = None, enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None, engineMode: scala.Option[String] = None, scalingConfiguration: scala.Option[ScalingConfiguration] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, globalClusterIdentifier: scala.Option[String] = None, enableHttpEndpoint: scala.Option[primitives.BooleanOptional] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, domain: scala.Option[String] = None, domainIAMRoleName: scala.Option[String] = None, enableGlobalWriteForwarding: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterRequest = {
      import CreateDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterRequest.builder().optionallyWith(availabilityZones.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.availabilityZones).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(characterSetName.map(value => value: java.lang.String))(_.characterSetName).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).engine(engine: java.lang.String).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(replicationSourceIdentifier.map(value => value: java.lang.String))(_.replicationSourceIdentifier).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean))(_.enableIAMDatabaseAuthentication).optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(_.backtrackWindow).optionallyWith(enableCloudwatchLogsExports.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enableCloudwatchLogsExports).optionallyWith(engineMode.map(value => value: java.lang.String))(_.engineMode).optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(_.scalingConfiguration).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(enableHttpEndpoint.map(value => value: java.lang.Boolean))(_.enableHttpEndpoint).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(_.domainIAMRoleName).optionallyWith(enableGlobalWriteForwarding.map(value => value: java.lang.Boolean))(_.enableGlobalWriteForwarding).build()
    }
    def asReadOnly: CreateDbClusterRequest.ReadOnly = CreateDbClusterRequest.wrap(buildAwsValue())
  }
  object CreateDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterRequest = CreateDbClusterRequest(availabilityZonesValue.map(value => value), backupRetentionPeriodValue.map(value => value), characterSetNameValue.map(value => value), databaseNameValue.map(value => value), dbClusterIdentifierValue, dbClusterParameterGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), dbSubnetGroupNameValue.map(value => value), engineValue, engineVersionValue.map(value => value), portValue.map(value => value), masterUsernameValue.map(value => value), masterUserPasswordValue.map(value => value), optionGroupNameValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), replicationSourceIdentifierValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), preSignedUrlValue.map(value => value), enableIAMDatabaseAuthenticationValue.map(value => value), backtrackWindowValue.map(value => value), enableCloudwatchLogsExportsValue.map(value => value), engineModeValue.map(value => value), scalingConfigurationValue.map(value => value.editable), deletionProtectionValue.map(value => value), globalClusterIdentifierValue.map(value => value), enableHttpEndpointValue.map(value => value), copyTagsToSnapshotValue.map(value => value), domainValue.map(value => value), domainIAMRoleNameValue.map(value => value), enableGlobalWriteForwardingValue.map(value => value))
      def availabilityZonesValue: scala.Option[List[String]]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def characterSetNameValue: scala.Option[String]
      def databaseNameValue: scala.Option[String]
      def dbClusterIdentifierValue: String
      def dbClusterParameterGroupNameValue: scala.Option[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def dbSubnetGroupNameValue: scala.Option[String]
      def engineValue: String
      def engineVersionValue: scala.Option[String]
      def portValue: scala.Option[primitives.IntegerOptional]
      def masterUsernameValue: scala.Option[String]
      def masterUserPasswordValue: scala.Option[String]
      def optionGroupNameValue: scala.Option[String]
      def preferredBackupWindowValue: scala.Option[String]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def replicationSourceIdentifierValue: scala.Option[String]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
      def kmsKeyIdValue: scala.Option[String]
      def preSignedUrlValue: scala.Option[String]
      def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional]
      def backtrackWindowValue: scala.Option[primitives.LongOptional]
      def enableCloudwatchLogsExportsValue: scala.Option[List[String]]
      def engineModeValue: scala.Option[String]
      def scalingConfigurationValue: scala.Option[ScalingConfiguration.ReadOnly]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def globalClusterIdentifierValue: scala.Option[String]
      def enableHttpEndpointValue: scala.Option[primitives.BooleanOptional]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def domainValue: scala.Option[String]
      def domainIAMRoleNameValue: scala.Option[String]
      def enableGlobalWriteForwardingValue: scala.Option[primitives.BooleanOptional]
      def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def characterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetName", characterSetNameValue)
      def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def replicationSourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicationSourceIdentifier", replicationSourceIdentifierValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
      def enableIAMDatabaseAuthentication: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableIAMDatabaseAuthentication", enableIAMDatabaseAuthenticationValue)
      def backtrackWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackWindow", backtrackWindowValue)
      def enableCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCloudwatchLogsExports", enableCloudwatchLogsExportsValue)
      def engineMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineMode", engineModeValue)
      def scalingConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ScalingConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scalingConfiguration", scalingConfigurationValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
      def enableHttpEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpointValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def domainIAMRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleNameValue)
      def enableGlobalWriteForwarding: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableGlobalWriteForwarding", enableGlobalWriteForwardingValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest) extends CreateDbClusterRequest.ReadOnly {
      override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def characterSetNameValue: scala.Option[String] = scala.Option(impl.characterSetName()).map(value => value: String)
      override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def engineValue: String = impl.engine(): String
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def replicationSourceIdentifierValue: scala.Option[String] = scala.Option(impl.replicationSourceIdentifier()).map(value => value: String)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
      override def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableIAMDatabaseAuthentication()).map(value => value: primitives.BooleanOptional)
      override def backtrackWindowValue: scala.Option[primitives.LongOptional] = scala.Option(impl.backtrackWindow()).map(value => value: primitives.LongOptional)
      override def enableCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enableCloudwatchLogsExports()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def engineModeValue: scala.Option[String] = scala.Option(impl.engineMode()).map(value => value: String)
      override def scalingConfigurationValue: scala.Option[ScalingConfiguration.ReadOnly] = scala.Option(impl.scalingConfiguration()).map(value => ScalingConfiguration.wrap(value))
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def globalClusterIdentifierValue: scala.Option[String] = scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
      override def enableHttpEndpointValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableHttpEndpoint()).map(value => value: primitives.BooleanOptional)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def domainIAMRoleNameValue: scala.Option[String] = scala.Option(impl.domainIAMRoleName()).map(value => value: String)
      override def enableGlobalWriteForwardingValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableGlobalWriteForwarding()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterResponse = {
      import CreateDbClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
    }
    def asReadOnly: CreateDbClusterResponse.ReadOnly = CreateDbClusterResponse.wrap(buildAwsValue())
  }
  object CreateDbClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterResponse = CreateDbClusterResponse(dbClusterValue.map(value => value.editable))
      def dbClusterValue: scala.Option[DBCluster.ReadOnly]
      def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterResponse) extends CreateDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterSnapshotRequest(dbClusterSnapshotIdentifier: String, dbClusterIdentifier: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest = {
      import CreateDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbClusterSnapshotRequest.ReadOnly = CreateDbClusterSnapshotRequest.wrap(buildAwsValue())
  }
  object CreateDbClusterSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterSnapshotRequest = CreateDbClusterSnapshotRequest(dbClusterSnapshotIdentifierValue, dbClusterIdentifierValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbClusterSnapshotIdentifierValue: String
      def dbClusterIdentifierValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest) extends CreateDbClusterSnapshotRequest.ReadOnly {
      override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbClusterSnapshotResponse(dbClusterSnapshot: scala.Option[DBClusterSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse = {
      import CreateDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse.builder().optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(_.dbClusterSnapshot).build()
    }
    def asReadOnly: CreateDbClusterSnapshotResponse.ReadOnly = CreateDbClusterSnapshotResponse.wrap(buildAwsValue())
  }
  object CreateDbClusterSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbClusterSnapshotResponse = CreateDbClusterSnapshotResponse(dbClusterSnapshotValue.map(value => value.editable))
      def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly]
      def dbClusterSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse) extends CreateDbClusterSnapshotResponse.ReadOnly { override def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly] = scala.Option(impl.dbClusterSnapshot()).map(value => DBClusterSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbInstanceReadReplicaRequest(dbInstanceIdentifier: String, sourceDBInstanceIdentifier: String, dbInstanceClass: scala.Option[String] = None, availabilityZone: scala.Option[String] = None, port: scala.Option[primitives.IntegerOptional] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, autoMinorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupName: scala.Option[String] = None, dbParameterGroupName: scala.Option[String] = None, publiclyAccessible: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None, dbSubnetGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, storageType: scala.Option[String] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, monitoringInterval: scala.Option[primitives.IntegerOptional] = None, monitoringRoleArn: scala.Option[String] = None, kmsKeyId: scala.Option[String] = None, preSignedUrl: scala.Option[String] = None, enableIAMDatabaseAuthentication: scala.Option[primitives.BooleanOptional] = None, enablePerformanceInsights: scala.Option[primitives.BooleanOptional] = None, performanceInsightsKMSKeyId: scala.Option[String] = None, performanceInsightsRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None, processorFeatures: scala.Option[Iterable[ProcessorFeature]] = None, useDefaultProcessorFeatures: scala.Option[primitives.BooleanOptional] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, domain: scala.Option[String] = None, domainIAMRoleName: scala.Option[String] = None, replicaMode: scala.Option[ReplicaMode] = None, maxAllocatedStorage: scala.Option[primitives.IntegerOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest = {
      import CreateDbInstanceReadReplicaRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).sourceDBInstanceIdentifier(sourceDBInstanceIdentifier: java.lang.String).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(monitoringInterval.map(value => value: java.lang.Integer))(_.monitoringInterval).optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(_.monitoringRoleArn).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(preSignedUrl.map(value => value: java.lang.String))(_.preSignedUrl).optionallyWith(enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean))(_.enableIAMDatabaseAuthentication).optionallyWith(enablePerformanceInsights.map(value => value: java.lang.Boolean))(_.enablePerformanceInsights).optionallyWith(performanceInsightsKMSKeyId.map(value => value: java.lang.String))(_.performanceInsightsKMSKeyId).optionallyWith(performanceInsightsRetentionPeriod.map(value => value: java.lang.Integer))(_.performanceInsightsRetentionPeriod).optionallyWith(enableCloudwatchLogsExports.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enableCloudwatchLogsExports).optionallyWith(processorFeatures.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.processorFeatures).optionallyWith(useDefaultProcessorFeatures.map(value => value: java.lang.Boolean))(_.useDefaultProcessorFeatures).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(_.domainIAMRoleName).optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode).optionallyWith(maxAllocatedStorage.map(value => value: java.lang.Integer))(_.maxAllocatedStorage).build()
    }
    def asReadOnly: CreateDbInstanceReadReplicaRequest.ReadOnly = CreateDbInstanceReadReplicaRequest.wrap(buildAwsValue())
  }
  object CreateDbInstanceReadReplicaRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbInstanceReadReplicaRequest = CreateDbInstanceReadReplicaRequest(dbInstanceIdentifierValue, sourceDBInstanceIdentifierValue, dbInstanceClassValue.map(value => value), availabilityZoneValue.map(value => value), portValue.map(value => value), multiAZValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), iopsValue.map(value => value), optionGroupNameValue.map(value => value), dbParameterGroupNameValue.map(value => value), publiclyAccessibleValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), dbSubnetGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), storageTypeValue.map(value => value), copyTagsToSnapshotValue.map(value => value), monitoringIntervalValue.map(value => value), monitoringRoleArnValue.map(value => value), kmsKeyIdValue.map(value => value), preSignedUrlValue.map(value => value), enableIAMDatabaseAuthenticationValue.map(value => value), enablePerformanceInsightsValue.map(value => value), performanceInsightsKMSKeyIdValue.map(value => value), performanceInsightsRetentionPeriodValue.map(value => value), enableCloudwatchLogsExportsValue.map(value => value), processorFeaturesValue.map(value => value.map { item => 
        item.editable
      }), useDefaultProcessorFeaturesValue.map(value => value), deletionProtectionValue.map(value => value), domainValue.map(value => value), domainIAMRoleNameValue.map(value => value), replicaModeValue.map(value => value), maxAllocatedStorageValue.map(value => value))
      def dbInstanceIdentifierValue: String
      def sourceDBInstanceIdentifierValue: String
      def dbInstanceClassValue: scala.Option[String]
      def availabilityZoneValue: scala.Option[String]
      def portValue: scala.Option[primitives.IntegerOptional]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupNameValue: scala.Option[String]
      def dbParameterGroupNameValue: scala.Option[String]
      def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbSubnetGroupNameValue: scala.Option[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def storageTypeValue: scala.Option[String]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def monitoringIntervalValue: scala.Option[primitives.IntegerOptional]
      def monitoringRoleArnValue: scala.Option[String]
      def kmsKeyIdValue: scala.Option[String]
      def preSignedUrlValue: scala.Option[String]
      def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional]
      def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional]
      def performanceInsightsKMSKeyIdValue: scala.Option[String]
      def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def enableCloudwatchLogsExportsValue: scala.Option[List[String]]
      def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]]
      def useDefaultProcessorFeaturesValue: scala.Option[primitives.BooleanOptional]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def domainValue: scala.Option[String]
      def domainIAMRoleNameValue: scala.Option[String]
      def replicaModeValue: scala.Option[ReplicaMode]
      def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def sourceDBInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(sourceDBInstanceIdentifierValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def monitoringInterval: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringInterval", monitoringIntervalValue)
      def monitoringRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArnValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def preSignedUrl: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preSignedUrl", preSignedUrlValue)
      def enableIAMDatabaseAuthentication: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableIAMDatabaseAuthentication", enableIAMDatabaseAuthenticationValue)
      def enablePerformanceInsights: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enablePerformanceInsights", enablePerformanceInsightsValue)
      def performanceInsightsKMSKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsKMSKeyId", performanceInsightsKMSKeyIdValue)
      def performanceInsightsRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsRetentionPeriod", performanceInsightsRetentionPeriodValue)
      def enableCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCloudwatchLogsExports", enableCloudwatchLogsExportsValue)
      def processorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProcessorFeature.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processorFeatures", processorFeaturesValue)
      def useDefaultProcessorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useDefaultProcessorFeatures", useDefaultProcessorFeaturesValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def domainIAMRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleNameValue)
      def replicaMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReplicaMode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicaMode", replicaModeValue)
      def maxAllocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest) extends CreateDbInstanceReadReplicaRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def sourceDBInstanceIdentifierValue: String = impl.sourceDBInstanceIdentifier(): String
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
      override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: primitives.BooleanOptional)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.publiclyAccessible()).map(value => value: primitives.BooleanOptional)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def monitoringIntervalValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.monitoringInterval()).map(value => value: primitives.IntegerOptional)
      override def monitoringRoleArnValue: scala.Option[String] = scala.Option(impl.monitoringRoleArn()).map(value => value: String)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def preSignedUrlValue: scala.Option[String] = scala.Option(impl.preSignedUrl()).map(value => value: String)
      override def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableIAMDatabaseAuthentication()).map(value => value: primitives.BooleanOptional)
      override def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enablePerformanceInsights()).map(value => value: primitives.BooleanOptional)
      override def performanceInsightsKMSKeyIdValue: scala.Option[String] = scala.Option(impl.performanceInsightsKMSKeyId()).map(value => value: String)
      override def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.performanceInsightsRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def enableCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enableCloudwatchLogsExports()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]] = scala.Option(impl.processorFeatures()).map(value => value.asScala.map { item => 
        ProcessorFeature.wrap(item)
      }.toList)
      override def useDefaultProcessorFeaturesValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.useDefaultProcessorFeatures()).map(value => value: primitives.BooleanOptional)
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def domainIAMRoleNameValue: scala.Option[String] = scala.Option(impl.domainIAMRoleName()).map(value => value: String)
      override def replicaModeValue: scala.Option[ReplicaMode] = scala.Option(impl.replicaMode()).map(value => ReplicaMode.wrap(value))
      override def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxAllocatedStorage()).map(value => value: primitives.IntegerOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbInstanceReadReplicaResponse(dbInstance: scala.Option[DBInstance] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse = {
      import CreateDbInstanceReadReplicaResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
    }
    def asReadOnly: CreateDbInstanceReadReplicaResponse.ReadOnly = CreateDbInstanceReadReplicaResponse.wrap(buildAwsValue())
  }
  object CreateDbInstanceReadReplicaResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbInstanceReadReplicaResponse = CreateDbInstanceReadReplicaResponse(dbInstanceValue.map(value => value.editable))
      def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
      def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse) extends CreateDbInstanceReadReplicaResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbInstanceRequest(dbName: scala.Option[String] = None, dbInstanceIdentifier: String, allocatedStorage: scala.Option[primitives.IntegerOptional] = None, dbInstanceClass: String, engine: String, masterUsername: scala.Option[String] = None, masterUserPassword: scala.Option[String] = None, dbSecurityGroups: scala.Option[Iterable[String]] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, availabilityZone: scala.Option[String] = None, dbSubnetGroupName: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, dbParameterGroupName: scala.Option[String] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, preferredBackupWindow: scala.Option[String] = None, port: scala.Option[primitives.IntegerOptional] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, engineVersion: scala.Option[String] = None, autoMinorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None, licenseModel: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupName: scala.Option[String] = None, characterSetName: scala.Option[String] = None, ncharCharacterSetName: scala.Option[String] = None, publiclyAccessible: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None, dbClusterIdentifier: scala.Option[String] = None, storageType: scala.Option[String] = None, tdeCredentialArn: scala.Option[String] = None, tdeCredentialPassword: scala.Option[String] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None, kmsKeyId: scala.Option[String] = None, domain: scala.Option[String] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, monitoringInterval: scala.Option[primitives.IntegerOptional] = None, monitoringRoleArn: scala.Option[String] = None, domainIAMRoleName: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None, timezone: scala.Option[String] = None, enableIAMDatabaseAuthentication: scala.Option[primitives.BooleanOptional] = None, enablePerformanceInsights: scala.Option[primitives.BooleanOptional] = None, performanceInsightsKMSKeyId: scala.Option[String] = None, performanceInsightsRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, enableCloudwatchLogsExports: scala.Option[Iterable[String]] = None, processorFeatures: scala.Option[Iterable[ProcessorFeature]] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, maxAllocatedStorage: scala.Option[primitives.IntegerOptional] = None, enableCustomerOwnedIp: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest = {
      import CreateDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest.builder().optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName).dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).dbInstanceClass(dbInstanceClass: java.lang.String).engine(engine: java.lang.String).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(dbSecurityGroups.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.dbSecurityGroups).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(characterSetName.map(value => value: java.lang.String))(_.characterSetName).optionallyWith(ncharCharacterSetName.map(value => value: java.lang.String))(_.ncharCharacterSetName).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(_.tdeCredentialArn).optionallyWith(tdeCredentialPassword.map(value => value: java.lang.String))(_.tdeCredentialPassword).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(monitoringInterval.map(value => value: java.lang.Integer))(_.monitoringInterval).optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(_.monitoringRoleArn).optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(_.domainIAMRoleName).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).optionallyWith(timezone.map(value => value: java.lang.String))(_.timezone).optionallyWith(enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean))(_.enableIAMDatabaseAuthentication).optionallyWith(enablePerformanceInsights.map(value => value: java.lang.Boolean))(_.enablePerformanceInsights).optionallyWith(performanceInsightsKMSKeyId.map(value => value: java.lang.String))(_.performanceInsightsKMSKeyId).optionallyWith(performanceInsightsRetentionPeriod.map(value => value: java.lang.Integer))(_.performanceInsightsRetentionPeriod).optionallyWith(enableCloudwatchLogsExports.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enableCloudwatchLogsExports).optionallyWith(processorFeatures.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.processorFeatures).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(maxAllocatedStorage.map(value => value: java.lang.Integer))(_.maxAllocatedStorage).optionallyWith(enableCustomerOwnedIp.map(value => value: java.lang.Boolean))(_.enableCustomerOwnedIp).build()
    }
    def asReadOnly: CreateDbInstanceRequest.ReadOnly = CreateDbInstanceRequest.wrap(buildAwsValue())
  }
  object CreateDbInstanceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbInstanceRequest = CreateDbInstanceRequest(dbNameValue.map(value => value), dbInstanceIdentifierValue, allocatedStorageValue.map(value => value), dbInstanceClassValue, engineValue, masterUsernameValue.map(value => value), masterUserPasswordValue.map(value => value), dbSecurityGroupsValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), availabilityZoneValue.map(value => value), dbSubnetGroupNameValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), dbParameterGroupNameValue.map(value => value), backupRetentionPeriodValue.map(value => value), preferredBackupWindowValue.map(value => value), portValue.map(value => value), multiAZValue.map(value => value), engineVersionValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), licenseModelValue.map(value => value), iopsValue.map(value => value), optionGroupNameValue.map(value => value), characterSetNameValue.map(value => value), ncharCharacterSetNameValue.map(value => value), publiclyAccessibleValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }), dbClusterIdentifierValue.map(value => value), storageTypeValue.map(value => value), tdeCredentialArnValue.map(value => value), tdeCredentialPasswordValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), domainValue.map(value => value), copyTagsToSnapshotValue.map(value => value), monitoringIntervalValue.map(value => value), monitoringRoleArnValue.map(value => value), domainIAMRoleNameValue.map(value => value), promotionTierValue.map(value => value), timezoneValue.map(value => value), enableIAMDatabaseAuthenticationValue.map(value => value), enablePerformanceInsightsValue.map(value => value), performanceInsightsKMSKeyIdValue.map(value => value), performanceInsightsRetentionPeriodValue.map(value => value), enableCloudwatchLogsExportsValue.map(value => value), processorFeaturesValue.map(value => value.map { item => 
        item.editable
      }), deletionProtectionValue.map(value => value), maxAllocatedStorageValue.map(value => value), enableCustomerOwnedIpValue.map(value => value))
      def dbNameValue: scala.Option[String]
      def dbInstanceIdentifierValue: String
      def allocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceClassValue: String
      def engineValue: String
      def masterUsernameValue: scala.Option[String]
      def masterUserPasswordValue: scala.Option[String]
      def dbSecurityGroupsValue: scala.Option[List[String]]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def availabilityZoneValue: scala.Option[String]
      def dbSubnetGroupNameValue: scala.Option[String]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def dbParameterGroupNameValue: scala.Option[String]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def preferredBackupWindowValue: scala.Option[String]
      def portValue: scala.Option[primitives.IntegerOptional]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def engineVersionValue: scala.Option[String]
      def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
      def licenseModelValue: scala.Option[String]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupNameValue: scala.Option[String]
      def characterSetNameValue: scala.Option[String]
      def ncharCharacterSetNameValue: scala.Option[String]
      def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbClusterIdentifierValue: scala.Option[String]
      def storageTypeValue: scala.Option[String]
      def tdeCredentialArnValue: scala.Option[String]
      def tdeCredentialPasswordValue: scala.Option[String]
      def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
      def kmsKeyIdValue: scala.Option[String]
      def domainValue: scala.Option[String]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def monitoringIntervalValue: scala.Option[primitives.IntegerOptional]
      def monitoringRoleArnValue: scala.Option[String]
      def domainIAMRoleNameValue: scala.Option[String]
      def promotionTierValue: scala.Option[primitives.IntegerOptional]
      def timezoneValue: scala.Option[String]
      def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional]
      def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional]
      def performanceInsightsKMSKeyIdValue: scala.Option[String]
      def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def enableCloudwatchLogsExportsValue: scala.Option[List[String]]
      def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def enableCustomerOwnedIpValue: scala.Option[primitives.BooleanOptional]
      def dbName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbName", dbNameValue)
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def dbInstanceClass: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceClassValue)
      def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
      def dbSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroupsValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def characterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetName", characterSetNameValue)
      def ncharCharacterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ncharCharacterSetName", ncharCharacterSetNameValue)
      def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def tdeCredentialArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArnValue)
      def tdeCredentialPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPasswordValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def monitoringInterval: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringInterval", monitoringIntervalValue)
      def monitoringRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArnValue)
      def domainIAMRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleNameValue)
      def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
      def timezone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timezone", timezoneValue)
      def enableIAMDatabaseAuthentication: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableIAMDatabaseAuthentication", enableIAMDatabaseAuthenticationValue)
      def enablePerformanceInsights: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enablePerformanceInsights", enablePerformanceInsightsValue)
      def performanceInsightsKMSKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsKMSKeyId", performanceInsightsKMSKeyIdValue)
      def performanceInsightsRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsRetentionPeriod", performanceInsightsRetentionPeriodValue)
      def enableCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCloudwatchLogsExports", enableCloudwatchLogsExportsValue)
      def processorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProcessorFeature.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processorFeatures", processorFeaturesValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def maxAllocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorageValue)
      def enableCustomerOwnedIp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIpValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest) extends CreateDbInstanceRequest.ReadOnly {
      override def dbNameValue: scala.Option[String] = scala.Option(impl.dbName()).map(value => value: String)
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def allocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def dbInstanceClassValue: String = impl.dbInstanceClass(): String
      override def engineValue: String = impl.engine(): String
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
      override def dbSecurityGroupsValue: scala.Option[List[String]] = scala.Option(impl.dbSecurityGroups()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: primitives.BooleanOptional)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def characterSetNameValue: scala.Option[String] = scala.Option(impl.characterSetName()).map(value => value: String)
      override def ncharCharacterSetNameValue: scala.Option[String] = scala.Option(impl.ncharCharacterSetName()).map(value => value: String)
      override def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.publiclyAccessible()).map(value => value: primitives.BooleanOptional)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def tdeCredentialArnValue: scala.Option[String] = scala.Option(impl.tdeCredentialArn()).map(value => value: String)
      override def tdeCredentialPasswordValue: scala.Option[String] = scala.Option(impl.tdeCredentialPassword()).map(value => value: String)
      override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def monitoringIntervalValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.monitoringInterval()).map(value => value: primitives.IntegerOptional)
      override def monitoringRoleArnValue: scala.Option[String] = scala.Option(impl.monitoringRoleArn()).map(value => value: String)
      override def domainIAMRoleNameValue: scala.Option[String] = scala.Option(impl.domainIAMRoleName()).map(value => value: String)
      override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
      override def timezoneValue: scala.Option[String] = scala.Option(impl.timezone()).map(value => value: String)
      override def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableIAMDatabaseAuthentication()).map(value => value: primitives.BooleanOptional)
      override def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enablePerformanceInsights()).map(value => value: primitives.BooleanOptional)
      override def performanceInsightsKMSKeyIdValue: scala.Option[String] = scala.Option(impl.performanceInsightsKMSKeyId()).map(value => value: String)
      override def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.performanceInsightsRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def enableCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enableCloudwatchLogsExports()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]] = scala.Option(impl.processorFeatures()).map(value => value.asScala.map { item => 
        ProcessorFeature.wrap(item)
      }.toList)
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxAllocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def enableCustomerOwnedIpValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableCustomerOwnedIp()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbInstanceResponse(dbInstance: scala.Option[DBInstance] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse = {
      import CreateDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
    }
    def asReadOnly: CreateDbInstanceResponse.ReadOnly = CreateDbInstanceResponse.wrap(buildAwsValue())
  }
  object CreateDbInstanceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbInstanceResponse = CreateDbInstanceResponse(dbInstanceValue.map(value => value.editable))
      def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
      def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse) extends CreateDbInstanceResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbParameterGroupRequest(dbParameterGroupName: String, dbParameterGroupFamily: String, description: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest = {
      import CreateDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest.builder().dbParameterGroupName(dbParameterGroupName: java.lang.String).dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).description(description: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbParameterGroupRequest.ReadOnly = CreateDbParameterGroupRequest.wrap(buildAwsValue())
  }
  object CreateDbParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbParameterGroupRequest = CreateDbParameterGroupRequest(dbParameterGroupNameValue, dbParameterGroupFamilyValue, descriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbParameterGroupNameValue: String
      def dbParameterGroupFamilyValue: String
      def descriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupNameValue)
      def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
      def description: ZIO[Any, Nothing, String] = ZIO.succeed(descriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest) extends CreateDbParameterGroupRequest.ReadOnly {
      override def dbParameterGroupNameValue: String = impl.dbParameterGroupName(): String
      override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
      override def descriptionValue: String = impl.description(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbParameterGroupResponse(dbParameterGroup: scala.Option[DBParameterGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse = {
      import CreateDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse.builder().optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(_.dbParameterGroup).build()
    }
    def asReadOnly: CreateDbParameterGroupResponse.ReadOnly = CreateDbParameterGroupResponse.wrap(buildAwsValue())
  }
  object CreateDbParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbParameterGroupResponse = CreateDbParameterGroupResponse(dbParameterGroupValue.map(value => value.editable))
      def dbParameterGroupValue: scala.Option[DBParameterGroup.ReadOnly]
      def dbParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBParameterGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse) extends CreateDbParameterGroupResponse.ReadOnly { override def dbParameterGroupValue: scala.Option[DBParameterGroup.ReadOnly] = scala.Option(impl.dbParameterGroup()).map(value => DBParameterGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbProxyEndpointRequest(dbProxyName: primitives.DBProxyName, dbProxyEndpointName: primitives.DBProxyEndpointName, vpcSubnetIds: Iterable[String], vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, targetRole: scala.Option[DBProxyEndpointTargetRole] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest = {
      import CreateDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest.builder().dbProxyName(dbProxyName: java.lang.String).dbProxyEndpointName(dbProxyEndpointName: java.lang.String).vpcSubnetIds(vpcSubnetIds.map { item => 
        item: java.lang.String
      }.asJavaCollection).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(targetRole.map(value => value.unwrap))(_.targetRole).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbProxyEndpointRequest.ReadOnly = CreateDbProxyEndpointRequest.wrap(buildAwsValue())
  }
  object CreateDbProxyEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbProxyEndpointRequest = CreateDbProxyEndpointRequest(dbProxyNameValue, dbProxyEndpointNameValue, vpcSubnetIdsValue, vpcSecurityGroupIdsValue.map(value => value), targetRoleValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbProxyNameValue: primitives.DBProxyName
      def dbProxyEndpointNameValue: primitives.DBProxyEndpointName
      def vpcSubnetIdsValue: List[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def targetRoleValue: scala.Option[DBProxyEndpointTargetRole]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbProxyName: ZIO[Any, Nothing, primitives.DBProxyName] = ZIO.succeed(dbProxyNameValue)
      def dbProxyEndpointName: ZIO[Any, Nothing, primitives.DBProxyEndpointName] = ZIO.succeed(dbProxyEndpointNameValue)
      def vpcSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(vpcSubnetIdsValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def targetRole: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpointTargetRole] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetRole", targetRoleValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest) extends CreateDbProxyEndpointRequest.ReadOnly {
      override def dbProxyNameValue: primitives.DBProxyName = impl.dbProxyName(): primitives.DBProxyName
      override def dbProxyEndpointNameValue: primitives.DBProxyEndpointName = impl.dbProxyEndpointName(): primitives.DBProxyEndpointName
      override def vpcSubnetIdsValue: List[String] = impl.vpcSubnetIds().asScala.map { item => 
        item: String
      }.toList
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def targetRoleValue: scala.Option[DBProxyEndpointTargetRole] = scala.Option(impl.targetRole()).map(value => DBProxyEndpointTargetRole.wrap(value))
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbProxyEndpointResponse(dbProxyEndpoint: scala.Option[DBProxyEndpoint] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse = {
      import CreateDbProxyEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse.builder().optionallyWith(dbProxyEndpoint.map(value => value.buildAwsValue()))(_.dbProxyEndpoint).build()
    }
    def asReadOnly: CreateDbProxyEndpointResponse.ReadOnly = CreateDbProxyEndpointResponse.wrap(buildAwsValue())
  }
  object CreateDbProxyEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbProxyEndpointResponse = CreateDbProxyEndpointResponse(dbProxyEndpointValue.map(value => value.editable))
      def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly]
      def dbProxyEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpoint", dbProxyEndpointValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse) extends CreateDbProxyEndpointResponse.ReadOnly { override def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly] = scala.Option(impl.dbProxyEndpoint()).map(value => DBProxyEndpoint.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbProxyRequest(dbProxyName: String, engineFamily: EngineFamily, auth: Iterable[UserAuthConfig], roleArn: String, vpcSubnetIds: Iterable[String], vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, requireTLS: scala.Option[Boolean] = None, idleClientTimeout: scala.Option[primitives.IntegerOptional] = None, debugLogging: scala.Option[Boolean] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbProxyRequest = {
      import CreateDbProxyRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbProxyRequest.builder().dbProxyName(dbProxyName: java.lang.String).engineFamily(engineFamily.unwrap).auth(auth.map { item => 
        item.buildAwsValue()
      }.asJavaCollection).roleArn(roleArn: java.lang.String).vpcSubnetIds(vpcSubnetIds.map { item => 
        item: java.lang.String
      }.asJavaCollection).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(_.requireTLS).optionallyWith(idleClientTimeout.map(value => value: java.lang.Integer))(_.idleClientTimeout).optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(_.debugLogging).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbProxyRequest.ReadOnly = CreateDbProxyRequest.wrap(buildAwsValue())
  }
  object CreateDbProxyRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbProxyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbProxyRequest = CreateDbProxyRequest(dbProxyNameValue, engineFamilyValue, authValue.map { item => 
        item.editable
      }, roleArnValue, vpcSubnetIdsValue, vpcSecurityGroupIdsValue.map(value => value), requireTLSValue.map(value => value), idleClientTimeoutValue.map(value => value), debugLoggingValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbProxyNameValue: String
      def engineFamilyValue: EngineFamily
      def authValue: List[UserAuthConfig.ReadOnly]
      def roleArnValue: String
      def vpcSubnetIdsValue: List[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def requireTLSValue: scala.Option[Boolean]
      def idleClientTimeoutValue: scala.Option[primitives.IntegerOptional]
      def debugLoggingValue: scala.Option[Boolean]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def engineFamily: ZIO[Any, Nothing, EngineFamily] = ZIO.succeed(engineFamilyValue)
      def auth: ZIO[Any, Nothing, List[UserAuthConfig.ReadOnly]] = ZIO.succeed(authValue)
      def roleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArnValue)
      def vpcSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(vpcSubnetIdsValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def requireTLS: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requireTLS", requireTLSValue)
      def idleClientTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeoutValue)
      def debugLogging: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("debugLogging", debugLoggingValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest) extends CreateDbProxyRequest.ReadOnly {
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def engineFamilyValue: EngineFamily = EngineFamily.wrap(impl.engineFamily())
      override def authValue: List[UserAuthConfig.ReadOnly] = impl.auth().asScala.map { item => 
        UserAuthConfig.wrap(item)
      }.toList
      override def roleArnValue: String = impl.roleArn(): String
      override def vpcSubnetIdsValue: List[String] = impl.vpcSubnetIds().asScala.map { item => 
        item: String
      }.toList
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def requireTLSValue: scala.Option[Boolean] = scala.Option(impl.requireTLS()).map(value => value: Boolean)
      override def idleClientTimeoutValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.idleClientTimeout()).map(value => value: primitives.IntegerOptional)
      override def debugLoggingValue: scala.Option[Boolean] = scala.Option(impl.debugLogging()).map(value => value: Boolean)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbProxyResponse(dbProxy: scala.Option[DBProxy] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbProxyResponse = {
      import CreateDbProxyResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbProxyResponse.builder().optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy).build()
    }
    def asReadOnly: CreateDbProxyResponse.ReadOnly = CreateDbProxyResponse.wrap(buildAwsValue())
  }
  object CreateDbProxyResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbProxyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbProxyResponse = CreateDbProxyResponse(dbProxyValue.map(value => value.editable))
      def dbProxyValue: scala.Option[DBProxy.ReadOnly]
      def dbProxy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxy.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxy", dbProxyValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyResponse) extends CreateDbProxyResponse.ReadOnly { override def dbProxyValue: scala.Option[DBProxy.ReadOnly] = scala.Option(impl.dbProxy()).map(value => DBProxy.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbProxyResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSecurityGroupRequest(dbSecurityGroupName: String, dbSecurityGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest = {
      import CreateDbSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest.builder().dbSecurityGroupName(dbSecurityGroupName: java.lang.String).dbSecurityGroupDescription(dbSecurityGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbSecurityGroupRequest.ReadOnly = CreateDbSecurityGroupRequest.wrap(buildAwsValue())
  }
  object CreateDbSecurityGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSecurityGroupRequest = CreateDbSecurityGroupRequest(dbSecurityGroupNameValue, dbSecurityGroupDescriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbSecurityGroupNameValue: String
      def dbSecurityGroupDescriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbSecurityGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSecurityGroupNameValue)
      def dbSecurityGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(dbSecurityGroupDescriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest) extends CreateDbSecurityGroupRequest.ReadOnly {
      override def dbSecurityGroupNameValue: String = impl.dbSecurityGroupName(): String
      override def dbSecurityGroupDescriptionValue: String = impl.dbSecurityGroupDescription(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSecurityGroupResponse(dbSecurityGroup: scala.Option[DBSecurityGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse = {
      import CreateDbSecurityGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse.builder().optionallyWith(dbSecurityGroup.map(value => value.buildAwsValue()))(_.dbSecurityGroup).build()
    }
    def asReadOnly: CreateDbSecurityGroupResponse.ReadOnly = CreateDbSecurityGroupResponse.wrap(buildAwsValue())
  }
  object CreateDbSecurityGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSecurityGroupResponse = CreateDbSecurityGroupResponse(dbSecurityGroupValue.map(value => value.editable))
      def dbSecurityGroupValue: scala.Option[DBSecurityGroup.ReadOnly]
      def dbSecurityGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSecurityGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroup", dbSecurityGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse) extends CreateDbSecurityGroupResponse.ReadOnly { override def dbSecurityGroupValue: scala.Option[DBSecurityGroup.ReadOnly] = scala.Option(impl.dbSecurityGroup()).map(value => DBSecurityGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSnapshotRequest(dbSnapshotIdentifier: String, dbInstanceIdentifier: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest = {
      import CreateDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest.builder().dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String).dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbSnapshotRequest.ReadOnly = CreateDbSnapshotRequest.wrap(buildAwsValue())
  }
  object CreateDbSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSnapshotRequest = CreateDbSnapshotRequest(dbSnapshotIdentifierValue, dbInstanceIdentifierValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbSnapshotIdentifierValue: String
      def dbInstanceIdentifierValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbSnapshotIdentifierValue)
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest) extends CreateDbSnapshotRequest.ReadOnly {
      override def dbSnapshotIdentifierValue: String = impl.dbSnapshotIdentifier(): String
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSnapshotResponse(dbSnapshot: scala.Option[DBSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse = {
      import CreateDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse.builder().optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(_.dbSnapshot).build()
    }
    def asReadOnly: CreateDbSnapshotResponse.ReadOnly = CreateDbSnapshotResponse.wrap(buildAwsValue())
  }
  object CreateDbSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSnapshotResponse = CreateDbSnapshotResponse(dbSnapshotValue.map(value => value.editable))
      def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly]
      def dbSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshot", dbSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse) extends CreateDbSnapshotResponse.ReadOnly { override def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly] = scala.Option(impl.dbSnapshot()).map(value => DBSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSubnetGroupRequest(dbSubnetGroupName: String, dbSubnetGroupDescription: String, subnetIds: Iterable[String], tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest = {
      import CreateDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).dbSubnetGroupDescription(dbSubnetGroupDescription: java.lang.String).subnetIds(subnetIds.map { item => 
        item: java.lang.String
      }.asJavaCollection).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateDbSubnetGroupRequest.ReadOnly = CreateDbSubnetGroupRequest.wrap(buildAwsValue())
  }
  object CreateDbSubnetGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSubnetGroupRequest = CreateDbSubnetGroupRequest(dbSubnetGroupNameValue, dbSubnetGroupDescriptionValue, subnetIdsValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbSubnetGroupNameValue: String
      def dbSubnetGroupDescriptionValue: String
      def subnetIdsValue: List[String]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
      def dbSubnetGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupDescriptionValue)
      def subnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIdsValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest) extends CreateDbSubnetGroupRequest.ReadOnly {
      override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String
      override def dbSubnetGroupDescriptionValue: String = impl.dbSubnetGroupDescription(): String
      override def subnetIdsValue: List[String] = impl.subnetIds().asScala.map { item => 
        item: String
      }.toList
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateDbSubnetGroupResponse(dbSubnetGroup: scala.Option[DBSubnetGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse = {
      import CreateDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse.builder().optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).build()
    }
    def asReadOnly: CreateDbSubnetGroupResponse.ReadOnly = CreateDbSubnetGroupResponse.wrap(buildAwsValue())
  }
  object CreateDbSubnetGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateDbSubnetGroupResponse = CreateDbSubnetGroupResponse(dbSubnetGroupValue.map(value => value.editable))
      def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
      def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse) extends CreateDbSubnetGroupResponse.ReadOnly { override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateEventSubscriptionRequest(subscriptionName: String, snsTopicArn: String, sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, sourceIds: scala.Option[Iterable[String]] = None, enabled: scala.Option[primitives.BooleanOptional] = None, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest = {
      import CreateEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).snsTopicArn(snsTopicArn: java.lang.String).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategories).optionallyWith(sourceIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.sourceIds).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateEventSubscriptionRequest.ReadOnly = CreateEventSubscriptionRequest.wrap(buildAwsValue())
  }
  object CreateEventSubscriptionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateEventSubscriptionRequest = CreateEventSubscriptionRequest(subscriptionNameValue, snsTopicArnValue, sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value), sourceIdsValue.map(value => value), enabledValue.map(value => value), tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def subscriptionNameValue: String
      def snsTopicArnValue: String
      def sourceTypeValue: scala.Option[String]
      def eventCategoriesValue: scala.Option[List[String]]
      def sourceIdsValue: scala.Option[List[String]]
      def enabledValue: scala.Option[primitives.BooleanOptional]
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
      def snsTopicArn: ZIO[Any, Nothing, String] = ZIO.succeed(snsTopicArnValue)
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
      def sourceIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIds", sourceIdsValue)
      def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest) extends CreateEventSubscriptionRequest.ReadOnly {
      override def subscriptionNameValue: String = impl.subscriptionName(): String
      override def snsTopicArnValue: String = impl.snsTopicArn(): String
      override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
      override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def sourceIdsValue: scala.Option[List[String]] = scala.Option(impl.sourceIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def enabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enabled()).map(value => value: primitives.BooleanOptional)
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateEventSubscriptionResponse(eventSubscription: scala.Option[EventSubscription] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse = {
      import CreateEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse.builder().optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(_.eventSubscription).build()
    }
    def asReadOnly: CreateEventSubscriptionResponse.ReadOnly = CreateEventSubscriptionResponse.wrap(buildAwsValue())
  }
  object CreateEventSubscriptionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateEventSubscriptionResponse = CreateEventSubscriptionResponse(eventSubscriptionValue.map(value => value.editable))
      def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly]
      def eventSubscription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EventSubscription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscription", eventSubscriptionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse) extends CreateEventSubscriptionResponse.ReadOnly { override def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly] = scala.Option(impl.eventSubscription()).map(value => EventSubscription.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateGlobalClusterRequest(globalClusterIdentifier: scala.Option[String] = None, sourceDBClusterIdentifier: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, databaseName: scala.Option[String] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest = {
      import CreateGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(sourceDBClusterIdentifier.map(value => value: java.lang.String))(_.sourceDBClusterIdentifier).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).build()
    }
    def asReadOnly: CreateGlobalClusterRequest.ReadOnly = CreateGlobalClusterRequest.wrap(buildAwsValue())
  }
  object CreateGlobalClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateGlobalClusterRequest = CreateGlobalClusterRequest(globalClusterIdentifierValue.map(value => value), sourceDBClusterIdentifierValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), deletionProtectionValue.map(value => value), databaseNameValue.map(value => value), storageEncryptedValue.map(value => value))
      def globalClusterIdentifierValue: scala.Option[String]
      def sourceDBClusterIdentifierValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def databaseNameValue: scala.Option[String]
      def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
      def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
      def sourceDBClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDBClusterIdentifier", sourceDBClusterIdentifierValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest) extends CreateGlobalClusterRequest.ReadOnly {
      override def globalClusterIdentifierValue: scala.Option[String] = scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
      override def sourceDBClusterIdentifierValue: scala.Option[String] = scala.Option(impl.sourceDBClusterIdentifier()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
      override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateGlobalClusterResponse(globalCluster: scala.Option[GlobalCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse = {
      import CreateGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse.builder().optionallyWith(globalCluster.map(value => value.buildAwsValue()))(_.globalCluster).build()
    }
    def asReadOnly: CreateGlobalClusterResponse.ReadOnly = CreateGlobalClusterResponse.wrap(buildAwsValue())
  }
  object CreateGlobalClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateGlobalClusterResponse = CreateGlobalClusterResponse(globalClusterValue.map(value => value.editable))
      def globalClusterValue: scala.Option[GlobalCluster.ReadOnly]
      def globalCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GlobalCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalCluster", globalClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse) extends CreateGlobalClusterResponse.ReadOnly { override def globalClusterValue: scala.Option[GlobalCluster.ReadOnly] = scala.Option(impl.globalCluster()).map(value => GlobalCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class CreateOptionGroupRequest(optionGroupName: String, engineName: String, majorEngineVersion: String, optionGroupDescription: String, tags: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest = {
      import CreateOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest.builder().optionGroupName(optionGroupName: java.lang.String).engineName(engineName: java.lang.String).majorEngineVersion(majorEngineVersion: java.lang.String).optionGroupDescription(optionGroupDescription: java.lang.String).optionallyWith(tags.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tags).build()
    }
    def asReadOnly: CreateOptionGroupRequest.ReadOnly = CreateOptionGroupRequest.wrap(buildAwsValue())
  }
  object CreateOptionGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateOptionGroupRequest = CreateOptionGroupRequest(optionGroupNameValue, engineNameValue, majorEngineVersionValue, optionGroupDescriptionValue, tagsValue.map(value => value.map { item => 
        item.editable
      }))
      def optionGroupNameValue: String
      def engineNameValue: String
      def majorEngineVersionValue: String
      def optionGroupDescriptionValue: String
      def tagsValue: scala.Option[List[Tag.ReadOnly]]
      def optionGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(optionGroupNameValue)
      def engineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineNameValue)
      def majorEngineVersion: ZIO[Any, Nothing, String] = ZIO.succeed(majorEngineVersionValue)
      def optionGroupDescription: ZIO[Any, Nothing, String] = ZIO.succeed(optionGroupDescriptionValue)
      def tags: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tags", tagsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest) extends CreateOptionGroupRequest.ReadOnly {
      override def optionGroupNameValue: String = impl.optionGroupName(): String
      override def engineNameValue: String = impl.engineName(): String
      override def majorEngineVersionValue: String = impl.majorEngineVersion(): String
      override def optionGroupDescriptionValue: String = impl.optionGroupDescription(): String
      override def tagsValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tags()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class CreateOptionGroupResponse(optionGroup: scala.Option[OptionGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse = {
      import CreateOptionGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse.builder().optionallyWith(optionGroup.map(value => value.buildAwsValue()))(_.optionGroup).build()
    }
    def asReadOnly: CreateOptionGroupResponse.ReadOnly = CreateOptionGroupResponse.wrap(buildAwsValue())
  }
  object CreateOptionGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CreateOptionGroupResponse = CreateOptionGroupResponse(optionGroupValue.map(value => value.editable))
      def optionGroupValue: scala.Option[OptionGroup.ReadOnly]
      def optionGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, OptionGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroup", optionGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse) extends CreateOptionGroupResponse.ReadOnly { override def optionGroupValue: scala.Option[OptionGroup.ReadOnly] = scala.Option(impl.optionGroup()).map(value => OptionGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class CustomAvailabilityZone(customAvailabilityZoneId: scala.Option[String] = None, customAvailabilityZoneName: scala.Option[String] = None, customAvailabilityZoneStatus: scala.Option[String] = None, vpnDetails: scala.Option[VpnDetails] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.CustomAvailabilityZone = {
      import CustomAvailabilityZone.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.CustomAvailabilityZone.builder().optionallyWith(customAvailabilityZoneId.map(value => value: java.lang.String))(_.customAvailabilityZoneId).optionallyWith(customAvailabilityZoneName.map(value => value: java.lang.String))(_.customAvailabilityZoneName).optionallyWith(customAvailabilityZoneStatus.map(value => value: java.lang.String))(_.customAvailabilityZoneStatus).optionallyWith(vpnDetails.map(value => value.buildAwsValue()))(_.vpnDetails).build()
    }
    def asReadOnly: CustomAvailabilityZone.ReadOnly = CustomAvailabilityZone.wrap(buildAwsValue())
  }
  object CustomAvailabilityZone {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.CustomAvailabilityZone] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: CustomAvailabilityZone = CustomAvailabilityZone(customAvailabilityZoneIdValue.map(value => value), customAvailabilityZoneNameValue.map(value => value), customAvailabilityZoneStatusValue.map(value => value), vpnDetailsValue.map(value => value.editable))
      def customAvailabilityZoneIdValue: scala.Option[String]
      def customAvailabilityZoneNameValue: scala.Option[String]
      def customAvailabilityZoneStatusValue: scala.Option[String]
      def vpnDetailsValue: scala.Option[VpnDetails.ReadOnly]
      def customAvailabilityZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneIdValue)
      def customAvailabilityZoneName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneName", customAvailabilityZoneNameValue)
      def customAvailabilityZoneStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneStatus", customAvailabilityZoneStatusValue)
      def vpnDetails: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, VpnDetails.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpnDetails", vpnDetailsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.CustomAvailabilityZone) extends CustomAvailabilityZone.ReadOnly {
      override def customAvailabilityZoneIdValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
      override def customAvailabilityZoneNameValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneName()).map(value => value: String)
      override def customAvailabilityZoneStatusValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneStatus()).map(value => value: String)
      override def vpnDetailsValue: scala.Option[VpnDetails.ReadOnly] = scala.Option(impl.vpnDetails()).map(value => VpnDetails.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.CustomAvailabilityZone): ReadOnly = new Wrapper(impl)
  }
  type CustomAvailabilityZoneList = List[CustomAvailabilityZone]
  case class DBCluster(allocatedStorage: scala.Option[primitives.IntegerOptional] = None, availabilityZones: scala.Option[Iterable[String]] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, characterSetName: scala.Option[String] = None, databaseName: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterParameterGroup: scala.Option[String] = None, dbSubnetGroup: scala.Option[String] = None, status: scala.Option[String] = None, percentProgress: scala.Option[String] = None, earliestRestorableTime: scala.Option[primitives.TStamp] = None, endpoint: scala.Option[String] = None, readerEndpoint: scala.Option[String] = None, customEndpoints: scala.Option[Iterable[String]] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, latestRestorableTime: scala.Option[primitives.TStamp] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUsername: scala.Option[String] = None, dbClusterOptionGroupMemberships: scala.Option[Iterable[DBClusterOptionGroupStatus]] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, replicationSourceIdentifier: scala.Option[String] = None, readReplicaIdentifiers: scala.Option[Iterable[String]] = None, dbClusterMembers: scala.Option[Iterable[DBClusterMember]] = None, vpcSecurityGroups: scala.Option[Iterable[VpcSecurityGroupMembership]] = None, hostedZoneId: scala.Option[String] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbClusterResourceId: scala.Option[String] = None, dbClusterArn: scala.Option[String] = None, associatedRoles: scala.Option[Iterable[DBClusterRole]] = None, iamDatabaseAuthenticationEnabled: scala.Option[primitives.BooleanOptional] = None, cloneGroupId: scala.Option[String] = None, clusterCreateTime: scala.Option[primitives.TStamp] = None, earliestBacktrackTime: scala.Option[primitives.TStamp] = None, backtrackWindow: scala.Option[primitives.LongOptional] = None, backtrackConsumedChangeRecords: scala.Option[primitives.LongOptional] = None, enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None, capacity: scala.Option[primitives.IntegerOptional] = None, engineMode: scala.Option[String] = None, scalingConfigurationInfo: scala.Option[ScalingConfigurationInfo] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, httpEndpointEnabled: scala.Option[primitives.BooleanOptional] = None, activityStreamMode: scala.Option[ActivityStreamMode] = None, activityStreamStatus: scala.Option[ActivityStreamStatus] = None, activityStreamKmsKeyId: scala.Option[String] = None, activityStreamKinesisStreamName: scala.Option[String] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, crossAccountClone: scala.Option[primitives.BooleanOptional] = None, domainMemberships: scala.Option[Iterable[DomainMembership]] = None, tagList: scala.Option[Iterable[Tag]] = None, globalWriteForwardingStatus: scala.Option[WriteForwardingStatus] = None, globalWriteForwardingRequested: scala.Option[primitives.BooleanOptional] = None, pendingModifiedValues: scala.Option[ClusterPendingModifiedValues] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBCluster = {
      import DBCluster.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBCluster.builder().optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(availabilityZones.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.availabilityZones).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(characterSetName.map(value => value: java.lang.String))(_.characterSetName).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterParameterGroup.map(value => value: java.lang.String))(_.dbClusterParameterGroup).optionallyWith(dbSubnetGroup.map(value => value: java.lang.String))(_.dbSubnetGroup).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(percentProgress.map(value => value: java.lang.String))(_.percentProgress).optionallyWith(earliestRestorableTime.map(value => value: java.time.Instant))(_.earliestRestorableTime).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(readerEndpoint.map(value => value: java.lang.String))(_.readerEndpoint).optionallyWith(customEndpoints.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.customEndpoints).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(latestRestorableTime.map(value => value: java.time.Instant))(_.latestRestorableTime).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(dbClusterOptionGroupMemberships.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterOptionGroupMemberships).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(replicationSourceIdentifier.map(value => value: java.lang.String))(_.replicationSourceIdentifier).optionallyWith(readReplicaIdentifiers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.readReplicaIdentifiers).optionallyWith(dbClusterMembers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterMembers).optionallyWith(vpcSecurityGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.vpcSecurityGroups).optionallyWith(hostedZoneId.map(value => value: java.lang.String))(_.hostedZoneId).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbClusterResourceId.map(value => value: java.lang.String))(_.dbClusterResourceId).optionallyWith(dbClusterArn.map(value => value: java.lang.String))(_.dbClusterArn).optionallyWith(associatedRoles.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.associatedRoles).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(cloneGroupId.map(value => value: java.lang.String))(_.cloneGroupId).optionallyWith(clusterCreateTime.map(value => value: java.time.Instant))(_.clusterCreateTime).optionallyWith(earliestBacktrackTime.map(value => value: java.time.Instant))(_.earliestBacktrackTime).optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(_.backtrackWindow).optionallyWith(backtrackConsumedChangeRecords.map(value => value: java.lang.Long))(_.backtrackConsumedChangeRecords).optionallyWith(enabledCloudwatchLogsExports.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enabledCloudwatchLogsExports).optionallyWith(capacity.map(value => value: java.lang.Integer))(_.capacity).optionallyWith(engineMode.map(value => value: java.lang.String))(_.engineMode).optionallyWith(scalingConfigurationInfo.map(value => value.buildAwsValue()))(_.scalingConfigurationInfo).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(httpEndpointEnabled.map(value => value: java.lang.Boolean))(_.httpEndpointEnabled).optionallyWith(activityStreamMode.map(value => value.unwrap))(_.activityStreamMode).optionallyWith(activityStreamStatus.map(value => value.unwrap))(_.activityStreamStatus).optionallyWith(activityStreamKmsKeyId.map(value => value: java.lang.String))(_.activityStreamKmsKeyId).optionallyWith(activityStreamKinesisStreamName.map(value => value: java.lang.String))(_.activityStreamKinesisStreamName).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(crossAccountClone.map(value => value: java.lang.Boolean))(_.crossAccountClone).optionallyWith(domainMemberships.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.domainMemberships).optionallyWith(tagList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tagList).optionallyWith(globalWriteForwardingStatus.map(value => value.unwrap))(_.globalWriteForwardingStatus).optionallyWith(globalWriteForwardingRequested.map(value => value: java.lang.Boolean))(_.globalWriteForwardingRequested).optionallyWith(pendingModifiedValues.map(value => value.buildAwsValue()))(_.pendingModifiedValues).build()
    }
    def asReadOnly: DBCluster.ReadOnly = DBCluster.wrap(buildAwsValue())
  }
  object DBCluster {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBCluster] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBCluster = DBCluster(allocatedStorageValue.map(value => value), availabilityZonesValue.map(value => value), backupRetentionPeriodValue.map(value => value), characterSetNameValue.map(value => value), databaseNameValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterParameterGroupValue.map(value => value), dbSubnetGroupValue.map(value => value), statusValue.map(value => value), percentProgressValue.map(value => value), earliestRestorableTimeValue.map(value => value), endpointValue.map(value => value), readerEndpointValue.map(value => value), customEndpointsValue.map(value => value), multiAZValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), latestRestorableTimeValue.map(value => value), portValue.map(value => value), masterUsernameValue.map(value => value), dbClusterOptionGroupMembershipsValue.map(value => value.map { item => 
        item.editable
      }), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), replicationSourceIdentifierValue.map(value => value), readReplicaIdentifiersValue.map(value => value), dbClusterMembersValue.map(value => value.map { item => 
        item.editable
      }), vpcSecurityGroupsValue.map(value => value.map { item => 
        item.editable
      }), hostedZoneIdValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbClusterResourceIdValue.map(value => value), dbClusterArnValue.map(value => value), associatedRolesValue.map(value => value.map { item => 
        item.editable
      }), iamDatabaseAuthenticationEnabledValue.map(value => value), cloneGroupIdValue.map(value => value), clusterCreateTimeValue.map(value => value), earliestBacktrackTimeValue.map(value => value), backtrackWindowValue.map(value => value), backtrackConsumedChangeRecordsValue.map(value => value), enabledCloudwatchLogsExportsValue.map(value => value), capacityValue.map(value => value), engineModeValue.map(value => value), scalingConfigurationInfoValue.map(value => value.editable), deletionProtectionValue.map(value => value), httpEndpointEnabledValue.map(value => value), activityStreamModeValue.map(value => value), activityStreamStatusValue.map(value => value), activityStreamKmsKeyIdValue.map(value => value), activityStreamKinesisStreamNameValue.map(value => value), copyTagsToSnapshotValue.map(value => value), crossAccountCloneValue.map(value => value), domainMembershipsValue.map(value => value.map { item => 
        item.editable
      }), tagListValue.map(value => value.map { item => 
        item.editable
      }), globalWriteForwardingStatusValue.map(value => value), globalWriteForwardingRequestedValue.map(value => value), pendingModifiedValuesValue.map(value => value.editable))
      def allocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def availabilityZonesValue: scala.Option[List[String]]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def characterSetNameValue: scala.Option[String]
      def databaseNameValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterParameterGroupValue: scala.Option[String]
      def dbSubnetGroupValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def percentProgressValue: scala.Option[String]
      def earliestRestorableTimeValue: scala.Option[primitives.TStamp]
      def endpointValue: scala.Option[String]
      def readerEndpointValue: scala.Option[String]
      def customEndpointsValue: scala.Option[List[String]]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def latestRestorableTimeValue: scala.Option[primitives.TStamp]
      def portValue: scala.Option[primitives.IntegerOptional]
      def masterUsernameValue: scala.Option[String]
      def dbClusterOptionGroupMembershipsValue: scala.Option[List[DBClusterOptionGroupStatus.ReadOnly]]
      def preferredBackupWindowValue: scala.Option[String]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def replicationSourceIdentifierValue: scala.Option[String]
      def readReplicaIdentifiersValue: scala.Option[List[String]]
      def dbClusterMembersValue: scala.Option[List[DBClusterMember.ReadOnly]]
      def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]]
      def hostedZoneIdValue: scala.Option[String]
      def storageEncryptedValue: scala.Option[Boolean]
      def kmsKeyIdValue: scala.Option[String]
      def dbClusterResourceIdValue: scala.Option[String]
      def dbClusterArnValue: scala.Option[String]
      def associatedRolesValue: scala.Option[List[DBClusterRole.ReadOnly]]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[primitives.BooleanOptional]
      def cloneGroupIdValue: scala.Option[String]
      def clusterCreateTimeValue: scala.Option[primitives.TStamp]
      def earliestBacktrackTimeValue: scala.Option[primitives.TStamp]
      def backtrackWindowValue: scala.Option[primitives.LongOptional]
      def backtrackConsumedChangeRecordsValue: scala.Option[primitives.LongOptional]
      def enabledCloudwatchLogsExportsValue: scala.Option[List[String]]
      def capacityValue: scala.Option[primitives.IntegerOptional]
      def engineModeValue: scala.Option[String]
      def scalingConfigurationInfoValue: scala.Option[ScalingConfigurationInfo.ReadOnly]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def httpEndpointEnabledValue: scala.Option[primitives.BooleanOptional]
      def activityStreamModeValue: scala.Option[ActivityStreamMode]
      def activityStreamStatusValue: scala.Option[ActivityStreamStatus]
      def activityStreamKmsKeyIdValue: scala.Option[String]
      def activityStreamKinesisStreamNameValue: scala.Option[String]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def crossAccountCloneValue: scala.Option[primitives.BooleanOptional]
      def domainMembershipsValue: scala.Option[List[DomainMembership.ReadOnly]]
      def tagListValue: scala.Option[List[Tag.ReadOnly]]
      def globalWriteForwardingStatusValue: scala.Option[WriteForwardingStatus]
      def globalWriteForwardingRequestedValue: scala.Option[primitives.BooleanOptional]
      def pendingModifiedValuesValue: scala.Option[ClusterPendingModifiedValues.ReadOnly]
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def characterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetName", characterSetNameValue)
      def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterParameterGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroup", dbClusterParameterGroupValue)
      def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
      def earliestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("earliestRestorableTime", earliestRestorableTimeValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def readerEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readerEndpoint", readerEndpointValue)
      def customEndpoints: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customEndpoints", customEndpointsValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def latestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def dbClusterOptionGroupMemberships: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterOptionGroupStatus.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterOptionGroupMemberships", dbClusterOptionGroupMembershipsValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def replicationSourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicationSourceIdentifier", replicationSourceIdentifierValue)
      def readReplicaIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readReplicaIdentifiers", readReplicaIdentifiersValue)
      def dbClusterMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterMember.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterMembers", dbClusterMembersValue)
      def vpcSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VpcSecurityGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroupsValue)
      def hostedZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hostedZoneId", hostedZoneIdValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def dbClusterResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterResourceId", dbClusterResourceIdValue)
      def dbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterArn", dbClusterArnValue)
      def associatedRoles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterRole.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedRoles", associatedRolesValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def cloneGroupId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloneGroupId", cloneGroupIdValue)
      def clusterCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTimeValue)
      def earliestBacktrackTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("earliestBacktrackTime", earliestBacktrackTimeValue)
      def backtrackWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackWindow", backtrackWindowValue)
      def backtrackConsumedChangeRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackConsumedChangeRecords", backtrackConsumedChangeRecordsValue)
      def enabledCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabledCloudwatchLogsExports", enabledCloudwatchLogsExportsValue)
      def capacity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("capacity", capacityValue)
      def engineMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineMode", engineModeValue)
      def scalingConfigurationInfo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ScalingConfigurationInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scalingConfigurationInfo", scalingConfigurationInfoValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def httpEndpointEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("httpEndpointEnabled", httpEndpointEnabledValue)
      def activityStreamMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ActivityStreamMode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activityStreamMode", activityStreamModeValue)
      def activityStreamStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ActivityStreamStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activityStreamStatus", activityStreamStatusValue)
      def activityStreamKmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activityStreamKmsKeyId", activityStreamKmsKeyIdValue)
      def activityStreamKinesisStreamName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("activityStreamKinesisStreamName", activityStreamKinesisStreamNameValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def crossAccountClone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("crossAccountClone", crossAccountCloneValue)
      def domainMemberships: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DomainMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainMemberships", domainMembershipsValue)
      def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
      def globalWriteForwardingStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, WriteForwardingStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalWriteForwardingStatus", globalWriteForwardingStatusValue)
      def globalWriteForwardingRequested: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalWriteForwardingRequested", globalWriteForwardingRequestedValue)
      def pendingModifiedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ClusterPendingModifiedValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValuesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBCluster) extends DBCluster.ReadOnly {
      override def allocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def characterSetNameValue: scala.Option[String] = scala.Option(impl.characterSetName()).map(value => value: String)
      override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterParameterGroupValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroup()).map(value => value: String)
      override def dbSubnetGroupValue: scala.Option[String] = scala.Option(impl.dbSubnetGroup()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def percentProgressValue: scala.Option[String] = scala.Option(impl.percentProgress()).map(value => value: String)
      override def earliestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.earliestRestorableTime()).map(value => value: primitives.TStamp)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def readerEndpointValue: scala.Option[String] = scala.Option(impl.readerEndpoint()).map(value => value: String)
      override def customEndpointsValue: scala.Option[List[String]] = scala.Option(impl.customEndpoints()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def latestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.latestRestorableTime()).map(value => value: primitives.TStamp)
      override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def dbClusterOptionGroupMembershipsValue: scala.Option[List[DBClusterOptionGroupStatus.ReadOnly]] = scala.Option(impl.dbClusterOptionGroupMemberships()).map(value => value.asScala.map { item => 
        DBClusterOptionGroupStatus.wrap(item)
      }.toList)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def replicationSourceIdentifierValue: scala.Option[String] = scala.Option(impl.replicationSourceIdentifier()).map(value => value: String)
      override def readReplicaIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.readReplicaIdentifiers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterMembersValue: scala.Option[List[DBClusterMember.ReadOnly]] = scala.Option(impl.dbClusterMembers()).map(value => value.asScala.map { item => 
        DBClusterMember.wrap(item)
      }.toList)
      override def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]] = scala.Option(impl.vpcSecurityGroups()).map(value => value.asScala.map { item => 
        VpcSecurityGroupMembership.wrap(item)
      }.toList)
      override def hostedZoneIdValue: scala.Option[String] = scala.Option(impl.hostedZoneId()).map(value => value: String)
      override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def dbClusterResourceIdValue: scala.Option[String] = scala.Option(impl.dbClusterResourceId()).map(value => value: String)
      override def dbClusterArnValue: scala.Option[String] = scala.Option(impl.dbClusterArn()).map(value => value: String)
      override def associatedRolesValue: scala.Option[List[DBClusterRole.ReadOnly]] = scala.Option(impl.associatedRoles()).map(value => value.asScala.map { item => 
        DBClusterRole.wrap(item)
      }.toList)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: primitives.BooleanOptional)
      override def cloneGroupIdValue: scala.Option[String] = scala.Option(impl.cloneGroupId()).map(value => value: String)
      override def clusterCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.clusterCreateTime()).map(value => value: primitives.TStamp)
      override def earliestBacktrackTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.earliestBacktrackTime()).map(value => value: primitives.TStamp)
      override def backtrackWindowValue: scala.Option[primitives.LongOptional] = scala.Option(impl.backtrackWindow()).map(value => value: primitives.LongOptional)
      override def backtrackConsumedChangeRecordsValue: scala.Option[primitives.LongOptional] = scala.Option(impl.backtrackConsumedChangeRecords()).map(value => value: primitives.LongOptional)
      override def enabledCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enabledCloudwatchLogsExports()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def capacityValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.capacity()).map(value => value: primitives.IntegerOptional)
      override def engineModeValue: scala.Option[String] = scala.Option(impl.engineMode()).map(value => value: String)
      override def scalingConfigurationInfoValue: scala.Option[ScalingConfigurationInfo.ReadOnly] = scala.Option(impl.scalingConfigurationInfo()).map(value => ScalingConfigurationInfo.wrap(value))
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def httpEndpointEnabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.httpEndpointEnabled()).map(value => value: primitives.BooleanOptional)
      override def activityStreamModeValue: scala.Option[ActivityStreamMode] = scala.Option(impl.activityStreamMode()).map(value => ActivityStreamMode.wrap(value))
      override def activityStreamStatusValue: scala.Option[ActivityStreamStatus] = scala.Option(impl.activityStreamStatus()).map(value => ActivityStreamStatus.wrap(value))
      override def activityStreamKmsKeyIdValue: scala.Option[String] = scala.Option(impl.activityStreamKmsKeyId()).map(value => value: String)
      override def activityStreamKinesisStreamNameValue: scala.Option[String] = scala.Option(impl.activityStreamKinesisStreamName()).map(value => value: String)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def crossAccountCloneValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.crossAccountClone()).map(value => value: primitives.BooleanOptional)
      override def domainMembershipsValue: scala.Option[List[DomainMembership.ReadOnly]] = scala.Option(impl.domainMemberships()).map(value => value.asScala.map { item => 
        DomainMembership.wrap(item)
      }.toList)
      override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def globalWriteForwardingStatusValue: scala.Option[WriteForwardingStatus] = scala.Option(impl.globalWriteForwardingStatus()).map(value => WriteForwardingStatus.wrap(value))
      override def globalWriteForwardingRequestedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.globalWriteForwardingRequested()).map(value => value: primitives.BooleanOptional)
      override def pendingModifiedValuesValue: scala.Option[ClusterPendingModifiedValues.ReadOnly] = scala.Option(impl.pendingModifiedValues()).map(value => ClusterPendingModifiedValues.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBCluster): ReadOnly = new Wrapper(impl)
  }
  case class DBClusterBacktrack(dbClusterIdentifier: scala.Option[String] = None, backtrackIdentifier: scala.Option[String] = None, backtrackTo: scala.Option[primitives.TStamp] = None, backtrackedFrom: scala.Option[primitives.TStamp] = None, backtrackRequestCreationTime: scala.Option[primitives.TStamp] = None, status: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterBacktrack = {
      import DBClusterBacktrack.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterBacktrack.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(backtrackIdentifier.map(value => value: java.lang.String))(_.backtrackIdentifier).optionallyWith(backtrackTo.map(value => value: java.time.Instant))(_.backtrackTo).optionallyWith(backtrackedFrom.map(value => value: java.time.Instant))(_.backtrackedFrom).optionallyWith(backtrackRequestCreationTime.map(value => value: java.time.Instant))(_.backtrackRequestCreationTime).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
    }
    def asReadOnly: DBClusterBacktrack.ReadOnly = DBClusterBacktrack.wrap(buildAwsValue())
  }
  object DBClusterBacktrack {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterBacktrack] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterBacktrack = DBClusterBacktrack(dbClusterIdentifierValue.map(value => value), backtrackIdentifierValue.map(value => value), backtrackToValue.map(value => value), backtrackedFromValue.map(value => value), backtrackRequestCreationTimeValue.map(value => value), statusValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def backtrackIdentifierValue: scala.Option[String]
      def backtrackToValue: scala.Option[primitives.TStamp]
      def backtrackedFromValue: scala.Option[primitives.TStamp]
      def backtrackRequestCreationTimeValue: scala.Option[primitives.TStamp]
      def statusValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def backtrackIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackIdentifier", backtrackIdentifierValue)
      def backtrackTo: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackTo", backtrackToValue)
      def backtrackedFrom: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackedFrom", backtrackedFromValue)
      def backtrackRequestCreationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackRequestCreationTime", backtrackRequestCreationTimeValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterBacktrack) extends DBClusterBacktrack.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def backtrackIdentifierValue: scala.Option[String] = scala.Option(impl.backtrackIdentifier()).map(value => value: String)
      override def backtrackToValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackTo()).map(value => value: primitives.TStamp)
      override def backtrackedFromValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackedFrom()).map(value => value: primitives.TStamp)
      override def backtrackRequestCreationTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.backtrackRequestCreationTime()).map(value => value: primitives.TStamp)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterBacktrack): ReadOnly = new Wrapper(impl)
  }
  type DBClusterBacktrackList = List[DBClusterBacktrack]
  case class DBClusterEndpoint(dbClusterEndpointIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterEndpointResourceIdentifier: scala.Option[String] = None, endpoint: scala.Option[String] = None, status: scala.Option[String] = None, endpointType: scala.Option[String] = None, customEndpointType: scala.Option[String] = None, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None, dbClusterEndpointArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterEndpoint = {
      import DBClusterEndpoint.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterEndpoint.builder().optionallyWith(dbClusterEndpointIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterEndpointResourceIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointResourceIdentifier).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(endpointType.map(value => value: java.lang.String))(_.endpointType).optionallyWith(customEndpointType.map(value => value: java.lang.String))(_.customEndpointType).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).optionallyWith(dbClusterEndpointArn.map(value => value: java.lang.String))(_.dbClusterEndpointArn).build()
    }
    def asReadOnly: DBClusterEndpoint.ReadOnly = DBClusterEndpoint.wrap(buildAwsValue())
  }
  object DBClusterEndpoint {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterEndpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterEndpoint = DBClusterEndpoint(dbClusterEndpointIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterEndpointResourceIdentifierValue.map(value => value), endpointValue.map(value => value), statusValue.map(value => value), endpointTypeValue.map(value => value), customEndpointTypeValue.map(value => value), staticMembersValue.map(value => value), excludedMembersValue.map(value => value), dbClusterEndpointArnValue.map(value => value))
      def dbClusterEndpointIdentifierValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterEndpointResourceIdentifierValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def endpointTypeValue: scala.Option[String]
      def customEndpointTypeValue: scala.Option[String]
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def dbClusterEndpointArnValue: scala.Option[String]
      def dbClusterEndpointIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointIdentifier", dbClusterEndpointIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterEndpointResourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointResourceIdentifier", dbClusterEndpointResourceIdentifierValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def endpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpointType", endpointTypeValue)
      def customEndpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customEndpointType", customEndpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
      def dbClusterEndpointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterEndpoint) extends DBClusterEndpoint.ReadOnly {
      override def dbClusterEndpointIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointIdentifier()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterEndpointResourceIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointResourceIdentifier()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def endpointTypeValue: scala.Option[String] = scala.Option(impl.endpointType()).map(value => value: String)
      override def customEndpointTypeValue: scala.Option[String] = scala.Option(impl.customEndpointType()).map(value => value: String)
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterEndpointArnValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterEndpoint): ReadOnly = new Wrapper(impl)
  }
  type DBClusterEndpointList = List[DBClusterEndpoint]
  type DBClusterList = List[DBCluster]
  case class DBClusterMember(dbInstanceIdentifier: scala.Option[String] = None, isClusterWriter: scala.Option[Boolean] = None, dbClusterParameterGroupStatus: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterMember = {
      import DBClusterMember.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterMember.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(isClusterWriter.map(value => value: java.lang.Boolean))(_.isClusterWriter).optionallyWith(dbClusterParameterGroupStatus.map(value => value: java.lang.String))(_.dbClusterParameterGroupStatus).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).build()
    }
    def asReadOnly: DBClusterMember.ReadOnly = DBClusterMember.wrap(buildAwsValue())
  }
  object DBClusterMember {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterMember] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterMember = DBClusterMember(dbInstanceIdentifierValue.map(value => value), isClusterWriterValue.map(value => value), dbClusterParameterGroupStatusValue.map(value => value), promotionTierValue.map(value => value))
      def dbInstanceIdentifierValue: scala.Option[String]
      def isClusterWriterValue: scala.Option[Boolean]
      def dbClusterParameterGroupStatusValue: scala.Option[String]
      def promotionTierValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def isClusterWriter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isClusterWriter", isClusterWriterValue)
      def dbClusterParameterGroupStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupStatus", dbClusterParameterGroupStatusValue)
      def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterMember) extends DBClusterMember.ReadOnly {
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def isClusterWriterValue: scala.Option[Boolean] = scala.Option(impl.isClusterWriter()).map(value => value: Boolean)
      override def dbClusterParameterGroupStatusValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupStatus()).map(value => value: String)
      override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterMember): ReadOnly = new Wrapper(impl)
  }
  type DBClusterMemberList = List[DBClusterMember]
  type DBClusterOptionGroupMemberships = List[DBClusterOptionGroupStatus]
  case class DBClusterOptionGroupStatus(dbClusterOptionGroupName: scala.Option[String] = None, status: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus = {
      import DBClusterOptionGroupStatus.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus.builder().optionallyWith(dbClusterOptionGroupName.map(value => value: java.lang.String))(_.dbClusterOptionGroupName).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
    }
    def asReadOnly: DBClusterOptionGroupStatus.ReadOnly = DBClusterOptionGroupStatus.wrap(buildAwsValue())
  }
  object DBClusterOptionGroupStatus {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterOptionGroupStatus = DBClusterOptionGroupStatus(dbClusterOptionGroupNameValue.map(value => value), statusValue.map(value => value))
      def dbClusterOptionGroupNameValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def dbClusterOptionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterOptionGroupName", dbClusterOptionGroupNameValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus) extends DBClusterOptionGroupStatus.ReadOnly {
      override def dbClusterOptionGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterOptionGroupName()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus): ReadOnly = new Wrapper(impl)
  }
  case class DBClusterParameterGroup(dbClusterParameterGroupName: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, description: scala.Option[String] = None, dbClusterParameterGroupArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterParameterGroup = {
      import DBClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterParameterGroup.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(dbClusterParameterGroupArn.map(value => value: java.lang.String))(_.dbClusterParameterGroupArn).build()
    }
    def asReadOnly: DBClusterParameterGroup.ReadOnly = DBClusterParameterGroup.wrap(buildAwsValue())
  }
  object DBClusterParameterGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterParameterGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterParameterGroup = DBClusterParameterGroup(dbClusterParameterGroupNameValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), descriptionValue.map(value => value), dbClusterParameterGroupArnValue.map(value => value))
      def dbClusterParameterGroupNameValue: scala.Option[String]
      def dbParameterGroupFamilyValue: scala.Option[String]
      def descriptionValue: scala.Option[String]
      def dbClusterParameterGroupArnValue: scala.Option[String]
      def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
      def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
      def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
      def dbClusterParameterGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupArn", dbClusterParameterGroupArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup) extends DBClusterParameterGroup.ReadOnly {
      override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
      override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
      override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
      override def dbClusterParameterGroupArnValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterParameterGroup): ReadOnly = new Wrapper(impl)
  }
  type DBClusterParameterGroupList = List[DBClusterParameterGroup]
  case class DBClusterRole(roleArn: scala.Option[String] = None, status: scala.Option[String] = None, featureName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterRole = {
      import DBClusterRole.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterRole.builder().optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(featureName.map(value => value: java.lang.String))(_.featureName).build()
    }
    def asReadOnly: DBClusterRole.ReadOnly = DBClusterRole.wrap(buildAwsValue())
  }
  object DBClusterRole {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterRole] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterRole = DBClusterRole(roleArnValue.map(value => value), statusValue.map(value => value), featureNameValue.map(value => value))
      def roleArnValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def featureNameValue: scala.Option[String]
      def roleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArn", roleArnValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def featureName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("featureName", featureNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterRole) extends DBClusterRole.ReadOnly {
      override def roleArnValue: scala.Option[String] = scala.Option(impl.roleArn()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def featureNameValue: scala.Option[String] = scala.Option(impl.featureName()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterRole): ReadOnly = new Wrapper(impl)
  }
  type DBClusterRoles = List[DBClusterRole]
  case class DBClusterSnapshot(availabilityZones: scala.Option[Iterable[String]] = None, dbClusterSnapshotIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, snapshotCreateTime: scala.Option[primitives.TStamp] = None, engine: scala.Option[String] = None, engineMode: scala.Option[String] = None, allocatedStorage: scala.Option[primitives.Integer] = None, status: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, vpcId: scala.Option[String] = None, clusterCreateTime: scala.Option[primitives.TStamp] = None, masterUsername: scala.Option[String] = None, engineVersion: scala.Option[String] = None, licenseModel: scala.Option[String] = None, snapshotType: scala.Option[String] = None, percentProgress: scala.Option[primitives.Integer] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbClusterSnapshotArn: scala.Option[String] = None, sourceDBClusterSnapshotArn: scala.Option[String] = None, iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None, tagList: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterSnapshot = {
      import DBClusterSnapshot.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterSnapshot.builder().optionallyWith(availabilityZones.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.availabilityZones).optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(snapshotCreateTime.map(value => value: java.time.Instant))(_.snapshotCreateTime).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineMode.map(value => value: java.lang.String))(_.engineMode).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(clusterCreateTime.map(value => value: java.time.Instant))(_.clusterCreateTime).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(percentProgress.map(value => value: java.lang.Integer))(_.percentProgress).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbClusterSnapshotArn.map(value => value: java.lang.String))(_.dbClusterSnapshotArn).optionallyWith(sourceDBClusterSnapshotArn.map(value => value: java.lang.String))(_.sourceDBClusterSnapshotArn).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(tagList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tagList).build()
    }
    def asReadOnly: DBClusterSnapshot.ReadOnly = DBClusterSnapshot.wrap(buildAwsValue())
  }
  object DBClusterSnapshot {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterSnapshot = DBClusterSnapshot(availabilityZonesValue.map(value => value), dbClusterSnapshotIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), snapshotCreateTimeValue.map(value => value), engineValue.map(value => value), engineModeValue.map(value => value), allocatedStorageValue.map(value => value), statusValue.map(value => value), portValue.map(value => value), vpcIdValue.map(value => value), clusterCreateTimeValue.map(value => value), masterUsernameValue.map(value => value), engineVersionValue.map(value => value), licenseModelValue.map(value => value), snapshotTypeValue.map(value => value), percentProgressValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbClusterSnapshotArnValue.map(value => value), sourceDBClusterSnapshotArnValue.map(value => value), iamDatabaseAuthenticationEnabledValue.map(value => value), tagListValue.map(value => value.map { item => 
        item.editable
      }))
      def availabilityZonesValue: scala.Option[List[String]]
      def dbClusterSnapshotIdentifierValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def snapshotCreateTimeValue: scala.Option[primitives.TStamp]
      def engineValue: scala.Option[String]
      def engineModeValue: scala.Option[String]
      def allocatedStorageValue: scala.Option[primitives.Integer]
      def statusValue: scala.Option[String]
      def portValue: scala.Option[primitives.Integer]
      def vpcIdValue: scala.Option[String]
      def clusterCreateTimeValue: scala.Option[primitives.TStamp]
      def masterUsernameValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def licenseModelValue: scala.Option[String]
      def snapshotTypeValue: scala.Option[String]
      def percentProgressValue: scala.Option[primitives.Integer]
      def storageEncryptedValue: scala.Option[Boolean]
      def kmsKeyIdValue: scala.Option[String]
      def dbClusterSnapshotArnValue: scala.Option[String]
      def sourceDBClusterSnapshotArnValue: scala.Option[String]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean]
      def tagListValue: scala.Option[List[Tag.ReadOnly]]
      def availabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZones", availabilityZonesValue)
      def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def snapshotCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTimeValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineMode", engineModeValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def clusterCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTimeValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
      def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def dbClusterSnapshotArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotArn", dbClusterSnapshotArnValue)
      def sourceDBClusterSnapshotArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDBClusterSnapshotArn", sourceDBClusterSnapshotArnValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot) extends DBClusterSnapshot.ReadOnly {
      override def availabilityZonesValue: scala.Option[List[String]] = scala.Option(impl.availabilityZones()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def snapshotCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.snapshotCreateTime()).map(value => value: primitives.TStamp)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineModeValue: scala.Option[String] = scala.Option(impl.engineMode()).map(value => value: String)
      override def allocatedStorageValue: scala.Option[primitives.Integer] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.Integer)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def clusterCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.clusterCreateTime()).map(value => value: primitives.TStamp)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
      override def percentProgressValue: scala.Option[primitives.Integer] = scala.Option(impl.percentProgress()).map(value => value: primitives.Integer)
      override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def dbClusterSnapshotArnValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotArn()).map(value => value: String)
      override def sourceDBClusterSnapshotArnValue: scala.Option[String] = scala.Option(impl.sourceDBClusterSnapshotArn()).map(value => value: String)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: Boolean)
      override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshot): ReadOnly = new Wrapper(impl)
  }
  case class DBClusterSnapshotAttribute(attributeName: scala.Option[String] = None, attributeValues: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute = {
      import DBClusterSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute.builder().optionallyWith(attributeName.map(value => value: java.lang.String))(_.attributeName).optionallyWith(attributeValues.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.attributeValues).build()
    }
    def asReadOnly: DBClusterSnapshotAttribute.ReadOnly = DBClusterSnapshotAttribute.wrap(buildAwsValue())
  }
  object DBClusterSnapshotAttribute {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterSnapshotAttribute = DBClusterSnapshotAttribute(attributeNameValue.map(value => value), attributeValuesValue.map(value => value))
      def attributeNameValue: scala.Option[String]
      def attributeValuesValue: scala.Option[List[String]]
      def attributeName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeName", attributeNameValue)
      def attributeValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeValues", attributeValuesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute) extends DBClusterSnapshotAttribute.ReadOnly {
      override def attributeNameValue: scala.Option[String] = scala.Option(impl.attributeName()).map(value => value: String)
      override def attributeValuesValue: scala.Option[List[String]] = scala.Option(impl.attributeValues()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttribute): ReadOnly = new Wrapper(impl)
  }
  type DBClusterSnapshotAttributeList = List[DBClusterSnapshotAttribute]
  case class DBClusterSnapshotAttributesResult(dbClusterSnapshotIdentifier: scala.Option[String] = None, dbClusterSnapshotAttributes: scala.Option[Iterable[DBClusterSnapshotAttribute]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult = {
      import DBClusterSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult.builder().optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(dbClusterSnapshotAttributes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterSnapshotAttributes).build()
    }
    def asReadOnly: DBClusterSnapshotAttributesResult.ReadOnly = DBClusterSnapshotAttributesResult.wrap(buildAwsValue())
  }
  object DBClusterSnapshotAttributesResult {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBClusterSnapshotAttributesResult = DBClusterSnapshotAttributesResult(dbClusterSnapshotIdentifierValue.map(value => value), dbClusterSnapshotAttributesValue.map(value => value.map { item => 
        item.editable
      }))
      def dbClusterSnapshotIdentifierValue: scala.Option[String]
      def dbClusterSnapshotAttributesValue: scala.Option[List[DBClusterSnapshotAttribute.ReadOnly]]
      def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
      def dbClusterSnapshotAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterSnapshotAttribute.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotAttributes", dbClusterSnapshotAttributesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult) extends DBClusterSnapshotAttributesResult.ReadOnly {
      override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
      override def dbClusterSnapshotAttributesValue: scala.Option[List[DBClusterSnapshotAttribute.ReadOnly]] = scala.Option(impl.dbClusterSnapshotAttributes()).map(value => value.asScala.map { item => 
        DBClusterSnapshotAttribute.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBClusterSnapshotAttributesResult): ReadOnly = new Wrapper(impl)
  }
  type DBClusterSnapshotList = List[DBClusterSnapshot]
  case class DBEngineVersion(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, dbEngineDescription: scala.Option[String] = None, dbEngineVersionDescription: scala.Option[String] = None, defaultCharacterSet: scala.Option[CharacterSet] = None, supportedCharacterSets: scala.Option[Iterable[CharacterSet]] = None, supportedNcharCharacterSets: scala.Option[Iterable[CharacterSet]] = None, validUpgradeTarget: scala.Option[Iterable[UpgradeTarget]] = None, supportedTimezones: scala.Option[Iterable[Timezone]] = None, exportableLogTypes: scala.Option[Iterable[String]] = None, supportsLogExportsToCloudwatchLogs: scala.Option[Boolean] = None, supportsReadReplica: scala.Option[Boolean] = None, supportedEngineModes: scala.Option[Iterable[String]] = None, supportedFeatureNames: scala.Option[Iterable[String]] = None, status: scala.Option[String] = None, supportsParallelQuery: scala.Option[Boolean] = None, supportsGlobalDatabases: scala.Option[Boolean] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBEngineVersion = {
      import DBEngineVersion.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBEngineVersion.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(dbEngineDescription.map(value => value: java.lang.String))(_.dbEngineDescription).optionallyWith(dbEngineVersionDescription.map(value => value: java.lang.String))(_.dbEngineVersionDescription).optionallyWith(defaultCharacterSet.map(value => value.buildAwsValue()))(_.defaultCharacterSet).optionallyWith(supportedCharacterSets.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.supportedCharacterSets).optionallyWith(supportedNcharCharacterSets.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.supportedNcharCharacterSets).optionallyWith(validUpgradeTarget.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.validUpgradeTarget).optionallyWith(supportedTimezones.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.supportedTimezones).optionallyWith(exportableLogTypes.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.exportableLogTypes).optionallyWith(supportsLogExportsToCloudwatchLogs.map(value => value: java.lang.Boolean))(_.supportsLogExportsToCloudwatchLogs).optionallyWith(supportsReadReplica.map(value => value: java.lang.Boolean))(_.supportsReadReplica).optionallyWith(supportedEngineModes.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.supportedEngineModes).optionallyWith(supportedFeatureNames.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.supportedFeatureNames).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(supportsParallelQuery.map(value => value: java.lang.Boolean))(_.supportsParallelQuery).optionallyWith(supportsGlobalDatabases.map(value => value: java.lang.Boolean))(_.supportsGlobalDatabases).build()
    }
    def asReadOnly: DBEngineVersion.ReadOnly = DBEngineVersion.wrap(buildAwsValue())
  }
  object DBEngineVersion {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBEngineVersion] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBEngineVersion = DBEngineVersion(engineValue.map(value => value), engineVersionValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), dbEngineDescriptionValue.map(value => value), dbEngineVersionDescriptionValue.map(value => value), defaultCharacterSetValue.map(value => value.editable), supportedCharacterSetsValue.map(value => value.map { item => 
        item.editable
      }), supportedNcharCharacterSetsValue.map(value => value.map { item => 
        item.editable
      }), validUpgradeTargetValue.map(value => value.map { item => 
        item.editable
      }), supportedTimezonesValue.map(value => value.map { item => 
        item.editable
      }), exportableLogTypesValue.map(value => value), supportsLogExportsToCloudwatchLogsValue.map(value => value), supportsReadReplicaValue.map(value => value), supportedEngineModesValue.map(value => value), supportedFeatureNamesValue.map(value => value), statusValue.map(value => value), supportsParallelQueryValue.map(value => value), supportsGlobalDatabasesValue.map(value => value))
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def dbParameterGroupFamilyValue: scala.Option[String]
      def dbEngineDescriptionValue: scala.Option[String]
      def dbEngineVersionDescriptionValue: scala.Option[String]
      def defaultCharacterSetValue: scala.Option[CharacterSet.ReadOnly]
      def supportedCharacterSetsValue: scala.Option[List[CharacterSet.ReadOnly]]
      def supportedNcharCharacterSetsValue: scala.Option[List[CharacterSet.ReadOnly]]
      def validUpgradeTargetValue: scala.Option[List[UpgradeTarget.ReadOnly]]
      def supportedTimezonesValue: scala.Option[List[Timezone.ReadOnly]]
      def exportableLogTypesValue: scala.Option[List[String]]
      def supportsLogExportsToCloudwatchLogsValue: scala.Option[Boolean]
      def supportsReadReplicaValue: scala.Option[Boolean]
      def supportedEngineModesValue: scala.Option[List[String]]
      def supportedFeatureNamesValue: scala.Option[List[String]]
      def statusValue: scala.Option[String]
      def supportsParallelQueryValue: scala.Option[Boolean]
      def supportsGlobalDatabasesValue: scala.Option[Boolean]
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
      def dbEngineDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineDescription", dbEngineDescriptionValue)
      def dbEngineVersionDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineVersionDescription", dbEngineVersionDescriptionValue)
      def defaultCharacterSet: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CharacterSet.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultCharacterSet", defaultCharacterSetValue)
      def supportedCharacterSets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CharacterSet.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedCharacterSets", supportedCharacterSetsValue)
      def supportedNcharCharacterSets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CharacterSet.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedNcharCharacterSets", supportedNcharCharacterSetsValue)
      def validUpgradeTarget: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[UpgradeTarget.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validUpgradeTarget", validUpgradeTargetValue)
      def supportedTimezones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Timezone.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedTimezones", supportedTimezonesValue)
      def exportableLogTypes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportableLogTypes", exportableLogTypesValue)
      def supportsLogExportsToCloudwatchLogs: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportsLogExportsToCloudwatchLogs", supportsLogExportsToCloudwatchLogsValue)
      def supportsReadReplica: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportsReadReplica", supportsReadReplicaValue)
      def supportedEngineModes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedEngineModes", supportedEngineModesValue)
      def supportedFeatureNames: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportedFeatureNames", supportedFeatureNamesValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def supportsParallelQuery: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportsParallelQuery", supportsParallelQueryValue)
      def supportsGlobalDatabases: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("supportsGlobalDatabases", supportsGlobalDatabasesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBEngineVersion) extends DBEngineVersion.ReadOnly {
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
      override def dbEngineDescriptionValue: scala.Option[String] = scala.Option(impl.dbEngineDescription()).map(value => value: String)
      override def dbEngineVersionDescriptionValue: scala.Option[String] = scala.Option(impl.dbEngineVersionDescription()).map(value => value: String)
      override def defaultCharacterSetValue: scala.Option[CharacterSet.ReadOnly] = scala.Option(impl.defaultCharacterSet()).map(value => CharacterSet.wrap(value))
      override def supportedCharacterSetsValue: scala.Option[List[CharacterSet.ReadOnly]] = scala.Option(impl.supportedCharacterSets()).map(value => value.asScala.map { item => 
        CharacterSet.wrap(item)
      }.toList)
      override def supportedNcharCharacterSetsValue: scala.Option[List[CharacterSet.ReadOnly]] = scala.Option(impl.supportedNcharCharacterSets()).map(value => value.asScala.map { item => 
        CharacterSet.wrap(item)
      }.toList)
      override def validUpgradeTargetValue: scala.Option[List[UpgradeTarget.ReadOnly]] = scala.Option(impl.validUpgradeTarget()).map(value => value.asScala.map { item => 
        UpgradeTarget.wrap(item)
      }.toList)
      override def supportedTimezonesValue: scala.Option[List[Timezone.ReadOnly]] = scala.Option(impl.supportedTimezones()).map(value => value.asScala.map { item => 
        Timezone.wrap(item)
      }.toList)
      override def exportableLogTypesValue: scala.Option[List[String]] = scala.Option(impl.exportableLogTypes()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def supportsLogExportsToCloudwatchLogsValue: scala.Option[Boolean] = scala.Option(impl.supportsLogExportsToCloudwatchLogs()).map(value => value: Boolean)
      override def supportsReadReplicaValue: scala.Option[Boolean] = scala.Option(impl.supportsReadReplica()).map(value => value: Boolean)
      override def supportedEngineModesValue: scala.Option[List[String]] = scala.Option(impl.supportedEngineModes()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def supportedFeatureNamesValue: scala.Option[List[String]] = scala.Option(impl.supportedFeatureNames()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def supportsParallelQueryValue: scala.Option[Boolean] = scala.Option(impl.supportsParallelQuery()).map(value => value: Boolean)
      override def supportsGlobalDatabasesValue: scala.Option[Boolean] = scala.Option(impl.supportsGlobalDatabases()).map(value => value: Boolean)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBEngineVersion): ReadOnly = new Wrapper(impl)
  }
  type DBEngineVersionList = List[DBEngineVersion]
  case class DBInstance(dbInstanceIdentifier: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, engine: scala.Option[String] = None, dbInstanceStatus: scala.Option[String] = None, masterUsername: scala.Option[String] = None, dbName: scala.Option[String] = None, endpoint: scala.Option[Endpoint] = None, allocatedStorage: scala.Option[primitives.Integer] = None, instanceCreateTime: scala.Option[primitives.TStamp] = None, preferredBackupWindow: scala.Option[String] = None, backupRetentionPeriod: scala.Option[primitives.Integer] = None, dbSecurityGroups: scala.Option[Iterable[DBSecurityGroupMembership]] = None, vpcSecurityGroups: scala.Option[Iterable[VpcSecurityGroupMembership]] = None, dbParameterGroups: scala.Option[Iterable[DBParameterGroupStatus]] = None, availabilityZone: scala.Option[String] = None, dbSubnetGroup: scala.Option[DBSubnetGroup] = None, preferredMaintenanceWindow: scala.Option[String] = None, pendingModifiedValues: scala.Option[PendingModifiedValues] = None, latestRestorableTime: scala.Option[primitives.TStamp] = None, multiAZ: scala.Option[Boolean] = None, engineVersion: scala.Option[String] = None, autoMinorVersionUpgrade: scala.Option[Boolean] = None, readReplicaSourceDBInstanceIdentifier: scala.Option[String] = None, readReplicaDBInstanceIdentifiers: scala.Option[Iterable[String]] = None, readReplicaDBClusterIdentifiers: scala.Option[Iterable[String]] = None, replicaMode: scala.Option[ReplicaMode] = None, licenseModel: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupMemberships: scala.Option[Iterable[OptionGroupMembership]] = None, characterSetName: scala.Option[String] = None, ncharCharacterSetName: scala.Option[String] = None, secondaryAvailabilityZone: scala.Option[String] = None, publiclyAccessible: scala.Option[Boolean] = None, statusInfos: scala.Option[Iterable[DBInstanceStatusInfo]] = None, storageType: scala.Option[String] = None, tdeCredentialArn: scala.Option[String] = None, dbInstancePort: scala.Option[primitives.Integer] = None, dbClusterIdentifier: scala.Option[String] = None, storageEncrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbiResourceId: scala.Option[String] = None, caCertificateIdentifier: scala.Option[String] = None, domainMemberships: scala.Option[Iterable[DomainMembership]] = None, copyTagsToSnapshot: scala.Option[Boolean] = None, monitoringInterval: scala.Option[primitives.IntegerOptional] = None, enhancedMonitoringResourceArn: scala.Option[String] = None, monitoringRoleArn: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None, dbInstanceArn: scala.Option[String] = None, timezone: scala.Option[String] = None, iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None, performanceInsightsEnabled: scala.Option[primitives.BooleanOptional] = None, performanceInsightsKMSKeyId: scala.Option[String] = None, performanceInsightsRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, enabledCloudwatchLogsExports: scala.Option[Iterable[String]] = None, processorFeatures: scala.Option[Iterable[ProcessorFeature]] = None, deletionProtection: scala.Option[Boolean] = None, associatedRoles: scala.Option[Iterable[DBInstanceRole]] = None, listenerEndpoint: scala.Option[Endpoint] = None, maxAllocatedStorage: scala.Option[primitives.IntegerOptional] = None, tagList: scala.Option[Iterable[Tag]] = None, dbInstanceAutomatedBackupsReplications: scala.Option[Iterable[DBInstanceAutomatedBackupsReplication]] = None, customerOwnedIpEnabled: scala.Option[primitives.BooleanOptional] = None, awsBackupRecoveryPointArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstance = {
      import DBInstance.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBInstance.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(_.dbInstanceStatus).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName).optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(instanceCreateTime.map(value => value: java.time.Instant))(_.instanceCreateTime).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(dbSecurityGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbSecurityGroups).optionallyWith(vpcSecurityGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.vpcSecurityGroups).optionallyWith(dbParameterGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbParameterGroups).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(pendingModifiedValues.map(value => value.buildAwsValue()))(_.pendingModifiedValues).optionallyWith(latestRestorableTime.map(value => value: java.time.Instant))(_.latestRestorableTime).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(readReplicaSourceDBInstanceIdentifier.map(value => value: java.lang.String))(_.readReplicaSourceDBInstanceIdentifier).optionallyWith(readReplicaDBInstanceIdentifiers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.readReplicaDBInstanceIdentifiers).optionallyWith(readReplicaDBClusterIdentifiers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.readReplicaDBClusterIdentifiers).optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupMemberships.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.optionGroupMemberships).optionallyWith(characterSetName.map(value => value: java.lang.String))(_.characterSetName).optionallyWith(ncharCharacterSetName.map(value => value: java.lang.String))(_.ncharCharacterSetName).optionallyWith(secondaryAvailabilityZone.map(value => value: java.lang.String))(_.secondaryAvailabilityZone).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(statusInfos.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.statusInfos).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(_.tdeCredentialArn).optionallyWith(dbInstancePort.map(value => value: java.lang.Integer))(_.dbInstancePort).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).optionallyWith(domainMemberships.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.domainMemberships).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(monitoringInterval.map(value => value: java.lang.Integer))(_.monitoringInterval).optionallyWith(enhancedMonitoringResourceArn.map(value => value: java.lang.String))(_.enhancedMonitoringResourceArn).optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(_.monitoringRoleArn).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(_.dbInstanceArn).optionallyWith(timezone.map(value => value: java.lang.String))(_.timezone).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(performanceInsightsEnabled.map(value => value: java.lang.Boolean))(_.performanceInsightsEnabled).optionallyWith(performanceInsightsKMSKeyId.map(value => value: java.lang.String))(_.performanceInsightsKMSKeyId).optionallyWith(performanceInsightsRetentionPeriod.map(value => value: java.lang.Integer))(_.performanceInsightsRetentionPeriod).optionallyWith(enabledCloudwatchLogsExports.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.enabledCloudwatchLogsExports).optionallyWith(processorFeatures.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.processorFeatures).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(associatedRoles.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.associatedRoles).optionallyWith(listenerEndpoint.map(value => value.buildAwsValue()))(_.listenerEndpoint).optionallyWith(maxAllocatedStorage.map(value => value: java.lang.Integer))(_.maxAllocatedStorage).optionallyWith(tagList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tagList).optionallyWith(dbInstanceAutomatedBackupsReplications.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbInstanceAutomatedBackupsReplications).optionallyWith(customerOwnedIpEnabled.map(value => value: java.lang.Boolean))(_.customerOwnedIpEnabled).optionallyWith(awsBackupRecoveryPointArn.map(value => value: java.lang.String))(_.awsBackupRecoveryPointArn).build()
    }
    def asReadOnly: DBInstance.ReadOnly = DBInstance.wrap(buildAwsValue())
  }
  object DBInstance {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstance] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBInstance = DBInstance(dbInstanceIdentifierValue.map(value => value), dbInstanceClassValue.map(value => value), engineValue.map(value => value), dbInstanceStatusValue.map(value => value), masterUsernameValue.map(value => value), dbNameValue.map(value => value), endpointValue.map(value => value.editable), allocatedStorageValue.map(value => value), instanceCreateTimeValue.map(value => value), preferredBackupWindowValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbSecurityGroupsValue.map(value => value.map { item => 
        item.editable
      }), vpcSecurityGroupsValue.map(value => value.map { item => 
        item.editable
      }), dbParameterGroupsValue.map(value => value.map { item => 
        item.editable
      }), availabilityZoneValue.map(value => value), dbSubnetGroupValue.map(value => value.editable), preferredMaintenanceWindowValue.map(value => value), pendingModifiedValuesValue.map(value => value.editable), latestRestorableTimeValue.map(value => value), multiAZValue.map(value => value), engineVersionValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), readReplicaSourceDBInstanceIdentifierValue.map(value => value), readReplicaDBInstanceIdentifiersValue.map(value => value), readReplicaDBClusterIdentifiersValue.map(value => value), replicaModeValue.map(value => value), licenseModelValue.map(value => value), iopsValue.map(value => value), optionGroupMembershipsValue.map(value => value.map { item => 
        item.editable
      }), characterSetNameValue.map(value => value), ncharCharacterSetNameValue.map(value => value), secondaryAvailabilityZoneValue.map(value => value), publiclyAccessibleValue.map(value => value), statusInfosValue.map(value => value.map { item => 
        item.editable
      }), storageTypeValue.map(value => value), tdeCredentialArnValue.map(value => value), dbInstancePortValue.map(value => value), dbClusterIdentifierValue.map(value => value), storageEncryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbiResourceIdValue.map(value => value), caCertificateIdentifierValue.map(value => value), domainMembershipsValue.map(value => value.map { item => 
        item.editable
      }), copyTagsToSnapshotValue.map(value => value), monitoringIntervalValue.map(value => value), enhancedMonitoringResourceArnValue.map(value => value), monitoringRoleArnValue.map(value => value), promotionTierValue.map(value => value), dbInstanceArnValue.map(value => value), timezoneValue.map(value => value), iamDatabaseAuthenticationEnabledValue.map(value => value), performanceInsightsEnabledValue.map(value => value), performanceInsightsKMSKeyIdValue.map(value => value), performanceInsightsRetentionPeriodValue.map(value => value), enabledCloudwatchLogsExportsValue.map(value => value), processorFeaturesValue.map(value => value.map { item => 
        item.editable
      }), deletionProtectionValue.map(value => value), associatedRolesValue.map(value => value.map { item => 
        item.editable
      }), listenerEndpointValue.map(value => value.editable), maxAllocatedStorageValue.map(value => value), tagListValue.map(value => value.map { item => 
        item.editable
      }), dbInstanceAutomatedBackupsReplicationsValue.map(value => value.map { item => 
        item.editable
      }), customerOwnedIpEnabledValue.map(value => value), awsBackupRecoveryPointArnValue.map(value => value))
      def dbInstanceIdentifierValue: scala.Option[String]
      def dbInstanceClassValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def dbInstanceStatusValue: scala.Option[String]
      def masterUsernameValue: scala.Option[String]
      def dbNameValue: scala.Option[String]
      def endpointValue: scala.Option[Endpoint.ReadOnly]
      def allocatedStorageValue: scala.Option[primitives.Integer]
      def instanceCreateTimeValue: scala.Option[primitives.TStamp]
      def preferredBackupWindowValue: scala.Option[String]
      def backupRetentionPeriodValue: scala.Option[primitives.Integer]
      def dbSecurityGroupsValue: scala.Option[List[DBSecurityGroupMembership.ReadOnly]]
      def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]]
      def dbParameterGroupsValue: scala.Option[List[DBParameterGroupStatus.ReadOnly]]
      def availabilityZoneValue: scala.Option[String]
      def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def pendingModifiedValuesValue: scala.Option[PendingModifiedValues.ReadOnly]
      def latestRestorableTimeValue: scala.Option[primitives.TStamp]
      def multiAZValue: scala.Option[Boolean]
      def engineVersionValue: scala.Option[String]
      def autoMinorVersionUpgradeValue: scala.Option[Boolean]
      def readReplicaSourceDBInstanceIdentifierValue: scala.Option[String]
      def readReplicaDBInstanceIdentifiersValue: scala.Option[List[String]]
      def readReplicaDBClusterIdentifiersValue: scala.Option[List[String]]
      def replicaModeValue: scala.Option[ReplicaMode]
      def licenseModelValue: scala.Option[String]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupMembershipsValue: scala.Option[List[OptionGroupMembership.ReadOnly]]
      def characterSetNameValue: scala.Option[String]
      def ncharCharacterSetNameValue: scala.Option[String]
      def secondaryAvailabilityZoneValue: scala.Option[String]
      def publiclyAccessibleValue: scala.Option[Boolean]
      def statusInfosValue: scala.Option[List[DBInstanceStatusInfo.ReadOnly]]
      def storageTypeValue: scala.Option[String]
      def tdeCredentialArnValue: scala.Option[String]
      def dbInstancePortValue: scala.Option[primitives.Integer]
      def dbClusterIdentifierValue: scala.Option[String]
      def storageEncryptedValue: scala.Option[Boolean]
      def kmsKeyIdValue: scala.Option[String]
      def dbiResourceIdValue: scala.Option[String]
      def caCertificateIdentifierValue: scala.Option[String]
      def domainMembershipsValue: scala.Option[List[DomainMembership.ReadOnly]]
      def copyTagsToSnapshotValue: scala.Option[Boolean]
      def monitoringIntervalValue: scala.Option[primitives.IntegerOptional]
      def enhancedMonitoringResourceArnValue: scala.Option[String]
      def monitoringRoleArnValue: scala.Option[String]
      def promotionTierValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceArnValue: scala.Option[String]
      def timezoneValue: scala.Option[String]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean]
      def performanceInsightsEnabledValue: scala.Option[primitives.BooleanOptional]
      def performanceInsightsKMSKeyIdValue: scala.Option[String]
      def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def enabledCloudwatchLogsExportsValue: scala.Option[List[String]]
      def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]]
      def deletionProtectionValue: scala.Option[Boolean]
      def associatedRolesValue: scala.Option[List[DBInstanceRole.ReadOnly]]
      def listenerEndpointValue: scala.Option[Endpoint.ReadOnly]
      def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def tagListValue: scala.Option[List[Tag.ReadOnly]]
      def dbInstanceAutomatedBackupsReplicationsValue: scala.Option[List[DBInstanceAutomatedBackupsReplication.ReadOnly]]
      def customerOwnedIpEnabledValue: scala.Option[primitives.BooleanOptional]
      def awsBackupRecoveryPointArnValue: scala.Option[String]
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def dbInstanceStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatusValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def dbName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbName", dbNameValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Endpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def instanceCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTimeValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def dbSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSecurityGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroupsValue)
      def vpcSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[VpcSecurityGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroupsValue)
      def dbParameterGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBParameterGroupStatus.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroupsValue)
      def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
      def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def pendingModifiedValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, PendingModifiedValues.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValuesValue)
      def latestRestorableTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTimeValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
      def readReplicaSourceDBInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readReplicaSourceDBInstanceIdentifier", readReplicaSourceDBInstanceIdentifierValue)
      def readReplicaDBInstanceIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readReplicaDBInstanceIdentifiers", readReplicaDBInstanceIdentifiersValue)
      def readReplicaDBClusterIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readReplicaDBClusterIdentifiers", readReplicaDBClusterIdentifiersValue)
      def replicaMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReplicaMode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicaMode", replicaModeValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupMemberships: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OptionGroupMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupMemberships", optionGroupMembershipsValue)
      def characterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("characterSetName", characterSetNameValue)
      def ncharCharacterSetName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ncharCharacterSetName", ncharCharacterSetNameValue)
      def secondaryAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZoneValue)
      def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
      def statusInfos: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceStatusInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusInfos", statusInfosValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def tdeCredentialArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArnValue)
      def dbInstancePort: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstancePort", dbInstancePortValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
      def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
      def domainMemberships: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DomainMembership.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainMemberships", domainMembershipsValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def monitoringInterval: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringInterval", monitoringIntervalValue)
      def enhancedMonitoringResourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enhancedMonitoringResourceArn", enhancedMonitoringResourceArnValue)
      def monitoringRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArnValue)
      def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
      def dbInstanceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArnValue)
      def timezone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timezone", timezoneValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def performanceInsightsEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsEnabled", performanceInsightsEnabledValue)
      def performanceInsightsKMSKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsKMSKeyId", performanceInsightsKMSKeyIdValue)
      def performanceInsightsRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsRetentionPeriod", performanceInsightsRetentionPeriodValue)
      def enabledCloudwatchLogsExports: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabledCloudwatchLogsExports", enabledCloudwatchLogsExportsValue)
      def processorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProcessorFeature.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processorFeatures", processorFeaturesValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def associatedRoles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceRole.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("associatedRoles", associatedRolesValue)
      def listenerEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Endpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("listenerEndpoint", listenerEndpointValue)
      def maxAllocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorageValue)
      def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
      def dbInstanceAutomatedBackupsReplications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceAutomatedBackupsReplication.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsReplications", dbInstanceAutomatedBackupsReplicationsValue)
      def customerOwnedIpEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerOwnedIpEnabled", customerOwnedIpEnabledValue)
      def awsBackupRecoveryPointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBInstance) extends DBInstance.ReadOnly {
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def dbInstanceStatusValue: scala.Option[String] = scala.Option(impl.dbInstanceStatus()).map(value => value: String)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def dbNameValue: scala.Option[String] = scala.Option(impl.dbName()).map(value => value: String)
      override def endpointValue: scala.Option[Endpoint.ReadOnly] = scala.Option(impl.endpoint()).map(value => Endpoint.wrap(value))
      override def allocatedStorageValue: scala.Option[primitives.Integer] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.Integer)
      override def instanceCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.instanceCreateTime()).map(value => value: primitives.TStamp)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def backupRetentionPeriodValue: scala.Option[primitives.Integer] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.Integer)
      override def dbSecurityGroupsValue: scala.Option[List[DBSecurityGroupMembership.ReadOnly]] = scala.Option(impl.dbSecurityGroups()).map(value => value.asScala.map { item => 
        DBSecurityGroupMembership.wrap(item)
      }.toList)
      override def vpcSecurityGroupsValue: scala.Option[List[VpcSecurityGroupMembership.ReadOnly]] = scala.Option(impl.vpcSecurityGroups()).map(value => value.asScala.map { item => 
        VpcSecurityGroupMembership.wrap(item)
      }.toList)
      override def dbParameterGroupsValue: scala.Option[List[DBParameterGroupStatus.ReadOnly]] = scala.Option(impl.dbParameterGroups()).map(value => value.asScala.map { item => 
        DBParameterGroupStatus.wrap(item)
      }.toList)
      override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
      override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value))
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def pendingModifiedValuesValue: scala.Option[PendingModifiedValues.ReadOnly] = scala.Option(impl.pendingModifiedValues()).map(value => PendingModifiedValues.wrap(value))
      override def latestRestorableTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.latestRestorableTime()).map(value => value: primitives.TStamp)
      override def multiAZValue: scala.Option[Boolean] = scala.Option(impl.multiAZ()).map(value => value: Boolean)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def autoMinorVersionUpgradeValue: scala.Option[Boolean] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: Boolean)
      override def readReplicaSourceDBInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.readReplicaSourceDBInstanceIdentifier()).map(value => value: String)
      override def readReplicaDBInstanceIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.readReplicaDBInstanceIdentifiers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def readReplicaDBClusterIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.readReplicaDBClusterIdentifiers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def replicaModeValue: scala.Option[ReplicaMode] = scala.Option(impl.replicaMode()).map(value => ReplicaMode.wrap(value))
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupMembershipsValue: scala.Option[List[OptionGroupMembership.ReadOnly]] = scala.Option(impl.optionGroupMemberships()).map(value => value.asScala.map { item => 
        OptionGroupMembership.wrap(item)
      }.toList)
      override def characterSetNameValue: scala.Option[String] = scala.Option(impl.characterSetName()).map(value => value: String)
      override def ncharCharacterSetNameValue: scala.Option[String] = scala.Option(impl.ncharCharacterSetName()).map(value => value: String)
      override def secondaryAvailabilityZoneValue: scala.Option[String] = scala.Option(impl.secondaryAvailabilityZone()).map(value => value: String)
      override def publiclyAccessibleValue: scala.Option[Boolean] = scala.Option(impl.publiclyAccessible()).map(value => value: Boolean)
      override def statusInfosValue: scala.Option[List[DBInstanceStatusInfo.ReadOnly]] = scala.Option(impl.statusInfos()).map(value => value.asScala.map { item => 
        DBInstanceStatusInfo.wrap(item)
      }.toList)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def tdeCredentialArnValue: scala.Option[String] = scala.Option(impl.tdeCredentialArn()).map(value => value: String)
      override def dbInstancePortValue: scala.Option[primitives.Integer] = scala.Option(impl.dbInstancePort()).map(value => value: primitives.Integer)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def storageEncryptedValue: scala.Option[Boolean] = scala.Option(impl.storageEncrypted()).map(value => value: Boolean)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
      override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
      override def domainMembershipsValue: scala.Option[List[DomainMembership.ReadOnly]] = scala.Option(impl.domainMemberships()).map(value => value.asScala.map { item => 
        DomainMembership.wrap(item)
      }.toList)
      override def copyTagsToSnapshotValue: scala.Option[Boolean] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: Boolean)
      override def monitoringIntervalValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.monitoringInterval()).map(value => value: primitives.IntegerOptional)
      override def enhancedMonitoringResourceArnValue: scala.Option[String] = scala.Option(impl.enhancedMonitoringResourceArn()).map(value => value: String)
      override def monitoringRoleArnValue: scala.Option[String] = scala.Option(impl.monitoringRoleArn()).map(value => value: String)
      override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
      override def dbInstanceArnValue: scala.Option[String] = scala.Option(impl.dbInstanceArn()).map(value => value: String)
      override def timezoneValue: scala.Option[String] = scala.Option(impl.timezone()).map(value => value: String)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: Boolean)
      override def performanceInsightsEnabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.performanceInsightsEnabled()).map(value => value: primitives.BooleanOptional)
      override def performanceInsightsKMSKeyIdValue: scala.Option[String] = scala.Option(impl.performanceInsightsKMSKeyId()).map(value => value: String)
      override def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.performanceInsightsRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def enabledCloudwatchLogsExportsValue: scala.Option[List[String]] = scala.Option(impl.enabledCloudwatchLogsExports()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]] = scala.Option(impl.processorFeatures()).map(value => value.asScala.map { item => 
        ProcessorFeature.wrap(item)
      }.toList)
      override def deletionProtectionValue: scala.Option[Boolean] = scala.Option(impl.deletionProtection()).map(value => value: Boolean)
      override def associatedRolesValue: scala.Option[List[DBInstanceRole.ReadOnly]] = scala.Option(impl.associatedRoles()).map(value => value.asScala.map { item => 
        DBInstanceRole.wrap(item)
      }.toList)
      override def listenerEndpointValue: scala.Option[Endpoint.ReadOnly] = scala.Option(impl.listenerEndpoint()).map(value => Endpoint.wrap(value))
      override def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxAllocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
      override def dbInstanceAutomatedBackupsReplicationsValue: scala.Option[List[DBInstanceAutomatedBackupsReplication.ReadOnly]] = scala.Option(impl.dbInstanceAutomatedBackupsReplications()).map(value => value.asScala.map { item => 
        DBInstanceAutomatedBackupsReplication.wrap(item)
      }.toList)
      override def customerOwnedIpEnabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.customerOwnedIpEnabled()).map(value => value: primitives.BooleanOptional)
      override def awsBackupRecoveryPointArnValue: scala.Option[String] = scala.Option(impl.awsBackupRecoveryPointArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBInstance): ReadOnly = new Wrapper(impl)
  }
  case class DBInstanceAutomatedBackup(dbInstanceArn: scala.Option[String] = None, dbiResourceId: scala.Option[String] = None, region: scala.Option[String] = None, dbInstanceIdentifier: scala.Option[String] = None, restoreWindow: scala.Option[RestoreWindow] = None, allocatedStorage: scala.Option[primitives.Integer] = None, status: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, availabilityZone: scala.Option[String] = None, vpcId: scala.Option[String] = None, instanceCreateTime: scala.Option[primitives.TStamp] = None, masterUsername: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, licenseModel: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupName: scala.Option[String] = None, tdeCredentialArn: scala.Option[String] = None, encrypted: scala.Option[Boolean] = None, storageType: scala.Option[String] = None, kmsKeyId: scala.Option[String] = None, timezone: scala.Option[String] = None, iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, dbInstanceAutomatedBackupsArn: scala.Option[String] = None, dbInstanceAutomatedBackupsReplications: scala.Option[Iterable[DBInstanceAutomatedBackupsReplication]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup = {
      import DBInstanceAutomatedBackup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup.builder().optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(_.dbInstanceArn).optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(region.map(value => value: java.lang.String))(_.region).optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(restoreWindow.map(value => value.buildAwsValue()))(_.restoreWindow).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(instanceCreateTime.map(value => value: java.time.Instant))(_.instanceCreateTime).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(_.tdeCredentialArn).optionallyWith(encrypted.map(value => value: java.lang.Boolean))(_.encrypted).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(timezone.map(value => value: java.lang.String))(_.timezone).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String))(_.dbInstanceAutomatedBackupsArn).optionallyWith(dbInstanceAutomatedBackupsReplications.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbInstanceAutomatedBackupsReplications).build()
    }
    def asReadOnly: DBInstanceAutomatedBackup.ReadOnly = DBInstanceAutomatedBackup.wrap(buildAwsValue())
  }
  object DBInstanceAutomatedBackup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBInstanceAutomatedBackup = DBInstanceAutomatedBackup(dbInstanceArnValue.map(value => value), dbiResourceIdValue.map(value => value), regionValue.map(value => value), dbInstanceIdentifierValue.map(value => value), restoreWindowValue.map(value => value.editable), allocatedStorageValue.map(value => value), statusValue.map(value => value), portValue.map(value => value), availabilityZoneValue.map(value => value), vpcIdValue.map(value => value), instanceCreateTimeValue.map(value => value), masterUsernameValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), licenseModelValue.map(value => value), iopsValue.map(value => value), optionGroupNameValue.map(value => value), tdeCredentialArnValue.map(value => value), encryptedValue.map(value => value), storageTypeValue.map(value => value), kmsKeyIdValue.map(value => value), timezoneValue.map(value => value), iamDatabaseAuthenticationEnabledValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbInstanceAutomatedBackupsArnValue.map(value => value), dbInstanceAutomatedBackupsReplicationsValue.map(value => value.map { item => 
        item.editable
      }))
      def dbInstanceArnValue: scala.Option[String]
      def dbiResourceIdValue: scala.Option[String]
      def regionValue: scala.Option[String]
      def dbInstanceIdentifierValue: scala.Option[String]
      def restoreWindowValue: scala.Option[RestoreWindow.ReadOnly]
      def allocatedStorageValue: scala.Option[primitives.Integer]
      def statusValue: scala.Option[String]
      def portValue: scala.Option[primitives.Integer]
      def availabilityZoneValue: scala.Option[String]
      def vpcIdValue: scala.Option[String]
      def instanceCreateTimeValue: scala.Option[primitives.TStamp]
      def masterUsernameValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def licenseModelValue: scala.Option[String]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupNameValue: scala.Option[String]
      def tdeCredentialArnValue: scala.Option[String]
      def encryptedValue: scala.Option[Boolean]
      def storageTypeValue: scala.Option[String]
      def kmsKeyIdValue: scala.Option[String]
      def timezoneValue: scala.Option[String]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceAutomatedBackupsArnValue: scala.Option[String]
      def dbInstanceAutomatedBackupsReplicationsValue: scala.Option[List[DBInstanceAutomatedBackupsReplication.ReadOnly]]
      def dbInstanceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArnValue)
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
      def region: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("region", regionValue)
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def restoreWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RestoreWindow.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("restoreWindow", restoreWindowValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def instanceCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTimeValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def tdeCredentialArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArnValue)
      def encrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("encrypted", encryptedValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def timezone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timezone", timezoneValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def dbInstanceAutomatedBackupsArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArnValue)
      def dbInstanceAutomatedBackupsReplications: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceAutomatedBackupsReplication.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsReplications", dbInstanceAutomatedBackupsReplicationsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup) extends DBInstanceAutomatedBackup.ReadOnly {
      override def dbInstanceArnValue: scala.Option[String] = scala.Option(impl.dbInstanceArn()).map(value => value: String)
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
      override def regionValue: scala.Option[String] = scala.Option(impl.region()).map(value => value: String)
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def restoreWindowValue: scala.Option[RestoreWindow.ReadOnly] = scala.Option(impl.restoreWindow()).map(value => RestoreWindow.wrap(value))
      override def allocatedStorageValue: scala.Option[primitives.Integer] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.Integer)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
      override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def instanceCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.instanceCreateTime()).map(value => value: primitives.TStamp)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def tdeCredentialArnValue: scala.Option[String] = scala.Option(impl.tdeCredentialArn()).map(value => value: String)
      override def encryptedValue: scala.Option[Boolean] = scala.Option(impl.encrypted()).map(value => value: Boolean)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def timezoneValue: scala.Option[String] = scala.Option(impl.timezone()).map(value => value: String)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: Boolean)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def dbInstanceAutomatedBackupsArnValue: scala.Option[String] = scala.Option(impl.dbInstanceAutomatedBackupsArn()).map(value => value: String)
      override def dbInstanceAutomatedBackupsReplicationsValue: scala.Option[List[DBInstanceAutomatedBackupsReplication.ReadOnly]] = scala.Option(impl.dbInstanceAutomatedBackupsReplications()).map(value => value.asScala.map { item => 
        DBInstanceAutomatedBackupsReplication.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup): ReadOnly = new Wrapper(impl)
  }
  type DBInstanceAutomatedBackupList = List[DBInstanceAutomatedBackup]
  case class DBInstanceAutomatedBackupsReplication(dbInstanceAutomatedBackupsArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication = {
      import DBInstanceAutomatedBackupsReplication.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication.builder().optionallyWith(dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String))(_.dbInstanceAutomatedBackupsArn).build()
    }
    def asReadOnly: DBInstanceAutomatedBackupsReplication.ReadOnly = DBInstanceAutomatedBackupsReplication.wrap(buildAwsValue())
  }
  object DBInstanceAutomatedBackupsReplication {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBInstanceAutomatedBackupsReplication = DBInstanceAutomatedBackupsReplication(dbInstanceAutomatedBackupsArnValue.map(value => value))
      def dbInstanceAutomatedBackupsArnValue: scala.Option[String]
      def dbInstanceAutomatedBackupsArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication) extends DBInstanceAutomatedBackupsReplication.ReadOnly { override def dbInstanceAutomatedBackupsArnValue: scala.Option[String] = scala.Option(impl.dbInstanceAutomatedBackupsArn()).map(value => value: String) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackupsReplication): ReadOnly = new Wrapper(impl)
  }
  type DBInstanceAutomatedBackupsReplicationList = List[DBInstanceAutomatedBackupsReplication]
  type DBInstanceList = List[DBInstance]
  case class DBInstanceRole(roleArn: scala.Option[String] = None, featureName: scala.Option[String] = None, status: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstanceRole = {
      import DBInstanceRole.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBInstanceRole.builder().optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn).optionallyWith(featureName.map(value => value: java.lang.String))(_.featureName).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
    }
    def asReadOnly: DBInstanceRole.ReadOnly = DBInstanceRole.wrap(buildAwsValue())
  }
  object DBInstanceRole {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstanceRole] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBInstanceRole = DBInstanceRole(roleArnValue.map(value => value), featureNameValue.map(value => value), statusValue.map(value => value))
      def roleArnValue: scala.Option[String]
      def featureNameValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def roleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArn", roleArnValue)
      def featureName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("featureName", featureNameValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBInstanceRole) extends DBInstanceRole.ReadOnly {
      override def roleArnValue: scala.Option[String] = scala.Option(impl.roleArn()).map(value => value: String)
      override def featureNameValue: scala.Option[String] = scala.Option(impl.featureName()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBInstanceRole): ReadOnly = new Wrapper(impl)
  }
  type DBInstanceRoles = List[DBInstanceRole]
  case class DBInstanceStatusInfo(statusType: scala.Option[String] = None, normal: scala.Option[Boolean] = None, status: scala.Option[String] = None, message: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo = {
      import DBInstanceStatusInfo.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo.builder().optionallyWith(statusType.map(value => value: java.lang.String))(_.statusType).optionallyWith(normal.map(value => value: java.lang.Boolean))(_.normal).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
    }
    def asReadOnly: DBInstanceStatusInfo.ReadOnly = DBInstanceStatusInfo.wrap(buildAwsValue())
  }
  object DBInstanceStatusInfo {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBInstanceStatusInfo = DBInstanceStatusInfo(statusTypeValue.map(value => value), normalValue.map(value => value), statusValue.map(value => value), messageValue.map(value => value))
      def statusTypeValue: scala.Option[String]
      def normalValue: scala.Option[Boolean]
      def statusValue: scala.Option[String]
      def messageValue: scala.Option[String]
      def statusType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("statusType", statusTypeValue)
      def normal: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("normal", normalValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo) extends DBInstanceStatusInfo.ReadOnly {
      override def statusTypeValue: scala.Option[String] = scala.Option(impl.statusType()).map(value => value: String)
      override def normalValue: scala.Option[Boolean] = scala.Option(impl.normal()).map(value => value: Boolean)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBInstanceStatusInfo): ReadOnly = new Wrapper(impl)
  }
  type DBInstanceStatusInfoList = List[DBInstanceStatusInfo]
  case class DBParameterGroup(dbParameterGroupName: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, description: scala.Option[String] = None, dbParameterGroupArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBParameterGroup = {
      import DBParameterGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBParameterGroup.builder().optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(description.map(value => value: java.lang.String))(_.description).optionallyWith(dbParameterGroupArn.map(value => value: java.lang.String))(_.dbParameterGroupArn).build()
    }
    def asReadOnly: DBParameterGroup.ReadOnly = DBParameterGroup.wrap(buildAwsValue())
  }
  object DBParameterGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBParameterGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBParameterGroup = DBParameterGroup(dbParameterGroupNameValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), descriptionValue.map(value => value), dbParameterGroupArnValue.map(value => value))
      def dbParameterGroupNameValue: scala.Option[String]
      def dbParameterGroupFamilyValue: scala.Option[String]
      def descriptionValue: scala.Option[String]
      def dbParameterGroupArnValue: scala.Option[String]
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
      def description: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("description", descriptionValue)
      def dbParameterGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupArn", dbParameterGroupArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBParameterGroup) extends DBParameterGroup.ReadOnly {
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
      override def descriptionValue: scala.Option[String] = scala.Option(impl.description()).map(value => value: String)
      override def dbParameterGroupArnValue: scala.Option[String] = scala.Option(impl.dbParameterGroupArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBParameterGroup): ReadOnly = new Wrapper(impl)
  }
  type DBParameterGroupList = List[DBParameterGroup]
  case class DBParameterGroupStatus(dbParameterGroupName: scala.Option[String] = None, parameterApplyStatus: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBParameterGroupStatus = {
      import DBParameterGroupStatus.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBParameterGroupStatus.builder().optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(parameterApplyStatus.map(value => value: java.lang.String))(_.parameterApplyStatus).build()
    }
    def asReadOnly: DBParameterGroupStatus.ReadOnly = DBParameterGroupStatus.wrap(buildAwsValue())
  }
  object DBParameterGroupStatus {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBParameterGroupStatus] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBParameterGroupStatus = DBParameterGroupStatus(dbParameterGroupNameValue.map(value => value), parameterApplyStatusValue.map(value => value))
      def dbParameterGroupNameValue: scala.Option[String]
      def parameterApplyStatusValue: scala.Option[String]
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def parameterApplyStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameterApplyStatus", parameterApplyStatusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBParameterGroupStatus) extends DBParameterGroupStatus.ReadOnly {
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def parameterApplyStatusValue: scala.Option[String] = scala.Option(impl.parameterApplyStatus()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBParameterGroupStatus): ReadOnly = new Wrapper(impl)
  }
  type DBParameterGroupStatusList = List[DBParameterGroupStatus]
  case class DBProxy(dbProxyName: scala.Option[String] = None, dbProxyArn: scala.Option[String] = None, status: scala.Option[DBProxyStatus] = None, engineFamily: scala.Option[String] = None, vpcId: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, vpcSubnetIds: scala.Option[Iterable[String]] = None, auth: scala.Option[Iterable[UserAuthConfigInfo]] = None, roleArn: scala.Option[String] = None, endpoint: scala.Option[String] = None, requireTLS: scala.Option[Boolean] = None, idleClientTimeout: scala.Option[primitives.Integer] = None, debugLogging: scala.Option[Boolean] = None, createdDate: scala.Option[primitives.TStamp] = None, updatedDate: scala.Option[primitives.TStamp] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxy = {
      import DBProxy.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBProxy.builder().optionallyWith(dbProxyName.map(value => value: java.lang.String))(_.dbProxyName).optionallyWith(dbProxyArn.map(value => value: java.lang.String))(_.dbProxyArn).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(engineFamily.map(value => value: java.lang.String))(_.engineFamily).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(vpcSubnetIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSubnetIds).optionallyWith(auth.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.auth).optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(_.requireTLS).optionallyWith(idleClientTimeout.map(value => value: java.lang.Integer))(_.idleClientTimeout).optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(_.debugLogging).optionallyWith(createdDate.map(value => value: java.time.Instant))(_.createdDate).optionallyWith(updatedDate.map(value => value: java.time.Instant))(_.updatedDate).build()
    }
    def asReadOnly: DBProxy.ReadOnly = DBProxy.wrap(buildAwsValue())
  }
  object DBProxy {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxy] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBProxy = DBProxy(dbProxyNameValue.map(value => value), dbProxyArnValue.map(value => value), statusValue.map(value => value), engineFamilyValue.map(value => value), vpcIdValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), vpcSubnetIdsValue.map(value => value), authValue.map(value => value.map { item => 
        item.editable
      }), roleArnValue.map(value => value), endpointValue.map(value => value), requireTLSValue.map(value => value), idleClientTimeoutValue.map(value => value), debugLoggingValue.map(value => value), createdDateValue.map(value => value), updatedDateValue.map(value => value))
      def dbProxyNameValue: scala.Option[String]
      def dbProxyArnValue: scala.Option[String]
      def statusValue: scala.Option[DBProxyStatus]
      def engineFamilyValue: scala.Option[String]
      def vpcIdValue: scala.Option[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def vpcSubnetIdsValue: scala.Option[List[String]]
      def authValue: scala.Option[List[UserAuthConfigInfo.ReadOnly]]
      def roleArnValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def requireTLSValue: scala.Option[Boolean]
      def idleClientTimeoutValue: scala.Option[primitives.Integer]
      def debugLoggingValue: scala.Option[Boolean]
      def createdDateValue: scala.Option[primitives.TStamp]
      def updatedDateValue: scala.Option[primitives.TStamp]
      def dbProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyName", dbProxyNameValue)
      def dbProxyArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyArn", dbProxyArnValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def engineFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineFamily", engineFamilyValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def vpcSubnetIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIdsValue)
      def auth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[UserAuthConfigInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("auth", authValue)
      def roleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArn", roleArnValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def requireTLS: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requireTLS", requireTLSValue)
      def idleClientTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeoutValue)
      def debugLogging: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("debugLogging", debugLoggingValue)
      def createdDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdDate", createdDateValue)
      def updatedDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("updatedDate", updatedDateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBProxy) extends DBProxy.ReadOnly {
      override def dbProxyNameValue: scala.Option[String] = scala.Option(impl.dbProxyName()).map(value => value: String)
      override def dbProxyArnValue: scala.Option[String] = scala.Option(impl.dbProxyArn()).map(value => value: String)
      override def statusValue: scala.Option[DBProxyStatus] = scala.Option(impl.status()).map(value => DBProxyStatus.wrap(value))
      override def engineFamilyValue: scala.Option[String] = scala.Option(impl.engineFamily()).map(value => value: String)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def vpcSubnetIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSubnetIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def authValue: scala.Option[List[UserAuthConfigInfo.ReadOnly]] = scala.Option(impl.auth()).map(value => value.asScala.map { item => 
        UserAuthConfigInfo.wrap(item)
      }.toList)
      override def roleArnValue: scala.Option[String] = scala.Option(impl.roleArn()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def requireTLSValue: scala.Option[Boolean] = scala.Option(impl.requireTLS()).map(value => value: Boolean)
      override def idleClientTimeoutValue: scala.Option[primitives.Integer] = scala.Option(impl.idleClientTimeout()).map(value => value: primitives.Integer)
      override def debugLoggingValue: scala.Option[Boolean] = scala.Option(impl.debugLogging()).map(value => value: Boolean)
      override def createdDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.createdDate()).map(value => value: primitives.TStamp)
      override def updatedDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.updatedDate()).map(value => value: primitives.TStamp)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBProxy): ReadOnly = new Wrapper(impl)
  }
  case class DBProxyEndpoint(dbProxyEndpointName: scala.Option[String] = None, dbProxyEndpointArn: scala.Option[String] = None, dbProxyName: scala.Option[String] = None, status: scala.Option[DBProxyEndpointStatus] = None, vpcId: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, vpcSubnetIds: scala.Option[Iterable[String]] = None, endpoint: scala.Option[String] = None, createdDate: scala.Option[primitives.TStamp] = None, targetRole: scala.Option[DBProxyEndpointTargetRole] = None, isDefault: scala.Option[Boolean] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxyEndpoint = {
      import DBProxyEndpoint.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBProxyEndpoint.builder().optionallyWith(dbProxyEndpointName.map(value => value: java.lang.String))(_.dbProxyEndpointName).optionallyWith(dbProxyEndpointArn.map(value => value: java.lang.String))(_.dbProxyEndpointArn).optionallyWith(dbProxyName.map(value => value: java.lang.String))(_.dbProxyName).optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(vpcSubnetIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSubnetIds).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(createdDate.map(value => value: java.time.Instant))(_.createdDate).optionallyWith(targetRole.map(value => value.unwrap))(_.targetRole).optionallyWith(isDefault.map(value => value: java.lang.Boolean))(_.isDefault).build()
    }
    def asReadOnly: DBProxyEndpoint.ReadOnly = DBProxyEndpoint.wrap(buildAwsValue())
  }
  object DBProxyEndpoint {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxyEndpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBProxyEndpoint = DBProxyEndpoint(dbProxyEndpointNameValue.map(value => value), dbProxyEndpointArnValue.map(value => value), dbProxyNameValue.map(value => value), statusValue.map(value => value), vpcIdValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), vpcSubnetIdsValue.map(value => value), endpointValue.map(value => value), createdDateValue.map(value => value), targetRoleValue.map(value => value), isDefaultValue.map(value => value))
      def dbProxyEndpointNameValue: scala.Option[String]
      def dbProxyEndpointArnValue: scala.Option[String]
      def dbProxyNameValue: scala.Option[String]
      def statusValue: scala.Option[DBProxyEndpointStatus]
      def vpcIdValue: scala.Option[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def vpcSubnetIdsValue: scala.Option[List[String]]
      def endpointValue: scala.Option[String]
      def createdDateValue: scala.Option[primitives.TStamp]
      def targetRoleValue: scala.Option[DBProxyEndpointTargetRole]
      def isDefaultValue: scala.Option[Boolean]
      def dbProxyEndpointName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpointName", dbProxyEndpointNameValue)
      def dbProxyEndpointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpointArn", dbProxyEndpointArnValue)
      def dbProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyName", dbProxyNameValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpointStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def vpcSubnetIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSubnetIds", vpcSubnetIdsValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def createdDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdDate", createdDateValue)
      def targetRole: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpointTargetRole] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetRole", targetRoleValue)
      def isDefault: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isDefault", isDefaultValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint) extends DBProxyEndpoint.ReadOnly {
      override def dbProxyEndpointNameValue: scala.Option[String] = scala.Option(impl.dbProxyEndpointName()).map(value => value: String)
      override def dbProxyEndpointArnValue: scala.Option[String] = scala.Option(impl.dbProxyEndpointArn()).map(value => value: String)
      override def dbProxyNameValue: scala.Option[String] = scala.Option(impl.dbProxyName()).map(value => value: String)
      override def statusValue: scala.Option[DBProxyEndpointStatus] = scala.Option(impl.status()).map(value => DBProxyEndpointStatus.wrap(value))
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def vpcSubnetIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSubnetIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def createdDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.createdDate()).map(value => value: primitives.TStamp)
      override def targetRoleValue: scala.Option[DBProxyEndpointTargetRole] = scala.Option(impl.targetRole()).map(value => DBProxyEndpointTargetRole.wrap(value))
      override def isDefaultValue: scala.Option[Boolean] = scala.Option(impl.isDefault()).map(value => value: Boolean)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBProxyEndpoint): ReadOnly = new Wrapper(impl)
  }
  type DBProxyEndpointList = List[DBProxyEndpoint]
  sealed trait DBProxyEndpointStatus { def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus }
  object DBProxyEndpointStatus {
    def wrap(value: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus): DBProxyEndpointStatus = value match {
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.AVAILABLE => available
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.MODIFYING => modifying
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INCOMPATIBLE_NETWORK => `incompatible-network`
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INSUFFICIENT_RESOURCE_LIMITS => `insufficient-resource-limits`
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.CREATING => creating
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.DELETING => deleting
    }
    final case object unknownToSdkVersion extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.UNKNOWN_TO_SDK_VERSION }
    final case object available extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.AVAILABLE }
    final case object modifying extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.MODIFYING }
    final case object `incompatible-network` extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INCOMPATIBLE_NETWORK }
    final case object `insufficient-resource-limits` extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.INSUFFICIENT_RESOURCE_LIMITS }
    final case object creating extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.CREATING }
    final case object deleting extends DBProxyEndpointStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus = software.amazon.awssdk.services.rds.model.DBProxyEndpointStatus.DELETING }
  }
  sealed trait DBProxyEndpointTargetRole { def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole }
  object DBProxyEndpointTargetRole {
    def wrap(value: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole): DBProxyEndpointTargetRole = value match {
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_WRITE => READ_WRITE
      case software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_ONLY => READ_ONLY
    }
    final case object unknownToSdkVersion extends DBProxyEndpointTargetRole { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole = software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.UNKNOWN_TO_SDK_VERSION }
    final case object READ_WRITE extends DBProxyEndpointTargetRole { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole = software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_WRITE }
    final case object READ_ONLY extends DBProxyEndpointTargetRole { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole = software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole.READ_ONLY }
  }
  type DBProxyList = List[DBProxy]
  sealed trait DBProxyStatus { def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus }
  object DBProxyStatus {
    def wrap(value: software.amazon.awssdk.services.rds.model.DBProxyStatus): DBProxyStatus = value match {
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.AVAILABLE => available
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.MODIFYING => modifying
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.INCOMPATIBLE_NETWORK => `incompatible-network`
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.INSUFFICIENT_RESOURCE_LIMITS => `insufficient-resource-limits`
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.CREATING => creating
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.DELETING => deleting
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDED => suspended
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDING => suspending
      case software.amazon.awssdk.services.rds.model.DBProxyStatus.REACTIVATING => reactivating
    }
    final case object unknownToSdkVersion extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.UNKNOWN_TO_SDK_VERSION }
    final case object available extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.AVAILABLE }
    final case object modifying extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.MODIFYING }
    final case object `incompatible-network` extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.INCOMPATIBLE_NETWORK }
    final case object `insufficient-resource-limits` extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.INSUFFICIENT_RESOURCE_LIMITS }
    final case object creating extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.CREATING }
    final case object deleting extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.DELETING }
    final case object suspended extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDED }
    final case object suspending extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.SUSPENDING }
    final case object reactivating extends DBProxyStatus { override def unwrap: software.amazon.awssdk.services.rds.model.DBProxyStatus = software.amazon.awssdk.services.rds.model.DBProxyStatus.REACTIVATING }
  }
  case class DBProxyTarget(targetArn: scala.Option[String] = None, endpoint: scala.Option[String] = None, trackedClusterId: scala.Option[String] = None, rdsResourceId: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, `type`: scala.Option[TargetType] = None, role: scala.Option[TargetRole] = None, targetHealth: scala.Option[TargetHealth] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxyTarget = {
      import DBProxyTarget.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBProxyTarget.builder().optionallyWith(targetArn.map(value => value: java.lang.String))(_.targetArn).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(trackedClusterId.map(value => value: java.lang.String))(_.trackedClusterId).optionallyWith(rdsResourceId.map(value => value: java.lang.String))(_.rdsResourceId).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(`type`.map(value => value.unwrap))(_.`type`).optionallyWith(role.map(value => value.unwrap))(_.role).optionallyWith(targetHealth.map(value => value.buildAwsValue()))(_.targetHealth).build()
    }
    def asReadOnly: DBProxyTarget.ReadOnly = DBProxyTarget.wrap(buildAwsValue())
  }
  object DBProxyTarget {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxyTarget] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBProxyTarget = DBProxyTarget(targetArnValue.map(value => value), endpointValue.map(value => value), trackedClusterIdValue.map(value => value), rdsResourceIdValue.map(value => value), portValue.map(value => value), typeValue.map(value => value), roleValue.map(value => value), targetHealthValue.map(value => value.editable))
      def targetArnValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def trackedClusterIdValue: scala.Option[String]
      def rdsResourceIdValue: scala.Option[String]
      def portValue: scala.Option[primitives.Integer]
      def typeValue: scala.Option[TargetType]
      def roleValue: scala.Option[TargetRole]
      def targetHealthValue: scala.Option[TargetHealth.ReadOnly]
      def targetArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetArn", targetArnValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def trackedClusterId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("trackedClusterId", trackedClusterIdValue)
      def rdsResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("rdsResourceId", rdsResourceIdValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def `type`: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TargetType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("type", typeValue)
      def role: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TargetRole] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("role", roleValue)
      def targetHealth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, TargetHealth.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetHealth", targetHealthValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBProxyTarget) extends DBProxyTarget.ReadOnly {
      override def targetArnValue: scala.Option[String] = scala.Option(impl.targetArn()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def trackedClusterIdValue: scala.Option[String] = scala.Option(impl.trackedClusterId()).map(value => value: String)
      override def rdsResourceIdValue: scala.Option[String] = scala.Option(impl.rdsResourceId()).map(value => value: String)
      override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
      override def typeValue: scala.Option[TargetType] = scala.Option(impl.`type`()).map(value => TargetType.wrap(value))
      override def roleValue: scala.Option[TargetRole] = scala.Option(impl.role()).map(value => TargetRole.wrap(value))
      override def targetHealthValue: scala.Option[TargetHealth.ReadOnly] = scala.Option(impl.targetHealth()).map(value => TargetHealth.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBProxyTarget): ReadOnly = new Wrapper(impl)
  }
  case class DBProxyTargetGroup(dbProxyName: scala.Option[String] = None, targetGroupName: scala.Option[String] = None, targetGroupArn: scala.Option[String] = None, isDefault: scala.Option[Boolean] = None, status: scala.Option[String] = None, connectionPoolConfig: scala.Option[ConnectionPoolConfigurationInfo] = None, createdDate: scala.Option[primitives.TStamp] = None, updatedDate: scala.Option[primitives.TStamp] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBProxyTargetGroup = {
      import DBProxyTargetGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBProxyTargetGroup.builder().optionallyWith(dbProxyName.map(value => value: java.lang.String))(_.dbProxyName).optionallyWith(targetGroupName.map(value => value: java.lang.String))(_.targetGroupName).optionallyWith(targetGroupArn.map(value => value: java.lang.String))(_.targetGroupArn).optionallyWith(isDefault.map(value => value: java.lang.Boolean))(_.isDefault).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(connectionPoolConfig.map(value => value.buildAwsValue()))(_.connectionPoolConfig).optionallyWith(createdDate.map(value => value: java.time.Instant))(_.createdDate).optionallyWith(updatedDate.map(value => value: java.time.Instant))(_.updatedDate).build()
    }
    def asReadOnly: DBProxyTargetGroup.ReadOnly = DBProxyTargetGroup.wrap(buildAwsValue())
  }
  object DBProxyTargetGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBProxyTargetGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBProxyTargetGroup = DBProxyTargetGroup(dbProxyNameValue.map(value => value), targetGroupNameValue.map(value => value), targetGroupArnValue.map(value => value), isDefaultValue.map(value => value), statusValue.map(value => value), connectionPoolConfigValue.map(value => value.editable), createdDateValue.map(value => value), updatedDateValue.map(value => value))
      def dbProxyNameValue: scala.Option[String]
      def targetGroupNameValue: scala.Option[String]
      def targetGroupArnValue: scala.Option[String]
      def isDefaultValue: scala.Option[Boolean]
      def statusValue: scala.Option[String]
      def connectionPoolConfigValue: scala.Option[ConnectionPoolConfigurationInfo.ReadOnly]
      def createdDateValue: scala.Option[primitives.TStamp]
      def updatedDateValue: scala.Option[primitives.TStamp]
      def dbProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyName", dbProxyNameValue)
      def targetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroupName", targetGroupNameValue)
      def targetGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroupArn", targetGroupArnValue)
      def isDefault: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isDefault", isDefaultValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def connectionPoolConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionPoolConfigurationInfo.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionPoolConfig", connectionPoolConfigValue)
      def createdDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("createdDate", createdDateValue)
      def updatedDate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("updatedDate", updatedDateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup) extends DBProxyTargetGroup.ReadOnly {
      override def dbProxyNameValue: scala.Option[String] = scala.Option(impl.dbProxyName()).map(value => value: String)
      override def targetGroupNameValue: scala.Option[String] = scala.Option(impl.targetGroupName()).map(value => value: String)
      override def targetGroupArnValue: scala.Option[String] = scala.Option(impl.targetGroupArn()).map(value => value: String)
      override def isDefaultValue: scala.Option[Boolean] = scala.Option(impl.isDefault()).map(value => value: Boolean)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def connectionPoolConfigValue: scala.Option[ConnectionPoolConfigurationInfo.ReadOnly] = scala.Option(impl.connectionPoolConfig()).map(value => ConnectionPoolConfigurationInfo.wrap(value))
      override def createdDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.createdDate()).map(value => value: primitives.TStamp)
      override def updatedDateValue: scala.Option[primitives.TStamp] = scala.Option(impl.updatedDate()).map(value => value: primitives.TStamp)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBProxyTargetGroup): ReadOnly = new Wrapper(impl)
  }
  case class DBSecurityGroup(ownerId: scala.Option[String] = None, dbSecurityGroupName: scala.Option[String] = None, dbSecurityGroupDescription: scala.Option[String] = None, vpcId: scala.Option[String] = None, ec2SecurityGroups: scala.Option[Iterable[EC2SecurityGroup]] = None, ipRanges: scala.Option[Iterable[IPRange]] = None, dbSecurityGroupArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSecurityGroup = {
      import DBSecurityGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSecurityGroup.builder().optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId).optionallyWith(dbSecurityGroupName.map(value => value: java.lang.String))(_.dbSecurityGroupName).optionallyWith(dbSecurityGroupDescription.map(value => value: java.lang.String))(_.dbSecurityGroupDescription).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(ec2SecurityGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.ec2SecurityGroups).optionallyWith(ipRanges.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.ipRanges).optionallyWith(dbSecurityGroupArn.map(value => value: java.lang.String))(_.dbSecurityGroupArn).build()
    }
    def asReadOnly: DBSecurityGroup.ReadOnly = DBSecurityGroup.wrap(buildAwsValue())
  }
  object DBSecurityGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSecurityGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSecurityGroup = DBSecurityGroup(ownerIdValue.map(value => value), dbSecurityGroupNameValue.map(value => value), dbSecurityGroupDescriptionValue.map(value => value), vpcIdValue.map(value => value), ec2SecurityGroupsValue.map(value => value.map { item => 
        item.editable
      }), ipRangesValue.map(value => value.map { item => 
        item.editable
      }), dbSecurityGroupArnValue.map(value => value))
      def ownerIdValue: scala.Option[String]
      def dbSecurityGroupNameValue: scala.Option[String]
      def dbSecurityGroupDescriptionValue: scala.Option[String]
      def vpcIdValue: scala.Option[String]
      def ec2SecurityGroupsValue: scala.Option[List[EC2SecurityGroup.ReadOnly]]
      def ipRangesValue: scala.Option[List[IPRange.ReadOnly]]
      def dbSecurityGroupArnValue: scala.Option[String]
      def ownerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ownerId", ownerIdValue)
      def dbSecurityGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupNameValue)
      def dbSecurityGroupDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroupDescription", dbSecurityGroupDescriptionValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def ec2SecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EC2SecurityGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroups", ec2SecurityGroupsValue)
      def ipRanges: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[IPRange.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ipRanges", ipRangesValue)
      def dbSecurityGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroupArn", dbSecurityGroupArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup) extends DBSecurityGroup.ReadOnly {
      override def ownerIdValue: scala.Option[String] = scala.Option(impl.ownerId()).map(value => value: String)
      override def dbSecurityGroupNameValue: scala.Option[String] = scala.Option(impl.dbSecurityGroupName()).map(value => value: String)
      override def dbSecurityGroupDescriptionValue: scala.Option[String] = scala.Option(impl.dbSecurityGroupDescription()).map(value => value: String)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def ec2SecurityGroupsValue: scala.Option[List[EC2SecurityGroup.ReadOnly]] = scala.Option(impl.ec2SecurityGroups()).map(value => value.asScala.map { item => 
        EC2SecurityGroup.wrap(item)
      }.toList)
      override def ipRangesValue: scala.Option[List[IPRange.ReadOnly]] = scala.Option(impl.ipRanges()).map(value => value.asScala.map { item => 
        IPRange.wrap(item)
      }.toList)
      override def dbSecurityGroupArnValue: scala.Option[String] = scala.Option(impl.dbSecurityGroupArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSecurityGroup): ReadOnly = new Wrapper(impl)
  }
  case class DBSecurityGroupMembership(dbSecurityGroupName: scala.Option[String] = None, status: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership = {
      import DBSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership.builder().optionallyWith(dbSecurityGroupName.map(value => value: java.lang.String))(_.dbSecurityGroupName).optionallyWith(status.map(value => value: java.lang.String))(_.status).build()
    }
    def asReadOnly: DBSecurityGroupMembership.ReadOnly = DBSecurityGroupMembership.wrap(buildAwsValue())
  }
  object DBSecurityGroupMembership {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSecurityGroupMembership = DBSecurityGroupMembership(dbSecurityGroupNameValue.map(value => value), statusValue.map(value => value))
      def dbSecurityGroupNameValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def dbSecurityGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupNameValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership) extends DBSecurityGroupMembership.ReadOnly {
      override def dbSecurityGroupNameValue: scala.Option[String] = scala.Option(impl.dbSecurityGroupName()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership): ReadOnly = new Wrapper(impl)
  }
  type DBSecurityGroupMembershipList = List[DBSecurityGroupMembership]
  type DBSecurityGroupNameList = List[String]
  type DBSecurityGroups = List[DBSecurityGroup]
  case class DBSnapshot(dbSnapshotIdentifier: scala.Option[String] = None, dbInstanceIdentifier: scala.Option[String] = None, snapshotCreateTime: scala.Option[primitives.TStamp] = None, engine: scala.Option[String] = None, allocatedStorage: scala.Option[primitives.Integer] = None, status: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, availabilityZone: scala.Option[String] = None, vpcId: scala.Option[String] = None, instanceCreateTime: scala.Option[primitives.TStamp] = None, masterUsername: scala.Option[String] = None, engineVersion: scala.Option[String] = None, licenseModel: scala.Option[String] = None, snapshotType: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupName: scala.Option[String] = None, percentProgress: scala.Option[primitives.Integer] = None, sourceRegion: scala.Option[String] = None, sourceDBSnapshotIdentifier: scala.Option[String] = None, storageType: scala.Option[String] = None, tdeCredentialArn: scala.Option[String] = None, encrypted: scala.Option[Boolean] = None, kmsKeyId: scala.Option[String] = None, dbSnapshotArn: scala.Option[String] = None, timezone: scala.Option[String] = None, iamDatabaseAuthenticationEnabled: scala.Option[Boolean] = None, processorFeatures: scala.Option[Iterable[ProcessorFeature]] = None, dbiResourceId: scala.Option[String] = None, tagList: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSnapshot = {
      import DBSnapshot.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSnapshot.builder().optionallyWith(dbSnapshotIdentifier.map(value => value: java.lang.String))(_.dbSnapshotIdentifier).optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(snapshotCreateTime.map(value => value: java.time.Instant))(_.snapshotCreateTime).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(availabilityZone.map(value => value: java.lang.String))(_.availabilityZone).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(instanceCreateTime.map(value => value: java.time.Instant))(_.instanceCreateTime).optionallyWith(masterUsername.map(value => value: java.lang.String))(_.masterUsername).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(percentProgress.map(value => value: java.lang.Integer))(_.percentProgress).optionallyWith(sourceRegion.map(value => value: java.lang.String))(_.sourceRegion).optionallyWith(sourceDBSnapshotIdentifier.map(value => value: java.lang.String))(_.sourceDBSnapshotIdentifier).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(_.tdeCredentialArn).optionallyWith(encrypted.map(value => value: java.lang.Boolean))(_.encrypted).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(dbSnapshotArn.map(value => value: java.lang.String))(_.dbSnapshotArn).optionallyWith(timezone.map(value => value: java.lang.String))(_.timezone).optionallyWith(iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean))(_.iamDatabaseAuthenticationEnabled).optionallyWith(processorFeatures.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.processorFeatures).optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(tagList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tagList).build()
    }
    def asReadOnly: DBSnapshot.ReadOnly = DBSnapshot.wrap(buildAwsValue())
  }
  object DBSnapshot {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSnapshot] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSnapshot = DBSnapshot(dbSnapshotIdentifierValue.map(value => value), dbInstanceIdentifierValue.map(value => value), snapshotCreateTimeValue.map(value => value), engineValue.map(value => value), allocatedStorageValue.map(value => value), statusValue.map(value => value), portValue.map(value => value), availabilityZoneValue.map(value => value), vpcIdValue.map(value => value), instanceCreateTimeValue.map(value => value), masterUsernameValue.map(value => value), engineVersionValue.map(value => value), licenseModelValue.map(value => value), snapshotTypeValue.map(value => value), iopsValue.map(value => value), optionGroupNameValue.map(value => value), percentProgressValue.map(value => value), sourceRegionValue.map(value => value), sourceDBSnapshotIdentifierValue.map(value => value), storageTypeValue.map(value => value), tdeCredentialArnValue.map(value => value), encryptedValue.map(value => value), kmsKeyIdValue.map(value => value), dbSnapshotArnValue.map(value => value), timezoneValue.map(value => value), iamDatabaseAuthenticationEnabledValue.map(value => value), processorFeaturesValue.map(value => value.map { item => 
        item.editable
      }), dbiResourceIdValue.map(value => value), tagListValue.map(value => value.map { item => 
        item.editable
      }))
      def dbSnapshotIdentifierValue: scala.Option[String]
      def dbInstanceIdentifierValue: scala.Option[String]
      def snapshotCreateTimeValue: scala.Option[primitives.TStamp]
      def engineValue: scala.Option[String]
      def allocatedStorageValue: scala.Option[primitives.Integer]
      def statusValue: scala.Option[String]
      def portValue: scala.Option[primitives.Integer]
      def availabilityZoneValue: scala.Option[String]
      def vpcIdValue: scala.Option[String]
      def instanceCreateTimeValue: scala.Option[primitives.TStamp]
      def masterUsernameValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def licenseModelValue: scala.Option[String]
      def snapshotTypeValue: scala.Option[String]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupNameValue: scala.Option[String]
      def percentProgressValue: scala.Option[primitives.Integer]
      def sourceRegionValue: scala.Option[String]
      def sourceDBSnapshotIdentifierValue: scala.Option[String]
      def storageTypeValue: scala.Option[String]
      def tdeCredentialArnValue: scala.Option[String]
      def encryptedValue: scala.Option[Boolean]
      def kmsKeyIdValue: scala.Option[String]
      def dbSnapshotArnValue: scala.Option[String]
      def timezoneValue: scala.Option[String]
      def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean]
      def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]]
      def dbiResourceIdValue: scala.Option[String]
      def tagListValue: scala.Option[List[Tag.ReadOnly]]
      def dbSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifierValue)
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def snapshotCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTimeValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def availabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZone", availabilityZoneValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def instanceCreateTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTimeValue)
      def masterUsername: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUsername", masterUsernameValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
      def sourceRegion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceRegion", sourceRegionValue)
      def sourceDBSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceDBSnapshotIdentifier", sourceDBSnapshotIdentifierValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def tdeCredentialArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArnValue)
      def encrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("encrypted", encryptedValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def dbSnapshotArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotArn", dbSnapshotArnValue)
      def timezone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timezone", timezoneValue)
      def iamDatabaseAuthenticationEnabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabledValue)
      def processorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProcessorFeature.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processorFeatures", processorFeaturesValue)
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
      def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSnapshot) extends DBSnapshot.ReadOnly {
      override def dbSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def snapshotCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.snapshotCreateTime()).map(value => value: primitives.TStamp)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def allocatedStorageValue: scala.Option[primitives.Integer] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.Integer)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
      override def availabilityZoneValue: scala.Option[String] = scala.Option(impl.availabilityZone()).map(value => value: String)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def instanceCreateTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.instanceCreateTime()).map(value => value: primitives.TStamp)
      override def masterUsernameValue: scala.Option[String] = scala.Option(impl.masterUsername()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def percentProgressValue: scala.Option[primitives.Integer] = scala.Option(impl.percentProgress()).map(value => value: primitives.Integer)
      override def sourceRegionValue: scala.Option[String] = scala.Option(impl.sourceRegion()).map(value => value: String)
      override def sourceDBSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.sourceDBSnapshotIdentifier()).map(value => value: String)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def tdeCredentialArnValue: scala.Option[String] = scala.Option(impl.tdeCredentialArn()).map(value => value: String)
      override def encryptedValue: scala.Option[Boolean] = scala.Option(impl.encrypted()).map(value => value: Boolean)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def dbSnapshotArnValue: scala.Option[String] = scala.Option(impl.dbSnapshotArn()).map(value => value: String)
      override def timezoneValue: scala.Option[String] = scala.Option(impl.timezone()).map(value => value: String)
      override def iamDatabaseAuthenticationEnabledValue: scala.Option[Boolean] = scala.Option(impl.iamDatabaseAuthenticationEnabled()).map(value => value: Boolean)
      override def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]] = scala.Option(impl.processorFeatures()).map(value => value.asScala.map { item => 
        ProcessorFeature.wrap(item)
      }.toList)
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
      override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSnapshot): ReadOnly = new Wrapper(impl)
  }
  case class DBSnapshotAttribute(attributeName: scala.Option[String] = None, attributeValues: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSnapshotAttribute = {
      import DBSnapshotAttribute.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSnapshotAttribute.builder().optionallyWith(attributeName.map(value => value: java.lang.String))(_.attributeName).optionallyWith(attributeValues.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.attributeValues).build()
    }
    def asReadOnly: DBSnapshotAttribute.ReadOnly = DBSnapshotAttribute.wrap(buildAwsValue())
  }
  object DBSnapshotAttribute {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSnapshotAttribute] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSnapshotAttribute = DBSnapshotAttribute(attributeNameValue.map(value => value), attributeValuesValue.map(value => value))
      def attributeNameValue: scala.Option[String]
      def attributeValuesValue: scala.Option[List[String]]
      def attributeName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeName", attributeNameValue)
      def attributeValues: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("attributeValues", attributeValuesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttribute) extends DBSnapshotAttribute.ReadOnly {
      override def attributeNameValue: scala.Option[String] = scala.Option(impl.attributeName()).map(value => value: String)
      override def attributeValuesValue: scala.Option[List[String]] = scala.Option(impl.attributeValues()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttribute): ReadOnly = new Wrapper(impl)
  }
  type DBSnapshotAttributeList = List[DBSnapshotAttribute]
  case class DBSnapshotAttributesResult(dbSnapshotIdentifier: scala.Option[String] = None, dbSnapshotAttributes: scala.Option[Iterable[DBSnapshotAttribute]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult = {
      import DBSnapshotAttributesResult.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult.builder().optionallyWith(dbSnapshotIdentifier.map(value => value: java.lang.String))(_.dbSnapshotIdentifier).optionallyWith(dbSnapshotAttributes.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbSnapshotAttributes).build()
    }
    def asReadOnly: DBSnapshotAttributesResult.ReadOnly = DBSnapshotAttributesResult.wrap(buildAwsValue())
  }
  object DBSnapshotAttributesResult {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSnapshotAttributesResult = DBSnapshotAttributesResult(dbSnapshotIdentifierValue.map(value => value), dbSnapshotAttributesValue.map(value => value.map { item => 
        item.editable
      }))
      def dbSnapshotIdentifierValue: scala.Option[String]
      def dbSnapshotAttributesValue: scala.Option[List[DBSnapshotAttribute.ReadOnly]]
      def dbSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifierValue)
      def dbSnapshotAttributes: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSnapshotAttribute.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotAttributes", dbSnapshotAttributesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult) extends DBSnapshotAttributesResult.ReadOnly {
      override def dbSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
      override def dbSnapshotAttributesValue: scala.Option[List[DBSnapshotAttribute.ReadOnly]] = scala.Option(impl.dbSnapshotAttributes()).map(value => value.asScala.map { item => 
        DBSnapshotAttribute.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSnapshotAttributesResult): ReadOnly = new Wrapper(impl)
  }
  type DBSnapshotList = List[DBSnapshot]
  case class DBSubnetGroup(dbSubnetGroupName: scala.Option[String] = None, dbSubnetGroupDescription: scala.Option[String] = None, vpcId: scala.Option[String] = None, subnetGroupStatus: scala.Option[String] = None, subnets: scala.Option[Iterable[Subnet]] = None, dbSubnetGroupArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DBSubnetGroup = {
      import DBSubnetGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DBSubnetGroup.builder().optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(dbSubnetGroupDescription.map(value => value: java.lang.String))(_.dbSubnetGroupDescription).optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId).optionallyWith(subnetGroupStatus.map(value => value: java.lang.String))(_.subnetGroupStatus).optionallyWith(subnets.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.subnets).optionallyWith(dbSubnetGroupArn.map(value => value: java.lang.String))(_.dbSubnetGroupArn).build()
    }
    def asReadOnly: DBSubnetGroup.ReadOnly = DBSubnetGroup.wrap(buildAwsValue())
  }
  object DBSubnetGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DBSubnetGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DBSubnetGroup = DBSubnetGroup(dbSubnetGroupNameValue.map(value => value), dbSubnetGroupDescriptionValue.map(value => value), vpcIdValue.map(value => value), subnetGroupStatusValue.map(value => value), subnetsValue.map(value => value.map { item => 
        item.editable
      }), dbSubnetGroupArnValue.map(value => value))
      def dbSubnetGroupNameValue: scala.Option[String]
      def dbSubnetGroupDescriptionValue: scala.Option[String]
      def vpcIdValue: scala.Option[String]
      def subnetGroupStatusValue: scala.Option[String]
      def subnetsValue: scala.Option[List[Subnet.ReadOnly]]
      def dbSubnetGroupArnValue: scala.Option[String]
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def dbSubnetGroupDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescriptionValue)
      def vpcId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcId", vpcIdValue)
      def subnetGroupStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnetGroupStatus", subnetGroupStatusValue)
      def subnets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Subnet.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subnets", subnetsValue)
      def dbSubnetGroupArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupArn", dbSubnetGroupArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup) extends DBSubnetGroup.ReadOnly {
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def dbSubnetGroupDescriptionValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
      override def vpcIdValue: scala.Option[String] = scala.Option(impl.vpcId()).map(value => value: String)
      override def subnetGroupStatusValue: scala.Option[String] = scala.Option(impl.subnetGroupStatus()).map(value => value: String)
      override def subnetsValue: scala.Option[List[Subnet.ReadOnly]] = scala.Option(impl.subnets()).map(value => value.asScala.map { item => 
        Subnet.wrap(item)
      }.toList)
      override def dbSubnetGroupArnValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DBSubnetGroup): ReadOnly = new Wrapper(impl)
  }
  type DBSubnetGroups = List[DBSubnetGroup]
  case class DeleteCustomAvailabilityZoneRequest(customAvailabilityZoneId: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest = {
      import DeleteCustomAvailabilityZoneRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest.builder().customAvailabilityZoneId(customAvailabilityZoneId: java.lang.String).build()
    }
    def asReadOnly: DeleteCustomAvailabilityZoneRequest.ReadOnly = DeleteCustomAvailabilityZoneRequest.wrap(buildAwsValue())
  }
  object DeleteCustomAvailabilityZoneRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteCustomAvailabilityZoneRequest = DeleteCustomAvailabilityZoneRequest(customAvailabilityZoneIdValue)
      def customAvailabilityZoneIdValue: String
      def customAvailabilityZoneId: ZIO[Any, Nothing, String] = ZIO.succeed(customAvailabilityZoneIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest) extends DeleteCustomAvailabilityZoneRequest.ReadOnly { override def customAvailabilityZoneIdValue: String = impl.customAvailabilityZoneId(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteCustomAvailabilityZoneResponse(customAvailabilityZone: scala.Option[CustomAvailabilityZone] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse = {
      import DeleteCustomAvailabilityZoneResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse.builder().optionallyWith(customAvailabilityZone.map(value => value.buildAwsValue()))(_.customAvailabilityZone).build()
    }
    def asReadOnly: DeleteCustomAvailabilityZoneResponse.ReadOnly = DeleteCustomAvailabilityZoneResponse.wrap(buildAwsValue())
  }
  object DeleteCustomAvailabilityZoneResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteCustomAvailabilityZoneResponse = DeleteCustomAvailabilityZoneResponse(customAvailabilityZoneValue.map(value => value.editable))
      def customAvailabilityZoneValue: scala.Option[CustomAvailabilityZone.ReadOnly]
      def customAvailabilityZone: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CustomAvailabilityZone.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZone", customAvailabilityZoneValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse) extends DeleteCustomAvailabilityZoneResponse.ReadOnly { override def customAvailabilityZoneValue: scala.Option[CustomAvailabilityZone.ReadOnly] = scala.Option(impl.customAvailabilityZone()).map(value => CustomAvailabilityZone.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterEndpointRequest(dbClusterEndpointIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest = {
      import DeleteDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest.builder().dbClusterEndpointIdentifier(dbClusterEndpointIdentifier: java.lang.String).build()
    }
    def asReadOnly: DeleteDbClusterEndpointRequest.ReadOnly = DeleteDbClusterEndpointRequest.wrap(buildAwsValue())
  }
  object DeleteDbClusterEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterEndpointRequest = DeleteDbClusterEndpointRequest(dbClusterEndpointIdentifierValue)
      def dbClusterEndpointIdentifierValue: String
      def dbClusterEndpointIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterEndpointIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest) extends DeleteDbClusterEndpointRequest.ReadOnly { override def dbClusterEndpointIdentifierValue: String = impl.dbClusterEndpointIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterEndpointResponse(dbClusterEndpointIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterEndpointResourceIdentifier: scala.Option[String] = None, endpoint: scala.Option[String] = None, status: scala.Option[String] = None, endpointType: scala.Option[String] = None, customEndpointType: scala.Option[String] = None, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None, dbClusterEndpointArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse = {
      import DeleteDbClusterEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse.builder().optionallyWith(dbClusterEndpointIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterEndpointResourceIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointResourceIdentifier).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(endpointType.map(value => value: java.lang.String))(_.endpointType).optionallyWith(customEndpointType.map(value => value: java.lang.String))(_.customEndpointType).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).optionallyWith(dbClusterEndpointArn.map(value => value: java.lang.String))(_.dbClusterEndpointArn).build()
    }
    def asReadOnly: DeleteDbClusterEndpointResponse.ReadOnly = DeleteDbClusterEndpointResponse.wrap(buildAwsValue())
  }
  object DeleteDbClusterEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterEndpointResponse = DeleteDbClusterEndpointResponse(dbClusterEndpointIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterEndpointResourceIdentifierValue.map(value => value), endpointValue.map(value => value), statusValue.map(value => value), endpointTypeValue.map(value => value), customEndpointTypeValue.map(value => value), staticMembersValue.map(value => value), excludedMembersValue.map(value => value), dbClusterEndpointArnValue.map(value => value))
      def dbClusterEndpointIdentifierValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterEndpointResourceIdentifierValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def endpointTypeValue: scala.Option[String]
      def customEndpointTypeValue: scala.Option[String]
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def dbClusterEndpointArnValue: scala.Option[String]
      def dbClusterEndpointIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointIdentifier", dbClusterEndpointIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterEndpointResourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointResourceIdentifier", dbClusterEndpointResourceIdentifierValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def endpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpointType", endpointTypeValue)
      def customEndpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customEndpointType", customEndpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
      def dbClusterEndpointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse) extends DeleteDbClusterEndpointResponse.ReadOnly {
      override def dbClusterEndpointIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointIdentifier()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterEndpointResourceIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointResourceIdentifier()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def endpointTypeValue: scala.Option[String] = scala.Option(impl.endpointType()).map(value => value: String)
      override def customEndpointTypeValue: scala.Option[String] = scala.Option(impl.customEndpointType()).map(value => value: String)
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterEndpointArnValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest = {
      import DeleteDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbClusterParameterGroupRequest.ReadOnly = DeleteDbClusterParameterGroupRequest.wrap(buildAwsValue())
  }
  object DeleteDbClusterParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterParameterGroupRequest = DeleteDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue)
      def dbClusterParameterGroupNameValue: String
      def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest) extends DeleteDbClusterParameterGroupRequest.ReadOnly { override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterRequest(dbClusterIdentifier: String, skipFinalSnapshot: scala.Option[Boolean] = None, finalDBSnapshotIdentifier: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest = {
      import DeleteDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(_.skipFinalSnapshot).optionallyWith(finalDBSnapshotIdentifier.map(value => value: java.lang.String))(_.finalDBSnapshotIdentifier).build()
    }
    def asReadOnly: DeleteDbClusterRequest.ReadOnly = DeleteDbClusterRequest.wrap(buildAwsValue())
  }
  object DeleteDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterRequest = DeleteDbClusterRequest(dbClusterIdentifierValue, skipFinalSnapshotValue.map(value => value), finalDBSnapshotIdentifierValue.map(value => value))
      def dbClusterIdentifierValue: String
      def skipFinalSnapshotValue: scala.Option[Boolean]
      def finalDBSnapshotIdentifierValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def skipFinalSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshotValue)
      def finalDBSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest) extends DeleteDbClusterRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def skipFinalSnapshotValue: scala.Option[Boolean] = scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
      override def finalDBSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse = {
      import DeleteDbClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
    }
    def asReadOnly: DeleteDbClusterResponse.ReadOnly = DeleteDbClusterResponse.wrap(buildAwsValue())
  }
  object DeleteDbClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterResponse = DeleteDbClusterResponse(dbClusterValue.map(value => value.editable))
      def dbClusterValue: scala.Option[DBCluster.ReadOnly]
      def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse) extends DeleteDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterSnapshotRequest(dbClusterSnapshotIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest = {
      import DeleteDbClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).build()
    }
    def asReadOnly: DeleteDbClusterSnapshotRequest.ReadOnly = DeleteDbClusterSnapshotRequest.wrap(buildAwsValue())
  }
  object DeleteDbClusterSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterSnapshotRequest = DeleteDbClusterSnapshotRequest(dbClusterSnapshotIdentifierValue)
      def dbClusterSnapshotIdentifierValue: String
      def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest) extends DeleteDbClusterSnapshotRequest.ReadOnly { override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbClusterSnapshotResponse(dbClusterSnapshot: scala.Option[DBClusterSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse = {
      import DeleteDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse.builder().optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(_.dbClusterSnapshot).build()
    }
    def asReadOnly: DeleteDbClusterSnapshotResponse.ReadOnly = DeleteDbClusterSnapshotResponse.wrap(buildAwsValue())
  }
  object DeleteDbClusterSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbClusterSnapshotResponse = DeleteDbClusterSnapshotResponse(dbClusterSnapshotValue.map(value => value.editable))
      def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly]
      def dbClusterSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse) extends DeleteDbClusterSnapshotResponse.ReadOnly { override def dbClusterSnapshotValue: scala.Option[DBClusterSnapshot.ReadOnly] = scala.Option(impl.dbClusterSnapshot()).map(value => DBClusterSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbInstanceAutomatedBackupRequest(dbiResourceId: scala.Option[String] = None, dbInstanceAutomatedBackupsArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest = {
      import DeleteDbInstanceAutomatedBackupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest.builder().optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String))(_.dbInstanceAutomatedBackupsArn).build()
    }
    def asReadOnly: DeleteDbInstanceAutomatedBackupRequest.ReadOnly = DeleteDbInstanceAutomatedBackupRequest.wrap(buildAwsValue())
  }
  object DeleteDbInstanceAutomatedBackupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbInstanceAutomatedBackupRequest = DeleteDbInstanceAutomatedBackupRequest(dbiResourceIdValue.map(value => value), dbInstanceAutomatedBackupsArnValue.map(value => value))
      def dbiResourceIdValue: scala.Option[String]
      def dbInstanceAutomatedBackupsArnValue: scala.Option[String]
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
      def dbInstanceAutomatedBackupsArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest) extends DeleteDbInstanceAutomatedBackupRequest.ReadOnly {
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
      override def dbInstanceAutomatedBackupsArnValue: scala.Option[String] = scala.Option(impl.dbInstanceAutomatedBackupsArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbInstanceAutomatedBackupResponse(dbInstanceAutomatedBackup: scala.Option[DBInstanceAutomatedBackup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse = {
      import DeleteDbInstanceAutomatedBackupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse.builder().optionallyWith(dbInstanceAutomatedBackup.map(value => value.buildAwsValue()))(_.dbInstanceAutomatedBackup).build()
    }
    def asReadOnly: DeleteDbInstanceAutomatedBackupResponse.ReadOnly = DeleteDbInstanceAutomatedBackupResponse.wrap(buildAwsValue())
  }
  object DeleteDbInstanceAutomatedBackupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbInstanceAutomatedBackupResponse = DeleteDbInstanceAutomatedBackupResponse(dbInstanceAutomatedBackupValue.map(value => value.editable))
      def dbInstanceAutomatedBackupValue: scala.Option[DBInstanceAutomatedBackup.ReadOnly]
      def dbInstanceAutomatedBackup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstanceAutomatedBackup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackup", dbInstanceAutomatedBackupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse) extends DeleteDbInstanceAutomatedBackupResponse.ReadOnly { override def dbInstanceAutomatedBackupValue: scala.Option[DBInstanceAutomatedBackup.ReadOnly] = scala.Option(impl.dbInstanceAutomatedBackup()).map(value => DBInstanceAutomatedBackup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbInstanceRequest(dbInstanceIdentifier: String, skipFinalSnapshot: scala.Option[Boolean] = None, finalDBSnapshotIdentifier: scala.Option[String] = None, deleteAutomatedBackups: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest = {
      import DeleteDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(skipFinalSnapshot.map(value => value: java.lang.Boolean))(_.skipFinalSnapshot).optionallyWith(finalDBSnapshotIdentifier.map(value => value: java.lang.String))(_.finalDBSnapshotIdentifier).optionallyWith(deleteAutomatedBackups.map(value => value: java.lang.Boolean))(_.deleteAutomatedBackups).build()
    }
    def asReadOnly: DeleteDbInstanceRequest.ReadOnly = DeleteDbInstanceRequest.wrap(buildAwsValue())
  }
  object DeleteDbInstanceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbInstanceRequest = DeleteDbInstanceRequest(dbInstanceIdentifierValue, skipFinalSnapshotValue.map(value => value), finalDBSnapshotIdentifierValue.map(value => value), deleteAutomatedBackupsValue.map(value => value))
      def dbInstanceIdentifierValue: String
      def skipFinalSnapshotValue: scala.Option[Boolean]
      def finalDBSnapshotIdentifierValue: scala.Option[String]
      def deleteAutomatedBackupsValue: scala.Option[primitives.BooleanOptional]
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def skipFinalSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("skipFinalSnapshot", skipFinalSnapshotValue)
      def finalDBSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("finalDBSnapshotIdentifier", finalDBSnapshotIdentifierValue)
      def deleteAutomatedBackups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deleteAutomatedBackups", deleteAutomatedBackupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest) extends DeleteDbInstanceRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def skipFinalSnapshotValue: scala.Option[Boolean] = scala.Option(impl.skipFinalSnapshot()).map(value => value: Boolean)
      override def finalDBSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.finalDBSnapshotIdentifier()).map(value => value: String)
      override def deleteAutomatedBackupsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deleteAutomatedBackups()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbInstanceResponse(dbInstance: scala.Option[DBInstance] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse = {
      import DeleteDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
    }
    def asReadOnly: DeleteDbInstanceResponse.ReadOnly = DeleteDbInstanceResponse.wrap(buildAwsValue())
  }
  object DeleteDbInstanceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbInstanceResponse = DeleteDbInstanceResponse(dbInstanceValue.map(value => value.editable))
      def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
      def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse) extends DeleteDbInstanceResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbParameterGroupRequest(dbParameterGroupName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest = {
      import DeleteDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest.builder().dbParameterGroupName(dbParameterGroupName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbParameterGroupRequest.ReadOnly = DeleteDbParameterGroupRequest.wrap(buildAwsValue())
  }
  object DeleteDbParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbParameterGroupRequest = DeleteDbParameterGroupRequest(dbParameterGroupNameValue)
      def dbParameterGroupNameValue: String
      def dbParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest) extends DeleteDbParameterGroupRequest.ReadOnly { override def dbParameterGroupNameValue: String = impl.dbParameterGroupName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbProxyEndpointRequest(dbProxyEndpointName: primitives.DBProxyEndpointName) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest = {
      import DeleteDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest.builder().dbProxyEndpointName(dbProxyEndpointName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbProxyEndpointRequest.ReadOnly = DeleteDbProxyEndpointRequest.wrap(buildAwsValue())
  }
  object DeleteDbProxyEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbProxyEndpointRequest = DeleteDbProxyEndpointRequest(dbProxyEndpointNameValue)
      def dbProxyEndpointNameValue: primitives.DBProxyEndpointName
      def dbProxyEndpointName: ZIO[Any, Nothing, primitives.DBProxyEndpointName] = ZIO.succeed(dbProxyEndpointNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest) extends DeleteDbProxyEndpointRequest.ReadOnly { override def dbProxyEndpointNameValue: primitives.DBProxyEndpointName = impl.dbProxyEndpointName(): primitives.DBProxyEndpointName }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbProxyEndpointResponse(dbProxyEndpoint: scala.Option[DBProxyEndpoint] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse = {
      import DeleteDbProxyEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse.builder().optionallyWith(dbProxyEndpoint.map(value => value.buildAwsValue()))(_.dbProxyEndpoint).build()
    }
    def asReadOnly: DeleteDbProxyEndpointResponse.ReadOnly = DeleteDbProxyEndpointResponse.wrap(buildAwsValue())
  }
  object DeleteDbProxyEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbProxyEndpointResponse = DeleteDbProxyEndpointResponse(dbProxyEndpointValue.map(value => value.editable))
      def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly]
      def dbProxyEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpoint", dbProxyEndpointValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse) extends DeleteDbProxyEndpointResponse.ReadOnly { override def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly] = scala.Option(impl.dbProxyEndpoint()).map(value => DBProxyEndpoint.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbProxyRequest(dbProxyName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest = {
      import DeleteDbProxyRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest.builder().dbProxyName(dbProxyName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbProxyRequest.ReadOnly = DeleteDbProxyRequest.wrap(buildAwsValue())
  }
  object DeleteDbProxyRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbProxyRequest = DeleteDbProxyRequest(dbProxyNameValue)
      def dbProxyNameValue: String
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest) extends DeleteDbProxyRequest.ReadOnly { override def dbProxyNameValue: String = impl.dbProxyName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbProxyResponse(dbProxy: scala.Option[DBProxy] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse = {
      import DeleteDbProxyResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse.builder().optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy).build()
    }
    def asReadOnly: DeleteDbProxyResponse.ReadOnly = DeleteDbProxyResponse.wrap(buildAwsValue())
  }
  object DeleteDbProxyResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbProxyResponse = DeleteDbProxyResponse(dbProxyValue.map(value => value.editable))
      def dbProxyValue: scala.Option[DBProxy.ReadOnly]
      def dbProxy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxy.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxy", dbProxyValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse) extends DeleteDbProxyResponse.ReadOnly { override def dbProxyValue: scala.Option[DBProxy.ReadOnly] = scala.Option(impl.dbProxy()).map(value => DBProxy.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbSecurityGroupRequest(dbSecurityGroupName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest = {
      import DeleteDbSecurityGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest.builder().dbSecurityGroupName(dbSecurityGroupName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbSecurityGroupRequest.ReadOnly = DeleteDbSecurityGroupRequest.wrap(buildAwsValue())
  }
  object DeleteDbSecurityGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbSecurityGroupRequest = DeleteDbSecurityGroupRequest(dbSecurityGroupNameValue)
      def dbSecurityGroupNameValue: String
      def dbSecurityGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSecurityGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest) extends DeleteDbSecurityGroupRequest.ReadOnly { override def dbSecurityGroupNameValue: String = impl.dbSecurityGroupName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbSnapshotRequest(dbSnapshotIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest = {
      import DeleteDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest.builder().dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String).build()
    }
    def asReadOnly: DeleteDbSnapshotRequest.ReadOnly = DeleteDbSnapshotRequest.wrap(buildAwsValue())
  }
  object DeleteDbSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbSnapshotRequest = DeleteDbSnapshotRequest(dbSnapshotIdentifierValue)
      def dbSnapshotIdentifierValue: String
      def dbSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbSnapshotIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest) extends DeleteDbSnapshotRequest.ReadOnly { override def dbSnapshotIdentifierValue: String = impl.dbSnapshotIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbSnapshotResponse(dbSnapshot: scala.Option[DBSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse = {
      import DeleteDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse.builder().optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(_.dbSnapshot).build()
    }
    def asReadOnly: DeleteDbSnapshotResponse.ReadOnly = DeleteDbSnapshotResponse.wrap(buildAwsValue())
  }
  object DeleteDbSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbSnapshotResponse = DeleteDbSnapshotResponse(dbSnapshotValue.map(value => value.editable))
      def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly]
      def dbSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshot", dbSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse) extends DeleteDbSnapshotResponse.ReadOnly { override def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly] = scala.Option(impl.dbSnapshot()).map(value => DBSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteDbSubnetGroupRequest(dbSubnetGroupName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest = {
      import DeleteDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).build()
    }
    def asReadOnly: DeleteDbSubnetGroupRequest.ReadOnly = DeleteDbSubnetGroupRequest.wrap(buildAwsValue())
  }
  object DeleteDbSubnetGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteDbSubnetGroupRequest = DeleteDbSubnetGroupRequest(dbSubnetGroupNameValue)
      def dbSubnetGroupNameValue: String
      def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest) extends DeleteDbSubnetGroupRequest.ReadOnly { override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteEventSubscriptionRequest(subscriptionName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest = {
      import DeleteEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).build()
    }
    def asReadOnly: DeleteEventSubscriptionRequest.ReadOnly = DeleteEventSubscriptionRequest.wrap(buildAwsValue())
  }
  object DeleteEventSubscriptionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteEventSubscriptionRequest = DeleteEventSubscriptionRequest(subscriptionNameValue)
      def subscriptionNameValue: String
      def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest) extends DeleteEventSubscriptionRequest.ReadOnly { override def subscriptionNameValue: String = impl.subscriptionName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteEventSubscriptionResponse(eventSubscription: scala.Option[EventSubscription] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse = {
      import DeleteEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse.builder().optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(_.eventSubscription).build()
    }
    def asReadOnly: DeleteEventSubscriptionResponse.ReadOnly = DeleteEventSubscriptionResponse.wrap(buildAwsValue())
  }
  object DeleteEventSubscriptionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteEventSubscriptionResponse = DeleteEventSubscriptionResponse(eventSubscriptionValue.map(value => value.editable))
      def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly]
      def eventSubscription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EventSubscription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscription", eventSubscriptionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse) extends DeleteEventSubscriptionResponse.ReadOnly { override def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly] = scala.Option(impl.eventSubscription()).map(value => EventSubscription.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteGlobalClusterRequest(globalClusterIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest = {
      import DeleteGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).build()
    }
    def asReadOnly: DeleteGlobalClusterRequest.ReadOnly = DeleteGlobalClusterRequest.wrap(buildAwsValue())
  }
  object DeleteGlobalClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteGlobalClusterRequest = DeleteGlobalClusterRequest(globalClusterIdentifierValue)
      def globalClusterIdentifierValue: String
      def globalClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(globalClusterIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest) extends DeleteGlobalClusterRequest.ReadOnly { override def globalClusterIdentifierValue: String = impl.globalClusterIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteGlobalClusterResponse(globalCluster: scala.Option[GlobalCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse = {
      import DeleteGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse.builder().optionallyWith(globalCluster.map(value => value.buildAwsValue()))(_.globalCluster).build()
    }
    def asReadOnly: DeleteGlobalClusterResponse.ReadOnly = DeleteGlobalClusterResponse.wrap(buildAwsValue())
  }
  object DeleteGlobalClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteGlobalClusterResponse = DeleteGlobalClusterResponse(globalClusterValue.map(value => value.editable))
      def globalClusterValue: scala.Option[GlobalCluster.ReadOnly]
      def globalCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GlobalCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalCluster", globalClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse) extends DeleteGlobalClusterResponse.ReadOnly { override def globalClusterValue: scala.Option[GlobalCluster.ReadOnly] = scala.Option(impl.globalCluster()).map(value => GlobalCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteInstallationMediaRequest(installationMediaId: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest = {
      import DeleteInstallationMediaRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest.builder().installationMediaId(installationMediaId: java.lang.String).build()
    }
    def asReadOnly: DeleteInstallationMediaRequest.ReadOnly = DeleteInstallationMediaRequest.wrap(buildAwsValue())
  }
  object DeleteInstallationMediaRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteInstallationMediaRequest = DeleteInstallationMediaRequest(installationMediaIdValue)
      def installationMediaIdValue: String
      def installationMediaId: ZIO[Any, Nothing, String] = ZIO.succeed(installationMediaIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest) extends DeleteInstallationMediaRequest.ReadOnly { override def installationMediaIdValue: String = impl.installationMediaId(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeleteInstallationMediaResponse(installationMediaId: scala.Option[String] = None, customAvailabilityZoneId: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, engineInstallationMediaPath: scala.Option[String] = None, osInstallationMediaPath: scala.Option[String] = None, status: scala.Option[String] = None, failureCause: scala.Option[InstallationMediaFailureCause] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse = {
      import DeleteInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse.builder().optionallyWith(installationMediaId.map(value => value: java.lang.String))(_.installationMediaId).optionallyWith(customAvailabilityZoneId.map(value => value: java.lang.String))(_.customAvailabilityZoneId).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(engineInstallationMediaPath.map(value => value: java.lang.String))(_.engineInstallationMediaPath).optionallyWith(osInstallationMediaPath.map(value => value: java.lang.String))(_.osInstallationMediaPath).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(failureCause.map(value => value.buildAwsValue()))(_.failureCause).build()
    }
    def asReadOnly: DeleteInstallationMediaResponse.ReadOnly = DeleteInstallationMediaResponse.wrap(buildAwsValue())
  }
  object DeleteInstallationMediaResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteInstallationMediaResponse = DeleteInstallationMediaResponse(installationMediaIdValue.map(value => value), customAvailabilityZoneIdValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), engineInstallationMediaPathValue.map(value => value), osInstallationMediaPathValue.map(value => value), statusValue.map(value => value), failureCauseValue.map(value => value.editable))
      def installationMediaIdValue: scala.Option[String]
      def customAvailabilityZoneIdValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def engineInstallationMediaPathValue: scala.Option[String]
      def osInstallationMediaPathValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly]
      def installationMediaId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("installationMediaId", installationMediaIdValue)
      def customAvailabilityZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneIdValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def engineInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineInstallationMediaPath", engineInstallationMediaPathValue)
      def osInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("osInstallationMediaPath", osInstallationMediaPathValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def failureCause: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstallationMediaFailureCause.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureCause", failureCauseValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse) extends DeleteInstallationMediaResponse.ReadOnly {
      override def installationMediaIdValue: scala.Option[String] = scala.Option(impl.installationMediaId()).map(value => value: String)
      override def customAvailabilityZoneIdValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def engineInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.engineInstallationMediaPath()).map(value => value: String)
      override def osInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.osInstallationMediaPath()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly] = scala.Option(impl.failureCause()).map(value => InstallationMediaFailureCause.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse): ReadOnly = new Wrapper(impl)
  }
  case class DeleteOptionGroupRequest(optionGroupName: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest = {
      import DeleteOptionGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest.builder().optionGroupName(optionGroupName: java.lang.String).build()
    }
    def asReadOnly: DeleteOptionGroupRequest.ReadOnly = DeleteOptionGroupRequest.wrap(buildAwsValue())
  }
  object DeleteOptionGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeleteOptionGroupRequest = DeleteOptionGroupRequest(optionGroupNameValue)
      def optionGroupNameValue: String
      def optionGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(optionGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest) extends DeleteOptionGroupRequest.ReadOnly { override def optionGroupNameValue: String = impl.optionGroupName(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeregisterDbProxyTargetsRequest(dbProxyName: String, targetGroupName: scala.Option[String] = None, dbInstanceIdentifiers: scala.Option[Iterable[String]] = None, dbClusterIdentifiers: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest = {
      import DeregisterDbProxyTargetsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest.builder().dbProxyName(dbProxyName: java.lang.String).optionallyWith(targetGroupName.map(value => value: java.lang.String))(_.targetGroupName).optionallyWith(dbInstanceIdentifiers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.dbInstanceIdentifiers).optionallyWith(dbClusterIdentifiers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.dbClusterIdentifiers).build()
    }
    def asReadOnly: DeregisterDbProxyTargetsRequest.ReadOnly = DeregisterDbProxyTargetsRequest.wrap(buildAwsValue())
  }
  object DeregisterDbProxyTargetsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DeregisterDbProxyTargetsRequest = DeregisterDbProxyTargetsRequest(dbProxyNameValue, targetGroupNameValue.map(value => value), dbInstanceIdentifiersValue.map(value => value), dbClusterIdentifiersValue.map(value => value))
      def dbProxyNameValue: String
      def targetGroupNameValue: scala.Option[String]
      def dbInstanceIdentifiersValue: scala.Option[List[String]]
      def dbClusterIdentifiersValue: scala.Option[List[String]]
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def targetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroupName", targetGroupNameValue)
      def dbInstanceIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifiers", dbInstanceIdentifiersValue)
      def dbClusterIdentifiers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifiers", dbClusterIdentifiersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest) extends DeregisterDbProxyTargetsRequest.ReadOnly {
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def targetGroupNameValue: scala.Option[String] = scala.Option(impl.targetGroupName()).map(value => value: String)
      override def dbInstanceIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.dbInstanceIdentifiers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterIdentifiersValue: scala.Option[List[String]] = scala.Option(impl.dbClusterIdentifiers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DeregisterDbProxyTargetsResponse() {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse = {
      import DeregisterDbProxyTargetsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse.builder().build()
    }
    def asReadOnly: DeregisterDbProxyTargetsResponse.ReadOnly = DeregisterDbProxyTargetsResponse.wrap(buildAwsValue())
  }
  object DeregisterDbProxyTargetsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly { def editable: DeregisterDbProxyTargetsResponse = DeregisterDbProxyTargetsResponse() }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse) extends DeregisterDbProxyTargetsResponse.ReadOnly
    def wrap(impl: software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeAccountAttributesRequest() {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest = {
      import DescribeAccountAttributesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest.builder().build()
    }
    def asReadOnly: DescribeAccountAttributesRequest.ReadOnly = DescribeAccountAttributesRequest.wrap(buildAwsValue())
  }
  object DescribeAccountAttributesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly { def editable: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest() }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest) extends DescribeAccountAttributesRequest.ReadOnly
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeAccountAttributesResponse(accountQuotas: scala.Option[Iterable[AccountQuota]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse = {
      import DescribeAccountAttributesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse.builder().optionallyWith(accountQuotas.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.accountQuotas).build()
    }
    def asReadOnly: DescribeAccountAttributesResponse.ReadOnly = DescribeAccountAttributesResponse.wrap(buildAwsValue())
  }
  object DescribeAccountAttributesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeAccountAttributesResponse = DescribeAccountAttributesResponse(accountQuotasValue.map(value => value.map { item => 
        item.editable
      }))
      def accountQuotasValue: scala.Option[List[AccountQuota.ReadOnly]]
      def accountQuotas: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AccountQuota.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountQuotas", accountQuotasValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse) extends DescribeAccountAttributesResponse.ReadOnly {
      override def accountQuotasValue: scala.Option[List[AccountQuota.ReadOnly]] = scala.Option(impl.accountQuotas()).map(value => value.asScala.map { item => 
        AccountQuota.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeCertificatesRequest(certificateIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest = {
      import DescribeCertificatesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest.builder().optionallyWith(certificateIdentifier.map(value => value: java.lang.String))(_.certificateIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeCertificatesRequest.ReadOnly = DescribeCertificatesRequest.wrap(buildAwsValue())
  }
  object DescribeCertificatesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeCertificatesRequest = DescribeCertificatesRequest(certificateIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def certificateIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def certificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest) extends DescribeCertificatesRequest.ReadOnly {
      override def certificateIdentifierValue: scala.Option[String] = scala.Option(impl.certificateIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeCertificatesResponse(certificates: scala.Option[Iterable[Certificate]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse = {
      import DescribeCertificatesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse.builder().optionallyWith(certificates.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.certificates).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeCertificatesResponse.ReadOnly = DescribeCertificatesResponse.wrap(buildAwsValue())
  }
  object DescribeCertificatesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeCertificatesResponse = DescribeCertificatesResponse(certificatesValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def certificatesValue: scala.Option[List[Certificate.ReadOnly]]
      def markerValue: scala.Option[String]
      def certificates: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Certificate.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificates", certificatesValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse) extends DescribeCertificatesResponse.ReadOnly {
      override def certificatesValue: scala.Option[List[Certificate.ReadOnly]] = scala.Option(impl.certificates()).map(value => value.asScala.map { item => 
        Certificate.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeCertificatesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeCustomAvailabilityZonesRequest(customAvailabilityZoneId: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest = {
      import DescribeCustomAvailabilityZonesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest.builder().optionallyWith(customAvailabilityZoneId.map(value => value: java.lang.String))(_.customAvailabilityZoneId).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeCustomAvailabilityZonesRequest.ReadOnly = DescribeCustomAvailabilityZonesRequest.wrap(buildAwsValue())
  }
  object DescribeCustomAvailabilityZonesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeCustomAvailabilityZonesRequest = DescribeCustomAvailabilityZonesRequest(customAvailabilityZoneIdValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def customAvailabilityZoneIdValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def customAvailabilityZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneIdValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest) extends DescribeCustomAvailabilityZonesRequest.ReadOnly {
      override def customAvailabilityZoneIdValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeCustomAvailabilityZonesResponse(marker: scala.Option[String] = None, customAvailabilityZones: scala.Option[Iterable[CustomAvailabilityZone]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse = {
      import DescribeCustomAvailabilityZonesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(customAvailabilityZones.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.customAvailabilityZones).build()
    }
    def asReadOnly: DescribeCustomAvailabilityZonesResponse.ReadOnly = DescribeCustomAvailabilityZonesResponse.wrap(buildAwsValue())
  }
  object DescribeCustomAvailabilityZonesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeCustomAvailabilityZonesResponse = DescribeCustomAvailabilityZonesResponse(markerValue.map(value => value), customAvailabilityZonesValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def customAvailabilityZonesValue: scala.Option[List[CustomAvailabilityZone.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def customAvailabilityZones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[CustomAvailabilityZone.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZones", customAvailabilityZonesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse) extends DescribeCustomAvailabilityZonesResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def customAvailabilityZonesValue: scala.Option[List[CustomAvailabilityZone.ReadOnly]] = scala.Option(impl.customAvailabilityZones()).map(value => value.asScala.map { item => 
        CustomAvailabilityZone.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDBLogFilesDetails(logFileName: scala.Option[String] = None, lastWritten: scala.Option[Long] = None, size: scala.Option[Long] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails = {
      import DescribeDBLogFilesDetails.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails.builder().optionallyWith(logFileName.map(value => value: java.lang.String))(_.logFileName).optionallyWith(lastWritten.map(value => value: java.lang.Long))(_.lastWritten).optionallyWith(size.map(value => value: java.lang.Long))(_.size).build()
    }
    def asReadOnly: DescribeDBLogFilesDetails.ReadOnly = DescribeDBLogFilesDetails.wrap(buildAwsValue())
  }
  object DescribeDBLogFilesDetails {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDBLogFilesDetails = DescribeDBLogFilesDetails(logFileNameValue.map(value => value), lastWrittenValue.map(value => value), sizeValue.map(value => value))
      def logFileNameValue: scala.Option[String]
      def lastWrittenValue: scala.Option[Long]
      def sizeValue: scala.Option[Long]
      def logFileName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logFileName", logFileNameValue)
      def lastWritten: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("lastWritten", lastWrittenValue)
      def size: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("size", sizeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails) extends DescribeDBLogFilesDetails.ReadOnly {
      override def logFileNameValue: scala.Option[String] = scala.Option(impl.logFileName()).map(value => value: String)
      override def lastWrittenValue: scala.Option[Long] = scala.Option(impl.lastWritten()).map(value => value: Long)
      override def sizeValue: scala.Option[Long] = scala.Option(impl.size()).map(value => value: Long)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails): ReadOnly = new Wrapper(impl)
  }
  type DescribeDBLogFilesList = List[DescribeDBLogFilesDetails]
  case class DescribeDbClusterBacktracksRequest(dbClusterIdentifier: String, backtrackIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest = {
      import DescribeDbClusterBacktracksRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(backtrackIdentifier.map(value => value: java.lang.String))(_.backtrackIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbClusterBacktracksRequest.ReadOnly = DescribeDbClusterBacktracksRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterBacktracksRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterBacktracksRequest = DescribeDbClusterBacktracksRequest(dbClusterIdentifierValue, backtrackIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbClusterIdentifierValue: String
      def backtrackIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def backtrackIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackIdentifier", backtrackIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest) extends DescribeDbClusterBacktracksRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def backtrackIdentifierValue: scala.Option[String] = scala.Option(impl.backtrackIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterBacktracksResponse(marker: scala.Option[String] = None, dbClusterBacktracks: scala.Option[Iterable[DBClusterBacktrack]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse = {
      import DescribeDbClusterBacktracksResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterBacktracks.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterBacktracks).build()
    }
    def asReadOnly: DescribeDbClusterBacktracksResponse.ReadOnly = DescribeDbClusterBacktracksResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterBacktracksResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterBacktracksResponse = DescribeDbClusterBacktracksResponse(markerValue.map(value => value), dbClusterBacktracksValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbClusterBacktracksValue: scala.Option[List[DBClusterBacktrack.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbClusterBacktracks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterBacktrack.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterBacktracks", dbClusterBacktracksValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse) extends DescribeDbClusterBacktracksResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbClusterBacktracksValue: scala.Option[List[DBClusterBacktrack.ReadOnly]] = scala.Option(impl.dbClusterBacktracks()).map(value => value.asScala.map { item => 
        DBClusterBacktrack.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterEndpointsRequest(dbClusterIdentifier: scala.Option[String] = None, dbClusterEndpointIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest = {
      import DescribeDbClusterEndpointsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterEndpointIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbClusterEndpointsRequest.ReadOnly = DescribeDbClusterEndpointsRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterEndpointsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterEndpointsRequest = DescribeDbClusterEndpointsRequest(dbClusterIdentifierValue.map(value => value), dbClusterEndpointIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterEndpointIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterEndpointIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointIdentifier", dbClusterEndpointIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest) extends DescribeDbClusterEndpointsRequest.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterEndpointIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterEndpointsResponse(marker: scala.Option[String] = None, dbClusterEndpoints: scala.Option[Iterable[DBClusterEndpoint]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse = {
      import DescribeDbClusterEndpointsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterEndpoints.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterEndpoints).build()
    }
    def asReadOnly: DescribeDbClusterEndpointsResponse.ReadOnly = DescribeDbClusterEndpointsResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterEndpointsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterEndpointsResponse = DescribeDbClusterEndpointsResponse(markerValue.map(value => value), dbClusterEndpointsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbClusterEndpointsValue: scala.Option[List[DBClusterEndpoint.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbClusterEndpoints: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterEndpoint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpoints", dbClusterEndpointsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse) extends DescribeDbClusterEndpointsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbClusterEndpointsValue: scala.Option[List[DBClusterEndpoint.ReadOnly]] = scala.Option(impl.dbClusterEndpoints()).map(value => value.asScala.map { item => 
        DBClusterEndpoint.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterParameterGroupsRequest(dbClusterParameterGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest = {
      import DescribeDbClusterParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbClusterParameterGroupsRequest.ReadOnly = DescribeDbClusterParameterGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterParameterGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterParameterGroupsRequest = DescribeDbClusterParameterGroupsRequest(dbClusterParameterGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbClusterParameterGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest) extends DescribeDbClusterParameterGroupsRequest.ReadOnly {
      override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterParameterGroupsResponse(marker: scala.Option[String] = None, dbClusterParameterGroups: scala.Option[Iterable[DBClusterParameterGroup]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse = {
      import DescribeDbClusterParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterParameterGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterParameterGroups).build()
    }
    def asReadOnly: DescribeDbClusterParameterGroupsResponse.ReadOnly = DescribeDbClusterParameterGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterParameterGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterParameterGroupsResponse = DescribeDbClusterParameterGroupsResponse(markerValue.map(value => value), dbClusterParameterGroupsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbClusterParameterGroupsValue: scala.Option[List[DBClusterParameterGroup.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbClusterParameterGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterParameterGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroups", dbClusterParameterGroupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse) extends DescribeDbClusterParameterGroupsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbClusterParameterGroupsValue: scala.Option[List[DBClusterParameterGroup.ReadOnly]] = scala.Option(impl.dbClusterParameterGroups()).map(value => value.asScala.map { item => 
        DBClusterParameterGroup.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterParametersRequest(dbClusterParameterGroupName: String, source: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest = {
      import DescribeDbClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).optionallyWith(source.map(value => value: java.lang.String))(_.source).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbClusterParametersRequest.ReadOnly = DescribeDbClusterParametersRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterParametersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterParametersRequest = DescribeDbClusterParametersRequest(dbClusterParameterGroupNameValue, sourceValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbClusterParameterGroupNameValue: String
      def sourceValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
      def source: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("source", sourceValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest) extends DescribeDbClusterParametersRequest.ReadOnly {
      override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
      override def sourceValue: scala.Option[String] = scala.Option(impl.source()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterParametersResponse(parameters: scala.Option[Iterable[Parameter]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse = {
      import DescribeDbClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse.builder().optionallyWith(parameters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.parameters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbClusterParametersResponse.ReadOnly = DescribeDbClusterParametersResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterParametersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterParametersResponse = DescribeDbClusterParametersResponse(parametersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def parametersValue: scala.Option[List[Parameter.ReadOnly]]
      def markerValue: scala.Option[String]
      def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse) extends DescribeDbClusterParametersResponse.ReadOnly {
      override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
        Parameter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterSnapshotAttributesRequest(dbClusterSnapshotIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest = {
      import DescribeDbClusterSnapshotAttributesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).build()
    }
    def asReadOnly: DescribeDbClusterSnapshotAttributesRequest.ReadOnly = DescribeDbClusterSnapshotAttributesRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterSnapshotAttributesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterSnapshotAttributesRequest = DescribeDbClusterSnapshotAttributesRequest(dbClusterSnapshotIdentifierValue)
      def dbClusterSnapshotIdentifierValue: String
      def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest) extends DescribeDbClusterSnapshotAttributesRequest.ReadOnly { override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterSnapshotAttributesResponse(dbClusterSnapshotAttributesResult: scala.Option[DBClusterSnapshotAttributesResult] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse = {
      import DescribeDbClusterSnapshotAttributesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse.builder().optionallyWith(dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue()))(_.dbClusterSnapshotAttributesResult).build()
    }
    def asReadOnly: DescribeDbClusterSnapshotAttributesResponse.ReadOnly = DescribeDbClusterSnapshotAttributesResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterSnapshotAttributesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterSnapshotAttributesResponse = DescribeDbClusterSnapshotAttributesResponse(dbClusterSnapshotAttributesResultValue.map(value => value.editable))
      def dbClusterSnapshotAttributesResultValue: scala.Option[DBClusterSnapshotAttributesResult.ReadOnly]
      def dbClusterSnapshotAttributesResult: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshotAttributesResult.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotAttributesResult", dbClusterSnapshotAttributesResultValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse) extends DescribeDbClusterSnapshotAttributesResponse.ReadOnly { override def dbClusterSnapshotAttributesResultValue: scala.Option[DBClusterSnapshotAttributesResult.ReadOnly] = scala.Option(impl.dbClusterSnapshotAttributesResult()).map(value => DBClusterSnapshotAttributesResult.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterSnapshotsRequest(dbClusterIdentifier: scala.Option[String] = None, dbClusterSnapshotIdentifier: scala.Option[String] = None, snapshotType: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, includeShared: scala.Option[Boolean] = None, includePublic: scala.Option[Boolean] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest = {
      import DescribeDbClusterSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterSnapshotIdentifier.map(value => value: java.lang.String))(_.dbClusterSnapshotIdentifier).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(includeShared.map(value => value: java.lang.Boolean))(_.includeShared).optionallyWith(includePublic.map(value => value: java.lang.Boolean))(_.includePublic).build()
    }
    def asReadOnly: DescribeDbClusterSnapshotsRequest.ReadOnly = DescribeDbClusterSnapshotsRequest.wrap(buildAwsValue())
  }
  object DescribeDbClusterSnapshotsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterSnapshotsRequest = DescribeDbClusterSnapshotsRequest(dbClusterIdentifierValue.map(value => value), dbClusterSnapshotIdentifierValue.map(value => value), snapshotTypeValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value), includeSharedValue.map(value => value), includePublicValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterSnapshotIdentifierValue: scala.Option[String]
      def snapshotTypeValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def includeSharedValue: scala.Option[Boolean]
      def includePublicValue: scala.Option[Boolean]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotIdentifier", dbClusterSnapshotIdentifierValue)
      def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def includeShared: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeShared", includeSharedValue)
      def includePublic: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includePublic", includePublicValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest) extends DescribeDbClusterSnapshotsRequest.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterSnapshotIdentifier()).map(value => value: String)
      override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def includeSharedValue: scala.Option[Boolean] = scala.Option(impl.includeShared()).map(value => value: Boolean)
      override def includePublicValue: scala.Option[Boolean] = scala.Option(impl.includePublic()).map(value => value: Boolean)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClusterSnapshotsResponse(marker: scala.Option[String] = None, dbClusterSnapshots: scala.Option[Iterable[DBClusterSnapshot]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse = {
      import DescribeDbClusterSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusterSnapshots.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusterSnapshots).build()
    }
    def asReadOnly: DescribeDbClusterSnapshotsResponse.ReadOnly = DescribeDbClusterSnapshotsResponse.wrap(buildAwsValue())
  }
  object DescribeDbClusterSnapshotsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClusterSnapshotsResponse = DescribeDbClusterSnapshotsResponse(markerValue.map(value => value), dbClusterSnapshotsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbClusterSnapshotsValue: scala.Option[List[DBClusterSnapshot.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbClusterSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBClusterSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshots", dbClusterSnapshotsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse) extends DescribeDbClusterSnapshotsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbClusterSnapshotsValue: scala.Option[List[DBClusterSnapshot.ReadOnly]] = scala.Option(impl.dbClusterSnapshots()).map(value => value.asScala.map { item => 
        DBClusterSnapshot.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClustersRequest(dbClusterIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, includeShared: scala.Option[Boolean] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest = {
      import DescribeDbClustersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(includeShared.map(value => value: java.lang.Boolean))(_.includeShared).build()
    }
    def asReadOnly: DescribeDbClustersRequest.ReadOnly = DescribeDbClustersRequest.wrap(buildAwsValue())
  }
  object DescribeDbClustersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClustersRequest = DescribeDbClustersRequest(dbClusterIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value), includeSharedValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def includeSharedValue: scala.Option[Boolean]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def includeShared: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeShared", includeSharedValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest) extends DescribeDbClustersRequest.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def includeSharedValue: scala.Option[Boolean] = scala.Option(impl.includeShared()).map(value => value: Boolean)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbClustersResponse(marker: scala.Option[String] = None, dbClusters: scala.Option[Iterable[DBCluster]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse = {
      import DescribeDbClustersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbClusters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbClusters).build()
    }
    def asReadOnly: DescribeDbClustersResponse.ReadOnly = DescribeDbClustersResponse.wrap(buildAwsValue())
  }
  object DescribeDbClustersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbClustersResponse = DescribeDbClustersResponse(markerValue.map(value => value), dbClustersValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbClustersValue: scala.Option[List[DBCluster.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbClusters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBCluster.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusters", dbClustersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse) extends DescribeDbClustersResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbClustersValue: scala.Option[List[DBCluster.ReadOnly]] = scala.Option(impl.dbClusters()).map(value => value.asScala.map { item => 
        DBCluster.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbEngineVersionsRequest(engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, dbParameterGroupFamily: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, defaultOnly: scala.Option[Boolean] = None, listSupportedCharacterSets: scala.Option[primitives.BooleanOptional] = None, listSupportedTimezones: scala.Option[primitives.BooleanOptional] = None, includeAll: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest = {
      import DescribeDbEngineVersionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest.builder().optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(defaultOnly.map(value => value: java.lang.Boolean))(_.defaultOnly).optionallyWith(listSupportedCharacterSets.map(value => value: java.lang.Boolean))(_.listSupportedCharacterSets).optionallyWith(listSupportedTimezones.map(value => value: java.lang.Boolean))(_.listSupportedTimezones).optionallyWith(includeAll.map(value => value: java.lang.Boolean))(_.includeAll).build()
    }
    def asReadOnly: DescribeDbEngineVersionsRequest.ReadOnly = DescribeDbEngineVersionsRequest.wrap(buildAwsValue())
  }
  object DescribeDbEngineVersionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbEngineVersionsRequest = DescribeDbEngineVersionsRequest(engineValue.map(value => value), engineVersionValue.map(value => value), dbParameterGroupFamilyValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value), defaultOnlyValue.map(value => value), listSupportedCharacterSetsValue.map(value => value), listSupportedTimezonesValue.map(value => value), includeAllValue.map(value => value))
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def dbParameterGroupFamilyValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def defaultOnlyValue: scala.Option[Boolean]
      def listSupportedCharacterSetsValue: scala.Option[primitives.BooleanOptional]
      def listSupportedTimezonesValue: scala.Option[primitives.BooleanOptional]
      def includeAllValue: scala.Option[primitives.BooleanOptional]
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def defaultOnly: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("defaultOnly", defaultOnlyValue)
      def listSupportedCharacterSets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("listSupportedCharacterSets", listSupportedCharacterSetsValue)
      def listSupportedTimezones: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("listSupportedTimezones", listSupportedTimezonesValue)
      def includeAll: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeAll", includeAllValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest) extends DescribeDbEngineVersionsRequest.ReadOnly {
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def defaultOnlyValue: scala.Option[Boolean] = scala.Option(impl.defaultOnly()).map(value => value: Boolean)
      override def listSupportedCharacterSetsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.listSupportedCharacterSets()).map(value => value: primitives.BooleanOptional)
      override def listSupportedTimezonesValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.listSupportedTimezones()).map(value => value: primitives.BooleanOptional)
      override def includeAllValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.includeAll()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbEngineVersionsResponse(marker: scala.Option[String] = None, dbEngineVersions: scala.Option[Iterable[DBEngineVersion]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse = {
      import DescribeDbEngineVersionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbEngineVersions.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbEngineVersions).build()
    }
    def asReadOnly: DescribeDbEngineVersionsResponse.ReadOnly = DescribeDbEngineVersionsResponse.wrap(buildAwsValue())
  }
  object DescribeDbEngineVersionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbEngineVersionsResponse = DescribeDbEngineVersionsResponse(markerValue.map(value => value), dbEngineVersionsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbEngineVersionsValue: scala.Option[List[DBEngineVersion.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbEngineVersions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBEngineVersion.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbEngineVersions", dbEngineVersionsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse) extends DescribeDbEngineVersionsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbEngineVersionsValue: scala.Option[List[DBEngineVersion.ReadOnly]] = scala.Option(impl.dbEngineVersions()).map(value => value.asScala.map { item => 
        DBEngineVersion.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbInstanceAutomatedBackupsRequest(dbiResourceId: scala.Option[String] = None, dbInstanceIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, dbInstanceAutomatedBackupsArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest = {
      import DescribeDbInstanceAutomatedBackupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest.builder().optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbInstanceAutomatedBackupsArn.map(value => value: java.lang.String))(_.dbInstanceAutomatedBackupsArn).build()
    }
    def asReadOnly: DescribeDbInstanceAutomatedBackupsRequest.ReadOnly = DescribeDbInstanceAutomatedBackupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbInstanceAutomatedBackupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbInstanceAutomatedBackupsRequest = DescribeDbInstanceAutomatedBackupsRequest(dbiResourceIdValue.map(value => value), dbInstanceIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value), dbInstanceAutomatedBackupsArnValue.map(value => value))
      def dbiResourceIdValue: scala.Option[String]
      def dbInstanceIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbInstanceAutomatedBackupsArnValue: scala.Option[String]
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbInstanceAutomatedBackupsArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackupsArn", dbInstanceAutomatedBackupsArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest) extends DescribeDbInstanceAutomatedBackupsRequest.ReadOnly {
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbInstanceAutomatedBackupsArnValue: scala.Option[String] = scala.Option(impl.dbInstanceAutomatedBackupsArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbInstanceAutomatedBackupsResponse(marker: scala.Option[String] = None, dbInstanceAutomatedBackups: scala.Option[Iterable[DBInstanceAutomatedBackup]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse = {
      import DescribeDbInstanceAutomatedBackupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbInstanceAutomatedBackups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbInstanceAutomatedBackups).build()
    }
    def asReadOnly: DescribeDbInstanceAutomatedBackupsResponse.ReadOnly = DescribeDbInstanceAutomatedBackupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbInstanceAutomatedBackupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbInstanceAutomatedBackupsResponse = DescribeDbInstanceAutomatedBackupsResponse(markerValue.map(value => value), dbInstanceAutomatedBackupsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbInstanceAutomatedBackupsValue: scala.Option[List[DBInstanceAutomatedBackup.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbInstanceAutomatedBackups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstanceAutomatedBackup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceAutomatedBackups", dbInstanceAutomatedBackupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse) extends DescribeDbInstanceAutomatedBackupsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbInstanceAutomatedBackupsValue: scala.Option[List[DBInstanceAutomatedBackup.ReadOnly]] = scala.Option(impl.dbInstanceAutomatedBackups()).map(value => value.asScala.map { item => 
        DBInstanceAutomatedBackup.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbInstancesRequest(dbInstanceIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest = {
      import DescribeDbInstancesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbInstancesRequest.ReadOnly = DescribeDbInstancesRequest.wrap(buildAwsValue())
  }
  object DescribeDbInstancesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbInstancesRequest = DescribeDbInstancesRequest(dbInstanceIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbInstanceIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest) extends DescribeDbInstancesRequest.ReadOnly {
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbInstancesResponse(marker: scala.Option[String] = None, dbInstances: scala.Option[Iterable[DBInstance]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse = {
      import DescribeDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbInstances.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbInstances).build()
    }
    def asReadOnly: DescribeDbInstancesResponse.ReadOnly = DescribeDbInstancesResponse.wrap(buildAwsValue())
  }
  object DescribeDbInstancesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbInstancesResponse = DescribeDbInstancesResponse(markerValue.map(value => value), dbInstancesValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbInstancesValue: scala.Option[List[DBInstance.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbInstances: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBInstance.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstances", dbInstancesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse) extends DescribeDbInstancesResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbInstancesValue: scala.Option[List[DBInstance.ReadOnly]] = scala.Option(impl.dbInstances()).map(value => value.asScala.map { item => 
        DBInstance.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbLogFilesRequest(dbInstanceIdentifier: String, filenameContains: scala.Option[String] = None, fileLastWritten: scala.Option[Long] = None, fileSize: scala.Option[Long] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest = {
      import DescribeDbLogFilesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(filenameContains.map(value => value: java.lang.String))(_.filenameContains).optionallyWith(fileLastWritten.map(value => value: java.lang.Long))(_.fileLastWritten).optionallyWith(fileSize.map(value => value: java.lang.Long))(_.fileSize).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbLogFilesRequest.ReadOnly = DescribeDbLogFilesRequest.wrap(buildAwsValue())
  }
  object DescribeDbLogFilesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbLogFilesRequest = DescribeDbLogFilesRequest(dbInstanceIdentifierValue, filenameContainsValue.map(value => value), fileLastWrittenValue.map(value => value), fileSizeValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbInstanceIdentifierValue: String
      def filenameContainsValue: scala.Option[String]
      def fileLastWrittenValue: scala.Option[Long]
      def fileSizeValue: scala.Option[Long]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def filenameContains: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filenameContains", filenameContainsValue)
      def fileLastWritten: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fileLastWritten", fileLastWrittenValue)
      def fileSize: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Long] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fileSize", fileSizeValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest) extends DescribeDbLogFilesRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def filenameContainsValue: scala.Option[String] = scala.Option(impl.filenameContains()).map(value => value: String)
      override def fileLastWrittenValue: scala.Option[Long] = scala.Option(impl.fileLastWritten()).map(value => value: Long)
      override def fileSizeValue: scala.Option[Long] = scala.Option(impl.fileSize()).map(value => value: Long)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbLogFilesResponse(describeDBLogFiles: scala.Option[Iterable[DescribeDBLogFilesDetails]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse = {
      import DescribeDbLogFilesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse.builder().optionallyWith(describeDBLogFiles.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.describeDBLogFiles).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbLogFilesResponse.ReadOnly = DescribeDbLogFilesResponse.wrap(buildAwsValue())
  }
  object DescribeDbLogFilesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbLogFilesResponse = DescribeDbLogFilesResponse(describeDBLogFilesValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def describeDBLogFilesValue: scala.Option[List[DescribeDBLogFilesDetails.ReadOnly]]
      def markerValue: scala.Option[String]
      def describeDBLogFiles: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DescribeDBLogFilesDetails.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("describeDBLogFiles", describeDBLogFilesValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse) extends DescribeDbLogFilesResponse.ReadOnly {
      override def describeDBLogFilesValue: scala.Option[List[DescribeDBLogFilesDetails.ReadOnly]] = scala.Option(impl.describeDBLogFiles()).map(value => value.asScala.map { item => 
        DescribeDBLogFilesDetails.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbParameterGroupsRequest(dbParameterGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest = {
      import DescribeDbParameterGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest.builder().optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbParameterGroupsRequest.ReadOnly = DescribeDbParameterGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbParameterGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbParameterGroupsRequest = DescribeDbParameterGroupsRequest(dbParameterGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbParameterGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest) extends DescribeDbParameterGroupsRequest.ReadOnly {
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbParameterGroupsResponse(marker: scala.Option[String] = None, dbParameterGroups: scala.Option[Iterable[DBParameterGroup]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse = {
      import DescribeDbParameterGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbParameterGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbParameterGroups).build()
    }
    def asReadOnly: DescribeDbParameterGroupsResponse.ReadOnly = DescribeDbParameterGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbParameterGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbParameterGroupsResponse = DescribeDbParameterGroupsResponse(markerValue.map(value => value), dbParameterGroupsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbParameterGroupsValue: scala.Option[List[DBParameterGroup.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbParameterGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBParameterGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse) extends DescribeDbParameterGroupsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbParameterGroupsValue: scala.Option[List[DBParameterGroup.ReadOnly]] = scala.Option(impl.dbParameterGroups()).map(value => value.asScala.map { item => 
        DBParameterGroup.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbParametersRequest(dbParameterGroupName: String, source: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest = {
      import DescribeDbParametersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest.builder().dbParameterGroupName(dbParameterGroupName: java.lang.String).optionallyWith(source.map(value => value: java.lang.String))(_.source).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbParametersRequest.ReadOnly = DescribeDbParametersRequest.wrap(buildAwsValue())
  }
  object DescribeDbParametersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbParametersRequest = DescribeDbParametersRequest(dbParameterGroupNameValue, sourceValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbParameterGroupNameValue: String
      def sourceValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupNameValue)
      def source: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("source", sourceValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest) extends DescribeDbParametersRequest.ReadOnly {
      override def dbParameterGroupNameValue: String = impl.dbParameterGroupName(): String
      override def sourceValue: scala.Option[String] = scala.Option(impl.source()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbParametersResponse(parameters: scala.Option[Iterable[Parameter]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse = {
      import DescribeDbParametersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse.builder().optionallyWith(parameters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.parameters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbParametersResponse.ReadOnly = DescribeDbParametersResponse.wrap(buildAwsValue())
  }
  object DescribeDbParametersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbParametersResponse = DescribeDbParametersResponse(parametersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def parametersValue: scala.Option[List[Parameter.ReadOnly]]
      def markerValue: scala.Option[String]
      def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse) extends DescribeDbParametersResponse.ReadOnly {
      override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
        Parameter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxiesRequest(dbProxyName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.MaxRecords] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest = {
      import DescribeDbProxiesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest.builder().optionallyWith(dbProxyName.map(value => value: java.lang.String))(_.dbProxyName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribeDbProxiesRequest.ReadOnly = DescribeDbProxiesRequest.wrap(buildAwsValue())
  }
  object DescribeDbProxiesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxiesRequest = DescribeDbProxiesRequest(dbProxyNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def dbProxyNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.MaxRecords]
      def dbProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyName", dbProxyNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxRecords] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest) extends DescribeDbProxiesRequest.ReadOnly {
      override def dbProxyNameValue: scala.Option[String] = scala.Option(impl.dbProxyName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.MaxRecords] = scala.Option(impl.maxRecords()).map(value => value: primitives.MaxRecords)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxiesResponse(dbProxies: scala.Option[Iterable[DBProxy]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse = {
      import DescribeDbProxiesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse.builder().optionallyWith(dbProxies.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbProxies).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbProxiesResponse.ReadOnly = DescribeDbProxiesResponse.wrap(buildAwsValue())
  }
  object DescribeDbProxiesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxiesResponse = DescribeDbProxiesResponse(dbProxiesValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def dbProxiesValue: scala.Option[List[DBProxy.ReadOnly]]
      def markerValue: scala.Option[String]
      def dbProxies: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBProxy.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxies", dbProxiesValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse) extends DescribeDbProxiesResponse.ReadOnly {
      override def dbProxiesValue: scala.Option[List[DBProxy.ReadOnly]] = scala.Option(impl.dbProxies()).map(value => value.asScala.map { item => 
        DBProxy.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxiesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyEndpointsRequest(dbProxyName: scala.Option[primitives.DBProxyName] = None, dbProxyEndpointName: scala.Option[primitives.DBProxyEndpointName] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.MaxRecords] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest = {
      import DescribeDbProxyEndpointsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest.builder().optionallyWith(dbProxyName.map(value => value: java.lang.String))(_.dbProxyName).optionallyWith(dbProxyEndpointName.map(value => value: java.lang.String))(_.dbProxyEndpointName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribeDbProxyEndpointsRequest.ReadOnly = DescribeDbProxyEndpointsRequest.wrap(buildAwsValue())
  }
  object DescribeDbProxyEndpointsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyEndpointsRequest = DescribeDbProxyEndpointsRequest(dbProxyNameValue.map(value => value), dbProxyEndpointNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def dbProxyNameValue: scala.Option[primitives.DBProxyName]
      def dbProxyEndpointNameValue: scala.Option[primitives.DBProxyEndpointName]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.MaxRecords]
      def dbProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DBProxyName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyName", dbProxyNameValue)
      def dbProxyEndpointName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DBProxyEndpointName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpointName", dbProxyEndpointNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxRecords] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest) extends DescribeDbProxyEndpointsRequest.ReadOnly {
      override def dbProxyNameValue: scala.Option[primitives.DBProxyName] = scala.Option(impl.dbProxyName()).map(value => value: primitives.DBProxyName)
      override def dbProxyEndpointNameValue: scala.Option[primitives.DBProxyEndpointName] = scala.Option(impl.dbProxyEndpointName()).map(value => value: primitives.DBProxyEndpointName)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.MaxRecords] = scala.Option(impl.maxRecords()).map(value => value: primitives.MaxRecords)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyEndpointsResponse(dbProxyEndpoints: scala.Option[Iterable[DBProxyEndpoint]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse = {
      import DescribeDbProxyEndpointsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse.builder().optionallyWith(dbProxyEndpoints.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbProxyEndpoints).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbProxyEndpointsResponse.ReadOnly = DescribeDbProxyEndpointsResponse.wrap(buildAwsValue())
  }
  object DescribeDbProxyEndpointsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyEndpointsResponse = DescribeDbProxyEndpointsResponse(dbProxyEndpointsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def dbProxyEndpointsValue: scala.Option[List[DBProxyEndpoint.ReadOnly]]
      def markerValue: scala.Option[String]
      def dbProxyEndpoints: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBProxyEndpoint.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpoints", dbProxyEndpointsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse) extends DescribeDbProxyEndpointsResponse.ReadOnly {
      override def dbProxyEndpointsValue: scala.Option[List[DBProxyEndpoint.ReadOnly]] = scala.Option(impl.dbProxyEndpoints()).map(value => value.asScala.map { item => 
        DBProxyEndpoint.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyTargetGroupsRequest(dbProxyName: String, targetGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.MaxRecords] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest = {
      import DescribeDbProxyTargetGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest.builder().dbProxyName(dbProxyName: java.lang.String).optionallyWith(targetGroupName.map(value => value: java.lang.String))(_.targetGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribeDbProxyTargetGroupsRequest.ReadOnly = DescribeDbProxyTargetGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbProxyTargetGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyTargetGroupsRequest = DescribeDbProxyTargetGroupsRequest(dbProxyNameValue, targetGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def dbProxyNameValue: String
      def targetGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.MaxRecords]
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def targetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroupName", targetGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxRecords] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest) extends DescribeDbProxyTargetGroupsRequest.ReadOnly {
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def targetGroupNameValue: scala.Option[String] = scala.Option(impl.targetGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.MaxRecords] = scala.Option(impl.maxRecords()).map(value => value: primitives.MaxRecords)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyTargetGroupsResponse(targetGroups: scala.Option[Iterable[DBProxyTargetGroup]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse = {
      import DescribeDbProxyTargetGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse.builder().optionallyWith(targetGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.targetGroups).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbProxyTargetGroupsResponse.ReadOnly = DescribeDbProxyTargetGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbProxyTargetGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyTargetGroupsResponse = DescribeDbProxyTargetGroupsResponse(targetGroupsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def targetGroupsValue: scala.Option[List[DBProxyTargetGroup.ReadOnly]]
      def markerValue: scala.Option[String]
      def targetGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBProxyTargetGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroups", targetGroupsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse) extends DescribeDbProxyTargetGroupsResponse.ReadOnly {
      override def targetGroupsValue: scala.Option[List[DBProxyTargetGroup.ReadOnly]] = scala.Option(impl.targetGroups()).map(value => value.asScala.map { item => 
        DBProxyTargetGroup.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyTargetsRequest(dbProxyName: String, targetGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.MaxRecords] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest = {
      import DescribeDbProxyTargetsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest.builder().dbProxyName(dbProxyName: java.lang.String).optionallyWith(targetGroupName.map(value => value: java.lang.String))(_.targetGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribeDbProxyTargetsRequest.ReadOnly = DescribeDbProxyTargetsRequest.wrap(buildAwsValue())
  }
  object DescribeDbProxyTargetsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyTargetsRequest = DescribeDbProxyTargetsRequest(dbProxyNameValue, targetGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def dbProxyNameValue: String
      def targetGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.MaxRecords]
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def targetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetGroupName", targetGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxRecords] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest) extends DescribeDbProxyTargetsRequest.ReadOnly {
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def targetGroupNameValue: scala.Option[String] = scala.Option(impl.targetGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.MaxRecords] = scala.Option(impl.maxRecords()).map(value => value: primitives.MaxRecords)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbProxyTargetsResponse(targets: scala.Option[Iterable[DBProxyTarget]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse = {
      import DescribeDbProxyTargetsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse.builder().optionallyWith(targets.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.targets).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbProxyTargetsResponse.ReadOnly = DescribeDbProxyTargetsResponse.wrap(buildAwsValue())
  }
  object DescribeDbProxyTargetsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbProxyTargetsResponse = DescribeDbProxyTargetsResponse(targetsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def targetsValue: scala.Option[List[DBProxyTarget.ReadOnly]]
      def markerValue: scala.Option[String]
      def targets: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBProxyTarget.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targets", targetsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse) extends DescribeDbProxyTargetsResponse.ReadOnly {
      override def targetsValue: scala.Option[List[DBProxyTarget.ReadOnly]] = scala.Option(impl.targets()).map(value => value.asScala.map { item => 
        DBProxyTarget.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSecurityGroupsRequest(dbSecurityGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest = {
      import DescribeDbSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest.builder().optionallyWith(dbSecurityGroupName.map(value => value: java.lang.String))(_.dbSecurityGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbSecurityGroupsRequest.ReadOnly = DescribeDbSecurityGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbSecurityGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSecurityGroupsRequest = DescribeDbSecurityGroupsRequest(dbSecurityGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbSecurityGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbSecurityGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroupName", dbSecurityGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest) extends DescribeDbSecurityGroupsRequest.ReadOnly {
      override def dbSecurityGroupNameValue: scala.Option[String] = scala.Option(impl.dbSecurityGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSecurityGroupsResponse(marker: scala.Option[String] = None, dbSecurityGroups: scala.Option[Iterable[DBSecurityGroup]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse = {
      import DescribeDbSecurityGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbSecurityGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbSecurityGroups).build()
    }
    def asReadOnly: DescribeDbSecurityGroupsResponse.ReadOnly = DescribeDbSecurityGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbSecurityGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSecurityGroupsResponse = DescribeDbSecurityGroupsResponse(markerValue.map(value => value), dbSecurityGroupsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbSecurityGroupsValue: scala.Option[List[DBSecurityGroup.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSecurityGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse) extends DescribeDbSecurityGroupsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbSecurityGroupsValue: scala.Option[List[DBSecurityGroup.ReadOnly]] = scala.Option(impl.dbSecurityGroups()).map(value => value.asScala.map { item => 
        DBSecurityGroup.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSnapshotAttributesRequest(dbSnapshotIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest = {
      import DescribeDbSnapshotAttributesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest.builder().dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String).build()
    }
    def asReadOnly: DescribeDbSnapshotAttributesRequest.ReadOnly = DescribeDbSnapshotAttributesRequest.wrap(buildAwsValue())
  }
  object DescribeDbSnapshotAttributesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSnapshotAttributesRequest = DescribeDbSnapshotAttributesRequest(dbSnapshotIdentifierValue)
      def dbSnapshotIdentifierValue: String
      def dbSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbSnapshotIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest) extends DescribeDbSnapshotAttributesRequest.ReadOnly { override def dbSnapshotIdentifierValue: String = impl.dbSnapshotIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSnapshotAttributesResponse(dbSnapshotAttributesResult: scala.Option[DBSnapshotAttributesResult] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse = {
      import DescribeDbSnapshotAttributesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse.builder().optionallyWith(dbSnapshotAttributesResult.map(value => value.buildAwsValue()))(_.dbSnapshotAttributesResult).build()
    }
    def asReadOnly: DescribeDbSnapshotAttributesResponse.ReadOnly = DescribeDbSnapshotAttributesResponse.wrap(buildAwsValue())
  }
  object DescribeDbSnapshotAttributesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSnapshotAttributesResponse = DescribeDbSnapshotAttributesResponse(dbSnapshotAttributesResultValue.map(value => value.editable))
      def dbSnapshotAttributesResultValue: scala.Option[DBSnapshotAttributesResult.ReadOnly]
      def dbSnapshotAttributesResult: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshotAttributesResult.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotAttributesResult", dbSnapshotAttributesResultValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse) extends DescribeDbSnapshotAttributesResponse.ReadOnly { override def dbSnapshotAttributesResultValue: scala.Option[DBSnapshotAttributesResult.ReadOnly] = scala.Option(impl.dbSnapshotAttributesResult()).map(value => DBSnapshotAttributesResult.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSnapshotsRequest(dbInstanceIdentifier: scala.Option[String] = None, dbSnapshotIdentifier: scala.Option[String] = None, snapshotType: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, includeShared: scala.Option[Boolean] = None, includePublic: scala.Option[Boolean] = None, dbiResourceId: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest = {
      import DescribeDbSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest.builder().optionallyWith(dbInstanceIdentifier.map(value => value: java.lang.String))(_.dbInstanceIdentifier).optionallyWith(dbSnapshotIdentifier.map(value => value: java.lang.String))(_.dbSnapshotIdentifier).optionallyWith(snapshotType.map(value => value: java.lang.String))(_.snapshotType).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(includeShared.map(value => value: java.lang.Boolean))(_.includeShared).optionallyWith(includePublic.map(value => value: java.lang.Boolean))(_.includePublic).optionallyWith(dbiResourceId.map(value => value: java.lang.String))(_.dbiResourceId).build()
    }
    def asReadOnly: DescribeDbSnapshotsRequest.ReadOnly = DescribeDbSnapshotsRequest.wrap(buildAwsValue())
  }
  object DescribeDbSnapshotsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSnapshotsRequest = DescribeDbSnapshotsRequest(dbInstanceIdentifierValue.map(value => value), dbSnapshotIdentifierValue.map(value => value), snapshotTypeValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value), includeSharedValue.map(value => value), includePublicValue.map(value => value), dbiResourceIdValue.map(value => value))
      def dbInstanceIdentifierValue: scala.Option[String]
      def dbSnapshotIdentifierValue: scala.Option[String]
      def snapshotTypeValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def includeSharedValue: scala.Option[Boolean]
      def includePublicValue: scala.Option[Boolean]
      def dbiResourceIdValue: scala.Option[String]
      def dbInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifierValue)
      def dbSnapshotIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotIdentifier", dbSnapshotIdentifierValue)
      def snapshotType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotType", snapshotTypeValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def includeShared: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includeShared", includeSharedValue)
      def includePublic: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("includePublic", includePublicValue)
      def dbiResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbiResourceId", dbiResourceIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest) extends DescribeDbSnapshotsRequest.ReadOnly {
      override def dbInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.dbInstanceIdentifier()).map(value => value: String)
      override def dbSnapshotIdentifierValue: scala.Option[String] = scala.Option(impl.dbSnapshotIdentifier()).map(value => value: String)
      override def snapshotTypeValue: scala.Option[String] = scala.Option(impl.snapshotType()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def includeSharedValue: scala.Option[Boolean] = scala.Option(impl.includeShared()).map(value => value: Boolean)
      override def includePublicValue: scala.Option[Boolean] = scala.Option(impl.includePublic()).map(value => value: Boolean)
      override def dbiResourceIdValue: scala.Option[String] = scala.Option(impl.dbiResourceId()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSnapshotsResponse(marker: scala.Option[String] = None, dbSnapshots: scala.Option[Iterable[DBSnapshot]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse = {
      import DescribeDbSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbSnapshots.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbSnapshots).build()
    }
    def asReadOnly: DescribeDbSnapshotsResponse.ReadOnly = DescribeDbSnapshotsResponse.wrap(buildAwsValue())
  }
  object DescribeDbSnapshotsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSnapshotsResponse = DescribeDbSnapshotsResponse(markerValue.map(value => value), dbSnapshotsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbSnapshotsValue: scala.Option[List[DBSnapshot.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbSnapshots: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSnapshot.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshots", dbSnapshotsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse) extends DescribeDbSnapshotsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbSnapshotsValue: scala.Option[List[DBSnapshot.ReadOnly]] = scala.Option(impl.dbSnapshots()).map(value => value.asScala.map { item => 
        DBSnapshot.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSubnetGroupsRequest(dbSubnetGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest = {
      import DescribeDbSubnetGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest.builder().optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeDbSubnetGroupsRequest.ReadOnly = DescribeDbSubnetGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeDbSubnetGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSubnetGroupsRequest = DescribeDbSubnetGroupsRequest(dbSubnetGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbSubnetGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest) extends DescribeDbSubnetGroupsRequest.ReadOnly {
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeDbSubnetGroupsResponse(marker: scala.Option[String] = None, dbSubnetGroups: scala.Option[Iterable[DBSubnetGroup]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse = {
      import DescribeDbSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(dbSubnetGroups.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.dbSubnetGroups).build()
    }
    def asReadOnly: DescribeDbSubnetGroupsResponse.ReadOnly = DescribeDbSubnetGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeDbSubnetGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeDbSubnetGroupsResponse = DescribeDbSubnetGroupsResponse(markerValue.map(value => value), dbSubnetGroupsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def dbSubnetGroupsValue: scala.Option[List[DBSubnetGroup.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def dbSubnetGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[DBSubnetGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroups", dbSubnetGroupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse) extends DescribeDbSubnetGroupsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def dbSubnetGroupsValue: scala.Option[List[DBSubnetGroup.ReadOnly]] = scala.Option(impl.dbSubnetGroups()).map(value => value.asScala.map { item => 
        DBSubnetGroup.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEngineDefaultClusterParametersRequest(dbParameterGroupFamily: String, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest = {
      import DescribeEngineDefaultClusterParametersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest.builder().dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeEngineDefaultClusterParametersRequest.ReadOnly = DescribeEngineDefaultClusterParametersRequest.wrap(buildAwsValue())
  }
  object DescribeEngineDefaultClusterParametersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEngineDefaultClusterParametersRequest = DescribeEngineDefaultClusterParametersRequest(dbParameterGroupFamilyValue, filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbParameterGroupFamilyValue: String
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest) extends DescribeEngineDefaultClusterParametersRequest.ReadOnly {
      override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEngineDefaultClusterParametersResponse(engineDefaults: scala.Option[EngineDefaults] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse = {
      import DescribeEngineDefaultClusterParametersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse.builder().optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(_.engineDefaults).build()
    }
    def asReadOnly: DescribeEngineDefaultClusterParametersResponse.ReadOnly = DescribeEngineDefaultClusterParametersResponse.wrap(buildAwsValue())
  }
  object DescribeEngineDefaultClusterParametersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEngineDefaultClusterParametersResponse = DescribeEngineDefaultClusterParametersResponse(engineDefaultsValue.map(value => value.editable))
      def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly]
      def engineDefaults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EngineDefaults.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineDefaults", engineDefaultsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse) extends DescribeEngineDefaultClusterParametersResponse.ReadOnly { override def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly] = scala.Option(impl.engineDefaults()).map(value => EngineDefaults.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEngineDefaultParametersRequest(dbParameterGroupFamily: String, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest = {
      import DescribeEngineDefaultParametersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest.builder().dbParameterGroupFamily(dbParameterGroupFamily: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeEngineDefaultParametersRequest.ReadOnly = DescribeEngineDefaultParametersRequest.wrap(buildAwsValue())
  }
  object DescribeEngineDefaultParametersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEngineDefaultParametersRequest = DescribeEngineDefaultParametersRequest(dbParameterGroupFamilyValue, filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def dbParameterGroupFamilyValue: String
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def dbParameterGroupFamily: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupFamilyValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest) extends DescribeEngineDefaultParametersRequest.ReadOnly {
      override def dbParameterGroupFamilyValue: String = impl.dbParameterGroupFamily(): String
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEngineDefaultParametersResponse(engineDefaults: scala.Option[EngineDefaults] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse = {
      import DescribeEngineDefaultParametersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse.builder().optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(_.engineDefaults).build()
    }
    def asReadOnly: DescribeEngineDefaultParametersResponse.ReadOnly = DescribeEngineDefaultParametersResponse.wrap(buildAwsValue())
  }
  object DescribeEngineDefaultParametersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEngineDefaultParametersResponse = DescribeEngineDefaultParametersResponse(engineDefaultsValue.map(value => value.editable))
      def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly]
      def engineDefaults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EngineDefaults.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineDefaults", engineDefaultsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse) extends DescribeEngineDefaultParametersResponse.ReadOnly { override def engineDefaultsValue: scala.Option[EngineDefaults.ReadOnly] = scala.Option(impl.engineDefaults()).map(value => EngineDefaults.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventCategoriesRequest(sourceType: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest = {
      import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest.builder().optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).build()
    }
    def asReadOnly: DescribeEventCategoriesRequest.ReadOnly = DescribeEventCategoriesRequest.wrap(buildAwsValue())
  }
  object DescribeEventCategoriesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventCategoriesRequest = DescribeEventCategoriesRequest(sourceTypeValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }))
      def sourceTypeValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest) extends DescribeEventCategoriesRequest.ReadOnly {
      override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventCategoriesResponse(eventCategoriesMapList: scala.Option[Iterable[EventCategoriesMap]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse = {
      import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse.builder().optionallyWith(eventCategoriesMapList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.eventCategoriesMapList).build()
    }
    def asReadOnly: DescribeEventCategoriesResponse.ReadOnly = DescribeEventCategoriesResponse.wrap(buildAwsValue())
  }
  object DescribeEventCategoriesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventCategoriesResponse = DescribeEventCategoriesResponse(eventCategoriesMapListValue.map(value => value.map { item => 
        item.editable
      }))
      def eventCategoriesMapListValue: scala.Option[List[EventCategoriesMap.ReadOnly]]
      def eventCategoriesMapList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EventCategoriesMap.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategoriesMapList", eventCategoriesMapListValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse) extends DescribeEventCategoriesResponse.ReadOnly {
      override def eventCategoriesMapListValue: scala.Option[List[EventCategoriesMap.ReadOnly]] = scala.Option(impl.eventCategoriesMapList()).map(value => value.asScala.map { item => 
        EventCategoriesMap.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventSubscriptionsRequest(subscriptionName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest = {
      import DescribeEventSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest.builder().optionallyWith(subscriptionName.map(value => value: java.lang.String))(_.subscriptionName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeEventSubscriptionsRequest.ReadOnly = DescribeEventSubscriptionsRequest.wrap(buildAwsValue())
  }
  object DescribeEventSubscriptionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventSubscriptionsRequest = DescribeEventSubscriptionsRequest(subscriptionNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def subscriptionNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def subscriptionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionName", subscriptionNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest) extends DescribeEventSubscriptionsRequest.ReadOnly {
      override def subscriptionNameValue: scala.Option[String] = scala.Option(impl.subscriptionName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventSubscriptionsResponse(marker: scala.Option[String] = None, eventSubscriptionsList: scala.Option[Iterable[EventSubscription]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse = {
      import DescribeEventSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(eventSubscriptionsList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.eventSubscriptionsList).build()
    }
    def asReadOnly: DescribeEventSubscriptionsResponse.ReadOnly = DescribeEventSubscriptionsResponse.wrap(buildAwsValue())
  }
  object DescribeEventSubscriptionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventSubscriptionsResponse = DescribeEventSubscriptionsResponse(markerValue.map(value => value), eventSubscriptionsListValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def eventSubscriptionsListValue: scala.Option[List[EventSubscription.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def eventSubscriptionsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[EventSubscription.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscriptionsList", eventSubscriptionsListValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse) extends DescribeEventSubscriptionsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def eventSubscriptionsListValue: scala.Option[List[EventSubscription.ReadOnly]] = scala.Option(impl.eventSubscriptionsList()).map(value => value.asScala.map { item => 
        EventSubscription.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventsRequest(sourceIdentifier: scala.Option[String] = None, sourceType: scala.Option[SourceType] = None, startTime: scala.Option[primitives.TStamp] = None, endTime: scala.Option[primitives.TStamp] = None, duration: scala.Option[primitives.IntegerOptional] = None, eventCategories: scala.Option[Iterable[String]] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventsRequest = {
      import DescribeEventsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventsRequest.builder().optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(_.sourceIdentifier).optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType).optionallyWith(startTime.map(value => value: java.time.Instant))(_.startTime).optionallyWith(endTime.map(value => value: java.time.Instant))(_.endTime).optionallyWith(duration.map(value => value: java.lang.Integer))(_.duration).optionallyWith(eventCategories.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategories).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeEventsRequest.ReadOnly = DescribeEventsRequest.wrap(buildAwsValue())
  }
  object DescribeEventsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventsRequest = DescribeEventsRequest(sourceIdentifierValue.map(value => value), sourceTypeValue.map(value => value), startTimeValue.map(value => value), endTimeValue.map(value => value), durationValue.map(value => value), eventCategoriesValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def sourceIdentifierValue: scala.Option[String]
      def sourceTypeValue: scala.Option[SourceType]
      def startTimeValue: scala.Option[primitives.TStamp]
      def endTimeValue: scala.Option[primitives.TStamp]
      def durationValue: scala.Option[primitives.IntegerOptional]
      def eventCategoriesValue: scala.Option[List[String]]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def sourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifierValue)
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def startTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("startTime", startTimeValue)
      def endTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endTime", endTimeValue)
      def duration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("duration", durationValue)
      def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventsRequest) extends DescribeEventsRequest.ReadOnly {
      override def sourceIdentifierValue: scala.Option[String] = scala.Option(impl.sourceIdentifier()).map(value => value: String)
      override def sourceTypeValue: scala.Option[SourceType] = scala.Option(impl.sourceType()).map(value => SourceType.wrap(value))
      override def startTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.startTime()).map(value => value: primitives.TStamp)
      override def endTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.endTime()).map(value => value: primitives.TStamp)
      override def durationValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.duration()).map(value => value: primitives.IntegerOptional)
      override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeEventsResponse(marker: scala.Option[String] = None, events: scala.Option[Iterable[Event]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeEventsResponse = {
      import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeEventsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(events.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.events).build()
    }
    def asReadOnly: DescribeEventsResponse.ReadOnly = DescribeEventsResponse.wrap(buildAwsValue())
  }
  object DescribeEventsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeEventsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeEventsResponse = DescribeEventsResponse(markerValue.map(value => value), eventsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def eventsValue: scala.Option[List[Event.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def events: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Event.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("events", eventsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeEventsResponse) extends DescribeEventsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def eventsValue: scala.Option[List[Event.ReadOnly]] = scala.Option(impl.events()).map(value => value.asScala.map { item => 
        Event.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeEventsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeExportTasksRequest(exportTaskIdentifier: scala.Option[String] = None, sourceArn: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.MaxRecords] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest = {
      import DescribeExportTasksRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest.builder().optionallyWith(exportTaskIdentifier.map(value => value: java.lang.String))(_.exportTaskIdentifier).optionallyWith(sourceArn.map(value => value: java.lang.String))(_.sourceArn).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribeExportTasksRequest.ReadOnly = DescribeExportTasksRequest.wrap(buildAwsValue())
  }
  object DescribeExportTasksRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeExportTasksRequest = DescribeExportTasksRequest(exportTaskIdentifierValue.map(value => value), sourceArnValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def exportTaskIdentifierValue: scala.Option[String]
      def sourceArnValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.MaxRecords]
      def exportTaskIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifierValue)
      def sourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceArn", sourceArnValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxRecords] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest) extends DescribeExportTasksRequest.ReadOnly {
      override def exportTaskIdentifierValue: scala.Option[String] = scala.Option(impl.exportTaskIdentifier()).map(value => value: String)
      override def sourceArnValue: scala.Option[String] = scala.Option(impl.sourceArn()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.MaxRecords] = scala.Option(impl.maxRecords()).map(value => value: primitives.MaxRecords)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeExportTasksResponse(marker: scala.Option[String] = None, exportTasks: scala.Option[Iterable[ExportTask]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse = {
      import DescribeExportTasksResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(exportTasks.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.exportTasks).build()
    }
    def asReadOnly: DescribeExportTasksResponse.ReadOnly = DescribeExportTasksResponse.wrap(buildAwsValue())
  }
  object DescribeExportTasksResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeExportTasksResponse = DescribeExportTasksResponse(markerValue.map(value => value), exportTasksValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def exportTasksValue: scala.Option[List[ExportTask.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def exportTasks: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ExportTask.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportTasks", exportTasksValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse) extends DescribeExportTasksResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def exportTasksValue: scala.Option[List[ExportTask.ReadOnly]] = scala.Option(impl.exportTasks()).map(value => value.asScala.map { item => 
        ExportTask.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeExportTasksResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeGlobalClustersRequest(globalClusterIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest = {
      import DescribeGlobalClustersRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeGlobalClustersRequest.ReadOnly = DescribeGlobalClustersRequest.wrap(buildAwsValue())
  }
  object DescribeGlobalClustersRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeGlobalClustersRequest = DescribeGlobalClustersRequest(globalClusterIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def globalClusterIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest) extends DescribeGlobalClustersRequest.ReadOnly {
      override def globalClusterIdentifierValue: scala.Option[String] = scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeGlobalClustersResponse(marker: scala.Option[String] = None, globalClusters: scala.Option[Iterable[GlobalCluster]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse = {
      import DescribeGlobalClustersResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(globalClusters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.globalClusters).build()
    }
    def asReadOnly: DescribeGlobalClustersResponse.ReadOnly = DescribeGlobalClustersResponse.wrap(buildAwsValue())
  }
  object DescribeGlobalClustersResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeGlobalClustersResponse = DescribeGlobalClustersResponse(markerValue.map(value => value), globalClustersValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def globalClustersValue: scala.Option[List[GlobalCluster.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def globalClusters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GlobalCluster.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusters", globalClustersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse) extends DescribeGlobalClustersResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def globalClustersValue: scala.Option[List[GlobalCluster.ReadOnly]] = scala.Option(impl.globalClusters()).map(value => value.asScala.map { item => 
        GlobalCluster.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeGlobalClustersResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeInstallationMediaRequest(installationMediaId: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest = {
      import DescribeInstallationMediaRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest.builder().optionallyWith(installationMediaId.map(value => value: java.lang.String))(_.installationMediaId).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeInstallationMediaRequest.ReadOnly = DescribeInstallationMediaRequest.wrap(buildAwsValue())
  }
  object DescribeInstallationMediaRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeInstallationMediaRequest = DescribeInstallationMediaRequest(installationMediaIdValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def installationMediaIdValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def installationMediaId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("installationMediaId", installationMediaIdValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest) extends DescribeInstallationMediaRequest.ReadOnly {
      override def installationMediaIdValue: scala.Option[String] = scala.Option(impl.installationMediaId()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeInstallationMediaResponse(marker: scala.Option[String] = None, installationMedia: scala.Option[Iterable[InstallationMedia]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse = {
      import DescribeInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(installationMedia.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.installationMedia).build()
    }
    def asReadOnly: DescribeInstallationMediaResponse.ReadOnly = DescribeInstallationMediaResponse.wrap(buildAwsValue())
  }
  object DescribeInstallationMediaResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeInstallationMediaResponse = DescribeInstallationMediaResponse(markerValue.map(value => value), installationMediaValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def installationMediaValue: scala.Option[List[InstallationMedia.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def installationMedia: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[InstallationMedia.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("installationMedia", installationMediaValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse) extends DescribeInstallationMediaResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def installationMediaValue: scala.Option[List[InstallationMedia.ReadOnly]] = scala.Option(impl.installationMedia()).map(value => value.asScala.map { item => 
        InstallationMedia.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeInstallationMediaResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOptionGroupOptionsRequest(engineName: String, majorEngineVersion: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest = {
      import DescribeOptionGroupOptionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest.builder().engineName(engineName: java.lang.String).optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(_.majorEngineVersion).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeOptionGroupOptionsRequest.ReadOnly = DescribeOptionGroupOptionsRequest.wrap(buildAwsValue())
  }
  object DescribeOptionGroupOptionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOptionGroupOptionsRequest = DescribeOptionGroupOptionsRequest(engineNameValue, majorEngineVersionValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def engineNameValue: String
      def majorEngineVersionValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def engineName: ZIO[Any, Nothing, String] = ZIO.succeed(engineNameValue)
      def majorEngineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersionValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest) extends DescribeOptionGroupOptionsRequest.ReadOnly {
      override def engineNameValue: String = impl.engineName(): String
      override def majorEngineVersionValue: scala.Option[String] = scala.Option(impl.majorEngineVersion()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOptionGroupOptionsResponse(optionGroupOptions: scala.Option[Iterable[OptionGroupOption]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse = {
      import DescribeOptionGroupOptionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse.builder().optionallyWith(optionGroupOptions.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.optionGroupOptions).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeOptionGroupOptionsResponse.ReadOnly = DescribeOptionGroupOptionsResponse.wrap(buildAwsValue())
  }
  object DescribeOptionGroupOptionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOptionGroupOptionsResponse = DescribeOptionGroupOptionsResponse(optionGroupOptionsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def optionGroupOptionsValue: scala.Option[List[OptionGroupOption.ReadOnly]]
      def markerValue: scala.Option[String]
      def optionGroupOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OptionGroupOption.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupOptions", optionGroupOptionsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse) extends DescribeOptionGroupOptionsResponse.ReadOnly {
      override def optionGroupOptionsValue: scala.Option[List[OptionGroupOption.ReadOnly]] = scala.Option(impl.optionGroupOptions()).map(value => value.asScala.map { item => 
        OptionGroupOption.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOptionGroupsRequest(optionGroupName: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, engineName: scala.Option[String] = None, majorEngineVersion: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest = {
      import DescribeOptionGroupsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest.builder().optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(engineName.map(value => value: java.lang.String))(_.engineName).optionallyWith(majorEngineVersion.map(value => value: java.lang.String))(_.majorEngineVersion).build()
    }
    def asReadOnly: DescribeOptionGroupsRequest.ReadOnly = DescribeOptionGroupsRequest.wrap(buildAwsValue())
  }
  object DescribeOptionGroupsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOptionGroupsRequest = DescribeOptionGroupsRequest(optionGroupNameValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value), engineNameValue.map(value => value), majorEngineVersionValue.map(value => value))
      def optionGroupNameValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def engineNameValue: scala.Option[String]
      def majorEngineVersionValue: scala.Option[String]
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def engineName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineName", engineNameValue)
      def majorEngineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("majorEngineVersion", majorEngineVersionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest) extends DescribeOptionGroupsRequest.ReadOnly {
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def engineNameValue: scala.Option[String] = scala.Option(impl.engineName()).map(value => value: String)
      override def majorEngineVersionValue: scala.Option[String] = scala.Option(impl.majorEngineVersion()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOptionGroupsResponse(optionGroupsList: scala.Option[Iterable[OptionGroup]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse = {
      import DescribeOptionGroupsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse.builder().optionallyWith(optionGroupsList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.optionGroupsList).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeOptionGroupsResponse.ReadOnly = DescribeOptionGroupsResponse.wrap(buildAwsValue())
  }
  object DescribeOptionGroupsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOptionGroupsResponse = DescribeOptionGroupsResponse(optionGroupsListValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def optionGroupsListValue: scala.Option[List[OptionGroup.ReadOnly]]
      def markerValue: scala.Option[String]
      def optionGroupsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OptionGroup.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupsList", optionGroupsListValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse) extends DescribeOptionGroupsResponse.ReadOnly {
      override def optionGroupsListValue: scala.Option[List[OptionGroup.ReadOnly]] = scala.Option(impl.optionGroupsList()).map(value => value.asScala.map { item => 
        OptionGroup.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOrderableDbInstanceOptionsRequest(engine: String, engineVersion: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, licenseModel: scala.Option[String] = None, availabilityZoneGroup: scala.Option[String] = None, vpc: scala.Option[primitives.BooleanOptional] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest = {
      import DescribeOrderableDbInstanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest.builder().engine(engine: java.lang.String).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(availabilityZoneGroup.map(value => value: java.lang.String))(_.availabilityZoneGroup).optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeOrderableDbInstanceOptionsRequest.ReadOnly = DescribeOrderableDbInstanceOptionsRequest.wrap(buildAwsValue())
  }
  object DescribeOrderableDbInstanceOptionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOrderableDbInstanceOptionsRequest = DescribeOrderableDbInstanceOptionsRequest(engineValue, engineVersionValue.map(value => value), dbInstanceClassValue.map(value => value), licenseModelValue.map(value => value), availabilityZoneGroupValue.map(value => value), vpcValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def engineValue: String
      def engineVersionValue: scala.Option[String]
      def dbInstanceClassValue: scala.Option[String]
      def licenseModelValue: scala.Option[String]
      def availabilityZoneGroupValue: scala.Option[String]
      def vpcValue: scala.Option[primitives.BooleanOptional]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def availabilityZoneGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("availabilityZoneGroup", availabilityZoneGroupValue)
      def vpc: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpc", vpcValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest) extends DescribeOrderableDbInstanceOptionsRequest.ReadOnly {
      override def engineValue: String = impl.engine(): String
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def availabilityZoneGroupValue: scala.Option[String] = scala.Option(impl.availabilityZoneGroup()).map(value => value: String)
      override def vpcValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.vpc()).map(value => value: primitives.BooleanOptional)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeOrderableDbInstanceOptionsResponse(orderableDBInstanceOptions: scala.Option[Iterable[OrderableDBInstanceOption]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse = {
      import DescribeOrderableDbInstanceOptionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse.builder().optionallyWith(orderableDBInstanceOptions.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.orderableDBInstanceOptions).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeOrderableDbInstanceOptionsResponse.ReadOnly = DescribeOrderableDbInstanceOptionsResponse.wrap(buildAwsValue())
  }
  object DescribeOrderableDbInstanceOptionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeOrderableDbInstanceOptionsResponse = DescribeOrderableDbInstanceOptionsResponse(orderableDBInstanceOptionsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def orderableDBInstanceOptionsValue: scala.Option[List[OrderableDBInstanceOption.ReadOnly]]
      def markerValue: scala.Option[String]
      def orderableDBInstanceOptions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[OrderableDBInstanceOption.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("orderableDBInstanceOptions", orderableDBInstanceOptionsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse) extends DescribeOrderableDbInstanceOptionsResponse.ReadOnly {
      override def orderableDBInstanceOptionsValue: scala.Option[List[OrderableDBInstanceOption.ReadOnly]] = scala.Option(impl.orderableDBInstanceOptions()).map(value => value.asScala.map { item => 
        OrderableDBInstanceOption.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribePendingMaintenanceActionsRequest(resourceIdentifier: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, marker: scala.Option[String] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest = {
      import DescribePendingMaintenanceActionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest.builder().optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(_.resourceIdentifier).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).build()
    }
    def asReadOnly: DescribePendingMaintenanceActionsRequest.ReadOnly = DescribePendingMaintenanceActionsRequest.wrap(buildAwsValue())
  }
  object DescribePendingMaintenanceActionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribePendingMaintenanceActionsRequest = DescribePendingMaintenanceActionsRequest(resourceIdentifierValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value), maxRecordsValue.map(value => value))
      def resourceIdentifierValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def markerValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def resourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifierValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest) extends DescribePendingMaintenanceActionsRequest.ReadOnly {
      override def resourceIdentifierValue: scala.Option[String] = scala.Option(impl.resourceIdentifier()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribePendingMaintenanceActionsResponse(pendingMaintenanceActions: scala.Option[Iterable[ResourcePendingMaintenanceActions]] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse = {
      import DescribePendingMaintenanceActionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse.builder().optionallyWith(pendingMaintenanceActions.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.pendingMaintenanceActions).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribePendingMaintenanceActionsResponse.ReadOnly = DescribePendingMaintenanceActionsResponse.wrap(buildAwsValue())
  }
  object DescribePendingMaintenanceActionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribePendingMaintenanceActionsResponse = DescribePendingMaintenanceActionsResponse(pendingMaintenanceActionsValue.map(value => value.map { item => 
        item.editable
      }), markerValue.map(value => value))
      def pendingMaintenanceActionsValue: scala.Option[List[ResourcePendingMaintenanceActions.ReadOnly]]
      def markerValue: scala.Option[String]
      def pendingMaintenanceActions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ResourcePendingMaintenanceActions.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingMaintenanceActions", pendingMaintenanceActionsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse) extends DescribePendingMaintenanceActionsResponse.ReadOnly {
      override def pendingMaintenanceActionsValue: scala.Option[List[ResourcePendingMaintenanceActions.ReadOnly]] = scala.Option(impl.pendingMaintenanceActions()).map(value => value.asScala.map { item => 
        ResourcePendingMaintenanceActions.wrap(item)
      }.toList)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeReservedDbInstancesOfferingsRequest(reservedDBInstancesOfferingId: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, duration: scala.Option[String] = None, productDescription: scala.Option[String] = None, offeringType: scala.Option[String] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest = {
      import DescribeReservedDbInstancesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest.builder().optionallyWith(reservedDBInstancesOfferingId.map(value => value: java.lang.String))(_.reservedDBInstancesOfferingId).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(duration.map(value => value: java.lang.String))(_.duration).optionallyWith(productDescription.map(value => value: java.lang.String))(_.productDescription).optionallyWith(offeringType.map(value => value: java.lang.String))(_.offeringType).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeReservedDbInstancesOfferingsRequest.ReadOnly = DescribeReservedDbInstancesOfferingsRequest.wrap(buildAwsValue())
  }
  object DescribeReservedDbInstancesOfferingsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeReservedDbInstancesOfferingsRequest = DescribeReservedDbInstancesOfferingsRequest(reservedDBInstancesOfferingIdValue.map(value => value), dbInstanceClassValue.map(value => value), durationValue.map(value => value), productDescriptionValue.map(value => value), offeringTypeValue.map(value => value), multiAZValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def reservedDBInstancesOfferingIdValue: scala.Option[String]
      def dbInstanceClassValue: scala.Option[String]
      def durationValue: scala.Option[String]
      def productDescriptionValue: scala.Option[String]
      def offeringTypeValue: scala.Option[String]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def reservedDBInstancesOfferingId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedDBInstancesOfferingId", reservedDBInstancesOfferingIdValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def duration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("duration", durationValue)
      def productDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productDescription", productDescriptionValue)
      def offeringType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringType", offeringTypeValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest) extends DescribeReservedDbInstancesOfferingsRequest.ReadOnly {
      override def reservedDBInstancesOfferingIdValue: scala.Option[String] = scala.Option(impl.reservedDBInstancesOfferingId()).map(value => value: String)
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def durationValue: scala.Option[String] = scala.Option(impl.duration()).map(value => value: String)
      override def productDescriptionValue: scala.Option[String] = scala.Option(impl.productDescription()).map(value => value: String)
      override def offeringTypeValue: scala.Option[String] = scala.Option(impl.offeringType()).map(value => value: String)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeReservedDbInstancesOfferingsResponse(marker: scala.Option[String] = None, reservedDBInstancesOfferings: scala.Option[Iterable[ReservedDBInstancesOffering]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse = {
      import DescribeReservedDbInstancesOfferingsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(reservedDBInstancesOfferings.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.reservedDBInstancesOfferings).build()
    }
    def asReadOnly: DescribeReservedDbInstancesOfferingsResponse.ReadOnly = DescribeReservedDbInstancesOfferingsResponse.wrap(buildAwsValue())
  }
  object DescribeReservedDbInstancesOfferingsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeReservedDbInstancesOfferingsResponse = DescribeReservedDbInstancesOfferingsResponse(markerValue.map(value => value), reservedDBInstancesOfferingsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def reservedDBInstancesOfferingsValue: scala.Option[List[ReservedDBInstancesOffering.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def reservedDBInstancesOfferings: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservedDBInstancesOffering.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedDBInstancesOfferings", reservedDBInstancesOfferingsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse) extends DescribeReservedDbInstancesOfferingsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def reservedDBInstancesOfferingsValue: scala.Option[List[ReservedDBInstancesOffering.ReadOnly]] = scala.Option(impl.reservedDBInstancesOfferings()).map(value => value.asScala.map { item => 
        ReservedDBInstancesOffering.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeReservedDbInstancesRequest(reservedDBInstanceId: scala.Option[String] = None, reservedDBInstancesOfferingId: scala.Option[String] = None, dbInstanceClass: scala.Option[String] = None, duration: scala.Option[String] = None, productDescription: scala.Option[String] = None, offeringType: scala.Option[String] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, leaseId: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest = {
      import DescribeReservedDbInstancesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest.builder().optionallyWith(reservedDBInstanceId.map(value => value: java.lang.String))(_.reservedDBInstanceId).optionallyWith(reservedDBInstancesOfferingId.map(value => value: java.lang.String))(_.reservedDBInstancesOfferingId).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(duration.map(value => value: java.lang.String))(_.duration).optionallyWith(productDescription.map(value => value: java.lang.String))(_.productDescription).optionallyWith(offeringType.map(value => value: java.lang.String))(_.offeringType).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(leaseId.map(value => value: java.lang.String))(_.leaseId).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).build()
    }
    def asReadOnly: DescribeReservedDbInstancesRequest.ReadOnly = DescribeReservedDbInstancesRequest.wrap(buildAwsValue())
  }
  object DescribeReservedDbInstancesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeReservedDbInstancesRequest = DescribeReservedDbInstancesRequest(reservedDBInstanceIdValue.map(value => value), reservedDBInstancesOfferingIdValue.map(value => value), dbInstanceClassValue.map(value => value), durationValue.map(value => value), productDescriptionValue.map(value => value), offeringTypeValue.map(value => value), multiAZValue.map(value => value), leaseIdValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }), maxRecordsValue.map(value => value), markerValue.map(value => value))
      def reservedDBInstanceIdValue: scala.Option[String]
      def reservedDBInstancesOfferingIdValue: scala.Option[String]
      def dbInstanceClassValue: scala.Option[String]
      def durationValue: scala.Option[String]
      def productDescriptionValue: scala.Option[String]
      def offeringTypeValue: scala.Option[String]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def leaseIdValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def reservedDBInstanceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedDBInstanceId", reservedDBInstanceIdValue)
      def reservedDBInstancesOfferingId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedDBInstancesOfferingId", reservedDBInstancesOfferingIdValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def duration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("duration", durationValue)
      def productDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("productDescription", productDescriptionValue)
      def offeringType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("offeringType", offeringTypeValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def leaseId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("leaseId", leaseIdValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest) extends DescribeReservedDbInstancesRequest.ReadOnly {
      override def reservedDBInstanceIdValue: scala.Option[String] = scala.Option(impl.reservedDBInstanceId()).map(value => value: String)
      override def reservedDBInstancesOfferingIdValue: scala.Option[String] = scala.Option(impl.reservedDBInstancesOfferingId()).map(value => value: String)
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def durationValue: scala.Option[String] = scala.Option(impl.duration()).map(value => value: String)
      override def productDescriptionValue: scala.Option[String] = scala.Option(impl.productDescription()).map(value => value: String)
      override def offeringTypeValue: scala.Option[String] = scala.Option(impl.offeringType()).map(value => value: String)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def leaseIdValue: scala.Option[String] = scala.Option(impl.leaseId()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeReservedDbInstancesResponse(marker: scala.Option[String] = None, reservedDBInstances: scala.Option[Iterable[ReservedDBInstance]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse = {
      import DescribeReservedDbInstancesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(reservedDBInstances.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.reservedDBInstances).build()
    }
    def asReadOnly: DescribeReservedDbInstancesResponse.ReadOnly = DescribeReservedDbInstancesResponse.wrap(buildAwsValue())
  }
  object DescribeReservedDbInstancesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeReservedDbInstancesResponse = DescribeReservedDbInstancesResponse(markerValue.map(value => value), reservedDBInstancesValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def reservedDBInstancesValue: scala.Option[List[ReservedDBInstance.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def reservedDBInstances: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ReservedDBInstance.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("reservedDBInstances", reservedDBInstancesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse) extends DescribeReservedDbInstancesResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def reservedDBInstancesValue: scala.Option[List[ReservedDBInstance.ReadOnly]] = scala.Option(impl.reservedDBInstances()).map(value => value.asScala.map { item => 
        ReservedDBInstance.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeSourceRegionsRequest(regionName: scala.Option[String] = None, maxRecords: scala.Option[primitives.IntegerOptional] = None, marker: scala.Option[String] = None, filters: scala.Option[Iterable[Filter]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest = {
      import DescribeSourceRegionsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest.builder().optionallyWith(regionName.map(value => value: java.lang.String))(_.regionName).optionallyWith(maxRecords.map(value => value: java.lang.Integer))(_.maxRecords).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).build()
    }
    def asReadOnly: DescribeSourceRegionsRequest.ReadOnly = DescribeSourceRegionsRequest.wrap(buildAwsValue())
  }
  object DescribeSourceRegionsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeSourceRegionsRequest = DescribeSourceRegionsRequest(regionNameValue.map(value => value), maxRecordsValue.map(value => value), markerValue.map(value => value), filtersValue.map(value => value.map { item => 
        item.editable
      }))
      def regionNameValue: scala.Option[String]
      def maxRecordsValue: scala.Option[primitives.IntegerOptional]
      def markerValue: scala.Option[String]
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def regionName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("regionName", regionNameValue)
      def maxRecords: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxRecords", maxRecordsValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest) extends DescribeSourceRegionsRequest.ReadOnly {
      override def regionNameValue: scala.Option[String] = scala.Option(impl.regionName()).map(value => value: String)
      override def maxRecordsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxRecords()).map(value => value: primitives.IntegerOptional)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeSourceRegionsResponse(marker: scala.Option[String] = None, sourceRegions: scala.Option[Iterable[SourceRegion]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse = {
      import DescribeSourceRegionsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse.builder().optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(sourceRegions.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.sourceRegions).build()
    }
    def asReadOnly: DescribeSourceRegionsResponse.ReadOnly = DescribeSourceRegionsResponse.wrap(buildAwsValue())
  }
  object DescribeSourceRegionsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeSourceRegionsResponse = DescribeSourceRegionsResponse(markerValue.map(value => value), sourceRegionsValue.map(value => value.map { item => 
        item.editable
      }))
      def markerValue: scala.Option[String]
      def sourceRegionsValue: scala.Option[List[SourceRegion.ReadOnly]]
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def sourceRegions: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[SourceRegion.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceRegions", sourceRegionsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse) extends DescribeSourceRegionsResponse.ReadOnly {
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def sourceRegionsValue: scala.Option[List[SourceRegion.ReadOnly]] = scala.Option(impl.sourceRegions()).map(value => value.asScala.map { item => 
        SourceRegion.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeSourceRegionsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DescribeValidDbInstanceModificationsRequest(dbInstanceIdentifier: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest = {
      import DescribeValidDbInstanceModificationsRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).build()
    }
    def asReadOnly: DescribeValidDbInstanceModificationsRequest.ReadOnly = DescribeValidDbInstanceModificationsRequest.wrap(buildAwsValue())
  }
  object DescribeValidDbInstanceModificationsRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeValidDbInstanceModificationsRequest = DescribeValidDbInstanceModificationsRequest(dbInstanceIdentifierValue)
      def dbInstanceIdentifierValue: String
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest) extends DescribeValidDbInstanceModificationsRequest.ReadOnly { override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest): ReadOnly = new Wrapper(impl)
  }
  case class DescribeValidDbInstanceModificationsResponse(validDBInstanceModificationsMessage: scala.Option[ValidDBInstanceModificationsMessage] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse = {
      import DescribeValidDbInstanceModificationsResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse.builder().optionallyWith(validDBInstanceModificationsMessage.map(value => value.buildAwsValue()))(_.validDBInstanceModificationsMessage).build()
    }
    def asReadOnly: DescribeValidDbInstanceModificationsResponse.ReadOnly = DescribeValidDbInstanceModificationsResponse.wrap(buildAwsValue())
  }
  object DescribeValidDbInstanceModificationsResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DescribeValidDbInstanceModificationsResponse = DescribeValidDbInstanceModificationsResponse(validDBInstanceModificationsMessageValue.map(value => value.editable))
      def validDBInstanceModificationsMessageValue: scala.Option[ValidDBInstanceModificationsMessage.ReadOnly]
      def validDBInstanceModificationsMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ValidDBInstanceModificationsMessage.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("validDBInstanceModificationsMessage", validDBInstanceModificationsMessageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse) extends DescribeValidDbInstanceModificationsResponse.ReadOnly { override def validDBInstanceModificationsMessageValue: scala.Option[ValidDBInstanceModificationsMessage.ReadOnly] = scala.Option(impl.validDBInstanceModificationsMessage()).map(value => ValidDBInstanceModificationsMessage.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse): ReadOnly = new Wrapper(impl)
  }
  case class DomainMembership(domain: scala.Option[String] = None, status: scala.Option[String] = None, fqdn: scala.Option[String] = None, iamRoleName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DomainMembership = {
      import DomainMembership.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DomainMembership.builder().optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(fqdn.map(value => value: java.lang.String))(_.fqdn).optionallyWith(iamRoleName.map(value => value: java.lang.String))(_.iamRoleName).build()
    }
    def asReadOnly: DomainMembership.ReadOnly = DomainMembership.wrap(buildAwsValue())
  }
  object DomainMembership {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DomainMembership] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DomainMembership = DomainMembership(domainValue.map(value => value), statusValue.map(value => value), fqdnValue.map(value => value), iamRoleNameValue.map(value => value))
      def domainValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def fqdnValue: scala.Option[String]
      def iamRoleNameValue: scala.Option[String]
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def fqdn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fqdn", fqdnValue)
      def iamRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamRoleName", iamRoleNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DomainMembership) extends DomainMembership.ReadOnly {
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def fqdnValue: scala.Option[String] = scala.Option(impl.fqdn()).map(value => value: String)
      override def iamRoleNameValue: scala.Option[String] = scala.Option(impl.iamRoleName()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DomainMembership): ReadOnly = new Wrapper(impl)
  }
  type DomainMembershipList = List[DomainMembership]
  case class DoubleRange(from: scala.Option[Double] = None, to: scala.Option[Double] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DoubleRange = {
      import DoubleRange.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DoubleRange.builder().optionallyWith(from.map(value => value: java.lang.Double))(_.from).optionallyWith(to.map(value => value: java.lang.Double))(_.to).build()
    }
    def asReadOnly: DoubleRange.ReadOnly = DoubleRange.wrap(buildAwsValue())
  }
  object DoubleRange {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DoubleRange] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DoubleRange = DoubleRange(fromValue.map(value => value), toValue.map(value => value))
      def fromValue: scala.Option[Double]
      def toValue: scala.Option[Double]
      def from: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("from", fromValue)
      def to: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Double] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("to", toValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DoubleRange) extends DoubleRange.ReadOnly {
      override def fromValue: scala.Option[Double] = scala.Option(impl.from()).map(value => value: Double)
      override def toValue: scala.Option[Double] = scala.Option(impl.to()).map(value => value: Double)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DoubleRange): ReadOnly = new Wrapper(impl)
  }
  type DoubleRangeList = List[DoubleRange]
  case class DownloadDbLogFilePortionRequest(dbInstanceIdentifier: String, logFileName: String, marker: scala.Option[String] = None, numberOfLines: scala.Option[primitives.Integer] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest = {
      import DownloadDbLogFilePortionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).logFileName(logFileName: java.lang.String).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(numberOfLines.map(value => value: java.lang.Integer))(_.numberOfLines).build()
    }
    def asReadOnly: DownloadDbLogFilePortionRequest.ReadOnly = DownloadDbLogFilePortionRequest.wrap(buildAwsValue())
  }
  object DownloadDbLogFilePortionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DownloadDbLogFilePortionRequest = DownloadDbLogFilePortionRequest(dbInstanceIdentifierValue, logFileNameValue, markerValue.map(value => value), numberOfLinesValue.map(value => value))
      def dbInstanceIdentifierValue: String
      def logFileNameValue: String
      def markerValue: scala.Option[String]
      def numberOfLinesValue: scala.Option[primitives.Integer]
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def logFileName: ZIO[Any, Nothing, String] = ZIO.succeed(logFileNameValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def numberOfLines: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("numberOfLines", numberOfLinesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest) extends DownloadDbLogFilePortionRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def logFileNameValue: String = impl.logFileName(): String
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def numberOfLinesValue: scala.Option[primitives.Integer] = scala.Option(impl.numberOfLines()).map(value => value: primitives.Integer)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest): ReadOnly = new Wrapper(impl)
  }
  case class DownloadDbLogFilePortionResponse(logFileData: scala.Option[String] = None, marker: scala.Option[String] = None, additionalDataPending: scala.Option[Boolean] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse = {
      import DownloadDbLogFilePortionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse.builder().optionallyWith(logFileData.map(value => value: java.lang.String))(_.logFileData).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(additionalDataPending.map(value => value: java.lang.Boolean))(_.additionalDataPending).build()
    }
    def asReadOnly: DownloadDbLogFilePortionResponse.ReadOnly = DownloadDbLogFilePortionResponse.wrap(buildAwsValue())
  }
  object DownloadDbLogFilePortionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: DownloadDbLogFilePortionResponse = DownloadDbLogFilePortionResponse(logFileDataValue.map(value => value), markerValue.map(value => value), additionalDataPendingValue.map(value => value))
      def logFileDataValue: scala.Option[String]
      def markerValue: scala.Option[String]
      def additionalDataPendingValue: scala.Option[Boolean]
      def logFileData: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("logFileData", logFileDataValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def additionalDataPending: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("additionalDataPending", additionalDataPendingValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse) extends DownloadDbLogFilePortionResponse.ReadOnly {
      override def logFileDataValue: scala.Option[String] = scala.Option(impl.logFileData()).map(value => value: String)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def additionalDataPendingValue: scala.Option[Boolean] = scala.Option(impl.additionalDataPending()).map(value => value: Boolean)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse): ReadOnly = new Wrapper(impl)
  }
  case class EC2SecurityGroup(status: scala.Option[String] = None, ec2SecurityGroupName: scala.Option[String] = None, ec2SecurityGroupId: scala.Option[String] = None, ec2SecurityGroupOwnerId: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.EC2SecurityGroup = {
      import EC2SecurityGroup.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.EC2SecurityGroup.builder().optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(ec2SecurityGroupName.map(value => value: java.lang.String))(_.ec2SecurityGroupName).optionallyWith(ec2SecurityGroupId.map(value => value: java.lang.String))(_.ec2SecurityGroupId).optionallyWith(ec2SecurityGroupOwnerId.map(value => value: java.lang.String))(_.ec2SecurityGroupOwnerId).build()
    }
    def asReadOnly: EC2SecurityGroup.ReadOnly = EC2SecurityGroup.wrap(buildAwsValue())
  }
  object EC2SecurityGroup {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.EC2SecurityGroup] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: EC2SecurityGroup = EC2SecurityGroup(statusValue.map(value => value), ec2SecurityGroupNameValue.map(value => value), ec2SecurityGroupIdValue.map(value => value), ec2SecurityGroupOwnerIdValue.map(value => value))
      def statusValue: scala.Option[String]
      def ec2SecurityGroupNameValue: scala.Option[String]
      def ec2SecurityGroupIdValue: scala.Option[String]
      def ec2SecurityGroupOwnerIdValue: scala.Option[String]
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def ec2SecurityGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupName", ec2SecurityGroupNameValue)
      def ec2SecurityGroupId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupId", ec2SecurityGroupIdValue)
      def ec2SecurityGroupOwnerId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.EC2SecurityGroup) extends EC2SecurityGroup.ReadOnly {
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def ec2SecurityGroupNameValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupName()).map(value => value: String)
      override def ec2SecurityGroupIdValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupId()).map(value => value: String)
      override def ec2SecurityGroupOwnerIdValue: scala.Option[String] = scala.Option(impl.ec2SecurityGroupOwnerId()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.EC2SecurityGroup): ReadOnly = new Wrapper(impl)
  }
  type EC2SecurityGroupList = List[EC2SecurityGroup]
  case class Endpoint(address: scala.Option[String] = None, port: scala.Option[primitives.Integer] = None, hostedZoneId: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.Endpoint = {
      import Endpoint.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.Endpoint.builder().optionallyWith(address.map(value => value: java.lang.String))(_.address).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(hostedZoneId.map(value => value: java.lang.String))(_.hostedZoneId).build()
    }
    def asReadOnly: Endpoint.ReadOnly = Endpoint.wrap(buildAwsValue())
  }
  object Endpoint {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.Endpoint] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Endpoint = Endpoint(addressValue.map(value => value), portValue.map(value => value), hostedZoneIdValue.map(value => value))
      def addressValue: scala.Option[String]
      def portValue: scala.Option[primitives.Integer]
      def hostedZoneIdValue: scala.Option[String]
      def address: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("address", addressValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def hostedZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("hostedZoneId", hostedZoneIdValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.Endpoint) extends Endpoint.ReadOnly {
      override def addressValue: scala.Option[String] = scala.Option(impl.address()).map(value => value: String)
      override def portValue: scala.Option[primitives.Integer] = scala.Option(impl.port()).map(value => value: primitives.Integer)
      override def hostedZoneIdValue: scala.Option[String] = scala.Option(impl.hostedZoneId()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.Endpoint): ReadOnly = new Wrapper(impl)
  }
  case class EngineDefaults(dbParameterGroupFamily: scala.Option[String] = None, marker: scala.Option[String] = None, parameters: scala.Option[Iterable[Parameter]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.EngineDefaults = {
      import EngineDefaults.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.EngineDefaults.builder().optionallyWith(dbParameterGroupFamily.map(value => value: java.lang.String))(_.dbParameterGroupFamily).optionallyWith(marker.map(value => value: java.lang.String))(_.marker).optionallyWith(parameters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.parameters).build()
    }
    def asReadOnly: EngineDefaults.ReadOnly = EngineDefaults.wrap(buildAwsValue())
  }
  object EngineDefaults {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.EngineDefaults] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: EngineDefaults = EngineDefaults(dbParameterGroupFamilyValue.map(value => value), markerValue.map(value => value), parametersValue.map(value => value.map { item => 
        item.editable
      }))
      def dbParameterGroupFamilyValue: scala.Option[String]
      def markerValue: scala.Option[String]
      def parametersValue: scala.Option[List[Parameter.ReadOnly]]
      def dbParameterGroupFamily: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamilyValue)
      def marker: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("marker", markerValue)
      def parameters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Parameter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("parameters", parametersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.EngineDefaults) extends EngineDefaults.ReadOnly {
      override def dbParameterGroupFamilyValue: scala.Option[String] = scala.Option(impl.dbParameterGroupFamily()).map(value => value: String)
      override def markerValue: scala.Option[String] = scala.Option(impl.marker()).map(value => value: String)
      override def parametersValue: scala.Option[List[Parameter.ReadOnly]] = scala.Option(impl.parameters()).map(value => value.asScala.map { item => 
        Parameter.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.EngineDefaults): ReadOnly = new Wrapper(impl)
  }
  sealed trait EngineFamily { def unwrap: software.amazon.awssdk.services.rds.model.EngineFamily }
  object EngineFamily {
    def wrap(value: software.amazon.awssdk.services.rds.model.EngineFamily): EngineFamily = value match {
      case software.amazon.awssdk.services.rds.model.EngineFamily.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.EngineFamily.MYSQL => MYSQL
      case software.amazon.awssdk.services.rds.model.EngineFamily.POSTGRESQL => POSTGRESQL
    }
    final case object unknownToSdkVersion extends EngineFamily { override def unwrap: software.amazon.awssdk.services.rds.model.EngineFamily = software.amazon.awssdk.services.rds.model.EngineFamily.UNKNOWN_TO_SDK_VERSION }
    final case object MYSQL extends EngineFamily { override def unwrap: software.amazon.awssdk.services.rds.model.EngineFamily = software.amazon.awssdk.services.rds.model.EngineFamily.MYSQL }
    final case object POSTGRESQL extends EngineFamily { override def unwrap: software.amazon.awssdk.services.rds.model.EngineFamily = software.amazon.awssdk.services.rds.model.EngineFamily.POSTGRESQL }
  }
  type EngineModeList = List[String]
  case class Event(sourceIdentifier: scala.Option[String] = None, sourceType: scala.Option[SourceType] = None, message: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, date: scala.Option[primitives.TStamp] = None, sourceArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.Event = {
      import Event.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.Event.builder().optionallyWith(sourceIdentifier.map(value => value: java.lang.String))(_.sourceIdentifier).optionallyWith(sourceType.map(value => value.unwrap))(_.sourceType).optionallyWith(message.map(value => value: java.lang.String))(_.message).optionallyWith(eventCategories.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategories).optionallyWith(date.map(value => value: java.time.Instant))(_.date).optionallyWith(sourceArn.map(value => value: java.lang.String))(_.sourceArn).build()
    }
    def asReadOnly: Event.ReadOnly = Event.wrap(buildAwsValue())
  }
  object Event {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.Event] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Event = Event(sourceIdentifierValue.map(value => value), sourceTypeValue.map(value => value), messageValue.map(value => value), eventCategoriesValue.map(value => value), dateValue.map(value => value), sourceArnValue.map(value => value))
      def sourceIdentifierValue: scala.Option[String]
      def sourceTypeValue: scala.Option[SourceType]
      def messageValue: scala.Option[String]
      def eventCategoriesValue: scala.Option[List[String]]
      def dateValue: scala.Option[primitives.TStamp]
      def sourceArnValue: scala.Option[String]
      def sourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifierValue)
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, SourceType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
      def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
      def date: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("date", dateValue)
      def sourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceArn", sourceArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.Event) extends Event.ReadOnly {
      override def sourceIdentifierValue: scala.Option[String] = scala.Option(impl.sourceIdentifier()).map(value => value: String)
      override def sourceTypeValue: scala.Option[SourceType] = scala.Option(impl.sourceType()).map(value => SourceType.wrap(value))
      override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String)
      override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dateValue: scala.Option[primitives.TStamp] = scala.Option(impl.date()).map(value => value: primitives.TStamp)
      override def sourceArnValue: scala.Option[String] = scala.Option(impl.sourceArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.Event): ReadOnly = new Wrapper(impl)
  }
  type EventCategoriesList = List[String]
  case class EventCategoriesMap(sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.EventCategoriesMap = {
      import EventCategoriesMap.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.EventCategoriesMap.builder().optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategories).build()
    }
    def asReadOnly: EventCategoriesMap.ReadOnly = EventCategoriesMap.wrap(buildAwsValue())
  }
  object EventCategoriesMap {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.EventCategoriesMap] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: EventCategoriesMap = EventCategoriesMap(sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value))
      def sourceTypeValue: scala.Option[String]
      def eventCategoriesValue: scala.Option[List[String]]
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.EventCategoriesMap) extends EventCategoriesMap.ReadOnly {
      override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
      override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.EventCategoriesMap): ReadOnly = new Wrapper(impl)
  }
  type EventCategoriesMapList = List[EventCategoriesMap]
  type EventList = List[Event]
  case class EventSubscription(customerAwsId: scala.Option[String] = None, custSubscriptionId: scala.Option[String] = None, snsTopicArn: scala.Option[String] = None, status: scala.Option[String] = None, subscriptionCreationTime: scala.Option[String] = None, sourceType: scala.Option[String] = None, sourceIdsList: scala.Option[Iterable[String]] = None, eventCategoriesList: scala.Option[Iterable[String]] = None, enabled: scala.Option[Boolean] = None, eventSubscriptionArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.EventSubscription = {
      import EventSubscription.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.EventSubscription.builder().optionallyWith(customerAwsId.map(value => value: java.lang.String))(_.customerAwsId).optionallyWith(custSubscriptionId.map(value => value: java.lang.String))(_.custSubscriptionId).optionallyWith(snsTopicArn.map(value => value: java.lang.String))(_.snsTopicArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(subscriptionCreationTime.map(value => value: java.lang.String))(_.subscriptionCreationTime).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(sourceIdsList.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.sourceIdsList).optionallyWith(eventCategoriesList.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategoriesList).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).optionallyWith(eventSubscriptionArn.map(value => value: java.lang.String))(_.eventSubscriptionArn).build()
    }
    def asReadOnly: EventSubscription.ReadOnly = EventSubscription.wrap(buildAwsValue())
  }
  object EventSubscription {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.EventSubscription] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: EventSubscription = EventSubscription(customerAwsIdValue.map(value => value), custSubscriptionIdValue.map(value => value), snsTopicArnValue.map(value => value), statusValue.map(value => value), subscriptionCreationTimeValue.map(value => value), sourceTypeValue.map(value => value), sourceIdsListValue.map(value => value), eventCategoriesListValue.map(value => value), enabledValue.map(value => value), eventSubscriptionArnValue.map(value => value))
      def customerAwsIdValue: scala.Option[String]
      def custSubscriptionIdValue: scala.Option[String]
      def snsTopicArnValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def subscriptionCreationTimeValue: scala.Option[String]
      def sourceTypeValue: scala.Option[String]
      def sourceIdsListValue: scala.Option[List[String]]
      def eventCategoriesListValue: scala.Option[List[String]]
      def enabledValue: scala.Option[Boolean]
      def eventSubscriptionArnValue: scala.Option[String]
      def customerAwsId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customerAwsId", customerAwsIdValue)
      def custSubscriptionId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("custSubscriptionId", custSubscriptionIdValue)
      def snsTopicArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def subscriptionCreationTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("subscriptionCreationTime", subscriptionCreationTimeValue)
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def sourceIdsList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceIdsList", sourceIdsListValue)
      def eventCategoriesList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategoriesList", eventCategoriesListValue)
      def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
      def eventSubscriptionArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscriptionArn", eventSubscriptionArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.EventSubscription) extends EventSubscription.ReadOnly {
      override def customerAwsIdValue: scala.Option[String] = scala.Option(impl.customerAwsId()).map(value => value: String)
      override def custSubscriptionIdValue: scala.Option[String] = scala.Option(impl.custSubscriptionId()).map(value => value: String)
      override def snsTopicArnValue: scala.Option[String] = scala.Option(impl.snsTopicArn()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def subscriptionCreationTimeValue: scala.Option[String] = scala.Option(impl.subscriptionCreationTime()).map(value => value: String)
      override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
      override def sourceIdsListValue: scala.Option[List[String]] = scala.Option(impl.sourceIdsList()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def eventCategoriesListValue: scala.Option[List[String]] = scala.Option(impl.eventCategoriesList()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def enabledValue: scala.Option[Boolean] = scala.Option(impl.enabled()).map(value => value: Boolean)
      override def eventSubscriptionArnValue: scala.Option[String] = scala.Option(impl.eventSubscriptionArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.EventSubscription): ReadOnly = new Wrapper(impl)
  }
  type EventSubscriptionsList = List[EventSubscription]
  case class ExportTask(exportTaskIdentifier: scala.Option[String] = None, sourceArn: scala.Option[String] = None, exportOnly: scala.Option[Iterable[String]] = None, snapshotTime: scala.Option[primitives.TStamp] = None, taskStartTime: scala.Option[primitives.TStamp] = None, taskEndTime: scala.Option[primitives.TStamp] = None, s3Bucket: scala.Option[String] = None, s3Prefix: scala.Option[String] = None, iamRoleArn: scala.Option[String] = None, kmsKeyId: scala.Option[String] = None, status: scala.Option[String] = None, percentProgress: scala.Option[primitives.Integer] = None, totalExtractedDataInGB: scala.Option[primitives.Integer] = None, failureCause: scala.Option[String] = None, warningMessage: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ExportTask = {
      import ExportTask.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ExportTask.builder().optionallyWith(exportTaskIdentifier.map(value => value: java.lang.String))(_.exportTaskIdentifier).optionallyWith(sourceArn.map(value => value: java.lang.String))(_.sourceArn).optionallyWith(exportOnly.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.exportOnly).optionallyWith(snapshotTime.map(value => value: java.time.Instant))(_.snapshotTime).optionallyWith(taskStartTime.map(value => value: java.time.Instant))(_.taskStartTime).optionallyWith(taskEndTime.map(value => value: java.time.Instant))(_.taskEndTime).optionallyWith(s3Bucket.map(value => value: java.lang.String))(_.s3Bucket).optionallyWith(s3Prefix.map(value => value: java.lang.String))(_.s3Prefix).optionallyWith(iamRoleArn.map(value => value: java.lang.String))(_.iamRoleArn).optionallyWith(kmsKeyId.map(value => value: java.lang.String))(_.kmsKeyId).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(percentProgress.map(value => value: java.lang.Integer))(_.percentProgress).optionallyWith(totalExtractedDataInGB.map(value => value: java.lang.Integer))(_.totalExtractedDataInGB).optionallyWith(failureCause.map(value => value: java.lang.String))(_.failureCause).optionallyWith(warningMessage.map(value => value: java.lang.String))(_.warningMessage).build()
    }
    def asReadOnly: ExportTask.ReadOnly = ExportTask.wrap(buildAwsValue())
  }
  object ExportTask {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ExportTask] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ExportTask = ExportTask(exportTaskIdentifierValue.map(value => value), sourceArnValue.map(value => value), exportOnlyValue.map(value => value), snapshotTimeValue.map(value => value), taskStartTimeValue.map(value => value), taskEndTimeValue.map(value => value), s3BucketValue.map(value => value), s3PrefixValue.map(value => value), iamRoleArnValue.map(value => value), kmsKeyIdValue.map(value => value), statusValue.map(value => value), percentProgressValue.map(value => value), totalExtractedDataInGBValue.map(value => value), failureCauseValue.map(value => value), warningMessageValue.map(value => value))
      def exportTaskIdentifierValue: scala.Option[String]
      def sourceArnValue: scala.Option[String]
      def exportOnlyValue: scala.Option[List[String]]
      def snapshotTimeValue: scala.Option[primitives.TStamp]
      def taskStartTimeValue: scala.Option[primitives.TStamp]
      def taskEndTimeValue: scala.Option[primitives.TStamp]
      def s3BucketValue: scala.Option[String]
      def s3PrefixValue: scala.Option[String]
      def iamRoleArnValue: scala.Option[String]
      def kmsKeyIdValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def percentProgressValue: scala.Option[primitives.Integer]
      def totalExtractedDataInGBValue: scala.Option[primitives.Integer]
      def failureCauseValue: scala.Option[String]
      def warningMessageValue: scala.Option[String]
      def exportTaskIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportTaskIdentifier", exportTaskIdentifierValue)
      def sourceArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceArn", sourceArnValue)
      def exportOnly: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("exportOnly", exportOnlyValue)
      def snapshotTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snapshotTime", snapshotTimeValue)
      def taskStartTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("taskStartTime", taskStartTimeValue)
      def taskEndTime: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.TStamp] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("taskEndTime", taskEndTimeValue)
      def s3Bucket: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Bucket", s3BucketValue)
      def s3Prefix: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("s3Prefix", s3PrefixValue)
      def iamRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iamRoleArn", iamRoleArnValue)
      def kmsKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("kmsKeyId", kmsKeyIdValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def percentProgress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("percentProgress", percentProgressValue)
      def totalExtractedDataInGB: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.Integer] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("totalExtractedDataInGB", totalExtractedDataInGBValue)
      def failureCause: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureCause", failureCauseValue)
      def warningMessage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("warningMessage", warningMessageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ExportTask) extends ExportTask.ReadOnly {
      override def exportTaskIdentifierValue: scala.Option[String] = scala.Option(impl.exportTaskIdentifier()).map(value => value: String)
      override def sourceArnValue: scala.Option[String] = scala.Option(impl.sourceArn()).map(value => value: String)
      override def exportOnlyValue: scala.Option[List[String]] = scala.Option(impl.exportOnly()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def snapshotTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.snapshotTime()).map(value => value: primitives.TStamp)
      override def taskStartTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.taskStartTime()).map(value => value: primitives.TStamp)
      override def taskEndTimeValue: scala.Option[primitives.TStamp] = scala.Option(impl.taskEndTime()).map(value => value: primitives.TStamp)
      override def s3BucketValue: scala.Option[String] = scala.Option(impl.s3Bucket()).map(value => value: String)
      override def s3PrefixValue: scala.Option[String] = scala.Option(impl.s3Prefix()).map(value => value: String)
      override def iamRoleArnValue: scala.Option[String] = scala.Option(impl.iamRoleArn()).map(value => value: String)
      override def kmsKeyIdValue: scala.Option[String] = scala.Option(impl.kmsKeyId()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def percentProgressValue: scala.Option[primitives.Integer] = scala.Option(impl.percentProgress()).map(value => value: primitives.Integer)
      override def totalExtractedDataInGBValue: scala.Option[primitives.Integer] = scala.Option(impl.totalExtractedDataInGB()).map(value => value: primitives.Integer)
      override def failureCauseValue: scala.Option[String] = scala.Option(impl.failureCause()).map(value => value: String)
      override def warningMessageValue: scala.Option[String] = scala.Option(impl.warningMessage()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ExportTask): ReadOnly = new Wrapper(impl)
  }
  type ExportTasksList = List[ExportTask]
  case class FailoverDbClusterRequest(dbClusterIdentifier: String, targetDBInstanceIdentifier: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest = {
      import FailoverDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(targetDBInstanceIdentifier.map(value => value: java.lang.String))(_.targetDBInstanceIdentifier).build()
    }
    def asReadOnly: FailoverDbClusterRequest.ReadOnly = FailoverDbClusterRequest.wrap(buildAwsValue())
  }
  object FailoverDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: FailoverDbClusterRequest = FailoverDbClusterRequest(dbClusterIdentifierValue, targetDBInstanceIdentifierValue.map(value => value))
      def dbClusterIdentifierValue: String
      def targetDBInstanceIdentifierValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def targetDBInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("targetDBInstanceIdentifier", targetDBInstanceIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest) extends FailoverDbClusterRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def targetDBInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.targetDBInstanceIdentifier()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class FailoverDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse = {
      import FailoverDbClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
    }
    def asReadOnly: FailoverDbClusterResponse.ReadOnly = FailoverDbClusterResponse.wrap(buildAwsValue())
  }
  object FailoverDbClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: FailoverDbClusterResponse = FailoverDbClusterResponse(dbClusterValue.map(value => value.editable))
      def dbClusterValue: scala.Option[DBCluster.ReadOnly]
      def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse) extends FailoverDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class FailoverGlobalClusterRequest(globalClusterIdentifier: primitives.GlobalClusterIdentifier, targetDbClusterIdentifier: primitives.DBClusterIdentifier) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest = {
      import FailoverGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest.builder().globalClusterIdentifier(globalClusterIdentifier: java.lang.String).targetDbClusterIdentifier(targetDbClusterIdentifier: java.lang.String).build()
    }
    def asReadOnly: FailoverGlobalClusterRequest.ReadOnly = FailoverGlobalClusterRequest.wrap(buildAwsValue())
  }
  object FailoverGlobalClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: FailoverGlobalClusterRequest = FailoverGlobalClusterRequest(globalClusterIdentifierValue, targetDbClusterIdentifierValue)
      def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier
      def targetDbClusterIdentifierValue: primitives.DBClusterIdentifier
      def globalClusterIdentifier: ZIO[Any, Nothing, primitives.GlobalClusterIdentifier] = ZIO.succeed(globalClusterIdentifierValue)
      def targetDbClusterIdentifier: ZIO[Any, Nothing, primitives.DBClusterIdentifier] = ZIO.succeed(targetDbClusterIdentifierValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest) extends FailoverGlobalClusterRequest.ReadOnly {
      override def globalClusterIdentifierValue: primitives.GlobalClusterIdentifier = impl.globalClusterIdentifier(): primitives.GlobalClusterIdentifier
      override def targetDbClusterIdentifierValue: primitives.DBClusterIdentifier = impl.targetDbClusterIdentifier(): primitives.DBClusterIdentifier
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class FailoverGlobalClusterResponse(globalCluster: scala.Option[GlobalCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse = {
      import FailoverGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse.builder().optionallyWith(globalCluster.map(value => value.buildAwsValue()))(_.globalCluster).build()
    }
    def asReadOnly: FailoverGlobalClusterResponse.ReadOnly = FailoverGlobalClusterResponse.wrap(buildAwsValue())
  }
  object FailoverGlobalClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: FailoverGlobalClusterResponse = FailoverGlobalClusterResponse(globalClusterValue.map(value => value.editable))
      def globalClusterValue: scala.Option[GlobalCluster.ReadOnly]
      def globalCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, GlobalCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalCluster", globalClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse) extends FailoverGlobalClusterResponse.ReadOnly { override def globalClusterValue: scala.Option[GlobalCluster.ReadOnly] = scala.Option(impl.globalCluster()).map(value => GlobalCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class FailoverState(status: scala.Option[FailoverStatus] = None, fromDbClusterArn: scala.Option[String] = None, toDbClusterArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.FailoverState = {
      import FailoverState.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.FailoverState.builder().optionallyWith(status.map(value => value.unwrap))(_.status).optionallyWith(fromDbClusterArn.map(value => value: java.lang.String))(_.fromDbClusterArn).optionallyWith(toDbClusterArn.map(value => value: java.lang.String))(_.toDbClusterArn).build()
    }
    def asReadOnly: FailoverState.ReadOnly = FailoverState.wrap(buildAwsValue())
  }
  object FailoverState {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.FailoverState] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: FailoverState = FailoverState(statusValue.map(value => value), fromDbClusterArnValue.map(value => value), toDbClusterArnValue.map(value => value))
      def statusValue: scala.Option[FailoverStatus]
      def fromDbClusterArnValue: scala.Option[String]
      def toDbClusterArnValue: scala.Option[String]
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, FailoverStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def fromDbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("fromDbClusterArn", fromDbClusterArnValue)
      def toDbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("toDbClusterArn", toDbClusterArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.FailoverState) extends FailoverState.ReadOnly {
      override def statusValue: scala.Option[FailoverStatus] = scala.Option(impl.status()).map(value => FailoverStatus.wrap(value))
      override def fromDbClusterArnValue: scala.Option[String] = scala.Option(impl.fromDbClusterArn()).map(value => value: String)
      override def toDbClusterArnValue: scala.Option[String] = scala.Option(impl.toDbClusterArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.FailoverState): ReadOnly = new Wrapper(impl)
  }
  sealed trait FailoverStatus { def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus }
  object FailoverStatus {
    def wrap(value: software.amazon.awssdk.services.rds.model.FailoverStatus): FailoverStatus = value match {
      case software.amazon.awssdk.services.rds.model.FailoverStatus.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.FailoverStatus.PENDING => pending
      case software.amazon.awssdk.services.rds.model.FailoverStatus.FAILING_OVER => `failing-over`
      case software.amazon.awssdk.services.rds.model.FailoverStatus.CANCELLING => cancelling
    }
    final case object unknownToSdkVersion extends FailoverStatus { override def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus = software.amazon.awssdk.services.rds.model.FailoverStatus.UNKNOWN_TO_SDK_VERSION }
    final case object pending extends FailoverStatus { override def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus = software.amazon.awssdk.services.rds.model.FailoverStatus.PENDING }
    final case object `failing-over` extends FailoverStatus { override def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus = software.amazon.awssdk.services.rds.model.FailoverStatus.FAILING_OVER }
    final case object cancelling extends FailoverStatus { override def unwrap: software.amazon.awssdk.services.rds.model.FailoverStatus = software.amazon.awssdk.services.rds.model.FailoverStatus.CANCELLING }
  }
  type FeatureNameList = List[String]
  case class Filter(name: String, values: Iterable[String]) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.Filter = {
      import Filter.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.Filter.builder().name(name: java.lang.String).values(values.map { item => 
        item: java.lang.String
      }.asJavaCollection).build()
    }
    def asReadOnly: Filter.ReadOnly = Filter.wrap(buildAwsValue())
  }
  object Filter {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.Filter] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: Filter = Filter(nameValue, valuesValue)
      def nameValue: String
      def valuesValue: List[String]
      def name: ZIO[Any, Nothing, String] = ZIO.succeed(nameValue)
      def values: ZIO[Any, Nothing, List[String]] = ZIO.succeed(valuesValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.Filter) extends Filter.ReadOnly {
      override def nameValue: String = impl.name(): String
      override def valuesValue: List[String] = impl.values().asScala.map { item => 
        item: String
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.Filter): ReadOnly = new Wrapper(impl)
  }
  type FilterList = List[Filter]
  type FilterValueList = List[String]
  case class GlobalCluster(globalClusterIdentifier: scala.Option[String] = None, globalClusterResourceId: scala.Option[String] = None, globalClusterArn: scala.Option[String] = None, status: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, databaseName: scala.Option[String] = None, storageEncrypted: scala.Option[primitives.BooleanOptional] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, globalClusterMembers: scala.Option[Iterable[GlobalClusterMember]] = None, failoverState: scala.Option[FailoverState] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.GlobalCluster = {
      import GlobalCluster.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.GlobalCluster.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(globalClusterResourceId.map(value => value: java.lang.String))(_.globalClusterResourceId).optionallyWith(globalClusterArn.map(value => value: java.lang.String))(_.globalClusterArn).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(databaseName.map(value => value: java.lang.String))(_.databaseName).optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(_.storageEncrypted).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(globalClusterMembers.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.globalClusterMembers).optionallyWith(failoverState.map(value => value.buildAwsValue()))(_.failoverState).build()
    }
    def asReadOnly: GlobalCluster.ReadOnly = GlobalCluster.wrap(buildAwsValue())
  }
  object GlobalCluster {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.GlobalCluster] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: GlobalCluster = GlobalCluster(globalClusterIdentifierValue.map(value => value), globalClusterResourceIdValue.map(value => value), globalClusterArnValue.map(value => value), statusValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), databaseNameValue.map(value => value), storageEncryptedValue.map(value => value), deletionProtectionValue.map(value => value), globalClusterMembersValue.map(value => value.map { item => 
        item.editable
      }), failoverStateValue.map(value => value.editable))
      def globalClusterIdentifierValue: scala.Option[String]
      def globalClusterResourceIdValue: scala.Option[String]
      def globalClusterArnValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def databaseNameValue: scala.Option[String]
      def storageEncryptedValue: scala.Option[primitives.BooleanOptional]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def globalClusterMembersValue: scala.Option[List[GlobalClusterMember.ReadOnly]]
      def failoverStateValue: scala.Option[FailoverState.ReadOnly]
      def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
      def globalClusterResourceId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterResourceId", globalClusterResourceIdValue)
      def globalClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterArn", globalClusterArnValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def databaseName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("databaseName", databaseNameValue)
      def storageEncrypted: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageEncrypted", storageEncryptedValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def globalClusterMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[GlobalClusterMember.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembersValue)
      def failoverState: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, FailoverState.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failoverState", failoverStateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.GlobalCluster) extends GlobalCluster.ReadOnly {
      override def globalClusterIdentifierValue: scala.Option[String] = scala.Option(impl.globalClusterIdentifier()).map(value => value: String)
      override def globalClusterResourceIdValue: scala.Option[String] = scala.Option(impl.globalClusterResourceId()).map(value => value: String)
      override def globalClusterArnValue: scala.Option[String] = scala.Option(impl.globalClusterArn()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def databaseNameValue: scala.Option[String] = scala.Option(impl.databaseName()).map(value => value: String)
      override def storageEncryptedValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.storageEncrypted()).map(value => value: primitives.BooleanOptional)
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def globalClusterMembersValue: scala.Option[List[GlobalClusterMember.ReadOnly]] = scala.Option(impl.globalClusterMembers()).map(value => value.asScala.map { item => 
        GlobalClusterMember.wrap(item)
      }.toList)
      override def failoverStateValue: scala.Option[FailoverState.ReadOnly] = scala.Option(impl.failoverState()).map(value => FailoverState.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.GlobalCluster): ReadOnly = new Wrapper(impl)
  }
  type GlobalClusterList = List[GlobalCluster]
  case class GlobalClusterMember(dbClusterArn: scala.Option[String] = None, readers: scala.Option[Iterable[String]] = None, isWriter: scala.Option[Boolean] = None, globalWriteForwardingStatus: scala.Option[WriteForwardingStatus] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.GlobalClusterMember = {
      import GlobalClusterMember.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.GlobalClusterMember.builder().optionallyWith(dbClusterArn.map(value => value: java.lang.String))(_.dbClusterArn).optionallyWith(readers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.readers).optionallyWith(isWriter.map(value => value: java.lang.Boolean))(_.isWriter).optionallyWith(globalWriteForwardingStatus.map(value => value.unwrap))(_.globalWriteForwardingStatus).build()
    }
    def asReadOnly: GlobalClusterMember.ReadOnly = GlobalClusterMember.wrap(buildAwsValue())
  }
  object GlobalClusterMember {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.GlobalClusterMember] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: GlobalClusterMember = GlobalClusterMember(dbClusterArnValue.map(value => value), readersValue.map(value => value), isWriterValue.map(value => value), globalWriteForwardingStatusValue.map(value => value))
      def dbClusterArnValue: scala.Option[String]
      def readersValue: scala.Option[List[String]]
      def isWriterValue: scala.Option[Boolean]
      def globalWriteForwardingStatusValue: scala.Option[WriteForwardingStatus]
      def dbClusterArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterArn", dbClusterArnValue)
      def readers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("readers", readersValue)
      def isWriter: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("isWriter", isWriterValue)
      def globalWriteForwardingStatus: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, WriteForwardingStatus] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalWriteForwardingStatus", globalWriteForwardingStatusValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.GlobalClusterMember) extends GlobalClusterMember.ReadOnly {
      override def dbClusterArnValue: scala.Option[String] = scala.Option(impl.dbClusterArn()).map(value => value: String)
      override def readersValue: scala.Option[List[String]] = scala.Option(impl.readers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def isWriterValue: scala.Option[Boolean] = scala.Option(impl.isWriter()).map(value => value: Boolean)
      override def globalWriteForwardingStatusValue: scala.Option[WriteForwardingStatus] = scala.Option(impl.globalWriteForwardingStatus()).map(value => WriteForwardingStatus.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.GlobalClusterMember): ReadOnly = new Wrapper(impl)
  }
  type GlobalClusterMemberList = List[GlobalClusterMember]
  sealed trait IAMAuthMode { def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode }
  object IAMAuthMode {
    def wrap(value: software.amazon.awssdk.services.rds.model.IAMAuthMode): IAMAuthMode = value match {
      case software.amazon.awssdk.services.rds.model.IAMAuthMode.UNKNOWN_TO_SDK_VERSION => unknownToSdkVersion
      case software.amazon.awssdk.services.rds.model.IAMAuthMode.DISABLED => DISABLED
      case software.amazon.awssdk.services.rds.model.IAMAuthMode.REQUIRED => REQUIRED
    }
    final case object unknownToSdkVersion extends IAMAuthMode { override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode = software.amazon.awssdk.services.rds.model.IAMAuthMode.UNKNOWN_TO_SDK_VERSION }
    final case object DISABLED extends IAMAuthMode { override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode = software.amazon.awssdk.services.rds.model.IAMAuthMode.DISABLED }
    final case object REQUIRED extends IAMAuthMode { override def unwrap: software.amazon.awssdk.services.rds.model.IAMAuthMode = software.amazon.awssdk.services.rds.model.IAMAuthMode.REQUIRED }
  }
  case class IPRange(status: scala.Option[String] = None, cidrip: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.IPRange = {
      import IPRange.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.IPRange.builder().optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(cidrip.map(value => value: java.lang.String))(_.cidrip).build()
    }
    def asReadOnly: IPRange.ReadOnly = IPRange.wrap(buildAwsValue())
  }
  object IPRange {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.IPRange] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: IPRange = IPRange(statusValue.map(value => value), cidripValue.map(value => value))
      def statusValue: scala.Option[String]
      def cidripValue: scala.Option[String]
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def cidrip: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cidrip", cidripValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.IPRange) extends IPRange.ReadOnly {
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def cidripValue: scala.Option[String] = scala.Option(impl.cidrip()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.IPRange): ReadOnly = new Wrapper(impl)
  }
  type IPRangeList = List[IPRange]
  case class ImportInstallationMediaRequest(customAvailabilityZoneId: String, engine: String, engineVersion: String, engineInstallationMediaPath: String, osInstallationMediaPath: String) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest = {
      import ImportInstallationMediaRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest.builder().customAvailabilityZoneId(customAvailabilityZoneId: java.lang.String).engine(engine: java.lang.String).engineVersion(engineVersion: java.lang.String).engineInstallationMediaPath(engineInstallationMediaPath: java.lang.String).osInstallationMediaPath(osInstallationMediaPath: java.lang.String).build()
    }
    def asReadOnly: ImportInstallationMediaRequest.ReadOnly = ImportInstallationMediaRequest.wrap(buildAwsValue())
  }
  object ImportInstallationMediaRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ImportInstallationMediaRequest = ImportInstallationMediaRequest(customAvailabilityZoneIdValue, engineValue, engineVersionValue, engineInstallationMediaPathValue, osInstallationMediaPathValue)
      def customAvailabilityZoneIdValue: String
      def engineValue: String
      def engineVersionValue: String
      def engineInstallationMediaPathValue: String
      def osInstallationMediaPathValue: String
      def customAvailabilityZoneId: ZIO[Any, Nothing, String] = ZIO.succeed(customAvailabilityZoneIdValue)
      def engine: ZIO[Any, Nothing, String] = ZIO.succeed(engineValue)
      def engineVersion: ZIO[Any, Nothing, String] = ZIO.succeed(engineVersionValue)
      def engineInstallationMediaPath: ZIO[Any, Nothing, String] = ZIO.succeed(engineInstallationMediaPathValue)
      def osInstallationMediaPath: ZIO[Any, Nothing, String] = ZIO.succeed(osInstallationMediaPathValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest) extends ImportInstallationMediaRequest.ReadOnly {
      override def customAvailabilityZoneIdValue: String = impl.customAvailabilityZoneId(): String
      override def engineValue: String = impl.engine(): String
      override def engineVersionValue: String = impl.engineVersion(): String
      override def engineInstallationMediaPathValue: String = impl.engineInstallationMediaPath(): String
      override def osInstallationMediaPathValue: String = impl.osInstallationMediaPath(): String
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest): ReadOnly = new Wrapper(impl)
  }
  case class ImportInstallationMediaResponse(installationMediaId: scala.Option[String] = None, customAvailabilityZoneId: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, engineInstallationMediaPath: scala.Option[String] = None, osInstallationMediaPath: scala.Option[String] = None, status: scala.Option[String] = None, failureCause: scala.Option[InstallationMediaFailureCause] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse = {
      import ImportInstallationMediaResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse.builder().optionallyWith(installationMediaId.map(value => value: java.lang.String))(_.installationMediaId).optionallyWith(customAvailabilityZoneId.map(value => value: java.lang.String))(_.customAvailabilityZoneId).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(engineInstallationMediaPath.map(value => value: java.lang.String))(_.engineInstallationMediaPath).optionallyWith(osInstallationMediaPath.map(value => value: java.lang.String))(_.osInstallationMediaPath).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(failureCause.map(value => value.buildAwsValue()))(_.failureCause).build()
    }
    def asReadOnly: ImportInstallationMediaResponse.ReadOnly = ImportInstallationMediaResponse.wrap(buildAwsValue())
  }
  object ImportInstallationMediaResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ImportInstallationMediaResponse = ImportInstallationMediaResponse(installationMediaIdValue.map(value => value), customAvailabilityZoneIdValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), engineInstallationMediaPathValue.map(value => value), osInstallationMediaPathValue.map(value => value), statusValue.map(value => value), failureCauseValue.map(value => value.editable))
      def installationMediaIdValue: scala.Option[String]
      def customAvailabilityZoneIdValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def engineInstallationMediaPathValue: scala.Option[String]
      def osInstallationMediaPathValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly]
      def installationMediaId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("installationMediaId", installationMediaIdValue)
      def customAvailabilityZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneIdValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def engineInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineInstallationMediaPath", engineInstallationMediaPathValue)
      def osInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("osInstallationMediaPath", osInstallationMediaPathValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def failureCause: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstallationMediaFailureCause.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureCause", failureCauseValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse) extends ImportInstallationMediaResponse.ReadOnly {
      override def installationMediaIdValue: scala.Option[String] = scala.Option(impl.installationMediaId()).map(value => value: String)
      override def customAvailabilityZoneIdValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def engineInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.engineInstallationMediaPath()).map(value => value: String)
      override def osInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.osInstallationMediaPath()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly] = scala.Option(impl.failureCause()).map(value => InstallationMediaFailureCause.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse): ReadOnly = new Wrapper(impl)
  }
  case class InstallationMedia(installationMediaId: scala.Option[String] = None, customAvailabilityZoneId: scala.Option[String] = None, engine: scala.Option[String] = None, engineVersion: scala.Option[String] = None, engineInstallationMediaPath: scala.Option[String] = None, osInstallationMediaPath: scala.Option[String] = None, status: scala.Option[String] = None, failureCause: scala.Option[InstallationMediaFailureCause] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.InstallationMedia = {
      import InstallationMedia.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.InstallationMedia.builder().optionallyWith(installationMediaId.map(value => value: java.lang.String))(_.installationMediaId).optionallyWith(customAvailabilityZoneId.map(value => value: java.lang.String))(_.customAvailabilityZoneId).optionallyWith(engine.map(value => value: java.lang.String))(_.engine).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(engineInstallationMediaPath.map(value => value: java.lang.String))(_.engineInstallationMediaPath).optionallyWith(osInstallationMediaPath.map(value => value: java.lang.String))(_.osInstallationMediaPath).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(failureCause.map(value => value.buildAwsValue()))(_.failureCause).build()
    }
    def asReadOnly: InstallationMedia.ReadOnly = InstallationMedia.wrap(buildAwsValue())
  }
  object InstallationMedia {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.InstallationMedia] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: InstallationMedia = InstallationMedia(installationMediaIdValue.map(value => value), customAvailabilityZoneIdValue.map(value => value), engineValue.map(value => value), engineVersionValue.map(value => value), engineInstallationMediaPathValue.map(value => value), osInstallationMediaPathValue.map(value => value), statusValue.map(value => value), failureCauseValue.map(value => value.editable))
      def installationMediaIdValue: scala.Option[String]
      def customAvailabilityZoneIdValue: scala.Option[String]
      def engineValue: scala.Option[String]
      def engineVersionValue: scala.Option[String]
      def engineInstallationMediaPathValue: scala.Option[String]
      def osInstallationMediaPathValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly]
      def installationMediaId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("installationMediaId", installationMediaIdValue)
      def customAvailabilityZoneId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customAvailabilityZoneId", customAvailabilityZoneIdValue)
      def engine: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engine", engineValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def engineInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineInstallationMediaPath", engineInstallationMediaPathValue)
      def osInstallationMediaPath: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("osInstallationMediaPath", osInstallationMediaPathValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def failureCause: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, InstallationMediaFailureCause.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("failureCause", failureCauseValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.InstallationMedia) extends InstallationMedia.ReadOnly {
      override def installationMediaIdValue: scala.Option[String] = scala.Option(impl.installationMediaId()).map(value => value: String)
      override def customAvailabilityZoneIdValue: scala.Option[String] = scala.Option(impl.customAvailabilityZoneId()).map(value => value: String)
      override def engineValue: scala.Option[String] = scala.Option(impl.engine()).map(value => value: String)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def engineInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.engineInstallationMediaPath()).map(value => value: String)
      override def osInstallationMediaPathValue: scala.Option[String] = scala.Option(impl.osInstallationMediaPath()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def failureCauseValue: scala.Option[InstallationMediaFailureCause.ReadOnly] = scala.Option(impl.failureCause()).map(value => InstallationMediaFailureCause.wrap(value))
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.InstallationMedia): ReadOnly = new Wrapper(impl)
  }
  case class InstallationMediaFailureCause(message: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause = {
      import InstallationMediaFailureCause.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause.builder().optionallyWith(message.map(value => value: java.lang.String))(_.message).build()
    }
    def asReadOnly: InstallationMediaFailureCause.ReadOnly = InstallationMediaFailureCause.wrap(buildAwsValue())
  }
  object InstallationMediaFailureCause {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: InstallationMediaFailureCause = InstallationMediaFailureCause(messageValue.map(value => value))
      def messageValue: scala.Option[String]
      def message: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("message", messageValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause) extends InstallationMediaFailureCause.ReadOnly { override def messageValue: scala.Option[String] = scala.Option(impl.message()).map(value => value: String) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.InstallationMediaFailureCause): ReadOnly = new Wrapper(impl)
  }
  type InstallationMediaList = List[InstallationMedia]
  type KeyList = List[String]
  case class ListTagsForResourceRequest(resourceName: String, filters: scala.Option[Iterable[Filter]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest = {
      import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest.builder().resourceName(resourceName: java.lang.String).optionallyWith(filters.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.filters).build()
    }
    def asReadOnly: ListTagsForResourceRequest.ReadOnly = ListTagsForResourceRequest.wrap(buildAwsValue())
  }
  object ListTagsForResourceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ListTagsForResourceRequest = ListTagsForResourceRequest(resourceNameValue, filtersValue.map(value => value.map { item => 
        item.editable
      }))
      def resourceNameValue: String
      def filtersValue: scala.Option[List[Filter.ReadOnly]]
      def resourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceNameValue)
      def filters: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Filter.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("filters", filtersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest) extends ListTagsForResourceRequest.ReadOnly {
      override def resourceNameValue: String = impl.resourceName(): String
      override def filtersValue: scala.Option[List[Filter.ReadOnly]] = scala.Option(impl.filters()).map(value => value.asScala.map { item => 
        Filter.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest): ReadOnly = new Wrapper(impl)
  }
  case class ListTagsForResourceResponse(tagList: scala.Option[Iterable[Tag]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse = {
      import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse.builder().optionallyWith(tagList.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.tagList).build()
    }
    def asReadOnly: ListTagsForResourceResponse.ReadOnly = ListTagsForResourceResponse.wrap(buildAwsValue())
  }
  object ListTagsForResourceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ListTagsForResourceResponse = ListTagsForResourceResponse(tagListValue.map(value => value.map { item => 
        item.editable
      }))
      def tagListValue: scala.Option[List[Tag.ReadOnly]]
      def tagList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[Tag.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tagList", tagListValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse) extends ListTagsForResourceResponse.ReadOnly {
      override def tagListValue: scala.Option[List[Tag.ReadOnly]] = scala.Option(impl.tagList()).map(value => value.asScala.map { item => 
        Tag.wrap(item)
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse): ReadOnly = new Wrapper(impl)
  }
  type LogTypeList = List[String]
  case class MinimumEngineVersionPerAllowedValue(allowedValue: scala.Option[String] = None, minimumEngineVersion: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue = {
      import MinimumEngineVersionPerAllowedValue.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue.builder().optionallyWith(allowedValue.map(value => value: java.lang.String))(_.allowedValue).optionallyWith(minimumEngineVersion.map(value => value: java.lang.String))(_.minimumEngineVersion).build()
    }
    def asReadOnly: MinimumEngineVersionPerAllowedValue.ReadOnly = MinimumEngineVersionPerAllowedValue.wrap(buildAwsValue())
  }
  object MinimumEngineVersionPerAllowedValue {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: MinimumEngineVersionPerAllowedValue = MinimumEngineVersionPerAllowedValue(allowedValueValue.map(value => value), minimumEngineVersionValue.map(value => value))
      def allowedValueValue: scala.Option[String]
      def minimumEngineVersionValue: scala.Option[String]
      def allowedValue: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowedValue", allowedValueValue)
      def minimumEngineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("minimumEngineVersion", minimumEngineVersionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue) extends MinimumEngineVersionPerAllowedValue.ReadOnly {
      override def allowedValueValue: scala.Option[String] = scala.Option(impl.allowedValue()).map(value => value: String)
      override def minimumEngineVersionValue: scala.Option[String] = scala.Option(impl.minimumEngineVersion()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.MinimumEngineVersionPerAllowedValue): ReadOnly = new Wrapper(impl)
  }
  type MinimumEngineVersionPerAllowedValueList = List[MinimumEngineVersionPerAllowedValue]
  case class ModifyCertificatesRequest(certificateIdentifier: scala.Option[String] = None, removeCustomerOverride: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest = {
      import ModifyCertificatesRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest.builder().optionallyWith(certificateIdentifier.map(value => value: java.lang.String))(_.certificateIdentifier).optionallyWith(removeCustomerOverride.map(value => value: java.lang.Boolean))(_.removeCustomerOverride).build()
    }
    def asReadOnly: ModifyCertificatesRequest.ReadOnly = ModifyCertificatesRequest.wrap(buildAwsValue())
  }
  object ModifyCertificatesRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyCertificatesRequest = ModifyCertificatesRequest(certificateIdentifierValue.map(value => value), removeCustomerOverrideValue.map(value => value))
      def certificateIdentifierValue: scala.Option[String]
      def removeCustomerOverrideValue: scala.Option[primitives.BooleanOptional]
      def certificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateIdentifier", certificateIdentifierValue)
      def removeCustomerOverride: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("removeCustomerOverride", removeCustomerOverrideValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest) extends ModifyCertificatesRequest.ReadOnly {
      override def certificateIdentifierValue: scala.Option[String] = scala.Option(impl.certificateIdentifier()).map(value => value: String)
      override def removeCustomerOverrideValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.removeCustomerOverride()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyCertificatesResponse(certificate: scala.Option[Certificate] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse = {
      import ModifyCertificatesResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse.builder().optionallyWith(certificate.map(value => value.buildAwsValue()))(_.certificate).build()
    }
    def asReadOnly: ModifyCertificatesResponse.ReadOnly = ModifyCertificatesResponse.wrap(buildAwsValue())
  }
  object ModifyCertificatesResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyCertificatesResponse = ModifyCertificatesResponse(certificateValue.map(value => value.editable))
      def certificateValue: scala.Option[Certificate.ReadOnly]
      def certificate: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Certificate.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificate", certificateValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse) extends ModifyCertificatesResponse.ReadOnly { override def certificateValue: scala.Option[Certificate.ReadOnly] = scala.Option(impl.certificate()).map(value => Certificate.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyCurrentDbClusterCapacityRequest(dbClusterIdentifier: String, capacity: scala.Option[primitives.IntegerOptional] = None, secondsBeforeTimeout: scala.Option[primitives.IntegerOptional] = None, timeoutAction: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest = {
      import ModifyCurrentDbClusterCapacityRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(capacity.map(value => value: java.lang.Integer))(_.capacity).optionallyWith(secondsBeforeTimeout.map(value => value: java.lang.Integer))(_.secondsBeforeTimeout).optionallyWith(timeoutAction.map(value => value: java.lang.String))(_.timeoutAction).build()
    }
    def asReadOnly: ModifyCurrentDbClusterCapacityRequest.ReadOnly = ModifyCurrentDbClusterCapacityRequest.wrap(buildAwsValue())
  }
  object ModifyCurrentDbClusterCapacityRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyCurrentDbClusterCapacityRequest = ModifyCurrentDbClusterCapacityRequest(dbClusterIdentifierValue, capacityValue.map(value => value), secondsBeforeTimeoutValue.map(value => value), timeoutActionValue.map(value => value))
      def dbClusterIdentifierValue: String
      def capacityValue: scala.Option[primitives.IntegerOptional]
      def secondsBeforeTimeoutValue: scala.Option[primitives.IntegerOptional]
      def timeoutActionValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def capacity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("capacity", capacityValue)
      def secondsBeforeTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeoutValue)
      def timeoutAction: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timeoutAction", timeoutActionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest) extends ModifyCurrentDbClusterCapacityRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def capacityValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.capacity()).map(value => value: primitives.IntegerOptional)
      override def secondsBeforeTimeoutValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.secondsBeforeTimeout()).map(value => value: primitives.IntegerOptional)
      override def timeoutActionValue: scala.Option[String] = scala.Option(impl.timeoutAction()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyCurrentDbClusterCapacityResponse(dbClusterIdentifier: scala.Option[String] = None, pendingCapacity: scala.Option[primitives.IntegerOptional] = None, currentCapacity: scala.Option[primitives.IntegerOptional] = None, secondsBeforeTimeout: scala.Option[primitives.IntegerOptional] = None, timeoutAction: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse = {
      import ModifyCurrentDbClusterCapacityResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse.builder().optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(pendingCapacity.map(value => value: java.lang.Integer))(_.pendingCapacity).optionallyWith(currentCapacity.map(value => value: java.lang.Integer))(_.currentCapacity).optionallyWith(secondsBeforeTimeout.map(value => value: java.lang.Integer))(_.secondsBeforeTimeout).optionallyWith(timeoutAction.map(value => value: java.lang.String))(_.timeoutAction).build()
    }
    def asReadOnly: ModifyCurrentDbClusterCapacityResponse.ReadOnly = ModifyCurrentDbClusterCapacityResponse.wrap(buildAwsValue())
  }
  object ModifyCurrentDbClusterCapacityResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyCurrentDbClusterCapacityResponse = ModifyCurrentDbClusterCapacityResponse(dbClusterIdentifierValue.map(value => value), pendingCapacityValue.map(value => value), currentCapacityValue.map(value => value), secondsBeforeTimeoutValue.map(value => value), timeoutActionValue.map(value => value))
      def dbClusterIdentifierValue: scala.Option[String]
      def pendingCapacityValue: scala.Option[primitives.IntegerOptional]
      def currentCapacityValue: scala.Option[primitives.IntegerOptional]
      def secondsBeforeTimeoutValue: scala.Option[primitives.IntegerOptional]
      def timeoutActionValue: scala.Option[String]
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def pendingCapacity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("pendingCapacity", pendingCapacityValue)
      def currentCapacity: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("currentCapacity", currentCapacityValue)
      def secondsBeforeTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secondsBeforeTimeout", secondsBeforeTimeoutValue)
      def timeoutAction: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("timeoutAction", timeoutActionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse) extends ModifyCurrentDbClusterCapacityResponse.ReadOnly {
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def pendingCapacityValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.pendingCapacity()).map(value => value: primitives.IntegerOptional)
      override def currentCapacityValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.currentCapacity()).map(value => value: primitives.IntegerOptional)
      override def secondsBeforeTimeoutValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.secondsBeforeTimeout()).map(value => value: primitives.IntegerOptional)
      override def timeoutActionValue: scala.Option[String] = scala.Option(impl.timeoutAction()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterEndpointRequest(dbClusterEndpointIdentifier: String, endpointType: scala.Option[String] = None, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest = {
      import ModifyDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest.builder().dbClusterEndpointIdentifier(dbClusterEndpointIdentifier: java.lang.String).optionallyWith(endpointType.map(value => value: java.lang.String))(_.endpointType).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).build()
    }
    def asReadOnly: ModifyDbClusterEndpointRequest.ReadOnly = ModifyDbClusterEndpointRequest.wrap(buildAwsValue())
  }
  object ModifyDbClusterEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterEndpointRequest = ModifyDbClusterEndpointRequest(dbClusterEndpointIdentifierValue, endpointTypeValue.map(value => value), staticMembersValue.map(value => value), excludedMembersValue.map(value => value))
      def dbClusterEndpointIdentifierValue: String
      def endpointTypeValue: scala.Option[String]
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def dbClusterEndpointIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterEndpointIdentifierValue)
      def endpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpointType", endpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest) extends ModifyDbClusterEndpointRequest.ReadOnly {
      override def dbClusterEndpointIdentifierValue: String = impl.dbClusterEndpointIdentifier(): String
      override def endpointTypeValue: scala.Option[String] = scala.Option(impl.endpointType()).map(value => value: String)
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterEndpointResponse(dbClusterEndpointIdentifier: scala.Option[String] = None, dbClusterIdentifier: scala.Option[String] = None, dbClusterEndpointResourceIdentifier: scala.Option[String] = None, endpoint: scala.Option[String] = None, status: scala.Option[String] = None, endpointType: scala.Option[String] = None, customEndpointType: scala.Option[String] = None, staticMembers: scala.Option[Iterable[String]] = None, excludedMembers: scala.Option[Iterable[String]] = None, dbClusterEndpointArn: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse = {
      import ModifyDbClusterEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse.builder().optionallyWith(dbClusterEndpointIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointIdentifier).optionallyWith(dbClusterIdentifier.map(value => value: java.lang.String))(_.dbClusterIdentifier).optionallyWith(dbClusterEndpointResourceIdentifier.map(value => value: java.lang.String))(_.dbClusterEndpointResourceIdentifier).optionallyWith(endpoint.map(value => value: java.lang.String))(_.endpoint).optionallyWith(status.map(value => value: java.lang.String))(_.status).optionallyWith(endpointType.map(value => value: java.lang.String))(_.endpointType).optionallyWith(customEndpointType.map(value => value: java.lang.String))(_.customEndpointType).optionallyWith(staticMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.staticMembers).optionallyWith(excludedMembers.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.excludedMembers).optionallyWith(dbClusterEndpointArn.map(value => value: java.lang.String))(_.dbClusterEndpointArn).build()
    }
    def asReadOnly: ModifyDbClusterEndpointResponse.ReadOnly = ModifyDbClusterEndpointResponse.wrap(buildAwsValue())
  }
  object ModifyDbClusterEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterEndpointResponse = ModifyDbClusterEndpointResponse(dbClusterEndpointIdentifierValue.map(value => value), dbClusterIdentifierValue.map(value => value), dbClusterEndpointResourceIdentifierValue.map(value => value), endpointValue.map(value => value), statusValue.map(value => value), endpointTypeValue.map(value => value), customEndpointTypeValue.map(value => value), staticMembersValue.map(value => value), excludedMembersValue.map(value => value), dbClusterEndpointArnValue.map(value => value))
      def dbClusterEndpointIdentifierValue: scala.Option[String]
      def dbClusterIdentifierValue: scala.Option[String]
      def dbClusterEndpointResourceIdentifierValue: scala.Option[String]
      def endpointValue: scala.Option[String]
      def statusValue: scala.Option[String]
      def endpointTypeValue: scala.Option[String]
      def customEndpointTypeValue: scala.Option[String]
      def staticMembersValue: scala.Option[List[String]]
      def excludedMembersValue: scala.Option[List[String]]
      def dbClusterEndpointArnValue: scala.Option[String]
      def dbClusterEndpointIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointIdentifier", dbClusterEndpointIdentifierValue)
      def dbClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifierValue)
      def dbClusterEndpointResourceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointResourceIdentifier", dbClusterEndpointResourceIdentifierValue)
      def endpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpoint", endpointValue)
      def status: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("status", statusValue)
      def endpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("endpointType", endpointTypeValue)
      def customEndpointType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("customEndpointType", customEndpointTypeValue)
      def staticMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("staticMembers", staticMembersValue)
      def excludedMembers: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("excludedMembers", excludedMembersValue)
      def dbClusterEndpointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse) extends ModifyDbClusterEndpointResponse.ReadOnly {
      override def dbClusterEndpointIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointIdentifier()).map(value => value: String)
      override def dbClusterIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterIdentifier()).map(value => value: String)
      override def dbClusterEndpointResourceIdentifierValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointResourceIdentifier()).map(value => value: String)
      override def endpointValue: scala.Option[String] = scala.Option(impl.endpoint()).map(value => value: String)
      override def statusValue: scala.Option[String] = scala.Option(impl.status()).map(value => value: String)
      override def endpointTypeValue: scala.Option[String] = scala.Option(impl.endpointType()).map(value => value: String)
      override def customEndpointTypeValue: scala.Option[String] = scala.Option(impl.customEndpointType()).map(value => value: String)
      override def staticMembersValue: scala.Option[List[String]] = scala.Option(impl.staticMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def excludedMembersValue: scala.Option[List[String]] = scala.Option(impl.excludedMembers()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def dbClusterEndpointArnValue: scala.Option[String] = scala.Option(impl.dbClusterEndpointArn()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterParameterGroupRequest(dbClusterParameterGroupName: String, parameters: Iterable[Parameter]) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest = {
      import ModifyDbClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest.builder().dbClusterParameterGroupName(dbClusterParameterGroupName: java.lang.String).parameters(parameters.map { item => 
        item.buildAwsValue()
      }.asJavaCollection).build()
    }
    def asReadOnly: ModifyDbClusterParameterGroupRequest.ReadOnly = ModifyDbClusterParameterGroupRequest.wrap(buildAwsValue())
  }
  object ModifyDbClusterParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterParameterGroupRequest = ModifyDbClusterParameterGroupRequest(dbClusterParameterGroupNameValue, parametersValue.map { item => 
        item.editable
      })
      def dbClusterParameterGroupNameValue: String
      def parametersValue: List[Parameter.ReadOnly]
      def dbClusterParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterParameterGroupNameValue)
      def parameters: ZIO[Any, Nothing, List[Parameter.ReadOnly]] = ZIO.succeed(parametersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest) extends ModifyDbClusterParameterGroupRequest.ReadOnly {
      override def dbClusterParameterGroupNameValue: String = impl.dbClusterParameterGroupName(): String
      override def parametersValue: List[Parameter.ReadOnly] = impl.parameters().asScala.map { item => 
        Parameter.wrap(item)
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterParameterGroupResponse(dbClusterParameterGroupName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse = {
      import ModifyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse.builder().optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).build()
    }
    def asReadOnly: ModifyDbClusterParameterGroupResponse.ReadOnly = ModifyDbClusterParameterGroupResponse.wrap(buildAwsValue())
  }
  object ModifyDbClusterParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterParameterGroupResponse = ModifyDbClusterParameterGroupResponse(dbClusterParameterGroupNameValue.map(value => value))
      def dbClusterParameterGroupNameValue: scala.Option[String]
      def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse) extends ModifyDbClusterParameterGroupResponse.ReadOnly { override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterRequest(dbClusterIdentifier: String, newDBClusterIdentifier: scala.Option[String] = None, applyImmediately: scala.Option[Boolean] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, dbClusterParameterGroupName: scala.Option[String] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, port: scala.Option[primitives.IntegerOptional] = None, masterUserPassword: scala.Option[String] = None, optionGroupName: scala.Option[String] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, enableIAMDatabaseAuthentication: scala.Option[primitives.BooleanOptional] = None, backtrackWindow: scala.Option[primitives.LongOptional] = None, cloudwatchLogsExportConfiguration: scala.Option[CloudwatchLogsExportConfiguration] = None, engineVersion: scala.Option[String] = None, allowMajorVersionUpgrade: scala.Option[Boolean] = None, dbInstanceParameterGroupName: scala.Option[String] = None, domain: scala.Option[String] = None, domainIAMRoleName: scala.Option[String] = None, scalingConfiguration: scala.Option[ScalingConfiguration] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, enableHttpEndpoint: scala.Option[primitives.BooleanOptional] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, enableGlobalWriteForwarding: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest = {
      import ModifyDbClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest.builder().dbClusterIdentifier(dbClusterIdentifier: java.lang.String).optionallyWith(newDBClusterIdentifier.map(value => value: java.lang.String))(_.newDBClusterIdentifier).optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(_.applyImmediately).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(dbClusterParameterGroupName.map(value => value: java.lang.String))(_.dbClusterParameterGroupName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(port.map(value => value: java.lang.Integer))(_.port).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean))(_.enableIAMDatabaseAuthentication).optionallyWith(backtrackWindow.map(value => value: java.lang.Long))(_.backtrackWindow).optionallyWith(cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue()))(_.cloudwatchLogsExportConfiguration).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(allowMajorVersionUpgrade.map(value => value: java.lang.Boolean))(_.allowMajorVersionUpgrade).optionallyWith(dbInstanceParameterGroupName.map(value => value: java.lang.String))(_.dbInstanceParameterGroupName).optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(_.domainIAMRoleName).optionallyWith(scalingConfiguration.map(value => value.buildAwsValue()))(_.scalingConfiguration).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(enableHttpEndpoint.map(value => value: java.lang.Boolean))(_.enableHttpEndpoint).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(enableGlobalWriteForwarding.map(value => value: java.lang.Boolean))(_.enableGlobalWriteForwarding).build()
    }
    def asReadOnly: ModifyDbClusterRequest.ReadOnly = ModifyDbClusterRequest.wrap(buildAwsValue())
  }
  object ModifyDbClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterRequest = ModifyDbClusterRequest(dbClusterIdentifierValue, newDBClusterIdentifierValue.map(value => value), applyImmediatelyValue.map(value => value), backupRetentionPeriodValue.map(value => value), dbClusterParameterGroupNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), portValue.map(value => value), masterUserPasswordValue.map(value => value), optionGroupNameValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), enableIAMDatabaseAuthenticationValue.map(value => value), backtrackWindowValue.map(value => value), cloudwatchLogsExportConfigurationValue.map(value => value.editable), engineVersionValue.map(value => value), allowMajorVersionUpgradeValue.map(value => value), dbInstanceParameterGroupNameValue.map(value => value), domainValue.map(value => value), domainIAMRoleNameValue.map(value => value), scalingConfigurationValue.map(value => value.editable), deletionProtectionValue.map(value => value), enableHttpEndpointValue.map(value => value), copyTagsToSnapshotValue.map(value => value), enableGlobalWriteForwardingValue.map(value => value))
      def dbClusterIdentifierValue: String
      def newDBClusterIdentifierValue: scala.Option[String]
      def applyImmediatelyValue: scala.Option[Boolean]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def dbClusterParameterGroupNameValue: scala.Option[String]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def portValue: scala.Option[primitives.IntegerOptional]
      def masterUserPasswordValue: scala.Option[String]
      def optionGroupNameValue: scala.Option[String]
      def preferredBackupWindowValue: scala.Option[String]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional]
      def backtrackWindowValue: scala.Option[primitives.LongOptional]
      def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly]
      def engineVersionValue: scala.Option[String]
      def allowMajorVersionUpgradeValue: scala.Option[Boolean]
      def dbInstanceParameterGroupNameValue: scala.Option[String]
      def domainValue: scala.Option[String]
      def domainIAMRoleNameValue: scala.Option[String]
      def scalingConfigurationValue: scala.Option[ScalingConfiguration.ReadOnly]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def enableHttpEndpointValue: scala.Option[primitives.BooleanOptional]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def enableGlobalWriteForwardingValue: scala.Option[primitives.BooleanOptional]
      def dbClusterIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterIdentifierValue)
      def newDBClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBClusterIdentifier", newDBClusterIdentifierValue)
      def applyImmediately: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def dbClusterParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterParameterGroupName", dbClusterParameterGroupNameValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def port: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("port", portValue)
      def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def enableIAMDatabaseAuthentication: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableIAMDatabaseAuthentication", enableIAMDatabaseAuthenticationValue)
      def backtrackWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.LongOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backtrackWindow", backtrackWindowValue)
      def cloudwatchLogsExportConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CloudwatchLogsExportConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudwatchLogsExportConfiguration", cloudwatchLogsExportConfigurationValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def allowMajorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgradeValue)
      def dbInstanceParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceParameterGroupName", dbInstanceParameterGroupNameValue)
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def domainIAMRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleNameValue)
      def scalingConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ScalingConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("scalingConfiguration", scalingConfigurationValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def enableHttpEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableHttpEndpoint", enableHttpEndpointValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def enableGlobalWriteForwarding: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableGlobalWriteForwarding", enableGlobalWriteForwardingValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest) extends ModifyDbClusterRequest.ReadOnly {
      override def dbClusterIdentifierValue: String = impl.dbClusterIdentifier(): String
      override def newDBClusterIdentifierValue: scala.Option[String] = scala.Option(impl.newDBClusterIdentifier()).map(value => value: String)
      override def applyImmediatelyValue: scala.Option[Boolean] = scala.Option(impl.applyImmediately()).map(value => value: Boolean)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def dbClusterParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbClusterParameterGroupName()).map(value => value: String)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def portValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.port()).map(value => value: primitives.IntegerOptional)
      override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableIAMDatabaseAuthentication()).map(value => value: primitives.BooleanOptional)
      override def backtrackWindowValue: scala.Option[primitives.LongOptional] = scala.Option(impl.backtrackWindow()).map(value => value: primitives.LongOptional)
      override def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly] = scala.Option(impl.cloudwatchLogsExportConfiguration()).map(value => CloudwatchLogsExportConfiguration.wrap(value))
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def allowMajorVersionUpgradeValue: scala.Option[Boolean] = scala.Option(impl.allowMajorVersionUpgrade()).map(value => value: Boolean)
      override def dbInstanceParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbInstanceParameterGroupName()).map(value => value: String)
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def domainIAMRoleNameValue: scala.Option[String] = scala.Option(impl.domainIAMRoleName()).map(value => value: String)
      override def scalingConfigurationValue: scala.Option[ScalingConfiguration.ReadOnly] = scala.Option(impl.scalingConfiguration()).map(value => ScalingConfiguration.wrap(value))
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def enableHttpEndpointValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableHttpEndpoint()).map(value => value: primitives.BooleanOptional)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def enableGlobalWriteForwardingValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableGlobalWriteForwarding()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterResponse(dbCluster: scala.Option[DBCluster] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse = {
      import ModifyDbClusterResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse.builder().optionallyWith(dbCluster.map(value => value.buildAwsValue()))(_.dbCluster).build()
    }
    def asReadOnly: ModifyDbClusterResponse.ReadOnly = ModifyDbClusterResponse.wrap(buildAwsValue())
  }
  object ModifyDbClusterResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterResponse = ModifyDbClusterResponse(dbClusterValue.map(value => value.editable))
      def dbClusterValue: scala.Option[DBCluster.ReadOnly]
      def dbCluster: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBCluster.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbCluster", dbClusterValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse) extends ModifyDbClusterResponse.ReadOnly { override def dbClusterValue: scala.Option[DBCluster.ReadOnly] = scala.Option(impl.dbCluster()).map(value => DBCluster.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterSnapshotAttributeRequest(dbClusterSnapshotIdentifier: String, attributeName: String, valuesToAdd: scala.Option[Iterable[String]] = None, valuesToRemove: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest = {
      import ModifyDbClusterSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest.builder().dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier: java.lang.String).attributeName(attributeName: java.lang.String).optionallyWith(valuesToAdd.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.valuesToAdd).optionallyWith(valuesToRemove.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.valuesToRemove).build()
    }
    def asReadOnly: ModifyDbClusterSnapshotAttributeRequest.ReadOnly = ModifyDbClusterSnapshotAttributeRequest.wrap(buildAwsValue())
  }
  object ModifyDbClusterSnapshotAttributeRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterSnapshotAttributeRequest = ModifyDbClusterSnapshotAttributeRequest(dbClusterSnapshotIdentifierValue, attributeNameValue, valuesToAddValue.map(value => value), valuesToRemoveValue.map(value => value))
      def dbClusterSnapshotIdentifierValue: String
      def attributeNameValue: String
      def valuesToAddValue: scala.Option[List[String]]
      def valuesToRemoveValue: scala.Option[List[String]]
      def dbClusterSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbClusterSnapshotIdentifierValue)
      def attributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeNameValue)
      def valuesToAdd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToAdd", valuesToAddValue)
      def valuesToRemove: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToRemove", valuesToRemoveValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest) extends ModifyDbClusterSnapshotAttributeRequest.ReadOnly {
      override def dbClusterSnapshotIdentifierValue: String = impl.dbClusterSnapshotIdentifier(): String
      override def attributeNameValue: String = impl.attributeName(): String
      override def valuesToAddValue: scala.Option[List[String]] = scala.Option(impl.valuesToAdd()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def valuesToRemoveValue: scala.Option[List[String]] = scala.Option(impl.valuesToRemove()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbClusterSnapshotAttributeResponse(dbClusterSnapshotAttributesResult: scala.Option[DBClusterSnapshotAttributesResult] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse = {
      import ModifyDbClusterSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse.builder().optionallyWith(dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue()))(_.dbClusterSnapshotAttributesResult).build()
    }
    def asReadOnly: ModifyDbClusterSnapshotAttributeResponse.ReadOnly = ModifyDbClusterSnapshotAttributeResponse.wrap(buildAwsValue())
  }
  object ModifyDbClusterSnapshotAttributeResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbClusterSnapshotAttributeResponse = ModifyDbClusterSnapshotAttributeResponse(dbClusterSnapshotAttributesResultValue.map(value => value.editable))
      def dbClusterSnapshotAttributesResultValue: scala.Option[DBClusterSnapshotAttributesResult.ReadOnly]
      def dbClusterSnapshotAttributesResult: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBClusterSnapshotAttributesResult.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbClusterSnapshotAttributesResult", dbClusterSnapshotAttributesResultValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse) extends ModifyDbClusterSnapshotAttributeResponse.ReadOnly { override def dbClusterSnapshotAttributesResultValue: scala.Option[DBClusterSnapshotAttributesResult.ReadOnly] = scala.Option(impl.dbClusterSnapshotAttributesResult()).map(value => DBClusterSnapshotAttributesResult.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbInstanceRequest(dbInstanceIdentifier: String, allocatedStorage: scala.Option[primitives.IntegerOptional] = None, dbInstanceClass: scala.Option[String] = None, dbSubnetGroupName: scala.Option[String] = None, dbSecurityGroups: scala.Option[Iterable[String]] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None, applyImmediately: scala.Option[Boolean] = None, masterUserPassword: scala.Option[String] = None, dbParameterGroupName: scala.Option[String] = None, backupRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, preferredBackupWindow: scala.Option[String] = None, preferredMaintenanceWindow: scala.Option[String] = None, multiAZ: scala.Option[primitives.BooleanOptional] = None, engineVersion: scala.Option[String] = None, allowMajorVersionUpgrade: scala.Option[Boolean] = None, autoMinorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None, licenseModel: scala.Option[String] = None, iops: scala.Option[primitives.IntegerOptional] = None, optionGroupName: scala.Option[String] = None, newDBInstanceIdentifier: scala.Option[String] = None, storageType: scala.Option[String] = None, tdeCredentialArn: scala.Option[String] = None, tdeCredentialPassword: scala.Option[String] = None, caCertificateIdentifier: scala.Option[String] = None, domain: scala.Option[String] = None, copyTagsToSnapshot: scala.Option[primitives.BooleanOptional] = None, monitoringInterval: scala.Option[primitives.IntegerOptional] = None, dbPortNumber: scala.Option[primitives.IntegerOptional] = None, publiclyAccessible: scala.Option[primitives.BooleanOptional] = None, monitoringRoleArn: scala.Option[String] = None, domainIAMRoleName: scala.Option[String] = None, promotionTier: scala.Option[primitives.IntegerOptional] = None, enableIAMDatabaseAuthentication: scala.Option[primitives.BooleanOptional] = None, enablePerformanceInsights: scala.Option[primitives.BooleanOptional] = None, performanceInsightsKMSKeyId: scala.Option[String] = None, performanceInsightsRetentionPeriod: scala.Option[primitives.IntegerOptional] = None, cloudwatchLogsExportConfiguration: scala.Option[CloudwatchLogsExportConfiguration] = None, processorFeatures: scala.Option[Iterable[ProcessorFeature]] = None, useDefaultProcessorFeatures: scala.Option[primitives.BooleanOptional] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, maxAllocatedStorage: scala.Option[primitives.IntegerOptional] = None, certificateRotationRestart: scala.Option[primitives.BooleanOptional] = None, replicaMode: scala.Option[ReplicaMode] = None, enableCustomerOwnedIp: scala.Option[primitives.BooleanOptional] = None, awsBackupRecoveryPointArn: scala.Option[primitives.AwsBackupRecoveryPointArn] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest = {
      import ModifyDbInstanceRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest.builder().dbInstanceIdentifier(dbInstanceIdentifier: java.lang.String).optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(_.allocatedStorage).optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(_.dbInstanceClass).optionallyWith(dbSubnetGroupName.map(value => value: java.lang.String))(_.dbSubnetGroupName).optionallyWith(dbSecurityGroups.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.dbSecurityGroups).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).optionallyWith(applyImmediately.map(value => value: java.lang.Boolean))(_.applyImmediately).optionallyWith(masterUserPassword.map(value => value: java.lang.String))(_.masterUserPassword).optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).optionallyWith(backupRetentionPeriod.map(value => value: java.lang.Integer))(_.backupRetentionPeriod).optionallyWith(preferredBackupWindow.map(value => value: java.lang.String))(_.preferredBackupWindow).optionallyWith(preferredMaintenanceWindow.map(value => value: java.lang.String))(_.preferredMaintenanceWindow).optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(allowMajorVersionUpgrade.map(value => value: java.lang.Boolean))(_.allowMajorVersionUpgrade).optionallyWith(autoMinorVersionUpgrade.map(value => value: java.lang.Boolean))(_.autoMinorVersionUpgrade).optionallyWith(licenseModel.map(value => value: java.lang.String))(_.licenseModel).optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).optionallyWith(newDBInstanceIdentifier.map(value => value: java.lang.String))(_.newDBInstanceIdentifier).optionallyWith(storageType.map(value => value: java.lang.String))(_.storageType).optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(_.tdeCredentialArn).optionallyWith(tdeCredentialPassword.map(value => value: java.lang.String))(_.tdeCredentialPassword).optionallyWith(caCertificateIdentifier.map(value => value: java.lang.String))(_.caCertificateIdentifier).optionallyWith(domain.map(value => value: java.lang.String))(_.domain).optionallyWith(copyTagsToSnapshot.map(value => value: java.lang.Boolean))(_.copyTagsToSnapshot).optionallyWith(monitoringInterval.map(value => value: java.lang.Integer))(_.monitoringInterval).optionallyWith(dbPortNumber.map(value => value: java.lang.Integer))(_.dbPortNumber).optionallyWith(publiclyAccessible.map(value => value: java.lang.Boolean))(_.publiclyAccessible).optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(_.monitoringRoleArn).optionallyWith(domainIAMRoleName.map(value => value: java.lang.String))(_.domainIAMRoleName).optionallyWith(promotionTier.map(value => value: java.lang.Integer))(_.promotionTier).optionallyWith(enableIAMDatabaseAuthentication.map(value => value: java.lang.Boolean))(_.enableIAMDatabaseAuthentication).optionallyWith(enablePerformanceInsights.map(value => value: java.lang.Boolean))(_.enablePerformanceInsights).optionallyWith(performanceInsightsKMSKeyId.map(value => value: java.lang.String))(_.performanceInsightsKMSKeyId).optionallyWith(performanceInsightsRetentionPeriod.map(value => value: java.lang.Integer))(_.performanceInsightsRetentionPeriod).optionallyWith(cloudwatchLogsExportConfiguration.map(value => value.buildAwsValue()))(_.cloudwatchLogsExportConfiguration).optionallyWith(processorFeatures.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.processorFeatures).optionallyWith(useDefaultProcessorFeatures.map(value => value: java.lang.Boolean))(_.useDefaultProcessorFeatures).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(maxAllocatedStorage.map(value => value: java.lang.Integer))(_.maxAllocatedStorage).optionallyWith(certificateRotationRestart.map(value => value: java.lang.Boolean))(_.certificateRotationRestart).optionallyWith(replicaMode.map(value => value.unwrap))(_.replicaMode).optionallyWith(enableCustomerOwnedIp.map(value => value: java.lang.Boolean))(_.enableCustomerOwnedIp).optionallyWith(awsBackupRecoveryPointArn.map(value => value: java.lang.String))(_.awsBackupRecoveryPointArn).build()
    }
    def asReadOnly: ModifyDbInstanceRequest.ReadOnly = ModifyDbInstanceRequest.wrap(buildAwsValue())
  }
  object ModifyDbInstanceRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbInstanceRequest = ModifyDbInstanceRequest(dbInstanceIdentifierValue, allocatedStorageValue.map(value => value), dbInstanceClassValue.map(value => value), dbSubnetGroupNameValue.map(value => value), dbSecurityGroupsValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value), applyImmediatelyValue.map(value => value), masterUserPasswordValue.map(value => value), dbParameterGroupNameValue.map(value => value), backupRetentionPeriodValue.map(value => value), preferredBackupWindowValue.map(value => value), preferredMaintenanceWindowValue.map(value => value), multiAZValue.map(value => value), engineVersionValue.map(value => value), allowMajorVersionUpgradeValue.map(value => value), autoMinorVersionUpgradeValue.map(value => value), licenseModelValue.map(value => value), iopsValue.map(value => value), optionGroupNameValue.map(value => value), newDBInstanceIdentifierValue.map(value => value), storageTypeValue.map(value => value), tdeCredentialArnValue.map(value => value), tdeCredentialPasswordValue.map(value => value), caCertificateIdentifierValue.map(value => value), domainValue.map(value => value), copyTagsToSnapshotValue.map(value => value), monitoringIntervalValue.map(value => value), dbPortNumberValue.map(value => value), publiclyAccessibleValue.map(value => value), monitoringRoleArnValue.map(value => value), domainIAMRoleNameValue.map(value => value), promotionTierValue.map(value => value), enableIAMDatabaseAuthenticationValue.map(value => value), enablePerformanceInsightsValue.map(value => value), performanceInsightsKMSKeyIdValue.map(value => value), performanceInsightsRetentionPeriodValue.map(value => value), cloudwatchLogsExportConfigurationValue.map(value => value.editable), processorFeaturesValue.map(value => value.map { item => 
        item.editable
      }), useDefaultProcessorFeaturesValue.map(value => value), deletionProtectionValue.map(value => value), maxAllocatedStorageValue.map(value => value), certificateRotationRestartValue.map(value => value), replicaModeValue.map(value => value), enableCustomerOwnedIpValue.map(value => value), awsBackupRecoveryPointArnValue.map(value => value))
      def dbInstanceIdentifierValue: String
      def allocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def dbInstanceClassValue: scala.Option[String]
      def dbSubnetGroupNameValue: scala.Option[String]
      def dbSecurityGroupsValue: scala.Option[List[String]]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def applyImmediatelyValue: scala.Option[Boolean]
      def masterUserPasswordValue: scala.Option[String]
      def dbParameterGroupNameValue: scala.Option[String]
      def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def preferredBackupWindowValue: scala.Option[String]
      def preferredMaintenanceWindowValue: scala.Option[String]
      def multiAZValue: scala.Option[primitives.BooleanOptional]
      def engineVersionValue: scala.Option[String]
      def allowMajorVersionUpgradeValue: scala.Option[Boolean]
      def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
      def licenseModelValue: scala.Option[String]
      def iopsValue: scala.Option[primitives.IntegerOptional]
      def optionGroupNameValue: scala.Option[String]
      def newDBInstanceIdentifierValue: scala.Option[String]
      def storageTypeValue: scala.Option[String]
      def tdeCredentialArnValue: scala.Option[String]
      def tdeCredentialPasswordValue: scala.Option[String]
      def caCertificateIdentifierValue: scala.Option[String]
      def domainValue: scala.Option[String]
      def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional]
      def monitoringIntervalValue: scala.Option[primitives.IntegerOptional]
      def dbPortNumberValue: scala.Option[primitives.IntegerOptional]
      def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional]
      def monitoringRoleArnValue: scala.Option[String]
      def domainIAMRoleNameValue: scala.Option[String]
      def promotionTierValue: scala.Option[primitives.IntegerOptional]
      def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional]
      def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional]
      def performanceInsightsKMSKeyIdValue: scala.Option[String]
      def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional]
      def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly]
      def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]]
      def useDefaultProcessorFeaturesValue: scala.Option[primitives.BooleanOptional]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional]
      def certificateRotationRestartValue: scala.Option[primitives.BooleanOptional]
      def replicaModeValue: scala.Option[ReplicaMode]
      def enableCustomerOwnedIpValue: scala.Option[primitives.BooleanOptional]
      def awsBackupRecoveryPointArnValue: scala.Option[primitives.AwsBackupRecoveryPointArn]
      def dbInstanceIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbInstanceIdentifierValue)
      def allocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allocatedStorage", allocatedStorageValue)
      def dbInstanceClass: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClassValue)
      def dbSubnetGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupName", dbSubnetGroupNameValue)
      def dbSecurityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroupsValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
      def applyImmediately: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("applyImmediately", applyImmediatelyValue)
      def masterUserPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("masterUserPassword", masterUserPasswordValue)
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
      def backupRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriodValue)
      def preferredBackupWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindowValue)
      def preferredMaintenanceWindow: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("preferredMaintenanceWindow", preferredMaintenanceWindowValue)
      def multiAZ: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("multiAZ", multiAZValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def allowMajorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, Boolean] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgradeValue)
      def autoMinorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgradeValue)
      def licenseModel: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("licenseModel", licenseModelValue)
      def iops: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("iops", iopsValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
      def newDBInstanceIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBInstanceIdentifier", newDBInstanceIdentifierValue)
      def storageType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("storageType", storageTypeValue)
      def tdeCredentialArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArnValue)
      def tdeCredentialPassword: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("tdeCredentialPassword", tdeCredentialPasswordValue)
      def caCertificateIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("caCertificateIdentifier", caCertificateIdentifierValue)
      def domain: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domain", domainValue)
      def copyTagsToSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshotValue)
      def monitoringInterval: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringInterval", monitoringIntervalValue)
      def dbPortNumber: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbPortNumber", dbPortNumberValue)
      def publiclyAccessible: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessibleValue)
      def monitoringRoleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArnValue)
      def domainIAMRoleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("domainIAMRoleName", domainIAMRoleNameValue)
      def promotionTier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("promotionTier", promotionTierValue)
      def enableIAMDatabaseAuthentication: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableIAMDatabaseAuthentication", enableIAMDatabaseAuthenticationValue)
      def enablePerformanceInsights: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enablePerformanceInsights", enablePerformanceInsightsValue)
      def performanceInsightsKMSKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsKMSKeyId", performanceInsightsKMSKeyIdValue)
      def performanceInsightsRetentionPeriod: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("performanceInsightsRetentionPeriod", performanceInsightsRetentionPeriodValue)
      def cloudwatchLogsExportConfiguration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, CloudwatchLogsExportConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("cloudwatchLogsExportConfiguration", cloudwatchLogsExportConfigurationValue)
      def processorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[ProcessorFeature.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("processorFeatures", processorFeaturesValue)
      def useDefaultProcessorFeatures: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("useDefaultProcessorFeatures", useDefaultProcessorFeaturesValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def maxAllocatedStorage: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxAllocatedStorage", maxAllocatedStorageValue)
      def certificateRotationRestart: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("certificateRotationRestart", certificateRotationRestartValue)
      def replicaMode: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ReplicaMode] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("replicaMode", replicaModeValue)
      def enableCustomerOwnedIp: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enableCustomerOwnedIp", enableCustomerOwnedIpValue)
      def awsBackupRecoveryPointArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AwsBackupRecoveryPointArn] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("awsBackupRecoveryPointArn", awsBackupRecoveryPointArnValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest) extends ModifyDbInstanceRequest.ReadOnly {
      override def dbInstanceIdentifierValue: String = impl.dbInstanceIdentifier(): String
      override def allocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.allocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def dbInstanceClassValue: scala.Option[String] = scala.Option(impl.dbInstanceClass()).map(value => value: String)
      override def dbSubnetGroupNameValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupName()).map(value => value: String)
      override def dbSecurityGroupsValue: scala.Option[List[String]] = scala.Option(impl.dbSecurityGroups()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def applyImmediatelyValue: scala.Option[Boolean] = scala.Option(impl.applyImmediately()).map(value => value: Boolean)
      override def masterUserPasswordValue: scala.Option[String] = scala.Option(impl.masterUserPassword()).map(value => value: String)
      override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String)
      override def backupRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.backupRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def preferredBackupWindowValue: scala.Option[String] = scala.Option(impl.preferredBackupWindow()).map(value => value: String)
      override def preferredMaintenanceWindowValue: scala.Option[String] = scala.Option(impl.preferredMaintenanceWindow()).map(value => value: String)
      override def multiAZValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.multiAZ()).map(value => value: primitives.BooleanOptional)
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def allowMajorVersionUpgradeValue: scala.Option[Boolean] = scala.Option(impl.allowMajorVersionUpgrade()).map(value => value: Boolean)
      override def autoMinorVersionUpgradeValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.autoMinorVersionUpgrade()).map(value => value: primitives.BooleanOptional)
      override def licenseModelValue: scala.Option[String] = scala.Option(impl.licenseModel()).map(value => value: String)
      override def iopsValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.iops()).map(value => value: primitives.IntegerOptional)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
      override def newDBInstanceIdentifierValue: scala.Option[String] = scala.Option(impl.newDBInstanceIdentifier()).map(value => value: String)
      override def storageTypeValue: scala.Option[String] = scala.Option(impl.storageType()).map(value => value: String)
      override def tdeCredentialArnValue: scala.Option[String] = scala.Option(impl.tdeCredentialArn()).map(value => value: String)
      override def tdeCredentialPasswordValue: scala.Option[String] = scala.Option(impl.tdeCredentialPassword()).map(value => value: String)
      override def caCertificateIdentifierValue: scala.Option[String] = scala.Option(impl.caCertificateIdentifier()).map(value => value: String)
      override def domainValue: scala.Option[String] = scala.Option(impl.domain()).map(value => value: String)
      override def copyTagsToSnapshotValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.copyTagsToSnapshot()).map(value => value: primitives.BooleanOptional)
      override def monitoringIntervalValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.monitoringInterval()).map(value => value: primitives.IntegerOptional)
      override def dbPortNumberValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.dbPortNumber()).map(value => value: primitives.IntegerOptional)
      override def publiclyAccessibleValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.publiclyAccessible()).map(value => value: primitives.BooleanOptional)
      override def monitoringRoleArnValue: scala.Option[String] = scala.Option(impl.monitoringRoleArn()).map(value => value: String)
      override def domainIAMRoleNameValue: scala.Option[String] = scala.Option(impl.domainIAMRoleName()).map(value => value: String)
      override def promotionTierValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.promotionTier()).map(value => value: primitives.IntegerOptional)
      override def enableIAMDatabaseAuthenticationValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableIAMDatabaseAuthentication()).map(value => value: primitives.BooleanOptional)
      override def enablePerformanceInsightsValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enablePerformanceInsights()).map(value => value: primitives.BooleanOptional)
      override def performanceInsightsKMSKeyIdValue: scala.Option[String] = scala.Option(impl.performanceInsightsKMSKeyId()).map(value => value: String)
      override def performanceInsightsRetentionPeriodValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.performanceInsightsRetentionPeriod()).map(value => value: primitives.IntegerOptional)
      override def cloudwatchLogsExportConfigurationValue: scala.Option[CloudwatchLogsExportConfiguration.ReadOnly] = scala.Option(impl.cloudwatchLogsExportConfiguration()).map(value => CloudwatchLogsExportConfiguration.wrap(value))
      override def processorFeaturesValue: scala.Option[List[ProcessorFeature.ReadOnly]] = scala.Option(impl.processorFeatures()).map(value => value.asScala.map { item => 
        ProcessorFeature.wrap(item)
      }.toList)
      override def useDefaultProcessorFeaturesValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.useDefaultProcessorFeatures()).map(value => value: primitives.BooleanOptional)
      override def deletionProtectionValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.deletionProtection()).map(value => value: primitives.BooleanOptional)
      override def maxAllocatedStorageValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.maxAllocatedStorage()).map(value => value: primitives.IntegerOptional)
      override def certificateRotationRestartValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.certificateRotationRestart()).map(value => value: primitives.BooleanOptional)
      override def replicaModeValue: scala.Option[ReplicaMode] = scala.Option(impl.replicaMode()).map(value => ReplicaMode.wrap(value))
      override def enableCustomerOwnedIpValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enableCustomerOwnedIp()).map(value => value: primitives.BooleanOptional)
      override def awsBackupRecoveryPointArnValue: scala.Option[primitives.AwsBackupRecoveryPointArn] = scala.Option(impl.awsBackupRecoveryPointArn()).map(value => value: primitives.AwsBackupRecoveryPointArn)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbInstanceResponse(dbInstance: scala.Option[DBInstance] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse = {
      import ModifyDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse.builder().optionallyWith(dbInstance.map(value => value.buildAwsValue()))(_.dbInstance).build()
    }
    def asReadOnly: ModifyDbInstanceResponse.ReadOnly = ModifyDbInstanceResponse.wrap(buildAwsValue())
  }
  object ModifyDbInstanceResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbInstanceResponse = ModifyDbInstanceResponse(dbInstanceValue.map(value => value.editable))
      def dbInstanceValue: scala.Option[DBInstance.ReadOnly]
      def dbInstance: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBInstance.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbInstance", dbInstanceValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse) extends ModifyDbInstanceResponse.ReadOnly { override def dbInstanceValue: scala.Option[DBInstance.ReadOnly] = scala.Option(impl.dbInstance()).map(value => DBInstance.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbParameterGroupRequest(dbParameterGroupName: String, parameters: Iterable[Parameter]) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest = {
      import ModifyDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest.builder().dbParameterGroupName(dbParameterGroupName: java.lang.String).parameters(parameters.map { item => 
        item.buildAwsValue()
      }.asJavaCollection).build()
    }
    def asReadOnly: ModifyDbParameterGroupRequest.ReadOnly = ModifyDbParameterGroupRequest.wrap(buildAwsValue())
  }
  object ModifyDbParameterGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbParameterGroupRequest = ModifyDbParameterGroupRequest(dbParameterGroupNameValue, parametersValue.map { item => 
        item.editable
      })
      def dbParameterGroupNameValue: String
      def parametersValue: List[Parameter.ReadOnly]
      def dbParameterGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbParameterGroupNameValue)
      def parameters: ZIO[Any, Nothing, List[Parameter.ReadOnly]] = ZIO.succeed(parametersValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest) extends ModifyDbParameterGroupRequest.ReadOnly {
      override def dbParameterGroupNameValue: String = impl.dbParameterGroupName(): String
      override def parametersValue: List[Parameter.ReadOnly] = impl.parameters().asScala.map { item => 
        Parameter.wrap(item)
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbParameterGroupResponse(dbParameterGroupName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse = {
      import ModifyDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse.builder().optionallyWith(dbParameterGroupName.map(value => value: java.lang.String))(_.dbParameterGroupName).build()
    }
    def asReadOnly: ModifyDbParameterGroupResponse.ReadOnly = ModifyDbParameterGroupResponse.wrap(buildAwsValue())
  }
  object ModifyDbParameterGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbParameterGroupResponse = ModifyDbParameterGroupResponse(dbParameterGroupNameValue.map(value => value))
      def dbParameterGroupNameValue: scala.Option[String]
      def dbParameterGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse) extends ModifyDbParameterGroupResponse.ReadOnly { override def dbParameterGroupNameValue: scala.Option[String] = scala.Option(impl.dbParameterGroupName()).map(value => value: String) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyEndpointRequest(dbProxyEndpointName: primitives.DBProxyEndpointName, newDBProxyEndpointName: scala.Option[primitives.DBProxyEndpointName] = None, vpcSecurityGroupIds: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest = {
      import ModifyDbProxyEndpointRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest.builder().dbProxyEndpointName(dbProxyEndpointName: java.lang.String).optionallyWith(newDBProxyEndpointName.map(value => value: java.lang.String))(_.newDBProxyEndpointName).optionallyWith(vpcSecurityGroupIds.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.vpcSecurityGroupIds).build()
    }
    def asReadOnly: ModifyDbProxyEndpointRequest.ReadOnly = ModifyDbProxyEndpointRequest.wrap(buildAwsValue())
  }
  object ModifyDbProxyEndpointRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyEndpointRequest = ModifyDbProxyEndpointRequest(dbProxyEndpointNameValue, newDBProxyEndpointNameValue.map(value => value), vpcSecurityGroupIdsValue.map(value => value))
      def dbProxyEndpointNameValue: primitives.DBProxyEndpointName
      def newDBProxyEndpointNameValue: scala.Option[primitives.DBProxyEndpointName]
      def vpcSecurityGroupIdsValue: scala.Option[List[String]]
      def dbProxyEndpointName: ZIO[Any, Nothing, primitives.DBProxyEndpointName] = ZIO.succeed(dbProxyEndpointNameValue)
      def newDBProxyEndpointName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.DBProxyEndpointName] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBProxyEndpointName", newDBProxyEndpointNameValue)
      def vpcSecurityGroupIds: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIdsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest) extends ModifyDbProxyEndpointRequest.ReadOnly {
      override def dbProxyEndpointNameValue: primitives.DBProxyEndpointName = impl.dbProxyEndpointName(): primitives.DBProxyEndpointName
      override def newDBProxyEndpointNameValue: scala.Option[primitives.DBProxyEndpointName] = scala.Option(impl.newDBProxyEndpointName()).map(value => value: primitives.DBProxyEndpointName)
      override def vpcSecurityGroupIdsValue: scala.Option[List[String]] = scala.Option(impl.vpcSecurityGroupIds()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyEndpointResponse(dbProxyEndpoint: scala.Option[DBProxyEndpoint] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse = {
      import ModifyDbProxyEndpointResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse.builder().optionallyWith(dbProxyEndpoint.map(value => value.buildAwsValue()))(_.dbProxyEndpoint).build()
    }
    def asReadOnly: ModifyDbProxyEndpointResponse.ReadOnly = ModifyDbProxyEndpointResponse.wrap(buildAwsValue())
  }
  object ModifyDbProxyEndpointResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyEndpointResponse = ModifyDbProxyEndpointResponse(dbProxyEndpointValue.map(value => value.editable))
      def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly]
      def dbProxyEndpoint: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyEndpoint.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyEndpoint", dbProxyEndpointValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse) extends ModifyDbProxyEndpointResponse.ReadOnly { override def dbProxyEndpointValue: scala.Option[DBProxyEndpoint.ReadOnly] = scala.Option(impl.dbProxyEndpoint()).map(value => DBProxyEndpoint.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyRequest(dbProxyName: String, newDBProxyName: scala.Option[String] = None, auth: scala.Option[Iterable[UserAuthConfig]] = None, requireTLS: scala.Option[primitives.BooleanOptional] = None, idleClientTimeout: scala.Option[primitives.IntegerOptional] = None, debugLogging: scala.Option[primitives.BooleanOptional] = None, roleArn: scala.Option[String] = None, securityGroups: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest = {
      import ModifyDbProxyRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest.builder().dbProxyName(dbProxyName: java.lang.String).optionallyWith(newDBProxyName.map(value => value: java.lang.String))(_.newDBProxyName).optionallyWith(auth.map(value => value.map { item => 
        item.buildAwsValue()
      }.asJavaCollection))(_.auth).optionallyWith(requireTLS.map(value => value: java.lang.Boolean))(_.requireTLS).optionallyWith(idleClientTimeout.map(value => value: java.lang.Integer))(_.idleClientTimeout).optionallyWith(debugLogging.map(value => value: java.lang.Boolean))(_.debugLogging).optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn).optionallyWith(securityGroups.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.securityGroups).build()
    }
    def asReadOnly: ModifyDbProxyRequest.ReadOnly = ModifyDbProxyRequest.wrap(buildAwsValue())
  }
  object ModifyDbProxyRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyRequest = ModifyDbProxyRequest(dbProxyNameValue, newDBProxyNameValue.map(value => value), authValue.map(value => value.map { item => 
        item.editable
      }), requireTLSValue.map(value => value), idleClientTimeoutValue.map(value => value), debugLoggingValue.map(value => value), roleArnValue.map(value => value), securityGroupsValue.map(value => value))
      def dbProxyNameValue: String
      def newDBProxyNameValue: scala.Option[String]
      def authValue: scala.Option[List[UserAuthConfig.ReadOnly]]
      def requireTLSValue: scala.Option[primitives.BooleanOptional]
      def idleClientTimeoutValue: scala.Option[primitives.IntegerOptional]
      def debugLoggingValue: scala.Option[primitives.BooleanOptional]
      def roleArnValue: scala.Option[String]
      def securityGroupsValue: scala.Option[List[String]]
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def newDBProxyName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newDBProxyName", newDBProxyNameValue)
      def auth: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[UserAuthConfig.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("auth", authValue)
      def requireTLS: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("requireTLS", requireTLSValue)
      def idleClientTimeout: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.IntegerOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("idleClientTimeout", idleClientTimeoutValue)
      def debugLogging: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("debugLogging", debugLoggingValue)
      def roleArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleArn", roleArnValue)
      def securityGroups: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("securityGroups", securityGroupsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest) extends ModifyDbProxyRequest.ReadOnly {
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def newDBProxyNameValue: scala.Option[String] = scala.Option(impl.newDBProxyName()).map(value => value: String)
      override def authValue: scala.Option[List[UserAuthConfig.ReadOnly]] = scala.Option(impl.auth()).map(value => value.asScala.map { item => 
        UserAuthConfig.wrap(item)
      }.toList)
      override def requireTLSValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.requireTLS()).map(value => value: primitives.BooleanOptional)
      override def idleClientTimeoutValue: scala.Option[primitives.IntegerOptional] = scala.Option(impl.idleClientTimeout()).map(value => value: primitives.IntegerOptional)
      override def debugLoggingValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.debugLogging()).map(value => value: primitives.BooleanOptional)
      override def roleArnValue: scala.Option[String] = scala.Option(impl.roleArn()).map(value => value: String)
      override def securityGroupsValue: scala.Option[List[String]] = scala.Option(impl.securityGroups()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyResponse(dbProxy: scala.Option[DBProxy] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse = {
      import ModifyDbProxyResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse.builder().optionallyWith(dbProxy.map(value => value.buildAwsValue()))(_.dbProxy).build()
    }
    def asReadOnly: ModifyDbProxyResponse.ReadOnly = ModifyDbProxyResponse.wrap(buildAwsValue())
  }
  object ModifyDbProxyResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyResponse = ModifyDbProxyResponse(dbProxyValue.map(value => value.editable))
      def dbProxyValue: scala.Option[DBProxy.ReadOnly]
      def dbProxy: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxy.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxy", dbProxyValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse) extends ModifyDbProxyResponse.ReadOnly { override def dbProxyValue: scala.Option[DBProxy.ReadOnly] = scala.Option(impl.dbProxy()).map(value => DBProxy.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyTargetGroupRequest(targetGroupName: String, dbProxyName: String, connectionPoolConfig: scala.Option[ConnectionPoolConfiguration] = None, newName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest = {
      import ModifyDbProxyTargetGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest.builder().targetGroupName(targetGroupName: java.lang.String).dbProxyName(dbProxyName: java.lang.String).optionallyWith(connectionPoolConfig.map(value => value.buildAwsValue()))(_.connectionPoolConfig).optionallyWith(newName.map(value => value: java.lang.String))(_.newName).build()
    }
    def asReadOnly: ModifyDbProxyTargetGroupRequest.ReadOnly = ModifyDbProxyTargetGroupRequest.wrap(buildAwsValue())
  }
  object ModifyDbProxyTargetGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyTargetGroupRequest = ModifyDbProxyTargetGroupRequest(targetGroupNameValue, dbProxyNameValue, connectionPoolConfigValue.map(value => value.editable), newNameValue.map(value => value))
      def targetGroupNameValue: String
      def dbProxyNameValue: String
      def connectionPoolConfigValue: scala.Option[ConnectionPoolConfiguration.ReadOnly]
      def newNameValue: scala.Option[String]
      def targetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(targetGroupNameValue)
      def dbProxyName: ZIO[Any, Nothing, String] = ZIO.succeed(dbProxyNameValue)
      def connectionPoolConfig: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, ConnectionPoolConfiguration.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("connectionPoolConfig", connectionPoolConfigValue)
      def newName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newName", newNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest) extends ModifyDbProxyTargetGroupRequest.ReadOnly {
      override def targetGroupNameValue: String = impl.targetGroupName(): String
      override def dbProxyNameValue: String = impl.dbProxyName(): String
      override def connectionPoolConfigValue: scala.Option[ConnectionPoolConfiguration.ReadOnly] = scala.Option(impl.connectionPoolConfig()).map(value => ConnectionPoolConfiguration.wrap(value))
      override def newNameValue: scala.Option[String] = scala.Option(impl.newName()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbProxyTargetGroupResponse(dbProxyTargetGroup: scala.Option[DBProxyTargetGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse = {
      import ModifyDbProxyTargetGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse.builder().optionallyWith(dbProxyTargetGroup.map(value => value.buildAwsValue()))(_.dbProxyTargetGroup).build()
    }
    def asReadOnly: ModifyDbProxyTargetGroupResponse.ReadOnly = ModifyDbProxyTargetGroupResponse.wrap(buildAwsValue())
  }
  object ModifyDbProxyTargetGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbProxyTargetGroupResponse = ModifyDbProxyTargetGroupResponse(dbProxyTargetGroupValue.map(value => value.editable))
      def dbProxyTargetGroupValue: scala.Option[DBProxyTargetGroup.ReadOnly]
      def dbProxyTargetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBProxyTargetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbProxyTargetGroup", dbProxyTargetGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse) extends ModifyDbProxyTargetGroupResponse.ReadOnly { override def dbProxyTargetGroupValue: scala.Option[DBProxyTargetGroup.ReadOnly] = scala.Option(impl.dbProxyTargetGroup()).map(value => DBProxyTargetGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSnapshotAttributeRequest(dbSnapshotIdentifier: String, attributeName: String, valuesToAdd: scala.Option[Iterable[String]] = None, valuesToRemove: scala.Option[Iterable[String]] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest = {
      import ModifyDbSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest.builder().dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String).attributeName(attributeName: java.lang.String).optionallyWith(valuesToAdd.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.valuesToAdd).optionallyWith(valuesToRemove.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.valuesToRemove).build()
    }
    def asReadOnly: ModifyDbSnapshotAttributeRequest.ReadOnly = ModifyDbSnapshotAttributeRequest.wrap(buildAwsValue())
  }
  object ModifyDbSnapshotAttributeRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSnapshotAttributeRequest = ModifyDbSnapshotAttributeRequest(dbSnapshotIdentifierValue, attributeNameValue, valuesToAddValue.map(value => value), valuesToRemoveValue.map(value => value))
      def dbSnapshotIdentifierValue: String
      def attributeNameValue: String
      def valuesToAddValue: scala.Option[List[String]]
      def valuesToRemoveValue: scala.Option[List[String]]
      def dbSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbSnapshotIdentifierValue)
      def attributeName: ZIO[Any, Nothing, String] = ZIO.succeed(attributeNameValue)
      def valuesToAdd: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToAdd", valuesToAddValue)
      def valuesToRemove: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("valuesToRemove", valuesToRemoveValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest) extends ModifyDbSnapshotAttributeRequest.ReadOnly {
      override def dbSnapshotIdentifierValue: String = impl.dbSnapshotIdentifier(): String
      override def attributeNameValue: String = impl.attributeName(): String
      override def valuesToAddValue: scala.Option[List[String]] = scala.Option(impl.valuesToAdd()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def valuesToRemoveValue: scala.Option[List[String]] = scala.Option(impl.valuesToRemove()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSnapshotAttributeResponse(dbSnapshotAttributesResult: scala.Option[DBSnapshotAttributesResult] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse = {
      import ModifyDbSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse.builder().optionallyWith(dbSnapshotAttributesResult.map(value => value.buildAwsValue()))(_.dbSnapshotAttributesResult).build()
    }
    def asReadOnly: ModifyDbSnapshotAttributeResponse.ReadOnly = ModifyDbSnapshotAttributeResponse.wrap(buildAwsValue())
  }
  object ModifyDbSnapshotAttributeResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSnapshotAttributeResponse = ModifyDbSnapshotAttributeResponse(dbSnapshotAttributesResultValue.map(value => value.editable))
      def dbSnapshotAttributesResultValue: scala.Option[DBSnapshotAttributesResult.ReadOnly]
      def dbSnapshotAttributesResult: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshotAttributesResult.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshotAttributesResult", dbSnapshotAttributesResultValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse) extends ModifyDbSnapshotAttributeResponse.ReadOnly { override def dbSnapshotAttributesResultValue: scala.Option[DBSnapshotAttributesResult.ReadOnly] = scala.Option(impl.dbSnapshotAttributesResult()).map(value => DBSnapshotAttributesResult.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSnapshotRequest(dbSnapshotIdentifier: String, engineVersion: scala.Option[String] = None, optionGroupName: scala.Option[String] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest = {
      import ModifyDbSnapshotRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest.builder().dbSnapshotIdentifier(dbSnapshotIdentifier: java.lang.String).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(optionGroupName.map(value => value: java.lang.String))(_.optionGroupName).build()
    }
    def asReadOnly: ModifyDbSnapshotRequest.ReadOnly = ModifyDbSnapshotRequest.wrap(buildAwsValue())
  }
  object ModifyDbSnapshotRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSnapshotRequest = ModifyDbSnapshotRequest(dbSnapshotIdentifierValue, engineVersionValue.map(value => value), optionGroupNameValue.map(value => value))
      def dbSnapshotIdentifierValue: String
      def engineVersionValue: scala.Option[String]
      def optionGroupNameValue: scala.Option[String]
      def dbSnapshotIdentifier: ZIO[Any, Nothing, String] = ZIO.succeed(dbSnapshotIdentifierValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def optionGroupName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("optionGroupName", optionGroupNameValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest) extends ModifyDbSnapshotRequest.ReadOnly {
      override def dbSnapshotIdentifierValue: String = impl.dbSnapshotIdentifier(): String
      override def engineVersionValue: scala.Option[String] = scala.Option(impl.engineVersion()).map(value => value: String)
      override def optionGroupNameValue: scala.Option[String] = scala.Option(impl.optionGroupName()).map(value => value: String)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSnapshotResponse(dbSnapshot: scala.Option[DBSnapshot] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse = {
      import ModifyDbSnapshotResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse.builder().optionallyWith(dbSnapshot.map(value => value.buildAwsValue()))(_.dbSnapshot).build()
    }
    def asReadOnly: ModifyDbSnapshotResponse.ReadOnly = ModifyDbSnapshotResponse.wrap(buildAwsValue())
  }
  object ModifyDbSnapshotResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSnapshotResponse = ModifyDbSnapshotResponse(dbSnapshotValue.map(value => value.editable))
      def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly]
      def dbSnapshot: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSnapshot.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSnapshot", dbSnapshotValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse) extends ModifyDbSnapshotResponse.ReadOnly { override def dbSnapshotValue: scala.Option[DBSnapshot.ReadOnly] = scala.Option(impl.dbSnapshot()).map(value => DBSnapshot.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSubnetGroupRequest(dbSubnetGroupName: String, dbSubnetGroupDescription: scala.Option[String] = None, subnetIds: Iterable[String]) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest = {
      import ModifyDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest.builder().dbSubnetGroupName(dbSubnetGroupName: java.lang.String).optionallyWith(dbSubnetGroupDescription.map(value => value: java.lang.String))(_.dbSubnetGroupDescription).subnetIds(subnetIds.map { item => 
        item: java.lang.String
      }.asJavaCollection).build()
    }
    def asReadOnly: ModifyDbSubnetGroupRequest.ReadOnly = ModifyDbSubnetGroupRequest.wrap(buildAwsValue())
  }
  object ModifyDbSubnetGroupRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSubnetGroupRequest = ModifyDbSubnetGroupRequest(dbSubnetGroupNameValue, dbSubnetGroupDescriptionValue.map(value => value), subnetIdsValue)
      def dbSubnetGroupNameValue: String
      def dbSubnetGroupDescriptionValue: scala.Option[String]
      def subnetIdsValue: List[String]
      def dbSubnetGroupName: ZIO[Any, Nothing, String] = ZIO.succeed(dbSubnetGroupNameValue)
      def dbSubnetGroupDescription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescriptionValue)
      def subnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIdsValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest) extends ModifyDbSubnetGroupRequest.ReadOnly {
      override def dbSubnetGroupNameValue: String = impl.dbSubnetGroupName(): String
      override def dbSubnetGroupDescriptionValue: scala.Option[String] = scala.Option(impl.dbSubnetGroupDescription()).map(value => value: String)
      override def subnetIdsValue: List[String] = impl.subnetIds().asScala.map { item => 
        item: String
      }.toList
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyDbSubnetGroupResponse(dbSubnetGroup: scala.Option[DBSubnetGroup] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse = {
      import ModifyDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse.builder().optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(_.dbSubnetGroup).build()
    }
    def asReadOnly: ModifyDbSubnetGroupResponse.ReadOnly = ModifyDbSubnetGroupResponse.wrap(buildAwsValue())
  }
  object ModifyDbSubnetGroupResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyDbSubnetGroupResponse = ModifyDbSubnetGroupResponse(dbSubnetGroupValue.map(value => value.editable))
      def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly]
      def dbSubnetGroup: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, DBSubnetGroup.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroupValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse) extends ModifyDbSubnetGroupResponse.ReadOnly { override def dbSubnetGroupValue: scala.Option[DBSubnetGroup.ReadOnly] = scala.Option(impl.dbSubnetGroup()).map(value => DBSubnetGroup.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyEventSubscriptionRequest(subscriptionName: String, snsTopicArn: scala.Option[String] = None, sourceType: scala.Option[String] = None, eventCategories: scala.Option[Iterable[String]] = None, enabled: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest = {
      import ModifyEventSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest.builder().subscriptionName(subscriptionName: java.lang.String).optionallyWith(snsTopicArn.map(value => value: java.lang.String))(_.snsTopicArn).optionallyWith(sourceType.map(value => value: java.lang.String))(_.sourceType).optionallyWith(eventCategories.map(value => value.map { item => 
        item: java.lang.String
      }.asJavaCollection))(_.eventCategories).optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled).build()
    }
    def asReadOnly: ModifyEventSubscriptionRequest.ReadOnly = ModifyEventSubscriptionRequest.wrap(buildAwsValue())
  }
  object ModifyEventSubscriptionRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyEventSubscriptionRequest = ModifyEventSubscriptionRequest(subscriptionNameValue, snsTopicArnValue.map(value => value), sourceTypeValue.map(value => value), eventCategoriesValue.map(value => value), enabledValue.map(value => value))
      def subscriptionNameValue: String
      def snsTopicArnValue: scala.Option[String]
      def sourceTypeValue: scala.Option[String]
      def eventCategoriesValue: scala.Option[List[String]]
      def enabledValue: scala.Option[primitives.BooleanOptional]
      def subscriptionName: ZIO[Any, Nothing, String] = ZIO.succeed(subscriptionNameValue)
      def snsTopicArn: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("snsTopicArn", snsTopicArnValue)
      def sourceType: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sourceType", sourceTypeValue)
      def eventCategories: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[String]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventCategories", eventCategoriesValue)
      def enabled: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("enabled", enabledValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest) extends ModifyEventSubscriptionRequest.ReadOnly {
      override def subscriptionNameValue: String = impl.subscriptionName(): String
      override def snsTopicArnValue: scala.Option[String] = scala.Option(impl.snsTopicArn()).map(value => value: String)
      override def sourceTypeValue: scala.Option[String] = scala.Option(impl.sourceType()).map(value => value: String)
      override def eventCategoriesValue: scala.Option[List[String]] = scala.Option(impl.eventCategories()).map(value => value.asScala.map { item => 
        item: String
      }.toList)
      override def enabledValue: scala.Option[primitives.BooleanOptional] = scala.Option(impl.enabled()).map(value => value: primitives.BooleanOptional)
    }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest): ReadOnly = new Wrapper(impl)
  }
  case class ModifyEventSubscriptionResponse(eventSubscription: scala.Option[EventSubscription] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse = {
      import ModifyEventSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse.builder().optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(_.eventSubscription).build()
    }
    def asReadOnly: ModifyEventSubscriptionResponse.ReadOnly = ModifyEventSubscriptionResponse.wrap(buildAwsValue())
  }
  object ModifyEventSubscriptionResponse {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyEventSubscriptionResponse = ModifyEventSubscriptionResponse(eventSubscriptionValue.map(value => value.editable))
      def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly]
      def eventSubscription: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, EventSubscription.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("eventSubscription", eventSubscriptionValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse) extends ModifyEventSubscriptionResponse.ReadOnly { override def eventSubscriptionValue: scala.Option[EventSubscription.ReadOnly] = scala.Option(impl.eventSubscription()).map(value => EventSubscription.wrap(value)) }
    def wrap(impl: software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse): ReadOnly = new Wrapper(impl)
  }
  case class ModifyGlobalClusterRequest(globalClusterIdentifier: scala.Option[String] = None, newGlobalClusterIdentifier: scala.Option[String] = None, deletionProtection: scala.Option[primitives.BooleanOptional] = None, engineVersion: scala.Option[String] = None, allowMajorVersionUpgrade: scala.Option[primitives.BooleanOptional] = None) {
    def buildAwsValue(): software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest = {
      import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
      software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest.builder().optionallyWith(globalClusterIdentifier.map(value => value: java.lang.String))(_.globalClusterIdentifier).optionallyWith(newGlobalClusterIdentifier.map(value => value: java.lang.String))(_.newGlobalClusterIdentifier).optionallyWith(deletionProtection.map(value => value: java.lang.Boolean))(_.deletionProtection).optionallyWith(engineVersion.map(value => value: java.lang.String))(_.engineVersion).optionallyWith(allowMajorVersionUpgrade.map(value => value: java.lang.Boolean))(_.allowMajorVersionUpgrade).build()
    }
    def asReadOnly: ModifyGlobalClusterRequest.ReadOnly = ModifyGlobalClusterRequest.wrap(buildAwsValue())
  }
  object ModifyGlobalClusterRequest {
    private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
    trait ReadOnly {
      def editable: ModifyGlobalClusterRequest = ModifyGlobalClusterRequest(globalClusterIdentifierValue.map(value => value), newGlobalClusterIdentifierValue.map(value => value), deletionProtectionValue.map(value => value), engineVersionValue.map(value => value), allowMajorVersionUpgradeValue.map(value => value))
      def globalClusterIdentifierValue: scala.Option[String]
      def newGlobalClusterIdentifierValue: scala.Option[String]
      def deletionProtectionValue: scala.Option[primitives.BooleanOptional]
      def engineVersionValue: scala.Option[String]
      def allowMajorVersionUpgradeValue: scala.Option[primitives.BooleanOptional]
      def globalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("globalClusterIdentifier", globalClusterIdentifierValue)
      def newGlobalClusterIdentifier: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("newGlobalClusterIdentifier", newGlobalClusterIdentifierValue)
      def deletionProtection: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("deletionProtection", deletionProtectionValue)
      def engineVersion: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, String] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("engineVersion", engineVersionValue)
      def allowMajorVersionUpgrade: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.BooleanOptional] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("allowMajorVersionUpgrade", allowMajorVersionUpgradeValue)
    }
    private class Wrapper(impl: software.amazon.awssdk.services.r