package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core._
import io.github.vigoo.zioaws.core.aspects._
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.services.rds.paginators._
import software.amazon.awssdk.services.rds.{ RdsAsyncClient, RdsAsyncClientBuilder }
import zio.{ Chunk, Has, IO, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters._
package object rds {
  import model._
  type Rds = Has[Rds.Service]
  object Rds {
    trait Service extends AspectSupport[Service] {
      val api: RdsAsyncClient
      def downloadDBLogFilePortion(request: DownloadDbLogFilePortionRequest): IO[AwsError, DownloadDbLogFilePortionResponse.ReadOnly]
      def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): IO[AwsError, CopyDbClusterSnapshotResponse.ReadOnly]
      def describeEngineDefaultParameters(request: DescribeEngineDefaultParametersRequest): IO[AwsError, DescribeEngineDefaultParametersResponse.ReadOnly]
      def modifyDBInstance(request: ModifyDbInstanceRequest): IO[AwsError, ModifyDbInstanceResponse.ReadOnly]
      def deleteDBProxy(request: DeleteDbProxyRequest): IO[AwsError, DeleteDbProxyResponse.ReadOnly]
      def describeDBClusterEndpoints(request: DescribeDbClusterEndpointsRequest): zio.stream.ZStream[Any, AwsError, DBClusterEndpoint.ReadOnly]
      def stopActivityStream(request: StopActivityStreamRequest): IO[AwsError, StopActivityStreamResponse.ReadOnly]
      def failoverGlobalCluster(request: FailoverGlobalClusterRequest): IO[AwsError, FailoverGlobalClusterResponse.ReadOnly]
      def describeDBLogFiles(request: DescribeDbLogFilesRequest): zio.stream.ZStream[Any, AwsError, DescribeDBLogFilesDetails.ReadOnly]
      def describeDBSnapshots(request: DescribeDbSnapshotsRequest): zio.stream.ZStream[Any, AwsError, DBSnapshot.ReadOnly]
      def describeDBParameters(request: DescribeDbParametersRequest): zio.stream.ZStream[Any, AwsError, Parameter.ReadOnly]
      def addTagsToResource(request: AddTagsToResourceRequest): IO[AwsError, scala.Unit]
      def describeDBProxies(request: DescribeDbProxiesRequest): zio.stream.ZStream[Any, AwsError, DBProxy.ReadOnly]
      def describeDBClusterSnapshots(request: DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[Any, AwsError, DBClusterSnapshot.ReadOnly]
      def resetDBClusterParameterGroup(request: ResetDbClusterParameterGroupRequest): IO[AwsError, ResetDbClusterParameterGroupResponse.ReadOnly]
      def describeDBProxyEndpoints(request: DescribeDbProxyEndpointsRequest): zio.stream.ZStream[Any, AwsError, DBProxyEndpoint.ReadOnly]
      def removeSourceIdentifierFromSubscription(request: RemoveSourceIdentifierFromSubscriptionRequest): IO[AwsError, RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly]
      def describeEngineDefaultClusterParameters(request: DescribeEngineDefaultClusterParametersRequest): IO[AwsError, DescribeEngineDefaultClusterParametersResponse.ReadOnly]
      def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[AwsError, CreateDbSubnetGroupResponse.ReadOnly]
      def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): IO[AwsError, CreateDbClusterEndpointResponse.ReadOnly]
      def addRoleToDBCluster(request: AddRoleToDbClusterRequest): IO[AwsError, scala.Unit]
      def copyDBClusterParameterGroup(request: CopyDbClusterParameterGroupRequest): IO[AwsError, CopyDbClusterParameterGroupResponse.ReadOnly]
      def describePendingMaintenanceActions(request: DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[Any, AwsError, ResourcePendingMaintenanceActions.ReadOnly]
      def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): IO[AwsError, DeleteDbClusterEndpointResponse.ReadOnly]
      def addRoleToDBInstance(request: AddRoleToDbInstanceRequest): IO[AwsError, scala.Unit]
      def deleteCustomAvailabilityZone(request: DeleteCustomAvailabilityZoneRequest): IO[AwsError, DeleteCustomAvailabilityZoneResponse.ReadOnly]
      def startActivityStream(request: StartActivityStreamRequest): IO[AwsError, StartActivityStreamResponse.ReadOnly]
      def deleteDBClusterParameterGroup(request: DeleteDbClusterParameterGroupRequest): IO[AwsError, scala.Unit]
      def createDBSecurityGroup(request: CreateDbSecurityGroupRequest): IO[AwsError, CreateDbSecurityGroupResponse.ReadOnly]
      def describeSourceRegions(request: DescribeSourceRegionsRequest): zio.stream.ZStream[Any, AwsError, SourceRegion.ReadOnly]
      def backtrackDBCluster(request: BacktrackDbClusterRequest): IO[AwsError, BacktrackDbClusterResponse.ReadOnly]
      def removeFromGlobalCluster(request: RemoveFromGlobalClusterRequest): IO[AwsError, RemoveFromGlobalClusterResponse.ReadOnly]
      def modifyDBClusterParameterGroup(request: ModifyDbClusterParameterGroupRequest): IO[AwsError, ModifyDbClusterParameterGroupResponse.ReadOnly]
      def cancelExportTask(request: CancelExportTaskRequest): IO[AwsError, CancelExportTaskResponse.ReadOnly]
      def createDBSnapshot(request: CreateDbSnapshotRequest): IO[AwsError, CreateDbSnapshotResponse.ReadOnly]
      def deleteDBInstanceAutomatedBackup(request: DeleteDbInstanceAutomatedBackupRequest): IO[AwsError, DeleteDbInstanceAutomatedBackupResponse.ReadOnly]
      def deleteDBSnapshot(request: DeleteDbSnapshotRequest): IO[AwsError, DeleteDbSnapshotResponse.ReadOnly]
      def stopDBCluster(request: StopDbClusterRequest): IO[AwsError, StopDbClusterResponse.ReadOnly]
      def createDBCluster(request: CreateDbClusterRequest): IO[AwsError, CreateDbClusterResponse.ReadOnly]
      def describeCertificates(request: DescribeCertificatesRequest): zio.stream.ZStream[Any, AwsError, Certificate.ReadOnly]
      def modifyDBSnapshot(request: ModifyDbSnapshotRequest): IO[AwsError, ModifyDbSnapshotResponse.ReadOnly]
      def deleteEventSubscription(request: DeleteEventSubscriptionRequest): IO[AwsError, DeleteEventSubscriptionResponse.ReadOnly]
      def deleteDBSecurityGroup(request: DeleteDbSecurityGroupRequest): IO[AwsError, scala.Unit]
      def deleteDBParameterGroup(request: DeleteDbParameterGroupRequest): IO[AwsError, scala.Unit]
      def describeDBSecurityGroups(request: DescribeDbSecurityGroupsRequest): zio.stream.ZStream[Any, AwsError, DBSecurityGroup.ReadOnly]
      def purchaseReservedDBInstancesOffering(request: PurchaseReservedDbInstancesOfferingRequest): IO[AwsError, PurchaseReservedDbInstancesOfferingResponse.ReadOnly]
      def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): zio.stream.ZStream[Any, AwsError, DBSubnetGroup.ReadOnly]
      def removeRoleFromDBCluster(request: RemoveRoleFromDbClusterRequest): IO[AwsError, scala.Unit]
      def createDBClusterParameterGroup(request: CreateDbClusterParameterGroupRequest): IO[AwsError, CreateDbClusterParameterGroupResponse.ReadOnly]
      def modifyDBCluster(request: ModifyDbClusterRequest): IO[AwsError, ModifyDbClusterResponse.ReadOnly]
      def restoreDBClusterFromS3(request: RestoreDbClusterFromS3Request): IO[AwsError, RestoreDbClusterFromS3Response.ReadOnly]
      def describeValidDBInstanceModifications(request: DescribeValidDbInstanceModificationsRequest): IO[AwsError, DescribeValidDbInstanceModificationsResponse.ReadOnly]
      def createDBProxyEndpoint(request: CreateDbProxyEndpointRequest): IO[AwsError, CreateDbProxyEndpointResponse.ReadOnly]
      def resetDBParameterGroup(request: ResetDbParameterGroupRequest): IO[AwsError, ResetDbParameterGroupResponse.ReadOnly]
      def deleteDBProxyEndpoint(request: DeleteDbProxyEndpointRequest): IO[AwsError, DeleteDbProxyEndpointResponse.ReadOnly]
      def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[AwsError, scala.Unit]
      def describeCustomAvailabilityZones(request: DescribeCustomAvailabilityZonesRequest): zio.stream.ZStream[Any, AwsError, CustomAvailabilityZone.ReadOnly]
      def promoteReadReplica(request: PromoteReadReplicaRequest): IO[AwsError, PromoteReadReplicaResponse.ReadOnly]
      def describeReservedDBInstancesOfferings(request: DescribeReservedDbInstancesOfferingsRequest): zio.stream.ZStream[Any, AwsError, ReservedDBInstancesOffering.ReadOnly]
      def createDBParameterGroup(request: CreateDbParameterGroupRequest): IO[AwsError, CreateDbParameterGroupResponse.ReadOnly]
      def startExportTask(request: StartExportTaskRequest): IO[AwsError, StartExportTaskResponse.ReadOnly]
      def applyPendingMaintenanceAction(request: ApplyPendingMaintenanceActionRequest): IO[AwsError, ApplyPendingMaintenanceActionResponse.ReadOnly]
      def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[AwsError, ModifyDbSubnetGroupResponse.ReadOnly]
      def modifyGlobalCluster(request: ModifyGlobalClusterRequest): IO[AwsError, ModifyGlobalClusterResponse.ReadOnly]
      def copyDBSnapshot(request: CopyDbSnapshotRequest): IO[AwsError, CopyDbSnapshotResponse.ReadOnly]
      def importInstallationMedia(request: ImportInstallationMediaRequest): IO[AwsError, ImportInstallationMediaResponse.ReadOnly]
      def restoreDBClusterFromSnapshot(request: RestoreDbClusterFromSnapshotRequest): IO[AwsError, RestoreDbClusterFromSnapshotResponse.ReadOnly]
      def copyOptionGroup(request: CopyOptionGroupRequest): IO[AwsError, CopyOptionGroupResponse.ReadOnly]
      def restoreDBInstanceFromS3(request: RestoreDbInstanceFromS3Request): IO[AwsError, RestoreDbInstanceFromS3Response.ReadOnly]
      def removeRoleFromDBInstance(request: RemoveRoleFromDbInstanceRequest): IO[AwsError, scala.Unit]
      def describeGlobalClusters(request: DescribeGlobalClustersRequest): zio.stream.ZStream[Any, AwsError, GlobalCluster.ReadOnly]
      def describeDBProxyTargetGroups(request: DescribeDbProxyTargetGroupsRequest): zio.stream.ZStream[Any, AwsError, DBProxyTargetGroup.ReadOnly]
      def describeDBInstanceAutomatedBackups(request: DescribeDbInstanceAutomatedBackupsRequest): zio.stream.ZStream[Any, AwsError, DBInstanceAutomatedBackup.ReadOnly]
      def describeDBClusterParameters(request: DescribeDbClusterParametersRequest): zio.stream.ZStream[Any, AwsError, Parameter.ReadOnly]
      def copyDBParameterGroup(request: CopyDbParameterGroupRequest): IO[AwsError, CopyDbParameterGroupResponse.ReadOnly]
      def modifyDBSnapshotAttribute(request: ModifyDbSnapshotAttributeRequest): IO[AwsError, ModifyDbSnapshotAttributeResponse.ReadOnly]
      def authorizeDBSecurityGroupIngress(request: AuthorizeDbSecurityGroupIngressRequest): IO[AwsError, AuthorizeDbSecurityGroupIngressResponse.ReadOnly]
      def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[AwsError, ModifyEventSubscriptionResponse.ReadOnly]
      def describeDBClusterBacktracks(request: DescribeDbClusterBacktracksRequest): zio.stream.ZStream[Any, AwsError, DBClusterBacktrack.ReadOnly]
      def modifyDBParameterGroup(request: ModifyDbParameterGroupRequest): IO[AwsError, ModifyDbParameterGroupResponse.ReadOnly]
      def modifyCertificates(request: ModifyCertificatesRequest): IO[AwsError, ModifyCertificatesResponse.ReadOnly]
      def createDBInstance(request: CreateDbInstanceRequest): IO[AwsError, CreateDbInstanceResponse.ReadOnly]
      def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): IO[AwsError, DeleteDbClusterSnapshotResponse.ReadOnly]
      def describeExportTasks(request: DescribeExportTasksRequest): zio.stream.ZStream[Any, AwsError, ExportTask.ReadOnly]
      def startDBCluster(request: StartDbClusterRequest): IO[AwsError, StartDbClusterResponse.ReadOnly]
      def modifyDBClusterSnapshotAttribute(request: ModifyDbClusterSnapshotAttributeRequest): IO[AwsError, ModifyDbClusterSnapshotAttributeResponse.ReadOnly]
      def createDBProxy(request: CreateDbProxyRequest): IO[AwsError, CreateDbProxyResponse.ReadOnly]
      def describeDBSnapshotAttributes(request: DescribeDbSnapshotAttributesRequest): IO[AwsError, DescribeDbSnapshotAttributesResponse.ReadOnly]
      def describeEventCategories(request: DescribeEventCategoriesRequest): IO[AwsError, DescribeEventCategoriesResponse.ReadOnly]
      def deleteDBSubnetGroup(request: DeleteDbSubnetGroupRequest): IO[AwsError, scala.Unit]
      def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): IO[AwsError, ModifyDbClusterEndpointResponse.ReadOnly]
      def startDBInstance(request: StartDbInstanceRequest): IO[AwsError, StartDbInstanceResponse.ReadOnly]
      def promoteReadReplicaDBCluster(request: PromoteReadReplicaDbClusterRequest): IO[AwsError, PromoteReadReplicaDbClusterResponse.ReadOnly]
      def registerDBProxyTargets(request: RegisterDbProxyTargetsRequest): IO[AwsError, RegisterDbProxyTargetsResponse.ReadOnly]
      def stopDBInstance(request: StopDbInstanceRequest): IO[AwsError, StopDbInstanceResponse.ReadOnly]
      def modifyDBProxyTargetGroup(request: ModifyDbProxyTargetGroupRequest): IO[AwsError, ModifyDbProxyTargetGroupResponse.ReadOnly]
      def restoreDBInstanceFromDBSnapshot(request: RestoreDbInstanceFromDbSnapshotRequest): IO[AwsError, RestoreDbInstanceFromDbSnapshotResponse.ReadOnly]
      def describeInstallationMedia(request: DescribeInstallationMediaRequest): zio.stream.ZStream[Any, AwsError, InstallationMedia.ReadOnly]
      def rebootDBInstance(request: RebootDbInstanceRequest): IO[AwsError, RebootDbInstanceResponse.ReadOnly]
      def describeOptionGroupOptions(request: DescribeOptionGroupOptionsRequest): zio.stream.ZStream[Any, AwsError, OptionGroupOption.ReadOnly]
      def startDBInstanceAutomatedBackupsReplication(request: StartDbInstanceAutomatedBackupsReplicationRequest): IO[AwsError, StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly]
      def createCustomAvailabilityZone(request: CreateCustomAvailabilityZoneRequest): IO[AwsError, CreateCustomAvailabilityZoneResponse.ReadOnly]
      def describeDBClusterParameterGroups(request: DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, DBClusterParameterGroup.ReadOnly]
      def deleteInstallationMedia(request: DeleteInstallationMediaRequest): IO[AwsError, DeleteInstallationMediaResponse.ReadOnly]
      def restoreDBInstanceToPointInTime(request: RestoreDbInstanceToPointInTimeRequest): IO[AwsError, RestoreDbInstanceToPointInTimeResponse.ReadOnly]
      def createEventSubscription(request: CreateEventSubscriptionRequest): IO[AwsError, CreateEventSubscriptionResponse.ReadOnly]
      def describeOptionGroups(request: DescribeOptionGroupsRequest): zio.stream.ZStream[Any, AwsError, OptionGroup.ReadOnly]
      def listTagsForResource(request: ListTagsForResourceRequest): IO[AwsError, ListTagsForResourceResponse.ReadOnly]
      def restoreDBClusterToPointInTime(request: RestoreDbClusterToPointInTimeRequest): IO[AwsError, RestoreDbClusterToPointInTimeResponse.ReadOnly]
      def describeDBProxyTargets(request: DescribeDbProxyTargetsRequest): zio.stream.ZStream[Any, AwsError, DBProxyTarget.ReadOnly]
      def describeDBClusters(request: DescribeDbClustersRequest): zio.stream.ZStream[Any, AwsError, DBCluster.ReadOnly]
      def failoverDBCluster(request: FailoverDbClusterRequest): IO[AwsError, FailoverDbClusterResponse.ReadOnly]
      def deleteOptionGroup(request: DeleteOptionGroupRequest): IO[AwsError, scala.Unit]
      def describeEventSubscriptions(request: DescribeEventSubscriptionsRequest): zio.stream.ZStream[Any, AwsError, EventSubscription.ReadOnly]
      def describeDBInstances(request: DescribeDbInstancesRequest): zio.stream.ZStream[Any, AwsError, DBInstance.ReadOnly]
      def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): IO[AwsError, CreateDbClusterSnapshotResponse.ReadOnly]
      def modifyCurrentDBClusterCapacity(request: ModifyCurrentDbClusterCapacityRequest): IO[AwsError, ModifyCurrentDbClusterCapacityResponse.ReadOnly]
      def deleteDBCluster(request: DeleteDbClusterRequest): IO[AwsError, DeleteDbClusterResponse.ReadOnly]
      def deleteGlobalCluster(request: DeleteGlobalClusterRequest): IO[AwsError, DeleteGlobalClusterResponse.ReadOnly]
      def describeReservedDBInstances(request: DescribeReservedDbInstancesRequest): zio.stream.ZStream[Any, AwsError, ReservedDBInstance.ReadOnly]
      def createDBInstanceReadReplica(request: CreateDbInstanceReadReplicaRequest): IO[AwsError, CreateDbInstanceReadReplicaResponse.ReadOnly]
      def deleteDBInstance(request: DeleteDbInstanceRequest): IO[AwsError, DeleteDbInstanceResponse.ReadOnly]
      def createOptionGroup(request: CreateOptionGroupRequest): IO[AwsError, CreateOptionGroupResponse.ReadOnly]
      def deregisterDBProxyTargets(request: DeregisterDbProxyTargetsRequest): IO[AwsError, DeregisterDbProxyTargetsResponse.ReadOnly]
      def modifyDBProxyEndpoint(request: ModifyDbProxyEndpointRequest): IO[AwsError, ModifyDbProxyEndpointResponse.ReadOnly]
      def addSourceIdentifierToSubscription(request: AddSourceIdentifierToSubscriptionRequest): IO[AwsError, AddSourceIdentifierToSubscriptionResponse.ReadOnly]
      def modifyDBProxy(request: ModifyDbProxyRequest): IO[AwsError, ModifyDbProxyResponse.ReadOnly]
      def modifyOptionGroup(request: ModifyOptionGroupRequest): IO[AwsError, ModifyOptionGroupResponse.ReadOnly]
      def describeDBEngineVersions(request: DescribeDbEngineVersionsRequest): zio.stream.ZStream[Any, AwsError, DBEngineVersion.ReadOnly]
      def describeAccountAttributes(request: DescribeAccountAttributesRequest): IO[AwsError, DescribeAccountAttributesResponse.ReadOnly]
      def createGlobalCluster(request: CreateGlobalClusterRequest): IO[AwsError, CreateGlobalClusterResponse.ReadOnly]
      def describeOrderableDBInstanceOptions(request: DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[Any, AwsError, OrderableDBInstanceOption.ReadOnly]
      def revokeDBSecurityGroupIngress(request: RevokeDbSecurityGroupIngressRequest): IO[AwsError, RevokeDbSecurityGroupIngressResponse.ReadOnly]
      def describeDBClusterSnapshotAttributes(request: DescribeDbClusterSnapshotAttributesRequest): IO[AwsError, DescribeDbClusterSnapshotAttributesResponse.ReadOnly]
      def stopDBInstanceAutomatedBackupsReplication(request: StopDbInstanceAutomatedBackupsReplicationRequest): IO[AwsError, StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly]
      def describeEvents(request: DescribeEventsRequest): zio.stream.ZStream[Any, AwsError, Event.ReadOnly]
      def describeDBParameterGroups(request: DescribeDbParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, DBParameterGroup.ReadOnly]
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Rds] = customized(identity)
  def customized(customization: RdsAsyncClientBuilder => RdsAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Rds] = managed(customization).toLayer
  def managed(customization: RdsAsyncClientBuilder => RdsAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Rds.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; b0 <- awsConfig.configure[RdsAsyncClient, RdsAsyncClientBuilder](RdsAsyncClient.builder()).toManaged_; b1 <- awsConfig.configureHttpClient[RdsAsyncClient, RdsAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new RdsImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class RdsImpl[R](override val api: RdsAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Rds.Service with AwsServiceBase[R, RdsImpl] {
    override val serviceName: String = "Rds"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): RdsImpl[R1] = new RdsImpl(api, newAspect, r)
    def downloadDBLogFilePortion(request: DownloadDbLogFilePortionRequest): IO[AwsError, DownloadDbLogFilePortionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest, software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionResponse]("downloadDBLogFilePortion", api.downloadDBLogFilePortion)(request.buildAwsValue()).map(DownloadDbLogFilePortionResponse.wrap).provide(r)
    def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): IO[AwsError, CopyDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotRequest, software.amazon.awssdk.services.rds.model.CopyDbClusterSnapshotResponse]("copyDBClusterSnapshot", api.copyDBClusterSnapshot)(request.buildAwsValue()).map(CopyDbClusterSnapshotResponse.wrap).provide(r)
    def describeEngineDefaultParameters(request: DescribeEngineDefaultParametersRequest): IO[AwsError, DescribeEngineDefaultParametersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersRequest, software.amazon.awssdk.services.rds.model.DescribeEngineDefaultParametersResponse]("describeEngineDefaultParameters", api.describeEngineDefaultParameters)(request.buildAwsValue()).map(DescribeEngineDefaultParametersResponse.wrap).provide(r)
    def modifyDBInstance(request: ModifyDbInstanceRequest): IO[AwsError, ModifyDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbInstanceRequest, software.amazon.awssdk.services.rds.model.ModifyDbInstanceResponse]("modifyDBInstance", api.modifyDBInstance)(request.buildAwsValue()).map(ModifyDbInstanceResponse.wrap).provide(r)
    def deleteDBProxy(request: DeleteDbProxyRequest): IO[AwsError, DeleteDbProxyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbProxyRequest, software.amazon.awssdk.services.rds.model.DeleteDbProxyResponse]("deleteDBProxy", api.deleteDBProxy)(request.buildAwsValue()).map(DeleteDbProxyResponse.wrap).provide(r)
    def describeDBClusterEndpoints(request: DescribeDbClusterEndpointsRequest): zio.stream.ZStream[Any, AwsError, DBClusterEndpoint.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClusterEndpointsRequest, software.amazon.awssdk.services.rds.model.DBClusterEndpoint, software.amazon.awssdk.services.rds.paginators.DescribeDBClusterEndpointsPublisher]("describeDBClusterEndpoints", api.describeDBClusterEndpointsPaginator, _.dbClusterEndpoints())(request.buildAwsValue()).map(item => DBClusterEndpoint.wrap(item)).provide(r)
    def stopActivityStream(request: StopActivityStreamRequest): IO[AwsError, StopActivityStreamResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StopActivityStreamRequest, software.amazon.awssdk.services.rds.model.StopActivityStreamResponse]("stopActivityStream", api.stopActivityStream)(request.buildAwsValue()).map(StopActivityStreamResponse.wrap).provide(r)
    def failoverGlobalCluster(request: FailoverGlobalClusterRequest): IO[AwsError, FailoverGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.FailoverGlobalClusterRequest, software.amazon.awssdk.services.rds.model.FailoverGlobalClusterResponse]("failoverGlobalCluster", api.failoverGlobalCluster)(request.buildAwsValue()).map(FailoverGlobalClusterResponse.wrap).provide(r)
    def describeDBLogFiles(request: DescribeDbLogFilesRequest): zio.stream.ZStream[Any, AwsError, DescribeDBLogFilesDetails.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest, software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails, software.amazon.awssdk.services.rds.paginators.DescribeDBLogFilesPublisher]("describeDBLogFiles", api.describeDBLogFilesPaginator, _.describeDBLogFiles())(request.buildAwsValue()).map(item => DescribeDBLogFilesDetails.wrap(item)).provide(r)
    def describeDBSnapshots(request: DescribeDbSnapshotsRequest): zio.stream.ZStream[Any, AwsError, DBSnapshot.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotsRequest, software.amazon.awssdk.services.rds.model.DBSnapshot, software.amazon.awssdk.services.rds.paginators.DescribeDBSnapshotsPublisher]("describeDBSnapshots", api.describeDBSnapshotsPaginator, _.dbSnapshots())(request.buildAwsValue()).map(item => DBSnapshot.wrap(item)).provide(r)
    def describeDBParameters(request: DescribeDbParametersRequest): zio.stream.ZStream[Any, AwsError, Parameter.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest, software.amazon.awssdk.services.rds.model.Parameter, software.amazon.awssdk.services.rds.paginators.DescribeDBParametersPublisher]("describeDBParameters", api.describeDBParametersPaginator, _.parameters())(request.buildAwsValue()).map(item => Parameter.wrap(item)).provide(r)
    def addTagsToResource(request: AddTagsToResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.AddTagsToResourceRequest, software.amazon.awssdk.services.rds.model.AddTagsToResourceResponse]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue()).unit.provide(r)
    def describeDBProxies(request: DescribeDbProxiesRequest): zio.stream.ZStream[Any, AwsError, DBProxy.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbProxiesRequest, software.amazon.awssdk.services.rds.model.DBProxy, software.amazon.awssdk.services.rds.paginators.DescribeDBProxiesPublisher]("describeDBProxies", api.describeDBProxiesPaginator, _.dbProxies())(request.buildAwsValue()).map(item => DBProxy.wrap(item)).provide(r)
    def describeDBClusterSnapshots(request: DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[Any, AwsError, DBClusterSnapshot.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest, software.amazon.awssdk.services.rds.model.DBClusterSnapshot, software.amazon.awssdk.services.rds.paginators.DescribeDBClusterSnapshotsPublisher]("describeDBClusterSnapshots", api.describeDBClusterSnapshotsPaginator, _.dbClusterSnapshots())(request.buildAwsValue()).map(item => DBClusterSnapshot.wrap(item)).provide(r)
    def resetDBClusterParameterGroup(request: ResetDbClusterParameterGroupRequest): IO[AwsError, ResetDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest, software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupResponse]("resetDBClusterParameterGroup", api.resetDBClusterParameterGroup)(request.buildAwsValue()).map(ResetDbClusterParameterGroupResponse.wrap).provide(r)
    def describeDBProxyEndpoints(request: DescribeDbProxyEndpointsRequest): zio.stream.ZStream[Any, AwsError, DBProxyEndpoint.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbProxyEndpointsRequest, software.amazon.awssdk.services.rds.model.DBProxyEndpoint, software.amazon.awssdk.services.rds.paginators.DescribeDBProxyEndpointsPublisher]("describeDBProxyEndpoints", api.describeDBProxyEndpointsPaginator, _.dbProxyEndpoints())(request.buildAwsValue()).map(item => DBProxyEndpoint.wrap(item)).provide(r)
    def removeSourceIdentifierFromSubscription(request: RemoveSourceIdentifierFromSubscriptionRequest): IO[AwsError, RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest, software.amazon.awssdk.services.rds.model.RemoveSourceIdentifierFromSubscriptionResponse]("removeSourceIdentifierFromSubscription", api.removeSourceIdentifierFromSubscription)(request.buildAwsValue()).map(RemoveSourceIdentifierFromSubscriptionResponse.wrap).provide(r)
    def describeEngineDefaultClusterParameters(request: DescribeEngineDefaultClusterParametersRequest): IO[AwsError, DescribeEngineDefaultClusterParametersResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersRequest, software.amazon.awssdk.services.rds.model.DescribeEngineDefaultClusterParametersResponse]("describeEngineDefaultClusterParameters", api.describeEngineDefaultClusterParameters)(request.buildAwsValue()).map(DescribeEngineDefaultClusterParametersResponse.wrap).provide(r)
    def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[AwsError, CreateDbSubnetGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupRequest, software.amazon.awssdk.services.rds.model.CreateDbSubnetGroupResponse]("createDBSubnetGroup", api.createDBSubnetGroup)(request.buildAwsValue()).map(CreateDbSubnetGroupResponse.wrap).provide(r)
    def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): IO[AwsError, CreateDbClusterEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointRequest, software.amazon.awssdk.services.rds.model.CreateDbClusterEndpointResponse]("createDBClusterEndpoint", api.createDBClusterEndpoint)(request.buildAwsValue()).map(CreateDbClusterEndpointResponse.wrap).provide(r)
    def addRoleToDBCluster(request: AddRoleToDbClusterRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest, software.amazon.awssdk.services.rds.model.AddRoleToDbClusterResponse]("addRoleToDBCluster", api.addRoleToDBCluster)(request.buildAwsValue()).unit.provide(r)
    def copyDBClusterParameterGroup(request: CopyDbClusterParameterGroupRequest): IO[AwsError, CopyDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupRequest, software.amazon.awssdk.services.rds.model.CopyDbClusterParameterGroupResponse]("copyDBClusterParameterGroup", api.copyDBClusterParameterGroup)(request.buildAwsValue()).map(CopyDbClusterParameterGroupResponse.wrap).provide(r)
    def describePendingMaintenanceActions(request: DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[Any, AwsError, ResourcePendingMaintenanceActions.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribePendingMaintenanceActionsRequest, software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions, software.amazon.awssdk.services.rds.paginators.DescribePendingMaintenanceActionsPublisher]("describePendingMaintenanceActions", api.describePendingMaintenanceActionsPaginator, _.pendingMaintenanceActions())(request.buildAwsValue()).map(item => ResourcePendingMaintenanceActions.wrap(item)).provide(r)
    def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): IO[AwsError, DeleteDbClusterEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointRequest, software.amazon.awssdk.services.rds.model.DeleteDbClusterEndpointResponse]("deleteDBClusterEndpoint", api.deleteDBClusterEndpoint)(request.buildAwsValue()).map(DeleteDbClusterEndpointResponse.wrap).provide(r)
    def addRoleToDBInstance(request: AddRoleToDbInstanceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceRequest, software.amazon.awssdk.services.rds.model.AddRoleToDbInstanceResponse]("addRoleToDBInstance", api.addRoleToDBInstance)(request.buildAwsValue()).unit.provide(r)
    def deleteCustomAvailabilityZone(request: DeleteCustomAvailabilityZoneRequest): IO[AwsError, DeleteCustomAvailabilityZoneResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneRequest, software.amazon.awssdk.services.rds.model.DeleteCustomAvailabilityZoneResponse]("deleteCustomAvailabilityZone", api.deleteCustomAvailabilityZone)(request.buildAwsValue()).map(DeleteCustomAvailabilityZoneResponse.wrap).provide(r)
    def startActivityStream(request: StartActivityStreamRequest): IO[AwsError, StartActivityStreamResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StartActivityStreamRequest, software.amazon.awssdk.services.rds.model.StartActivityStreamResponse]("startActivityStream", api.startActivityStream)(request.buildAwsValue()).map(StartActivityStreamResponse.wrap).provide(r)
    def deleteDBClusterParameterGroup(request: DeleteDbClusterParameterGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupRequest, software.amazon.awssdk.services.rds.model.DeleteDbClusterParameterGroupResponse]("deleteDBClusterParameterGroup", api.deleteDBClusterParameterGroup)(request.buildAwsValue()).unit.provide(r)
    def createDBSecurityGroup(request: CreateDbSecurityGroupRequest): IO[AwsError, CreateDbSecurityGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupRequest, software.amazon.awssdk.services.rds.model.CreateDbSecurityGroupResponse]("createDBSecurityGroup", api.createDBSecurityGroup)(request.buildAwsValue()).map(CreateDbSecurityGroupResponse.wrap).provide(r)
    def describeSourceRegions(request: DescribeSourceRegionsRequest): zio.stream.ZStream[Any, AwsError, SourceRegion.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeSourceRegionsRequest, software.amazon.awssdk.services.rds.model.SourceRegion, software.amazon.awssdk.services.rds.paginators.DescribeSourceRegionsPublisher]("describeSourceRegions", api.describeSourceRegionsPaginator, _.sourceRegions())(request.buildAwsValue()).map(item => SourceRegion.wrap(item)).provide(r)
    def backtrackDBCluster(request: BacktrackDbClusterRequest): IO[AwsError, BacktrackDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.BacktrackDbClusterRequest, software.amazon.awssdk.services.rds.model.BacktrackDbClusterResponse]("backtrackDBCluster", api.backtrackDBCluster)(request.buildAwsValue()).map(BacktrackDbClusterResponse.wrap).provide(r)
    def removeFromGlobalCluster(request: RemoveFromGlobalClusterRequest): IO[AwsError, RemoveFromGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterRequest, software.amazon.awssdk.services.rds.model.RemoveFromGlobalClusterResponse]("removeFromGlobalCluster", api.removeFromGlobalCluster)(request.buildAwsValue()).map(RemoveFromGlobalClusterResponse.wrap).provide(r)
    def modifyDBClusterParameterGroup(request: ModifyDbClusterParameterGroupRequest): IO[AwsError, ModifyDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupRequest, software.amazon.awssdk.services.rds.model.ModifyDbClusterParameterGroupResponse]("modifyDBClusterParameterGroup", api.modifyDBClusterParameterGroup)(request.buildAwsValue()).map(ModifyDbClusterParameterGroupResponse.wrap).provide(r)
    def cancelExportTask(request: CancelExportTaskRequest): IO[AwsError, CancelExportTaskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CancelExportTaskRequest, software.amazon.awssdk.services.rds.model.CancelExportTaskResponse]("cancelExportTask", api.cancelExportTask)(request.buildAwsValue()).map(CancelExportTaskResponse.wrap).provide(r)
    def createDBSnapshot(request: CreateDbSnapshotRequest): IO[AwsError, CreateDbSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbSnapshotRequest, software.amazon.awssdk.services.rds.model.CreateDbSnapshotResponse]("createDBSnapshot", api.createDBSnapshot)(request.buildAwsValue()).map(CreateDbSnapshotResponse.wrap).provide(r)
    def deleteDBInstanceAutomatedBackup(request: DeleteDbInstanceAutomatedBackupRequest): IO[AwsError, DeleteDbInstanceAutomatedBackupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupRequest, software.amazon.awssdk.services.rds.model.DeleteDbInstanceAutomatedBackupResponse]("deleteDBInstanceAutomatedBackup", api.deleteDBInstanceAutomatedBackup)(request.buildAwsValue()).map(DeleteDbInstanceAutomatedBackupResponse.wrap).provide(r)
    def deleteDBSnapshot(request: DeleteDbSnapshotRequest): IO[AwsError, DeleteDbSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbSnapshotRequest, software.amazon.awssdk.services.rds.model.DeleteDbSnapshotResponse]("deleteDBSnapshot", api.deleteDBSnapshot)(request.buildAwsValue()).map(DeleteDbSnapshotResponse.wrap).provide(r)
    def stopDBCluster(request: StopDbClusterRequest): IO[AwsError, StopDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StopDbClusterRequest, software.amazon.awssdk.services.rds.model.StopDbClusterResponse]("stopDBCluster", api.stopDBCluster)(request.buildAwsValue()).map(StopDbClusterResponse.wrap).provide(r)
    def createDBCluster(request: CreateDbClusterRequest): IO[AwsError, CreateDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbClusterRequest, software.amazon.awssdk.services.rds.model.CreateDbClusterResponse]("createDBCluster", api.createDBCluster)(request.buildAwsValue()).map(CreateDbClusterResponse.wrap).provide(r)
    def describeCertificates(request: DescribeCertificatesRequest): zio.stream.ZStream[Any, AwsError, Certificate.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeCertificatesRequest, software.amazon.awssdk.services.rds.model.Certificate, software.amazon.awssdk.services.rds.paginators.DescribeCertificatesPublisher]("describeCertificates", api.describeCertificatesPaginator, _.certificates())(request.buildAwsValue()).map(item => Certificate.wrap(item)).provide(r)
    def modifyDBSnapshot(request: ModifyDbSnapshotRequest): IO[AwsError, ModifyDbSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotRequest, software.amazon.awssdk.services.rds.model.ModifyDbSnapshotResponse]("modifyDBSnapshot", api.modifyDBSnapshot)(request.buildAwsValue()).map(ModifyDbSnapshotResponse.wrap).provide(r)
    def deleteEventSubscription(request: DeleteEventSubscriptionRequest): IO[AwsError, DeleteEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionRequest, software.amazon.awssdk.services.rds.model.DeleteEventSubscriptionResponse]("deleteEventSubscription", api.deleteEventSubscription)(request.buildAwsValue()).map(DeleteEventSubscriptionResponse.wrap).provide(r)
    def deleteDBSecurityGroup(request: DeleteDbSecurityGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupRequest, software.amazon.awssdk.services.rds.model.DeleteDbSecurityGroupResponse]("deleteDBSecurityGroup", api.deleteDBSecurityGroup)(request.buildAwsValue()).unit.provide(r)
    def deleteDBParameterGroup(request: DeleteDbParameterGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupRequest, software.amazon.awssdk.services.rds.model.DeleteDbParameterGroupResponse]("deleteDBParameterGroup", api.deleteDBParameterGroup)(request.buildAwsValue()).unit.provide(r)
    def describeDBSecurityGroups(request: DescribeDbSecurityGroupsRequest): zio.stream.ZStream[Any, AwsError, DBSecurityGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbSecurityGroupsRequest, software.amazon.awssdk.services.rds.model.DBSecurityGroup, software.amazon.awssdk.services.rds.paginators.DescribeDBSecurityGroupsPublisher]("describeDBSecurityGroups", api.describeDBSecurityGroupsPaginator, _.dbSecurityGroups())(request.buildAwsValue()).map(item => DBSecurityGroup.wrap(item)).provide(r)
    def purchaseReservedDBInstancesOffering(request: PurchaseReservedDbInstancesOfferingRequest): IO[AwsError, PurchaseReservedDbInstancesOfferingResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest, software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingResponse]("purchaseReservedDBInstancesOffering", api.purchaseReservedDBInstancesOffering)(request.buildAwsValue()).map(PurchaseReservedDbInstancesOfferingResponse.wrap).provide(r)
    def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): zio.stream.ZStream[Any, AwsError, DBSubnetGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest, software.amazon.awssdk.services.rds.model.DBSubnetGroup, software.amazon.awssdk.services.rds.paginators.DescribeDBSubnetGroupsPublisher]("describeDBSubnetGroups", api.describeDBSubnetGroupsPaginator, _.dbSubnetGroups())(request.buildAwsValue()).map(item => DBSubnetGroup.wrap(item)).provide(r)
    def removeRoleFromDBCluster(request: RemoveRoleFromDbClusterRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest, software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterResponse]("removeRoleFromDBCluster", api.removeRoleFromDBCluster)(request.buildAwsValue()).unit.provide(r)
    def createDBClusterParameterGroup(request: CreateDbClusterParameterGroupRequest): IO[AwsError, CreateDbClusterParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupRequest, software.amazon.awssdk.services.rds.model.CreateDbClusterParameterGroupResponse]("createDBClusterParameterGroup", api.createDBClusterParameterGroup)(request.buildAwsValue()).map(CreateDbClusterParameterGroupResponse.wrap).provide(r)
    def modifyDBCluster(request: ModifyDbClusterRequest): IO[AwsError, ModifyDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest, software.amazon.awssdk.services.rds.model.ModifyDbClusterResponse]("modifyDBCluster", api.modifyDBCluster)(request.buildAwsValue()).map(ModifyDbClusterResponse.wrap).provide(r)
    def restoreDBClusterFromS3(request: RestoreDbClusterFromS3Request): IO[AwsError, RestoreDbClusterFromS3Response.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request, software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Response]("restoreDBClusterFromS3", api.restoreDBClusterFromS3)(request.buildAwsValue()).map(RestoreDbClusterFromS3Response.wrap).provide(r)
    def describeValidDBInstanceModifications(request: DescribeValidDbInstanceModificationsRequest): IO[AwsError, DescribeValidDbInstanceModificationsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsRequest, software.amazon.awssdk.services.rds.model.DescribeValidDbInstanceModificationsResponse]("describeValidDBInstanceModifications", api.describeValidDBInstanceModifications)(request.buildAwsValue()).map(DescribeValidDbInstanceModificationsResponse.wrap).provide(r)
    def createDBProxyEndpoint(request: CreateDbProxyEndpointRequest): IO[AwsError, CreateDbProxyEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointRequest, software.amazon.awssdk.services.rds.model.CreateDbProxyEndpointResponse]("createDBProxyEndpoint", api.createDBProxyEndpoint)(request.buildAwsValue()).map(CreateDbProxyEndpointResponse.wrap).provide(r)
    def resetDBParameterGroup(request: ResetDbParameterGroupRequest): IO[AwsError, ResetDbParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ResetDbParameterGroupRequest, software.amazon.awssdk.services.rds.model.ResetDbParameterGroupResponse]("resetDBParameterGroup", api.resetDBParameterGroup)(request.buildAwsValue()).map(ResetDbParameterGroupResponse.wrap).provide(r)
    def deleteDBProxyEndpoint(request: DeleteDbProxyEndpointRequest): IO[AwsError, DeleteDbProxyEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointRequest, software.amazon.awssdk.services.rds.model.DeleteDbProxyEndpointResponse]("deleteDBProxyEndpoint", api.deleteDBProxyEndpoint)(request.buildAwsValue()).map(DeleteDbProxyEndpointResponse.wrap).provide(r)
    def removeTagsFromResource(request: RemoveTagsFromResourceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest, software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceResponse]("removeTagsFromResource", api.removeTagsFromResource)(request.buildAwsValue()).unit.provide(r)
    def describeCustomAvailabilityZones(request: DescribeCustomAvailabilityZonesRequest): zio.stream.ZStream[Any, AwsError, CustomAvailabilityZone.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest, software.amazon.awssdk.services.rds.model.CustomAvailabilityZone, software.amazon.awssdk.services.rds.paginators.DescribeCustomAvailabilityZonesPublisher]("describeCustomAvailabilityZones", api.describeCustomAvailabilityZonesPaginator, _.customAvailabilityZones())(request.buildAwsValue()).map(item => CustomAvailabilityZone.wrap(item)).provide(r)
    def promoteReadReplica(request: PromoteReadReplicaRequest): IO[AwsError, PromoteReadReplicaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest, software.amazon.awssdk.services.rds.model.PromoteReadReplicaResponse]("promoteReadReplica", api.promoteReadReplica)(request.buildAwsValue()).map(PromoteReadReplicaResponse.wrap).provide(r)
    def describeReservedDBInstancesOfferings(request: DescribeReservedDbInstancesOfferingsRequest): zio.stream.ZStream[Any, AwsError, ReservedDBInstancesOffering.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesOfferingsRequest, software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering, software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesOfferingsPublisher]("describeReservedDBInstancesOfferings", api.describeReservedDBInstancesOfferingsPaginator, _.reservedDBInstancesOfferings())(request.buildAwsValue()).map(item => ReservedDBInstancesOffering.wrap(item)).provide(r)
    def createDBParameterGroup(request: CreateDbParameterGroupRequest): IO[AwsError, CreateDbParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbParameterGroupRequest, software.amazon.awssdk.services.rds.model.CreateDbParameterGroupResponse]("createDBParameterGroup", api.createDBParameterGroup)(request.buildAwsValue()).map(CreateDbParameterGroupResponse.wrap).provide(r)
    def startExportTask(request: StartExportTaskRequest): IO[AwsError, StartExportTaskResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StartExportTaskRequest, software.amazon.awssdk.services.rds.model.StartExportTaskResponse]("startExportTask", api.startExportTask)(request.buildAwsValue()).map(StartExportTaskResponse.wrap).provide(r)
    def applyPendingMaintenanceAction(request: ApplyPendingMaintenanceActionRequest): IO[AwsError, ApplyPendingMaintenanceActionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionRequest, software.amazon.awssdk.services.rds.model.ApplyPendingMaintenanceActionResponse]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(request.buildAwsValue()).map(ApplyPendingMaintenanceActionResponse.wrap).provide(r)
    def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[AwsError, ModifyDbSubnetGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupRequest, software.amazon.awssdk.services.rds.model.ModifyDbSubnetGroupResponse]("modifyDBSubnetGroup", api.modifyDBSubnetGroup)(request.buildAwsValue()).map(ModifyDbSubnetGroupResponse.wrap).provide(r)
    def modifyGlobalCluster(request: ModifyGlobalClusterRequest): IO[AwsError, ModifyGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyGlobalClusterRequest, software.amazon.awssdk.services.rds.model.ModifyGlobalClusterResponse]("modifyGlobalCluster", api.modifyGlobalCluster)(request.buildAwsValue()).map(ModifyGlobalClusterResponse.wrap).provide(r)
    def copyDBSnapshot(request: CopyDbSnapshotRequest): IO[AwsError, CopyDbSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CopyDbSnapshotRequest, software.amazon.awssdk.services.rds.model.CopyDbSnapshotResponse]("copyDBSnapshot", api.copyDBSnapshot)(request.buildAwsValue()).map(CopyDbSnapshotResponse.wrap).provide(r)
    def importInstallationMedia(request: ImportInstallationMediaRequest): IO[AwsError, ImportInstallationMediaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ImportInstallationMediaRequest, software.amazon.awssdk.services.rds.model.ImportInstallationMediaResponse]("importInstallationMedia", api.importInstallationMedia)(request.buildAwsValue()).map(ImportInstallationMediaResponse.wrap).provide(r)
    def restoreDBClusterFromSnapshot(request: RestoreDbClusterFromSnapshotRequest): IO[AwsError, RestoreDbClusterFromSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest, software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotResponse]("restoreDBClusterFromSnapshot", api.restoreDBClusterFromSnapshot)(request.buildAwsValue()).map(RestoreDbClusterFromSnapshotResponse.wrap).provide(r)
    def copyOptionGroup(request: CopyOptionGroupRequest): IO[AwsError, CopyOptionGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest, software.amazon.awssdk.services.rds.model.CopyOptionGroupResponse]("copyOptionGroup", api.copyOptionGroup)(request.buildAwsValue()).map(CopyOptionGroupResponse.wrap).provide(r)
    def restoreDBInstanceFromS3(request: RestoreDbInstanceFromS3Request): IO[AwsError, RestoreDbInstanceFromS3Response.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request, software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Response]("restoreDBInstanceFromS3", api.restoreDBInstanceFromS3)(request.buildAwsValue()).map(RestoreDbInstanceFromS3Response.wrap).provide(r)
    def removeRoleFromDBInstance(request: RemoveRoleFromDbInstanceRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceRequest, software.amazon.awssdk.services.rds.model.RemoveRoleFromDbInstanceResponse]("removeRoleFromDBInstance", api.removeRoleFromDBInstance)(request.buildAwsValue()).unit.provide(r)
    def describeGlobalClusters(request: DescribeGlobalClustersRequest): zio.stream.ZStream[Any, AwsError, GlobalCluster.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeGlobalClustersRequest, software.amazon.awssdk.services.rds.model.GlobalCluster, software.amazon.awssdk.services.rds.paginators.DescribeGlobalClustersPublisher]("describeGlobalClusters", api.describeGlobalClustersPaginator, _.globalClusters())(request.buildAwsValue()).map(item => GlobalCluster.wrap(item)).provide(r)
    def describeDBProxyTargetGroups(request: DescribeDbProxyTargetGroupsRequest): zio.stream.ZStream[Any, AwsError, DBProxyTargetGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetGroupsRequest, software.amazon.awssdk.services.rds.model.DBProxyTargetGroup, software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetGroupsPublisher]("describeDBProxyTargetGroups", api.describeDBProxyTargetGroupsPaginator, _.targetGroups())(request.buildAwsValue()).map(item => DBProxyTargetGroup.wrap(item)).provide(r)
    def describeDBInstanceAutomatedBackups(request: DescribeDbInstanceAutomatedBackupsRequest): zio.stream.ZStream[Any, AwsError, DBInstanceAutomatedBackup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbInstanceAutomatedBackupsRequest, software.amazon.awssdk.services.rds.model.DBInstanceAutomatedBackup, software.amazon.awssdk.services.rds.paginators.DescribeDBInstanceAutomatedBackupsPublisher]("describeDBInstanceAutomatedBackups", api.describeDBInstanceAutomatedBackupsPaginator, _.dbInstanceAutomatedBackups())(request.buildAwsValue()).map(item => DBInstanceAutomatedBackup.wrap(item)).provide(r)
    def describeDBClusterParameters(request: DescribeDbClusterParametersRequest): zio.stream.ZStream[Any, AwsError, Parameter.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClusterParametersRequest, software.amazon.awssdk.services.rds.model.Parameter, software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParametersPublisher]("describeDBClusterParameters", api.describeDBClusterParametersPaginator, _.parameters())(request.buildAwsValue()).map(item => Parameter.wrap(item)).provide(r)
    def copyDBParameterGroup(request: CopyDbParameterGroupRequest): IO[AwsError, CopyDbParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CopyDbParameterGroupRequest, software.amazon.awssdk.services.rds.model.CopyDbParameterGroupResponse]("copyDBParameterGroup", api.copyDBParameterGroup)(request.buildAwsValue()).map(CopyDbParameterGroupResponse.wrap).provide(r)
    def modifyDBSnapshotAttribute(request: ModifyDbSnapshotAttributeRequest): IO[AwsError, ModifyDbSnapshotAttributeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest, software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeResponse]("modifyDBSnapshotAttribute", api.modifyDBSnapshotAttribute)(request.buildAwsValue()).map(ModifyDbSnapshotAttributeResponse.wrap).provide(r)
    def authorizeDBSecurityGroupIngress(request: AuthorizeDbSecurityGroupIngressRequest): IO[AwsError, AuthorizeDbSecurityGroupIngressResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressRequest, software.amazon.awssdk.services.rds.model.AuthorizeDbSecurityGroupIngressResponse]("authorizeDBSecurityGroupIngress", api.authorizeDBSecurityGroupIngress)(request.buildAwsValue()).map(AuthorizeDbSecurityGroupIngressResponse.wrap).provide(r)
    def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[AwsError, ModifyEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionRequest, software.amazon.awssdk.services.rds.model.ModifyEventSubscriptionResponse]("modifyEventSubscription", api.modifyEventSubscription)(request.buildAwsValue()).map(ModifyEventSubscriptionResponse.wrap).provide(r)
    def describeDBClusterBacktracks(request: DescribeDbClusterBacktracksRequest): zio.stream.ZStream[Any, AwsError, DBClusterBacktrack.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClusterBacktracksRequest, software.amazon.awssdk.services.rds.model.DBClusterBacktrack, software.amazon.awssdk.services.rds.paginators.DescribeDBClusterBacktracksPublisher]("describeDBClusterBacktracks", api.describeDBClusterBacktracksPaginator, _.dbClusterBacktracks())(request.buildAwsValue()).map(item => DBClusterBacktrack.wrap(item)).provide(r)
    def modifyDBParameterGroup(request: ModifyDbParameterGroupRequest): IO[AwsError, ModifyDbParameterGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupRequest, software.amazon.awssdk.services.rds.model.ModifyDbParameterGroupResponse]("modifyDBParameterGroup", api.modifyDBParameterGroup)(request.buildAwsValue()).map(ModifyDbParameterGroupResponse.wrap).provide(r)
    def modifyCertificates(request: ModifyCertificatesRequest): IO[AwsError, ModifyCertificatesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyCertificatesRequest, software.amazon.awssdk.services.rds.model.ModifyCertificatesResponse]("modifyCertificates", api.modifyCertificates)(request.buildAwsValue()).map(ModifyCertificatesResponse.wrap).provide(r)
    def createDBInstance(request: CreateDbInstanceRequest): IO[AwsError, CreateDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbInstanceRequest, software.amazon.awssdk.services.rds.model.CreateDbInstanceResponse]("createDBInstance", api.createDBInstance)(request.buildAwsValue()).map(CreateDbInstanceResponse.wrap).provide(r)
    def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): IO[AwsError, DeleteDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotRequest, software.amazon.awssdk.services.rds.model.DeleteDbClusterSnapshotResponse]("deleteDBClusterSnapshot", api.deleteDBClusterSnapshot)(request.buildAwsValue()).map(DeleteDbClusterSnapshotResponse.wrap).provide(r)
    def describeExportTasks(request: DescribeExportTasksRequest): zio.stream.ZStream[Any, AwsError, ExportTask.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeExportTasksRequest, software.amazon.awssdk.services.rds.model.ExportTask, software.amazon.awssdk.services.rds.paginators.DescribeExportTasksPublisher]("describeExportTasks", api.describeExportTasksPaginator, _.exportTasks())(request.buildAwsValue()).map(item => ExportTask.wrap(item)).provide(r)
    def startDBCluster(request: StartDbClusterRequest): IO[AwsError, StartDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StartDbClusterRequest, software.amazon.awssdk.services.rds.model.StartDbClusterResponse]("startDBCluster", api.startDBCluster)(request.buildAwsValue()).map(StartDbClusterResponse.wrap).provide(r)
    def modifyDBClusterSnapshotAttribute(request: ModifyDbClusterSnapshotAttributeRequest): IO[AwsError, ModifyDbClusterSnapshotAttributeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeRequest, software.amazon.awssdk.services.rds.model.ModifyDbClusterSnapshotAttributeResponse]("modifyDBClusterSnapshotAttribute", api.modifyDBClusterSnapshotAttribute)(request.buildAwsValue()).map(ModifyDbClusterSnapshotAttributeResponse.wrap).provide(r)
    def createDBProxy(request: CreateDbProxyRequest): IO[AwsError, CreateDbProxyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbProxyRequest, software.amazon.awssdk.services.rds.model.CreateDbProxyResponse]("createDBProxy", api.createDBProxy)(request.buildAwsValue()).map(CreateDbProxyResponse.wrap).provide(r)
    def describeDBSnapshotAttributes(request: DescribeDbSnapshotAttributesRequest): IO[AwsError, DescribeDbSnapshotAttributesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesRequest, software.amazon.awssdk.services.rds.model.DescribeDbSnapshotAttributesResponse]("describeDBSnapshotAttributes", api.describeDBSnapshotAttributes)(request.buildAwsValue()).map(DescribeDbSnapshotAttributesResponse.wrap).provide(r)
    def describeEventCategories(request: DescribeEventCategoriesRequest): IO[AwsError, DescribeEventCategoriesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeEventCategoriesRequest, software.amazon.awssdk.services.rds.model.DescribeEventCategoriesResponse]("describeEventCategories", api.describeEventCategories)(request.buildAwsValue()).map(DescribeEventCategoriesResponse.wrap).provide(r)
    def deleteDBSubnetGroup(request: DeleteDbSubnetGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupRequest, software.amazon.awssdk.services.rds.model.DeleteDbSubnetGroupResponse]("deleteDBSubnetGroup", api.deleteDBSubnetGroup)(request.buildAwsValue()).unit.provide(r)
    def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): IO[AwsError, ModifyDbClusterEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointRequest, software.amazon.awssdk.services.rds.model.ModifyDbClusterEndpointResponse]("modifyDBClusterEndpoint", api.modifyDBClusterEndpoint)(request.buildAwsValue()).map(ModifyDbClusterEndpointResponse.wrap).provide(r)
    def startDBInstance(request: StartDbInstanceRequest): IO[AwsError, StartDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StartDbInstanceRequest, software.amazon.awssdk.services.rds.model.StartDbInstanceResponse]("startDBInstance", api.startDBInstance)(request.buildAwsValue()).map(StartDbInstanceResponse.wrap).provide(r)
    def promoteReadReplicaDBCluster(request: PromoteReadReplicaDbClusterRequest): IO[AwsError, PromoteReadReplicaDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterRequest, software.amazon.awssdk.services.rds.model.PromoteReadReplicaDbClusterResponse]("promoteReadReplicaDBCluster", api.promoteReadReplicaDBCluster)(request.buildAwsValue()).map(PromoteReadReplicaDbClusterResponse.wrap).provide(r)
    def registerDBProxyTargets(request: RegisterDbProxyTargetsRequest): IO[AwsError, RegisterDbProxyTargetsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsRequest, software.amazon.awssdk.services.rds.model.RegisterDbProxyTargetsResponse]("registerDBProxyTargets", api.registerDBProxyTargets)(request.buildAwsValue()).map(RegisterDbProxyTargetsResponse.wrap).provide(r)
    def stopDBInstance(request: StopDbInstanceRequest): IO[AwsError, StopDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StopDbInstanceRequest, software.amazon.awssdk.services.rds.model.StopDbInstanceResponse]("stopDBInstance", api.stopDBInstance)(request.buildAwsValue()).map(StopDbInstanceResponse.wrap).provide(r)
    def modifyDBProxyTargetGroup(request: ModifyDbProxyTargetGroupRequest): IO[AwsError, ModifyDbProxyTargetGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupRequest, software.amazon.awssdk.services.rds.model.ModifyDbProxyTargetGroupResponse]("modifyDBProxyTargetGroup", api.modifyDBProxyTargetGroup)(request.buildAwsValue()).map(ModifyDbProxyTargetGroupResponse.wrap).provide(r)
    def restoreDBInstanceFromDBSnapshot(request: RestoreDbInstanceFromDbSnapshotRequest): IO[AwsError, RestoreDbInstanceFromDbSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotRequest, software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromDbSnapshotResponse]("restoreDBInstanceFromDBSnapshot", api.restoreDBInstanceFromDBSnapshot)(request.buildAwsValue()).map(RestoreDbInstanceFromDbSnapshotResponse.wrap).provide(r)
    def describeInstallationMedia(request: DescribeInstallationMediaRequest): zio.stream.ZStream[Any, AwsError, InstallationMedia.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeInstallationMediaRequest, software.amazon.awssdk.services.rds.model.InstallationMedia, software.amazon.awssdk.services.rds.paginators.DescribeInstallationMediaPublisher]("describeInstallationMedia", api.describeInstallationMediaPaginator, _.installationMedia())(request.buildAwsValue()).map(item => InstallationMedia.wrap(item)).provide(r)
    def rebootDBInstance(request: RebootDbInstanceRequest): IO[AwsError, RebootDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RebootDbInstanceRequest, software.amazon.awssdk.services.rds.model.RebootDbInstanceResponse]("rebootDBInstance", api.rebootDBInstance)(request.buildAwsValue()).map(RebootDbInstanceResponse.wrap).provide(r)
    def describeOptionGroupOptions(request: DescribeOptionGroupOptionsRequest): zio.stream.ZStream[Any, AwsError, OptionGroupOption.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest, software.amazon.awssdk.services.rds.model.OptionGroupOption, software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupOptionsPublisher]("describeOptionGroupOptions", api.describeOptionGroupOptionsPaginator, _.optionGroupOptions())(request.buildAwsValue()).map(item => OptionGroupOption.wrap(item)).provide(r)
    def startDBInstanceAutomatedBackupsReplication(request: StartDbInstanceAutomatedBackupsReplicationRequest): IO[AwsError, StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationRequest, software.amazon.awssdk.services.rds.model.StartDbInstanceAutomatedBackupsReplicationResponse]("startDBInstanceAutomatedBackupsReplication", api.startDBInstanceAutomatedBackupsReplication)(request.buildAwsValue()).map(StartDbInstanceAutomatedBackupsReplicationResponse.wrap).provide(r)
    def createCustomAvailabilityZone(request: CreateCustomAvailabilityZoneRequest): IO[AwsError, CreateCustomAvailabilityZoneResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneRequest, software.amazon.awssdk.services.rds.model.CreateCustomAvailabilityZoneResponse]("createCustomAvailabilityZone", api.createCustomAvailabilityZone)(request.buildAwsValue()).map(CreateCustomAvailabilityZoneResponse.wrap).provide(r)
    def describeDBClusterParameterGroups(request: DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, DBClusterParameterGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClusterParameterGroupsRequest, software.amazon.awssdk.services.rds.model.DBClusterParameterGroup, software.amazon.awssdk.services.rds.paginators.DescribeDBClusterParameterGroupsPublisher]("describeDBClusterParameterGroups", api.describeDBClusterParameterGroupsPaginator, _.dbClusterParameterGroups())(request.buildAwsValue()).map(item => DBClusterParameterGroup.wrap(item)).provide(r)
    def deleteInstallationMedia(request: DeleteInstallationMediaRequest): IO[AwsError, DeleteInstallationMediaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteInstallationMediaRequest, software.amazon.awssdk.services.rds.model.DeleteInstallationMediaResponse]("deleteInstallationMedia", api.deleteInstallationMedia)(request.buildAwsValue()).map(DeleteInstallationMediaResponse.wrap).provide(r)
    def restoreDBInstanceToPointInTime(request: RestoreDbInstanceToPointInTimeRequest): IO[AwsError, RestoreDbInstanceToPointInTimeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest, software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeResponse]("restoreDBInstanceToPointInTime", api.restoreDBInstanceToPointInTime)(request.buildAwsValue()).map(RestoreDbInstanceToPointInTimeResponse.wrap).provide(r)
    def createEventSubscription(request: CreateEventSubscriptionRequest): IO[AwsError, CreateEventSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest, software.amazon.awssdk.services.rds.model.CreateEventSubscriptionResponse]("createEventSubscription", api.createEventSubscription)(request.buildAwsValue()).map(CreateEventSubscriptionResponse.wrap).provide(r)
    def describeOptionGroups(request: DescribeOptionGroupsRequest): zio.stream.ZStream[Any, AwsError, OptionGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest, software.amazon.awssdk.services.rds.model.OptionGroup, software.amazon.awssdk.services.rds.paginators.DescribeOptionGroupsPublisher]("describeOptionGroups", api.describeOptionGroupsPaginator, _.optionGroupsList())(request.buildAwsValue()).map(item => OptionGroup.wrap(item)).provide(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[AwsError, ListTagsForResourceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ListTagsForResourceRequest, software.amazon.awssdk.services.rds.model.ListTagsForResourceResponse]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue()).map(ListTagsForResourceResponse.wrap).provide(r)
    def restoreDBClusterToPointInTime(request: RestoreDbClusterToPointInTimeRequest): IO[AwsError, RestoreDbClusterToPointInTimeResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeRequest, software.amazon.awssdk.services.rds.model.RestoreDbClusterToPointInTimeResponse]("restoreDBClusterToPointInTime", api.restoreDBClusterToPointInTime)(request.buildAwsValue()).map(RestoreDbClusterToPointInTimeResponse.wrap).provide(r)
    def describeDBProxyTargets(request: DescribeDbProxyTargetsRequest): zio.stream.ZStream[Any, AwsError, DBProxyTarget.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbProxyTargetsRequest, software.amazon.awssdk.services.rds.model.DBProxyTarget, software.amazon.awssdk.services.rds.paginators.DescribeDBProxyTargetsPublisher]("describeDBProxyTargets", api.describeDBProxyTargetsPaginator, _.targets())(request.buildAwsValue()).map(item => DBProxyTarget.wrap(item)).provide(r)
    def describeDBClusters(request: DescribeDbClustersRequest): zio.stream.ZStream[Any, AwsError, DBCluster.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest, software.amazon.awssdk.services.rds.model.DBCluster, software.amazon.awssdk.services.rds.paginators.DescribeDBClustersPublisher]("describeDBClusters", api.describeDBClustersPaginator, _.dbClusters())(request.buildAwsValue()).map(item => DBCluster.wrap(item)).provide(r)
    def failoverDBCluster(request: FailoverDbClusterRequest): IO[AwsError, FailoverDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.FailoverDbClusterRequest, software.amazon.awssdk.services.rds.model.FailoverDbClusterResponse]("failoverDBCluster", api.failoverDBCluster)(request.buildAwsValue()).map(FailoverDbClusterResponse.wrap).provide(r)
    def deleteOptionGroup(request: DeleteOptionGroupRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteOptionGroupRequest, software.amazon.awssdk.services.rds.model.DeleteOptionGroupResponse]("deleteOptionGroup", api.deleteOptionGroup)(request.buildAwsValue()).unit.provide(r)
    def describeEventSubscriptions(request: DescribeEventSubscriptionsRequest): zio.stream.ZStream[Any, AwsError, EventSubscription.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeEventSubscriptionsRequest, software.amazon.awssdk.services.rds.model.EventSubscription, software.amazon.awssdk.services.rds.paginators.DescribeEventSubscriptionsPublisher]("describeEventSubscriptions", api.describeEventSubscriptionsPaginator, _.eventSubscriptionsList())(request.buildAwsValue()).map(item => EventSubscription.wrap(item)).provide(r)
    def describeDBInstances(request: DescribeDbInstancesRequest): zio.stream.ZStream[Any, AwsError, DBInstance.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest, software.amazon.awssdk.services.rds.model.DBInstance, software.amazon.awssdk.services.rds.paginators.DescribeDBInstancesPublisher]("describeDBInstances", api.describeDBInstancesPaginator, _.dbInstances())(request.buildAwsValue()).map(item => DBInstance.wrap(item)).provide(r)
    def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): IO[AwsError, CreateDbClusterSnapshotResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest, software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse]("createDBClusterSnapshot", api.createDBClusterSnapshot)(request.buildAwsValue()).map(CreateDbClusterSnapshotResponse.wrap).provide(r)
    def modifyCurrentDBClusterCapacity(request: ModifyCurrentDbClusterCapacityRequest): IO[AwsError, ModifyCurrentDbClusterCapacityResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest, software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityResponse]("modifyCurrentDBClusterCapacity", api.modifyCurrentDBClusterCapacity)(request.buildAwsValue()).map(ModifyCurrentDbClusterCapacityResponse.wrap).provide(r)
    def deleteDBCluster(request: DeleteDbClusterRequest): IO[AwsError, DeleteDbClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbClusterRequest, software.amazon.awssdk.services.rds.model.DeleteDbClusterResponse]("deleteDBCluster", api.deleteDBCluster)(request.buildAwsValue()).map(DeleteDbClusterResponse.wrap).provide(r)
    def deleteGlobalCluster(request: DeleteGlobalClusterRequest): IO[AwsError, DeleteGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteGlobalClusterRequest, software.amazon.awssdk.services.rds.model.DeleteGlobalClusterResponse]("deleteGlobalCluster", api.deleteGlobalCluster)(request.buildAwsValue()).map(DeleteGlobalClusterResponse.wrap).provide(r)
    def describeReservedDBInstances(request: DescribeReservedDbInstancesRequest): zio.stream.ZStream[Any, AwsError, ReservedDBInstance.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest, software.amazon.awssdk.services.rds.model.ReservedDBInstance, software.amazon.awssdk.services.rds.paginators.DescribeReservedDBInstancesPublisher]("describeReservedDBInstances", api.describeReservedDBInstancesPaginator, _.reservedDBInstances())(request.buildAwsValue()).map(item => ReservedDBInstance.wrap(item)).provide(r)
    def createDBInstanceReadReplica(request: CreateDbInstanceReadReplicaRequest): IO[AwsError, CreateDbInstanceReadReplicaResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest, software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaResponse]("createDBInstanceReadReplica", api.createDBInstanceReadReplica)(request.buildAwsValue()).map(CreateDbInstanceReadReplicaResponse.wrap).provide(r)
    def deleteDBInstance(request: DeleteDbInstanceRequest): IO[AwsError, DeleteDbInstanceResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeleteDbInstanceRequest, software.amazon.awssdk.services.rds.model.DeleteDbInstanceResponse]("deleteDBInstance", api.deleteDBInstance)(request.buildAwsValue()).map(DeleteDbInstanceResponse.wrap).provide(r)
    def createOptionGroup(request: CreateOptionGroupRequest): IO[AwsError, CreateOptionGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest, software.amazon.awssdk.services.rds.model.CreateOptionGroupResponse]("createOptionGroup", api.createOptionGroup)(request.buildAwsValue()).map(CreateOptionGroupResponse.wrap).provide(r)
    def deregisterDBProxyTargets(request: DeregisterDbProxyTargetsRequest): IO[AwsError, DeregisterDbProxyTargetsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsRequest, software.amazon.awssdk.services.rds.model.DeregisterDbProxyTargetsResponse]("deregisterDBProxyTargets", api.deregisterDBProxyTargets)(request.buildAwsValue()).map(DeregisterDbProxyTargetsResponse.wrap).provide(r)
    def modifyDBProxyEndpoint(request: ModifyDbProxyEndpointRequest): IO[AwsError, ModifyDbProxyEndpointResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointRequest, software.amazon.awssdk.services.rds.model.ModifyDbProxyEndpointResponse]("modifyDBProxyEndpoint", api.modifyDBProxyEndpoint)(request.buildAwsValue()).map(ModifyDbProxyEndpointResponse.wrap).provide(r)
    def addSourceIdentifierToSubscription(request: AddSourceIdentifierToSubscriptionRequest): IO[AwsError, AddSourceIdentifierToSubscriptionResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest, software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionResponse]("addSourceIdentifierToSubscription", api.addSourceIdentifierToSubscription)(request.buildAwsValue()).map(AddSourceIdentifierToSubscriptionResponse.wrap).provide(r)
    def modifyDBProxy(request: ModifyDbProxyRequest): IO[AwsError, ModifyDbProxyResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyDbProxyRequest, software.amazon.awssdk.services.rds.model.ModifyDbProxyResponse]("modifyDBProxy", api.modifyDBProxy)(request.buildAwsValue()).map(ModifyDbProxyResponse.wrap).provide(r)
    def modifyOptionGroup(request: ModifyOptionGroupRequest): IO[AwsError, ModifyOptionGroupResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest, software.amazon.awssdk.services.rds.model.ModifyOptionGroupResponse]("modifyOptionGroup", api.modifyOptionGroup)(request.buildAwsValue()).map(ModifyOptionGroupResponse.wrap).provide(r)
    def describeDBEngineVersions(request: DescribeDbEngineVersionsRequest): zio.stream.ZStream[Any, AwsError, DBEngineVersion.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbEngineVersionsRequest, software.amazon.awssdk.services.rds.model.DBEngineVersion, software.amazon.awssdk.services.rds.paginators.DescribeDBEngineVersionsPublisher]("describeDBEngineVersions", api.describeDBEngineVersionsPaginator, _.dbEngineVersions())(request.buildAwsValue()).map(item => DBEngineVersion.wrap(item)).provide(r)
    def describeAccountAttributes(request: DescribeAccountAttributesRequest): IO[AwsError, DescribeAccountAttributesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeAccountAttributesRequest, software.amazon.awssdk.services.rds.model.DescribeAccountAttributesResponse]("describeAccountAttributes", api.describeAccountAttributes)(request.buildAwsValue()).map(DescribeAccountAttributesResponse.wrap).provide(r)
    def createGlobalCluster(request: CreateGlobalClusterRequest): IO[AwsError, CreateGlobalClusterResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.CreateGlobalClusterRequest, software.amazon.awssdk.services.rds.model.CreateGlobalClusterResponse]("createGlobalCluster", api.createGlobalCluster)(request.buildAwsValue()).map(CreateGlobalClusterResponse.wrap).provide(r)
    def describeOrderableDBInstanceOptions(request: DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[Any, AwsError, OrderableDBInstanceOption.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest, software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption, software.amazon.awssdk.services.rds.paginators.DescribeOrderableDBInstanceOptionsPublisher]("describeOrderableDBInstanceOptions", api.describeOrderableDBInstanceOptionsPaginator, _.orderableDBInstanceOptions())(request.buildAwsValue()).map(item => OrderableDBInstanceOption.wrap(item)).provide(r)
    def revokeDBSecurityGroupIngress(request: RevokeDbSecurityGroupIngressRequest): IO[AwsError, RevokeDbSecurityGroupIngressResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressRequest, software.amazon.awssdk.services.rds.model.RevokeDbSecurityGroupIngressResponse]("revokeDBSecurityGroupIngress", api.revokeDBSecurityGroupIngress)(request.buildAwsValue()).map(RevokeDbSecurityGroupIngressResponse.wrap).provide(r)
    def describeDBClusterSnapshotAttributes(request: DescribeDbClusterSnapshotAttributesRequest): IO[AwsError, DescribeDbClusterSnapshotAttributesResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesRequest, software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotAttributesResponse]("describeDBClusterSnapshotAttributes", api.describeDBClusterSnapshotAttributes)(request.buildAwsValue()).map(DescribeDbClusterSnapshotAttributesResponse.wrap).provide(r)
    def stopDBInstanceAutomatedBackupsReplication(request: StopDbInstanceAutomatedBackupsReplicationRequest): IO[AwsError, StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationRequest, software.amazon.awssdk.services.rds.model.StopDbInstanceAutomatedBackupsReplicationResponse]("stopDBInstanceAutomatedBackupsReplication", api.stopDBInstanceAutomatedBackupsReplication)(request.buildAwsValue()).map(StopDbInstanceAutomatedBackupsReplicationResponse.wrap).provide(r)
    def describeEvents(request: DescribeEventsRequest): zio.stream.ZStream[Any, AwsError, Event.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeEventsRequest, software.amazon.awssdk.services.rds.model.Event, software.amazon.awssdk.services.rds.paginators.DescribeEventsPublisher]("describeEvents", api.describeEventsPaginator, _.events())(request.buildAwsValue()).map(item => Event.wrap(item)).provide(r)
    def describeDBParameterGroups(request: DescribeDbParameterGroupsRequest): zio.stream.ZStream[Any, AwsError, DBParameterGroup.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.rds.model.DescribeDbParameterGroupsRequest, software.amazon.awssdk.services.rds.model.DBParameterGroup, software.amazon.awssdk.services.rds.paginators.DescribeDBParameterGroupsPublisher]("describeDBParameterGroups", api.describeDBParameterGroupsPaginator, _.dbParameterGroups())(request.buildAwsValue()).map(item => DBParameterGroup.wrap(item)).provide(r)
  }
  def downloadDBLogFilePortion(request: DownloadDbLogFilePortionRequest): ZIO[Rds, AwsError, DownloadDbLogFilePortionResponse.ReadOnly] = ZIO.accessM(_.get.downloadDBLogFilePortion(request))
  def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): ZIO[Rds, AwsError, CopyDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.copyDBClusterSnapshot(request))
  def describeEngineDefaultParameters(request: DescribeEngineDefaultParametersRequest): ZIO[Rds, AwsError, DescribeEngineDefaultParametersResponse.ReadOnly] = ZIO.accessM(_.get.describeEngineDefaultParameters(request))
  def modifyDBInstance(request: ModifyDbInstanceRequest): ZIO[Rds, AwsError, ModifyDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBInstance(request))
  def deleteDBProxy(request: DeleteDbProxyRequest): ZIO[Rds, AwsError, DeleteDbProxyResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBProxy(request))
  def describeDBClusterEndpoints(request: DescribeDbClusterEndpointsRequest): zio.stream.ZStream[Rds, AwsError, DBClusterEndpoint.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterEndpoints(request))
  def stopActivityStream(request: StopActivityStreamRequest): ZIO[Rds, AwsError, StopActivityStreamResponse.ReadOnly] = ZIO.accessM(_.get.stopActivityStream(request))
  def failoverGlobalCluster(request: FailoverGlobalClusterRequest): ZIO[Rds, AwsError, FailoverGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.failoverGlobalCluster(request))
  def describeDBLogFiles(request: DescribeDbLogFilesRequest): zio.stream.ZStream[Rds, AwsError, DescribeDBLogFilesDetails.ReadOnly] = ZStream.accessStream(_.get.describeDBLogFiles(request))
  def describeDBSnapshots(request: DescribeDbSnapshotsRequest): zio.stream.ZStream[Rds, AwsError, DBSnapshot.ReadOnly] = ZStream.accessStream(_.get.describeDBSnapshots(request))
  def describeDBParameters(request: DescribeDbParametersRequest): zio.stream.ZStream[Rds, AwsError, Parameter.ReadOnly] = ZStream.accessStream(_.get.describeDBParameters(request))
  def addTagsToResource(request: AddTagsToResourceRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.addTagsToResource(request))
  def describeDBProxies(request: DescribeDbProxiesRequest): zio.stream.ZStream[Rds, AwsError, DBProxy.ReadOnly] = ZStream.accessStream(_.get.describeDBProxies(request))
  def describeDBClusterSnapshots(request: DescribeDbClusterSnapshotsRequest): zio.stream.ZStream[Rds, AwsError, DBClusterSnapshot.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterSnapshots(request))
  def resetDBClusterParameterGroup(request: ResetDbClusterParameterGroupRequest): ZIO[Rds, AwsError, ResetDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.resetDBClusterParameterGroup(request))
  def describeDBProxyEndpoints(request: DescribeDbProxyEndpointsRequest): zio.stream.ZStream[Rds, AwsError, DBProxyEndpoint.ReadOnly] = ZStream.accessStream(_.get.describeDBProxyEndpoints(request))
  def removeSourceIdentifierFromSubscription(request: RemoveSourceIdentifierFromSubscriptionRequest): ZIO[Rds, AwsError, RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.removeSourceIdentifierFromSubscription(request))
  def describeEngineDefaultClusterParameters(request: DescribeEngineDefaultClusterParametersRequest): ZIO[Rds, AwsError, DescribeEngineDefaultClusterParametersResponse.ReadOnly] = ZIO.accessM(_.get.describeEngineDefaultClusterParameters(request))
  def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): ZIO[Rds, AwsError, CreateDbSubnetGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBSubnetGroup(request))
  def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): ZIO[Rds, AwsError, CreateDbClusterEndpointResponse.ReadOnly] = ZIO.accessM(_.get.createDBClusterEndpoint(request))
  def addRoleToDBCluster(request: AddRoleToDbClusterRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.addRoleToDBCluster(request))
  def copyDBClusterParameterGroup(request: CopyDbClusterParameterGroupRequest): ZIO[Rds, AwsError, CopyDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.copyDBClusterParameterGroup(request))
  def describePendingMaintenanceActions(request: DescribePendingMaintenanceActionsRequest): zio.stream.ZStream[Rds, AwsError, ResourcePendingMaintenanceActions.ReadOnly] = ZStream.accessStream(_.get.describePendingMaintenanceActions(request))
  def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): ZIO[Rds, AwsError, DeleteDbClusterEndpointResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBClusterEndpoint(request))
  def addRoleToDBInstance(request: AddRoleToDbInstanceRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.addRoleToDBInstance(request))
  def deleteCustomAvailabilityZone(request: DeleteCustomAvailabilityZoneRequest): ZIO[Rds, AwsError, DeleteCustomAvailabilityZoneResponse.ReadOnly] = ZIO.accessM(_.get.deleteCustomAvailabilityZone(request))
  def startActivityStream(request: StartActivityStreamRequest): ZIO[Rds, AwsError, StartActivityStreamResponse.ReadOnly] = ZIO.accessM(_.get.startActivityStream(request))
  def deleteDBClusterParameterGroup(request: DeleteDbClusterParameterGroupRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBClusterParameterGroup(request))
  def createDBSecurityGroup(request: CreateDbSecurityGroupRequest): ZIO[Rds, AwsError, CreateDbSecurityGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBSecurityGroup(request))
  def describeSourceRegions(request: DescribeSourceRegionsRequest): zio.stream.ZStream[Rds, AwsError, SourceRegion.ReadOnly] = ZStream.accessStream(_.get.describeSourceRegions(request))
  def backtrackDBCluster(request: BacktrackDbClusterRequest): ZIO[Rds, AwsError, BacktrackDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.backtrackDBCluster(request))
  def removeFromGlobalCluster(request: RemoveFromGlobalClusterRequest): ZIO[Rds, AwsError, RemoveFromGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.removeFromGlobalCluster(request))
  def modifyDBClusterParameterGroup(request: ModifyDbClusterParameterGroupRequest): ZIO[Rds, AwsError, ModifyDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBClusterParameterGroup(request))
  def cancelExportTask(request: CancelExportTaskRequest): ZIO[Rds, AwsError, CancelExportTaskResponse.ReadOnly] = ZIO.accessM(_.get.cancelExportTask(request))
  def createDBSnapshot(request: CreateDbSnapshotRequest): ZIO[Rds, AwsError, CreateDbSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createDBSnapshot(request))
  def deleteDBInstanceAutomatedBackup(request: DeleteDbInstanceAutomatedBackupRequest): ZIO[Rds, AwsError, DeleteDbInstanceAutomatedBackupResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBInstanceAutomatedBackup(request))
  def deleteDBSnapshot(request: DeleteDbSnapshotRequest): ZIO[Rds, AwsError, DeleteDbSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBSnapshot(request))
  def stopDBCluster(request: StopDbClusterRequest): ZIO[Rds, AwsError, StopDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.stopDBCluster(request))
  def createDBCluster(request: CreateDbClusterRequest): ZIO[Rds, AwsError, CreateDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.createDBCluster(request))
  def describeCertificates(request: DescribeCertificatesRequest): zio.stream.ZStream[Rds, AwsError, Certificate.ReadOnly] = ZStream.accessStream(_.get.describeCertificates(request))
  def modifyDBSnapshot(request: ModifyDbSnapshotRequest): ZIO[Rds, AwsError, ModifyDbSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBSnapshot(request))
  def deleteEventSubscription(request: DeleteEventSubscriptionRequest): ZIO[Rds, AwsError, DeleteEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.deleteEventSubscription(request))
  def deleteDBSecurityGroup(request: DeleteDbSecurityGroupRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBSecurityGroup(request))
  def deleteDBParameterGroup(request: DeleteDbParameterGroupRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBParameterGroup(request))
  def describeDBSecurityGroups(request: DescribeDbSecurityGroupsRequest): zio.stream.ZStream[Rds, AwsError, DBSecurityGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBSecurityGroups(request))
  def purchaseReservedDBInstancesOffering(request: PurchaseReservedDbInstancesOfferingRequest): ZIO[Rds, AwsError, PurchaseReservedDbInstancesOfferingResponse.ReadOnly] = ZIO.accessM(_.get.purchaseReservedDBInstancesOffering(request))
  def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): zio.stream.ZStream[Rds, AwsError, DBSubnetGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBSubnetGroups(request))
  def removeRoleFromDBCluster(request: RemoveRoleFromDbClusterRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.removeRoleFromDBCluster(request))
  def createDBClusterParameterGroup(request: CreateDbClusterParameterGroupRequest): ZIO[Rds, AwsError, CreateDbClusterParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBClusterParameterGroup(request))
  def modifyDBCluster(request: ModifyDbClusterRequest): ZIO[Rds, AwsError, ModifyDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBCluster(request))
  def restoreDBClusterFromS3(request: RestoreDbClusterFromS3Request): ZIO[Rds, AwsError, RestoreDbClusterFromS3Response.ReadOnly] = ZIO.accessM(_.get.restoreDBClusterFromS3(request))
  def describeValidDBInstanceModifications(request: DescribeValidDbInstanceModificationsRequest): ZIO[Rds, AwsError, DescribeValidDbInstanceModificationsResponse.ReadOnly] = ZIO.accessM(_.get.describeValidDBInstanceModifications(request))
  def createDBProxyEndpoint(request: CreateDbProxyEndpointRequest): ZIO[Rds, AwsError, CreateDbProxyEndpointResponse.ReadOnly] = ZIO.accessM(_.get.createDBProxyEndpoint(request))
  def resetDBParameterGroup(request: ResetDbParameterGroupRequest): ZIO[Rds, AwsError, ResetDbParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.resetDBParameterGroup(request))
  def deleteDBProxyEndpoint(request: DeleteDbProxyEndpointRequest): ZIO[Rds, AwsError, DeleteDbProxyEndpointResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBProxyEndpoint(request))
  def removeTagsFromResource(request: RemoveTagsFromResourceRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.removeTagsFromResource(request))
  def describeCustomAvailabilityZones(request: DescribeCustomAvailabilityZonesRequest): zio.stream.ZStream[Rds, AwsError, CustomAvailabilityZone.ReadOnly] = ZStream.accessStream(_.get.describeCustomAvailabilityZones(request))
  def promoteReadReplica(request: PromoteReadReplicaRequest): ZIO[Rds, AwsError, PromoteReadReplicaResponse.ReadOnly] = ZIO.accessM(_.get.promoteReadReplica(request))
  def describeReservedDBInstancesOfferings(request: DescribeReservedDbInstancesOfferingsRequest): zio.stream.ZStream[Rds, AwsError, ReservedDBInstancesOffering.ReadOnly] = ZStream.accessStream(_.get.describeReservedDBInstancesOfferings(request))
  def createDBParameterGroup(request: CreateDbParameterGroupRequest): ZIO[Rds, AwsError, CreateDbParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.createDBParameterGroup(request))
  def startExportTask(request: StartExportTaskRequest): ZIO[Rds, AwsError, StartExportTaskResponse.ReadOnly] = ZIO.accessM(_.get.startExportTask(request))
  def applyPendingMaintenanceAction(request: ApplyPendingMaintenanceActionRequest): ZIO[Rds, AwsError, ApplyPendingMaintenanceActionResponse.ReadOnly] = ZIO.accessM(_.get.applyPendingMaintenanceAction(request))
  def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): ZIO[Rds, AwsError, ModifyDbSubnetGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBSubnetGroup(request))
  def modifyGlobalCluster(request: ModifyGlobalClusterRequest): ZIO[Rds, AwsError, ModifyGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.modifyGlobalCluster(request))
  def copyDBSnapshot(request: CopyDbSnapshotRequest): ZIO[Rds, AwsError, CopyDbSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.copyDBSnapshot(request))
  def importInstallationMedia(request: ImportInstallationMediaRequest): ZIO[Rds, AwsError, ImportInstallationMediaResponse.ReadOnly] = ZIO.accessM(_.get.importInstallationMedia(request))
  def restoreDBClusterFromSnapshot(request: RestoreDbClusterFromSnapshotRequest): ZIO[Rds, AwsError, RestoreDbClusterFromSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBClusterFromSnapshot(request))
  def copyOptionGroup(request: CopyOptionGroupRequest): ZIO[Rds, AwsError, CopyOptionGroupResponse.ReadOnly] = ZIO.accessM(_.get.copyOptionGroup(request))
  def restoreDBInstanceFromS3(request: RestoreDbInstanceFromS3Request): ZIO[Rds, AwsError, RestoreDbInstanceFromS3Response.ReadOnly] = ZIO.accessM(_.get.restoreDBInstanceFromS3(request))
  def removeRoleFromDBInstance(request: RemoveRoleFromDbInstanceRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.removeRoleFromDBInstance(request))
  def describeGlobalClusters(request: DescribeGlobalClustersRequest): zio.stream.ZStream[Rds, AwsError, GlobalCluster.ReadOnly] = ZStream.accessStream(_.get.describeGlobalClusters(request))
  def describeDBProxyTargetGroups(request: DescribeDbProxyTargetGroupsRequest): zio.stream.ZStream[Rds, AwsError, DBProxyTargetGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBProxyTargetGroups(request))
  def describeDBInstanceAutomatedBackups(request: DescribeDbInstanceAutomatedBackupsRequest): zio.stream.ZStream[Rds, AwsError, DBInstanceAutomatedBackup.ReadOnly] = ZStream.accessStream(_.get.describeDBInstanceAutomatedBackups(request))
  def describeDBClusterParameters(request: DescribeDbClusterParametersRequest): zio.stream.ZStream[Rds, AwsError, Parameter.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterParameters(request))
  def copyDBParameterGroup(request: CopyDbParameterGroupRequest): ZIO[Rds, AwsError, CopyDbParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.copyDBParameterGroup(request))
  def modifyDBSnapshotAttribute(request: ModifyDbSnapshotAttributeRequest): ZIO[Rds, AwsError, ModifyDbSnapshotAttributeResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBSnapshotAttribute(request))
  def authorizeDBSecurityGroupIngress(request: AuthorizeDbSecurityGroupIngressRequest): ZIO[Rds, AwsError, AuthorizeDbSecurityGroupIngressResponse.ReadOnly] = ZIO.accessM(_.get.authorizeDBSecurityGroupIngress(request))
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): ZIO[Rds, AwsError, ModifyEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.modifyEventSubscription(request))
  def describeDBClusterBacktracks(request: DescribeDbClusterBacktracksRequest): zio.stream.ZStream[Rds, AwsError, DBClusterBacktrack.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterBacktracks(request))
  def modifyDBParameterGroup(request: ModifyDbParameterGroupRequest): ZIO[Rds, AwsError, ModifyDbParameterGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBParameterGroup(request))
  def modifyCertificates(request: ModifyCertificatesRequest): ZIO[Rds, AwsError, ModifyCertificatesResponse.ReadOnly] = ZIO.accessM(_.get.modifyCertificates(request))
  def createDBInstance(request: CreateDbInstanceRequest): ZIO[Rds, AwsError, CreateDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.createDBInstance(request))
  def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): ZIO[Rds, AwsError, DeleteDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBClusterSnapshot(request))
  def describeExportTasks(request: DescribeExportTasksRequest): zio.stream.ZStream[Rds, AwsError, ExportTask.ReadOnly] = ZStream.accessStream(_.get.describeExportTasks(request))
  def startDBCluster(request: StartDbClusterRequest): ZIO[Rds, AwsError, StartDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.startDBCluster(request))
  def modifyDBClusterSnapshotAttribute(request: ModifyDbClusterSnapshotAttributeRequest): ZIO[Rds, AwsError, ModifyDbClusterSnapshotAttributeResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBClusterSnapshotAttribute(request))
  def createDBProxy(request: CreateDbProxyRequest): ZIO[Rds, AwsError, CreateDbProxyResponse.ReadOnly] = ZIO.accessM(_.get.createDBProxy(request))
  def describeDBSnapshotAttributes(request: DescribeDbSnapshotAttributesRequest): ZIO[Rds, AwsError, DescribeDbSnapshotAttributesResponse.ReadOnly] = ZIO.accessM(_.get.describeDBSnapshotAttributes(request))
  def describeEventCategories(request: DescribeEventCategoriesRequest): ZIO[Rds, AwsError, DescribeEventCategoriesResponse.ReadOnly] = ZIO.accessM(_.get.describeEventCategories(request))
  def deleteDBSubnetGroup(request: DeleteDbSubnetGroupRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteDBSubnetGroup(request))
  def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): ZIO[Rds, AwsError, ModifyDbClusterEndpointResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBClusterEndpoint(request))
  def startDBInstance(request: StartDbInstanceRequest): ZIO[Rds, AwsError, StartDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.startDBInstance(request))
  def promoteReadReplicaDBCluster(request: PromoteReadReplicaDbClusterRequest): ZIO[Rds, AwsError, PromoteReadReplicaDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.promoteReadReplicaDBCluster(request))
  def registerDBProxyTargets(request: RegisterDbProxyTargetsRequest): ZIO[Rds, AwsError, RegisterDbProxyTargetsResponse.ReadOnly] = ZIO.accessM(_.get.registerDBProxyTargets(request))
  def stopDBInstance(request: StopDbInstanceRequest): ZIO[Rds, AwsError, StopDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.stopDBInstance(request))
  def modifyDBProxyTargetGroup(request: ModifyDbProxyTargetGroupRequest): ZIO[Rds, AwsError, ModifyDbProxyTargetGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBProxyTargetGroup(request))
  def restoreDBInstanceFromDBSnapshot(request: RestoreDbInstanceFromDbSnapshotRequest): ZIO[Rds, AwsError, RestoreDbInstanceFromDbSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBInstanceFromDBSnapshot(request))
  def describeInstallationMedia(request: DescribeInstallationMediaRequest): zio.stream.ZStream[Rds, AwsError, InstallationMedia.ReadOnly] = ZStream.accessStream(_.get.describeInstallationMedia(request))
  def rebootDBInstance(request: RebootDbInstanceRequest): ZIO[Rds, AwsError, RebootDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.rebootDBInstance(request))
  def describeOptionGroupOptions(request: DescribeOptionGroupOptionsRequest): zio.stream.ZStream[Rds, AwsError, OptionGroupOption.ReadOnly] = ZStream.accessStream(_.get.describeOptionGroupOptions(request))
  def startDBInstanceAutomatedBackupsReplication(request: StartDbInstanceAutomatedBackupsReplicationRequest): ZIO[Rds, AwsError, StartDbInstanceAutomatedBackupsReplicationResponse.ReadOnly] = ZIO.accessM(_.get.startDBInstanceAutomatedBackupsReplication(request))
  def createCustomAvailabilityZone(request: CreateCustomAvailabilityZoneRequest): ZIO[Rds, AwsError, CreateCustomAvailabilityZoneResponse.ReadOnly] = ZIO.accessM(_.get.createCustomAvailabilityZone(request))
  def describeDBClusterParameterGroups(request: DescribeDbClusterParameterGroupsRequest): zio.stream.ZStream[Rds, AwsError, DBClusterParameterGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBClusterParameterGroups(request))
  def deleteInstallationMedia(request: DeleteInstallationMediaRequest): ZIO[Rds, AwsError, DeleteInstallationMediaResponse.ReadOnly] = ZIO.accessM(_.get.deleteInstallationMedia(request))
  def restoreDBInstanceToPointInTime(request: RestoreDbInstanceToPointInTimeRequest): ZIO[Rds, AwsError, RestoreDbInstanceToPointInTimeResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBInstanceToPointInTime(request))
  def createEventSubscription(request: CreateEventSubscriptionRequest): ZIO[Rds, AwsError, CreateEventSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.createEventSubscription(request))
  def describeOptionGroups(request: DescribeOptionGroupsRequest): zio.stream.ZStream[Rds, AwsError, OptionGroup.ReadOnly] = ZStream.accessStream(_.get.describeOptionGroups(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[Rds, AwsError, ListTagsForResourceResponse.ReadOnly] = ZIO.accessM(_.get.listTagsForResource(request))
  def restoreDBClusterToPointInTime(request: RestoreDbClusterToPointInTimeRequest): ZIO[Rds, AwsError, RestoreDbClusterToPointInTimeResponse.ReadOnly] = ZIO.accessM(_.get.restoreDBClusterToPointInTime(request))
  def describeDBProxyTargets(request: DescribeDbProxyTargetsRequest): zio.stream.ZStream[Rds, AwsError, DBProxyTarget.ReadOnly] = ZStream.accessStream(_.get.describeDBProxyTargets(request))
  def describeDBClusters(request: DescribeDbClustersRequest): zio.stream.ZStream[Rds, AwsError, DBCluster.ReadOnly] = ZStream.accessStream(_.get.describeDBClusters(request))
  def failoverDBCluster(request: FailoverDbClusterRequest): ZIO[Rds, AwsError, FailoverDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.failoverDBCluster(request))
  def deleteOptionGroup(request: DeleteOptionGroupRequest): ZIO[Rds, AwsError, scala.Unit] = ZIO.accessM(_.get.deleteOptionGroup(request))
  def describeEventSubscriptions(request: DescribeEventSubscriptionsRequest): zio.stream.ZStream[Rds, AwsError, EventSubscription.ReadOnly] = ZStream.accessStream(_.get.describeEventSubscriptions(request))
  def describeDBInstances(request: DescribeDbInstancesRequest): zio.stream.ZStream[Rds, AwsError, DBInstance.ReadOnly] = ZStream.accessStream(_.get.describeDBInstances(request))
  def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): ZIO[Rds, AwsError, CreateDbClusterSnapshotResponse.ReadOnly] = ZIO.accessM(_.get.createDBClusterSnapshot(request))
  def modifyCurrentDBClusterCapacity(request: ModifyCurrentDbClusterCapacityRequest): ZIO[Rds, AwsError, ModifyCurrentDbClusterCapacityResponse.ReadOnly] = ZIO.accessM(_.get.modifyCurrentDBClusterCapacity(request))
  def deleteDBCluster(request: DeleteDbClusterRequest): ZIO[Rds, AwsError, DeleteDbClusterResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBCluster(request))
  def deleteGlobalCluster(request: DeleteGlobalClusterRequest): ZIO[Rds, AwsError, DeleteGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.deleteGlobalCluster(request))
  def describeReservedDBInstances(request: DescribeReservedDbInstancesRequest): zio.stream.ZStream[Rds, AwsError, ReservedDBInstance.ReadOnly] = ZStream.accessStream(_.get.describeReservedDBInstances(request))
  def createDBInstanceReadReplica(request: CreateDbInstanceReadReplicaRequest): ZIO[Rds, AwsError, CreateDbInstanceReadReplicaResponse.ReadOnly] = ZIO.accessM(_.get.createDBInstanceReadReplica(request))
  def deleteDBInstance(request: DeleteDbInstanceRequest): ZIO[Rds, AwsError, DeleteDbInstanceResponse.ReadOnly] = ZIO.accessM(_.get.deleteDBInstance(request))
  def createOptionGroup(request: CreateOptionGroupRequest): ZIO[Rds, AwsError, CreateOptionGroupResponse.ReadOnly] = ZIO.accessM(_.get.createOptionGroup(request))
  def deregisterDBProxyTargets(request: DeregisterDbProxyTargetsRequest): ZIO[Rds, AwsError, DeregisterDbProxyTargetsResponse.ReadOnly] = ZIO.accessM(_.get.deregisterDBProxyTargets(request))
  def modifyDBProxyEndpoint(request: ModifyDbProxyEndpointRequest): ZIO[Rds, AwsError, ModifyDbProxyEndpointResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBProxyEndpoint(request))
  def addSourceIdentifierToSubscription(request: AddSourceIdentifierToSubscriptionRequest): ZIO[Rds, AwsError, AddSourceIdentifierToSubscriptionResponse.ReadOnly] = ZIO.accessM(_.get.addSourceIdentifierToSubscription(request))
  def modifyDBProxy(request: ModifyDbProxyRequest): ZIO[Rds, AwsError, ModifyDbProxyResponse.ReadOnly] = ZIO.accessM(_.get.modifyDBProxy(request))
  def modifyOptionGroup(request: ModifyOptionGroupRequest): ZIO[Rds, AwsError, ModifyOptionGroupResponse.ReadOnly] = ZIO.accessM(_.get.modifyOptionGroup(request))
  def describeDBEngineVersions(request: DescribeDbEngineVersionsRequest): zio.stream.ZStream[Rds, AwsError, DBEngineVersion.ReadOnly] = ZStream.accessStream(_.get.describeDBEngineVersions(request))
  def describeAccountAttributes(request: DescribeAccountAttributesRequest): ZIO[Rds, AwsError, DescribeAccountAttributesResponse.ReadOnly] = ZIO.accessM(_.get.describeAccountAttributes(request))
  def createGlobalCluster(request: CreateGlobalClusterRequest): ZIO[Rds, AwsError, CreateGlobalClusterResponse.ReadOnly] = ZIO.accessM(_.get.createGlobalCluster(request))
  def describeOrderableDBInstanceOptions(request: DescribeOrderableDbInstanceOptionsRequest): zio.stream.ZStream[Rds, AwsError, OrderableDBInstanceOption.ReadOnly] = ZStream.accessStream(_.get.describeOrderableDBInstanceOptions(request))
  def revokeDBSecurityGroupIngress(request: RevokeDbSecurityGroupIngressRequest): ZIO[Rds, AwsError, RevokeDbSecurityGroupIngressResponse.ReadOnly] = ZIO.accessM(_.get.revokeDBSecurityGroupIngress(request))
  def describeDBClusterSnapshotAttributes(request: DescribeDbClusterSnapshotAttributesRequest): ZIO[Rds, AwsError, DescribeDbClusterSnapshotAttributesResponse.ReadOnly] = ZIO.accessM(_.get.describeDBClusterSnapshotAttributes(request))
  def stopDBInstanceAutomatedBackupsReplication(request: StopDbInstanceAutomatedBackupsReplicationRequest): ZIO[Rds, AwsError, StopDbInstanceAutomatedBackupsReplicationResponse.ReadOnly] = ZIO.accessM(_.get.stopDBInstanceAutomatedBackupsReplication(request))
  def describeEvents(request: DescribeEventsRequest): zio.stream.ZStream[Rds, AwsError, Event.ReadOnly] = ZStream.accessStream(_.get.describeEvents(request))
  def describeDBParameterGroups(request: DescribeDbParameterGroupsRequest): zio.stream.ZStream[Rds, AwsError, DBParameterGroup.ReadOnly] = ZStream.accessStream(_.get.describeDBParameterGroups(request))
}