package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.DaysAfterInitiation
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AbortIncompleteMultipartUpload(
    daysAfterInitiation: Option[DaysAfterInitiation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload = {
    import AbortIncompleteMultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
      .builder()
      .optionallyWith(daysAfterInitiation.map(value => value: Integer))(
        _.daysAfterInitiation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload
      .wrap(buildAwsValue())
}
object AbortIncompleteMultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload =
      io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload(
        daysAfterInitiationValue.map(value => value)
      )
    def daysAfterInitiationValue: Option[DaysAfterInitiation]
    def daysAfterInitiation: ZIO[Any, AwsError, DaysAfterInitiation] = AwsError
      .unwrapOptionField("daysAfterInitiation", daysAfterInitiationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ) extends io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly {
    override def daysAfterInitiationValue: Option[DaysAfterInitiation] = scala
      .Option(impl.daysAfterInitiation())
      .map(value => value: DaysAfterInitiation)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload
  ): io.github.vigoo.zioaws.s3.model.AbortIncompleteMultipartUpload.ReadOnly =
    new Wrapper(impl)
}
