package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AbortMultipartUploadResponse(
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse = {
    import AbortMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse
      .wrap(buildAwsValue())
}
object AbortMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse =
      io.github.vigoo.zioaws.s3.model
        .AbortMultipartUploadResponse(requestChargedValue.map(value => value))
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ) extends io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly {
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AbortMultipartUploadResponse
  ): io.github.vigoo.zioaws.s3.model.AbortMultipartUploadResponse.ReadOnly =
    new Wrapper(impl)
}
