package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AccessControlPolicy(
    grants: Option[Iterable[io.github.vigoo.zioaws.s3.model.Grant]] = None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AccessControlPolicy = {
    import AccessControlPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AccessControlPolicy
      .builder()
      .optionallyWith(
        grants.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.grants)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AccessControlPolicy.wrap(buildAwsValue())
}
object AccessControlPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AccessControlPolicy =
      io.github.vigoo.zioaws.s3.model.AccessControlPolicy(
        grantsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ownerValue.map(value => value.editable)
      )
    def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def grants: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.Grant.ReadOnly
    ]] = AwsError.unwrapOptionField("grants", grantsValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ) extends io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly {
    override def grantsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.Grant.ReadOnly]] = scala
      .Option(impl.grants())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.Grant.wrap(item)
        }.toList
      )
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AccessControlPolicy
  ): io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly = new Wrapper(
    impl
  )
}
