package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AccessControlTranslation(
    owner: io.github.vigoo.zioaws.s3.model.OwnerOverride
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AccessControlTranslation = {
    import AccessControlTranslation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AccessControlTranslation
      .builder()
      .owner(owner.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AccessControlTranslation
      .wrap(buildAwsValue())
}
object AccessControlTranslation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AccessControlTranslation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AccessControlTranslation =
      io.github.vigoo.zioaws.s3.model.AccessControlTranslation(ownerValue)
    def ownerValue: io.github.vigoo.zioaws.s3.model.OwnerOverride
    def owner
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.OwnerOverride] =
      ZIO.succeed(ownerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AccessControlTranslation
  ) extends io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly {
    override def ownerValue: io.github.vigoo.zioaws.s3.model.OwnerOverride =
      io.github.vigoo.zioaws.s3.model.OwnerOverride.wrap(impl.owner())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AccessControlTranslation
  ): io.github.vigoo.zioaws.s3.model.AccessControlTranslation.ReadOnly =
    new Wrapper(impl)
}
