package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.AnalyticsId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalyticsConfiguration(
    id: AnalyticsId,
    filter: Option[io.github.vigoo.zioaws.s3.model.AnalyticsFilter] = None,
    storageClassAnalysis: io.github.vigoo.zioaws.s3.model.StorageClassAnalysis
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsConfiguration = {
    import AnalyticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .storageClassAnalysis(storageClassAnalysis.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.wrap(buildAwsValue())
}
object AnalyticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration =
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration(
        idValue,
        filterValue.map(value => value.editable),
        storageClassAnalysisValue.editable
      )
    def idValue: AnalyticsId
    def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly]
    def storageClassAnalysisValue
        : io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly
    def id: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(idValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
    def storageClassAnalysis: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly
    ] = ZIO.succeed(storageClassAnalysisValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly {
    override def idValue: AnalyticsId = impl.id(): AnalyticsId
    override def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.AnalyticsFilter.wrap(value)
        )
    override def storageClassAnalysisValue
        : io.github.vigoo.zioaws.s3.model.StorageClassAnalysis.ReadOnly =
      io.github.vigoo.zioaws.s3.model.StorageClassAnalysis
        .wrap(impl.storageClassAnalysis())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsConfiguration
  ): io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly =
    new Wrapper(impl)
}
