package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyticsExportDestination(
    s3BucketDestination: io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsExportDestination = {
    import AnalyticsExportDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
      .builder()
      .s3BucketDestination(s3BucketDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination
      .wrap(buildAwsValue())
}
object AnalyticsExportDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination =
      io.github.vigoo.zioaws.s3.model
        .AnalyticsExportDestination(s3BucketDestinationValue.editable)
    def s3BucketDestinationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly
    def s3BucketDestination: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly
    ] = ZIO.succeed(s3BucketDestinationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ) extends io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly {
    override def s3BucketDestinationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly =
      io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination
        .wrap(impl.s3BucketDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsExportDestination
  ): io.github.vigoo.zioaws.s3.model.AnalyticsExportDestination.ReadOnly =
    new Wrapper(impl)
}
