package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Prefix
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalyticsFilter(
    prefix: Option[Prefix] = None,
    tag: Option[io.github.vigoo.zioaws.s3.model.Tag] = None,
    and: Option[io.github.vigoo.zioaws.s3.model.AnalyticsAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsFilter = {
    import AnalyticsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AnalyticsFilter.wrap(buildAwsValue())
}
object AnalyticsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AnalyticsFilter =
      io.github.vigoo.zioaws.s3.model.AnalyticsFilter(
        prefixValue.map(value => value),
        tagValue.map(value => value.editable),
        andValue.map(value => value.editable)
      )
    def prefixValue: Option[Prefix]
    def tagValue: Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def andValue
        : Option[io.github.vigoo.zioaws.s3.model.AnalyticsAndOperator.ReadOnly]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tag: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tagValue)
    def and: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AnalyticsAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", andValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ) extends io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagValue
        : Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => io.github.vigoo.zioaws.s3.model.Tag.wrap(value))
    override def andValue: Option[
      io.github.vigoo.zioaws.s3.model.AnalyticsAndOperator.ReadOnly
    ] = scala
      .Option(impl.and())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.AnalyticsAndOperator.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsFilter
  ): io.github.vigoo.zioaws.s3.model.AnalyticsFilter.ReadOnly = new Wrapper(
    impl
  )
}
