package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  Prefix,
  BucketName,
  AccountId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalyticsS3BucketDestination(
    format: io.github.vigoo.zioaws.s3.model.AnalyticsS3ExportFileFormat,
    bucketAccountId: Option[AccountId] = None,
    bucket: BucketName,
    prefix: Option[Prefix] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination = {
    import AnalyticsS3BucketDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
      .builder()
      .format(format.unwrap)
      .optionallyWith(bucketAccountId.map(value => value: java.lang.String))(
        _.bucketAccountId
      )
      .bucket(bucket: java.lang.String)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly =
    io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination
      .wrap(buildAwsValue())
}
object AnalyticsS3BucketDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination =
      io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination(
        formatValue,
        bucketAccountIdValue.map(value => value),
        bucketValue,
        prefixValue.map(value => value)
      )
    def formatValue: io.github.vigoo.zioaws.s3.model.AnalyticsS3ExportFileFormat
    def bucketAccountIdValue: Option[AccountId]
    def bucketValue: BucketName
    def prefixValue: Option[Prefix]
    def format: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.AnalyticsS3ExportFileFormat
    ] = ZIO.succeed(formatValue)
    def bucketAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("bucketAccountId", bucketAccountIdValue)
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ) extends io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly {
    override def formatValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsS3ExportFileFormat =
      io.github.vigoo.zioaws.s3.model.AnalyticsS3ExportFileFormat
        .wrap(impl.format())
    override def bucketAccountIdValue: Option[AccountId] =
      scala.Option(impl.bucketAccountId()).map(value => value: AccountId)
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.AnalyticsS3BucketDestination
  ): io.github.vigoo.zioaws.s3.model.AnalyticsS3BucketDestination.ReadOnly =
    new Wrapper(impl)
}
