package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{CreationDate, BucketName}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Bucket(
    name: Option[BucketName] = None,
    creationDate: Option[CreationDate] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Bucket = {
    import Bucket.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Bucket
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(creationDate.map(value => value: Instant))(_.creationDate)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Bucket.wrap(buildAwsValue())
}
object Bucket {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Bucket] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Bucket =
      io.github.vigoo.zioaws.s3.model.Bucket(
        nameValue.map(value => value),
        creationDateValue.map(value => value)
      )
    def nameValue: Option[BucketName]
    def creationDateValue: Option[CreationDate]
    def name: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("name", nameValue)
    def creationDate: ZIO[Any, AwsError, CreationDate] =
      AwsError.unwrapOptionField("creationDate", creationDateValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Bucket)
      extends io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly {
    override def nameValue: Option[BucketName] =
      scala.Option(impl.name()).map(value => value: BucketName)
    override def creationDateValue: Option[CreationDate] =
      scala.Option(impl.creationDate()).map(value => value: CreationDate)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Bucket
  ): io.github.vigoo.zioaws.s3.model.Bucket.ReadOnly = new Wrapper(impl)
}
