package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BucketLifecycleConfiguration(
    rules: Iterable[io.github.vigoo.zioaws.s3.model.LifecycleRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration = {
    import BucketLifecycleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration
      .wrap(buildAwsValue())
}
object BucketLifecycleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration =
      io.github.vigoo.zioaws.s3.model
        .BucketLifecycleConfiguration(rulesValue.map { item =>
          item.editable
        })
    def rulesValue: List[io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly]
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly {
    override def rulesValue
        : List[io.github.vigoo.zioaws.s3.model.LifecycleRule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.LifecycleRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration
  ): io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly =
    new Wrapper(impl)
}
