package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BucketLoggingStatus(
    loggingEnabled: Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.BucketLoggingStatus = {
    import BucketLoggingStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.BucketLoggingStatus
      .builder()
      .optionallyWith(loggingEnabled.map(value => value.buildAwsValue()))(
        _.loggingEnabled
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly =
    io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.wrap(buildAwsValue())
}
object BucketLoggingStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.BucketLoggingStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.BucketLoggingStatus =
      io.github.vigoo.zioaws.s3.model
        .BucketLoggingStatus(loggingEnabledValue.map(value => value.editable))
    def loggingEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly]
    def loggingEnabled: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly
    ] = AwsError.unwrapOptionField("loggingEnabled", loggingEnabledValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.BucketLoggingStatus
  ) extends io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly {
    override def loggingEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.LoggingEnabled.ReadOnly] =
      scala
        .Option(impl.loggingEnabled())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.LoggingEnabled.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.BucketLoggingStatus
  ): io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly = new Wrapper(
    impl
  )
}
