package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait BucketVersioningStatus {
  def unwrap: software.amazon.awssdk.services.s3.model.BucketVersioningStatus
}
object BucketVersioningStatus {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.BucketVersioningStatus
  ): io.github.vigoo.zioaws.s3.model.BucketVersioningStatus = value match {
    case software.amazon.awssdk.services.s3.model.BucketVersioningStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.BucketVersioningStatus.ENABLED =>
      val r = Enabled
      r
    case software.amazon.awssdk.services.s3.model.BucketVersioningStatus.SUSPENDED =>
      val r = Suspended
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3.model.BucketVersioningStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends io.github.vigoo.zioaws.s3.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3.model.BucketVersioningStatus.ENABLED
  }
  case object Suspended
      extends io.github.vigoo.zioaws.s3.model.BucketVersioningStatus {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.BucketVersioningStatus =
      software.amazon.awssdk.services.s3.model.BucketVersioningStatus.SUSPENDED
  }
}
