package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CORSConfiguration(
    corsRules: Iterable[io.github.vigoo.zioaws.s3.model.CORSRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CORSConfiguration = {
    import CORSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CORSConfiguration
      .builder()
      .corsRules(corsRules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CORSConfiguration.wrap(buildAwsValue())
}
object CORSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CORSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CORSConfiguration =
      io.github.vigoo.zioaws.s3.model.CORSConfiguration(corsRulesValue.map {
        item =>
          item.editable
      })
    def corsRulesValue: List[io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly]
    def corsRules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly
    ]] = ZIO.succeed(corsRulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CORSConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly {
    override def corsRulesValue
        : List[io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly] = impl
      .corsRules()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.CORSRule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CORSConfiguration
  ): io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
