package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{
  AllowedOrigin,
  AllowedMethod,
  AllowedHeader,
  MaxAgeSeconds,
  ExposeHeader,
  ID
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CORSRule(
    id: Option[ID] = None,
    allowedHeaders: Option[Iterable[AllowedHeader]] = None,
    allowedMethods: Iterable[AllowedMethod],
    allowedOrigins: Iterable[AllowedOrigin],
    exposeHeaders: Option[Iterable[ExposeHeader]] = None,
    maxAgeSeconds: Option[MaxAgeSeconds] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CORSRule = {
    import CORSRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CORSRule
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(
        allowedHeaders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedHeaders)
      .allowedMethods(allowedMethods.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .allowedOrigins(allowedOrigins.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        exposeHeaders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.exposeHeaders)
      .optionallyWith(maxAgeSeconds.map(value => value: Integer))(
        _.maxAgeSeconds
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CORSRule.wrap(buildAwsValue())
}
object CORSRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CORSRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CORSRule =
      io.github.vigoo.zioaws.s3.model.CORSRule(
        idValue.map(value => value),
        allowedHeadersValue.map(value => value),
        allowedMethodsValue,
        allowedOriginsValue,
        exposeHeadersValue.map(value => value),
        maxAgeSecondsValue.map(value => value)
      )
    def idValue: Option[ID]
    def allowedHeadersValue: Option[List[AllowedHeader]]
    def allowedMethodsValue: List[AllowedMethod]
    def allowedOriginsValue: List[AllowedOrigin]
    def exposeHeadersValue: Option[List[ExposeHeader]]
    def maxAgeSecondsValue: Option[MaxAgeSeconds]
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
    def allowedHeaders: ZIO[Any, AwsError, List[AllowedHeader]] =
      AwsError.unwrapOptionField("allowedHeaders", allowedHeadersValue)
    def allowedMethods: ZIO[Any, Nothing, List[AllowedMethod]] =
      ZIO.succeed(allowedMethodsValue)
    def allowedOrigins: ZIO[Any, Nothing, List[AllowedOrigin]] =
      ZIO.succeed(allowedOriginsValue)
    def exposeHeaders: ZIO[Any, AwsError, List[ExposeHeader]] =
      AwsError.unwrapOptionField("exposeHeaders", exposeHeadersValue)
    def maxAgeSeconds: ZIO[Any, AwsError, MaxAgeSeconds] =
      AwsError.unwrapOptionField("maxAgeSeconds", maxAgeSecondsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.CORSRule)
      extends io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly {
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
    override def allowedHeadersValue: Option[List[AllowedHeader]] = scala
      .Option(impl.allowedHeaders())
      .map(value =>
        value.asScala.map { item =>
          item: AllowedHeader
        }.toList
      )
    override def allowedMethodsValue: List[AllowedMethod] = impl
      .allowedMethods()
      .asScala
      .map { item =>
        item: AllowedMethod
      }
      .toList
    override def allowedOriginsValue: List[AllowedOrigin] = impl
      .allowedOrigins()
      .asScala
      .map { item =>
        item: AllowedOrigin
      }
      .toList
    override def exposeHeadersValue: Option[List[ExposeHeader]] = scala
      .Option(impl.exposeHeaders())
      .map(value =>
        value.asScala.map { item =>
          item: ExposeHeader
        }.toList
      )
    override def maxAgeSecondsValue: Option[MaxAgeSeconds] =
      scala.Option(impl.maxAgeSeconds()).map(value => value: MaxAgeSeconds)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CORSRule
  ): io.github.vigoo.zioaws.s3.model.CORSRule.ReadOnly = new Wrapper(impl)
}
