package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  RecordDelimiter,
  FieldDelimiter,
  AllowQuotedRecordDelimiter,
  QuoteEscapeCharacter,
  QuoteCharacter,
  Comments
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CSVInput(
    fileHeaderInfo: Option[io.github.vigoo.zioaws.s3.model.FileHeaderInfo] =
      None,
    comments: Option[Comments] = None,
    quoteEscapeCharacter: Option[QuoteEscapeCharacter] = None,
    recordDelimiter: Option[RecordDelimiter] = None,
    fieldDelimiter: Option[FieldDelimiter] = None,
    quoteCharacter: Option[QuoteCharacter] = None,
    allowQuotedRecordDelimiter: Option[AllowQuotedRecordDelimiter] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CSVInput = {
    import CSVInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CSVInput
      .builder()
      .optionallyWith(fileHeaderInfo.map(value => value.unwrap))(
        _.fileHeaderInfo
      )
      .optionallyWith(comments.map(value => value: java.lang.String))(
        _.comments
      )
      .optionallyWith(
        quoteEscapeCharacter.map(value => value: java.lang.String)
      )(_.quoteEscapeCharacter)
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .optionallyWith(fieldDelimiter.map(value => value: java.lang.String))(
        _.fieldDelimiter
      )
      .optionallyWith(quoteCharacter.map(value => value: java.lang.String))(
        _.quoteCharacter
      )
      .optionallyWith(
        allowQuotedRecordDelimiter.map(value => value: java.lang.Boolean)
      )(_.allowQuotedRecordDelimiter)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CSVInput.wrap(buildAwsValue())
}
object CSVInput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CSVInput] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CSVInput =
      io.github.vigoo.zioaws.s3.model.CSVInput(
        fileHeaderInfoValue.map(value => value),
        commentsValue.map(value => value),
        quoteEscapeCharacterValue.map(value => value),
        recordDelimiterValue.map(value => value),
        fieldDelimiterValue.map(value => value),
        quoteCharacterValue.map(value => value),
        allowQuotedRecordDelimiterValue.map(value => value)
      )
    def fileHeaderInfoValue
        : Option[io.github.vigoo.zioaws.s3.model.FileHeaderInfo]
    def commentsValue: Option[Comments]
    def quoteEscapeCharacterValue: Option[QuoteEscapeCharacter]
    def recordDelimiterValue: Option[RecordDelimiter]
    def fieldDelimiterValue: Option[FieldDelimiter]
    def quoteCharacterValue: Option[QuoteCharacter]
    def allowQuotedRecordDelimiterValue: Option[AllowQuotedRecordDelimiter]
    def fileHeaderInfo
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.FileHeaderInfo] =
      AwsError.unwrapOptionField("fileHeaderInfo", fileHeaderInfoValue)
    def comments: ZIO[Any, AwsError, Comments] =
      AwsError.unwrapOptionField("comments", commentsValue)
    def quoteEscapeCharacter: ZIO[Any, AwsError, QuoteEscapeCharacter] =
      AwsError.unwrapOptionField(
        "quoteEscapeCharacter",
        quoteEscapeCharacterValue
      )
    def recordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiterValue)
    def fieldDelimiter: ZIO[Any, AwsError, FieldDelimiter] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiterValue)
    def quoteCharacter: ZIO[Any, AwsError, QuoteCharacter] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacterValue)
    def allowQuotedRecordDelimiter
        : ZIO[Any, AwsError, AllowQuotedRecordDelimiter] =
      AwsError.unwrapOptionField(
        "allowQuotedRecordDelimiter",
        allowQuotedRecordDelimiterValue
      )
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.CSVInput)
      extends io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly {
    override def fileHeaderInfoValue
        : Option[io.github.vigoo.zioaws.s3.model.FileHeaderInfo] = scala
      .Option(impl.fileHeaderInfo())
      .map(value => io.github.vigoo.zioaws.s3.model.FileHeaderInfo.wrap(value))
    override def commentsValue: Option[Comments] =
      scala.Option(impl.comments()).map(value => value: Comments)
    override def quoteEscapeCharacterValue: Option[QuoteEscapeCharacter] = scala
      .Option(impl.quoteEscapeCharacter())
      .map(value => value: QuoteEscapeCharacter)
    override def recordDelimiterValue: Option[RecordDelimiter] =
      scala.Option(impl.recordDelimiter()).map(value => value: RecordDelimiter)
    override def fieldDelimiterValue: Option[FieldDelimiter] =
      scala.Option(impl.fieldDelimiter()).map(value => value: FieldDelimiter)
    override def quoteCharacterValue: Option[QuoteCharacter] =
      scala.Option(impl.quoteCharacter()).map(value => value: QuoteCharacter)
    override def allowQuotedRecordDelimiterValue
        : Option[AllowQuotedRecordDelimiter] = scala
      .Option(impl.allowQuotedRecordDelimiter())
      .map(value => value: AllowQuotedRecordDelimiter)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CSVInput
  ): io.github.vigoo.zioaws.s3.model.CSVInput.ReadOnly = new Wrapper(impl)
}
