package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  QuoteCharacter,
  FieldDelimiter,
  RecordDelimiter,
  QuoteEscapeCharacter
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CSVOutput(
    quoteFields: Option[io.github.vigoo.zioaws.s3.model.QuoteFields] = None,
    quoteEscapeCharacter: Option[QuoteEscapeCharacter] = None,
    recordDelimiter: Option[RecordDelimiter] = None,
    fieldDelimiter: Option[FieldDelimiter] = None,
    quoteCharacter: Option[QuoteCharacter] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CSVOutput = {
    import CSVOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CSVOutput
      .builder()
      .optionallyWith(quoteFields.map(value => value.unwrap))(_.quoteFields)
      .optionallyWith(
        quoteEscapeCharacter.map(value => value: java.lang.String)
      )(_.quoteEscapeCharacter)
      .optionallyWith(recordDelimiter.map(value => value: java.lang.String))(
        _.recordDelimiter
      )
      .optionallyWith(fieldDelimiter.map(value => value: java.lang.String))(
        _.fieldDelimiter
      )
      .optionallyWith(quoteCharacter.map(value => value: java.lang.String))(
        _.quoteCharacter
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CSVOutput.wrap(buildAwsValue())
}
object CSVOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CSVOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CSVOutput =
      io.github.vigoo.zioaws.s3.model.CSVOutput(
        quoteFieldsValue.map(value => value),
        quoteEscapeCharacterValue.map(value => value),
        recordDelimiterValue.map(value => value),
        fieldDelimiterValue.map(value => value),
        quoteCharacterValue.map(value => value)
      )
    def quoteFieldsValue: Option[io.github.vigoo.zioaws.s3.model.QuoteFields]
    def quoteEscapeCharacterValue: Option[QuoteEscapeCharacter]
    def recordDelimiterValue: Option[RecordDelimiter]
    def fieldDelimiterValue: Option[FieldDelimiter]
    def quoteCharacterValue: Option[QuoteCharacter]
    def quoteFields
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.QuoteFields] =
      AwsError.unwrapOptionField("quoteFields", quoteFieldsValue)
    def quoteEscapeCharacter: ZIO[Any, AwsError, QuoteEscapeCharacter] =
      AwsError.unwrapOptionField(
        "quoteEscapeCharacter",
        quoteEscapeCharacterValue
      )
    def recordDelimiter: ZIO[Any, AwsError, RecordDelimiter] =
      AwsError.unwrapOptionField("recordDelimiter", recordDelimiterValue)
    def fieldDelimiter: ZIO[Any, AwsError, FieldDelimiter] =
      AwsError.unwrapOptionField("fieldDelimiter", fieldDelimiterValue)
    def quoteCharacter: ZIO[Any, AwsError, QuoteCharacter] =
      AwsError.unwrapOptionField("quoteCharacter", quoteCharacterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CSVOutput
  ) extends io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly {
    override def quoteFieldsValue
        : Option[io.github.vigoo.zioaws.s3.model.QuoteFields] = scala
      .Option(impl.quoteFields())
      .map(value => io.github.vigoo.zioaws.s3.model.QuoteFields.wrap(value))
    override def quoteEscapeCharacterValue: Option[QuoteEscapeCharacter] = scala
      .Option(impl.quoteEscapeCharacter())
      .map(value => value: QuoteEscapeCharacter)
    override def recordDelimiterValue: Option[RecordDelimiter] =
      scala.Option(impl.recordDelimiter()).map(value => value: RecordDelimiter)
    override def fieldDelimiterValue: Option[FieldDelimiter] =
      scala.Option(impl.fieldDelimiter()).map(value => value: FieldDelimiter)
    override def quoteCharacterValue: Option[QuoteCharacter] =
      scala.Option(impl.quoteCharacter()).map(value => value: QuoteCharacter)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CSVOutput
  ): io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly = new Wrapper(impl)
}
