package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ChecksumMode {
  def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode
}
object ChecksumMode {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ChecksumMode
  ): io.github.vigoo.zioaws.s3.model.ChecksumMode = value match {
    case software.amazon.awssdk.services.s3.model.ChecksumMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ChecksumMode.ENABLED =>
      val r = ENABLED
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ChecksumMode {
    override def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode =
      software.amazon.awssdk.services.s3.model.ChecksumMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends io.github.vigoo.zioaws.s3.model.ChecksumMode {
    override def unwrap: software.amazon.awssdk.services.s3.model.ChecksumMode =
      software.amazon.awssdk.services.s3.model.ChecksumMode.ENABLED
  }
}
