package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Prefix
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CommonPrefix(prefix: Option[Prefix] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.CommonPrefix = {
    import CommonPrefix.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CommonPrefix
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CommonPrefix.wrap(buildAwsValue())
}
object CommonPrefix {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CommonPrefix] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CommonPrefix =
      io.github.vigoo.zioaws.s3.model
        .CommonPrefix(prefixValue.map(value => value))
    def prefixValue: Option[Prefix]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CommonPrefix
  ) extends io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CommonPrefix
  ): io.github.vigoo.zioaws.s3.model.CommonPrefix.ReadOnly = new Wrapper(impl)
}
