package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  ChecksumSHA256,
  ChecksumCRC32C,
  ObjectKey,
  ChecksumCRC32,
  ChecksumSHA1,
  BucketName,
  MultipartUploadId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompleteMultipartUploadRequest(
    bucket: BucketName,
    key: ObjectKey,
    multipartUpload: Option[
      io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload
    ] = None,
    uploadId: MultipartUploadId,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    expectedBucketOwner: Option[AccountId] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest = {
    import CompleteMultipartUploadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(multipartUpload.map(value => value.buildAwsValue()))(
        _.multipartUpload
      )
      .uploadId(uploadId: java.lang.String)
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest
      .wrap(buildAwsValue())
}
object CompleteMultipartUploadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest =
      io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest(
        bucketValue,
        keyValue,
        multipartUploadValue.map(value => value.editable),
        uploadIdValue,
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value),
        requestPayerValue.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def multipartUploadValue: Option[
      io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly
    ]
    def uploadIdValue: MultipartUploadId
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def expectedBucketOwnerValue: Option[AccountId]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def multipartUpload: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly
    ] = AwsError.unwrapOptionField("multipartUpload", multipartUploadValue)
    def uploadId: ZIO[Any, Nothing, MultipartUploadId] =
      ZIO.succeed(uploadIdValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ) extends io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def multipartUploadValue: Option[
      io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly
    ] = scala
      .Option(impl.multipartUpload())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.wrap(value)
      )
    override def uploadIdValue: MultipartUploadId =
      impl.uploadId(): MultipartUploadId
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest
  ): io.github.vigoo.zioaws.s3.model.CompleteMultipartUploadRequest.ReadOnly =
    new Wrapper(impl)
}
