package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompletedMultipartUpload(
    parts: Option[Iterable[io.github.vigoo.zioaws.s3.model.CompletedPart]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CompletedMultipartUpload = {
    import CompletedMultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
      .builder()
      .optionallyWith(
        parts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parts)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload
      .wrap(buildAwsValue())
}
object CompletedMultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload =
      io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload(
        partsValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def partsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CompletedPart.ReadOnly]]
    def parts: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.CompletedPart.ReadOnly
    ]] = AwsError.unwrapOptionField("parts", partsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ) extends io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly {
    override def partsValue
        : Option[List[io.github.vigoo.zioaws.s3.model.CompletedPart.ReadOnly]] =
      scala
        .Option(impl.parts())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.CompletedPart.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CompletedMultipartUpload
  ): io.github.vigoo.zioaws.s3.model.CompletedMultipartUpload.ReadOnly =
    new Wrapper(impl)
}
