package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait CompressionType {
  def unwrap: software.amazon.awssdk.services.s3.model.CompressionType
}
object CompressionType {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.CompressionType
  ): io.github.vigoo.zioaws.s3.model.CompressionType = value match {
    case software.amazon.awssdk.services.s3.model.CompressionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.GZIP =>
      val r = GZIP
      r
    case software.amazon.awssdk.services.s3.model.CompressionType.BZIP2 =>
      val r = BZIP2
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends io.github.vigoo.zioaws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.NONE
  }
  case object GZIP extends io.github.vigoo.zioaws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.GZIP
  }
  case object BZIP2 extends io.github.vigoo.zioaws.s3.model.CompressionType {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.CompressionType =
      software.amazon.awssdk.services.s3.model.CompressionType.BZIP2
  }
}
