package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  KeyPrefixEquals,
  HttpErrorCodeReturnedEquals
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Condition(
    httpErrorCodeReturnedEquals: Option[HttpErrorCodeReturnedEquals] = None,
    keyPrefixEquals: Option[KeyPrefixEquals] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Condition = {
    import Condition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Condition
      .builder()
      .optionallyWith(
        httpErrorCodeReturnedEquals.map(value => value: java.lang.String)
      )(_.httpErrorCodeReturnedEquals)
      .optionallyWith(keyPrefixEquals.map(value => value: java.lang.String))(
        _.keyPrefixEquals
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Condition.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Condition.wrap(buildAwsValue())
}
object Condition {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Condition] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Condition =
      io.github.vigoo.zioaws.s3.model.Condition(
        httpErrorCodeReturnedEqualsValue.map(value => value),
        keyPrefixEqualsValue.map(value => value)
      )
    def httpErrorCodeReturnedEqualsValue: Option[HttpErrorCodeReturnedEquals]
    def keyPrefixEqualsValue: Option[KeyPrefixEquals]
    def httpErrorCodeReturnedEquals
        : ZIO[Any, AwsError, HttpErrorCodeReturnedEquals] =
      AwsError.unwrapOptionField(
        "httpErrorCodeReturnedEquals",
        httpErrorCodeReturnedEqualsValue
      )
    def keyPrefixEquals: ZIO[Any, AwsError, KeyPrefixEquals] =
      AwsError.unwrapOptionField("keyPrefixEquals", keyPrefixEqualsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.Condition
  ) extends io.github.vigoo.zioaws.s3.model.Condition.ReadOnly {
    override def httpErrorCodeReturnedEqualsValue
        : Option[HttpErrorCodeReturnedEquals] = scala
      .Option(impl.httpErrorCodeReturnedEquals())
      .map(value => value: HttpErrorCodeReturnedEquals)
    override def keyPrefixEqualsValue: Option[KeyPrefixEquals] =
      scala.Option(impl.keyPrefixEquals()).map(value => value: KeyPrefixEquals)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Condition
  ): io.github.vigoo.zioaws.s3.model.Condition.ReadOnly = new Wrapper(impl)
}
