package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  Expiration,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  SSEKMSKeyId,
  ObjectVersionId,
  CopySourceVersionId,
  BucketKeyEnabled
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyObjectResponse(
    copyObjectResult: Option[io.github.vigoo.zioaws.s3.model.CopyObjectResult] =
      None,
    expiration: Option[Expiration] = None,
    copySourceVersionId: Option[CopySourceVersionId] = None,
    versionId: Option[ObjectVersionId] = None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyObjectResponse = {
    import CopyObjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
      .builder()
      .optionallyWith(copyObjectResult.map(value => value.buildAwsValue()))(
        _.copyObjectResult
      )
      .optionallyWith(expiration.map(value => value: java.lang.String))(
        _.expiration
      )
      .optionallyWith(
        copySourceVersionId.map(value => value: java.lang.String)
      )(_.copySourceVersionId)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(
        ssekmsEncryptionContext.map(value => value: java.lang.String)
      )(_.ssekmsEncryptionContext)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CopyObjectResponse.wrap(buildAwsValue())
}
object CopyObjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CopyObjectResponse =
      io.github.vigoo.zioaws.s3.model.CopyObjectResponse(
        copyObjectResultValue.map(value => value.editable),
        expirationValue.map(value => value),
        copySourceVersionIdValue.map(value => value),
        versionIdValue.map(value => value),
        serverSideEncryptionValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        ssekmsEncryptionContextValue.map(value => value),
        bucketKeyEnabledValue.map(value => value),
        requestChargedValue.map(value => value)
      )
    def copyObjectResultValue
        : Option[io.github.vigoo.zioaws.s3.model.CopyObjectResult.ReadOnly]
    def expirationValue: Option[Expiration]
    def copySourceVersionIdValue: Option[CopySourceVersionId]
    def versionIdValue: Option[ObjectVersionId]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def copyObjectResult: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CopyObjectResult.ReadOnly
    ] = AwsError.unwrapOptionField("copyObjectResult", copyObjectResultValue)
    def expiration: ZIO[Any, AwsError, Expiration] =
      AwsError.unwrapOptionField("expiration", expirationValue)
    def copySourceVersionId: ZIO[Any, AwsError, CopySourceVersionId] = AwsError
      .unwrapOptionField("copySourceVersionId", copySourceVersionIdValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def ssekmsEncryptionContext: ZIO[Any, AwsError, SSEKMSEncryptionContext] =
      AwsError.unwrapOptionField(
        "ssekmsEncryptionContext",
        ssekmsEncryptionContextValue
      )
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ) extends io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly {
    override def copyObjectResultValue
        : Option[io.github.vigoo.zioaws.s3.model.CopyObjectResult.ReadOnly] =
      scala
        .Option(impl.copyObjectResult())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.CopyObjectResult.wrap(value)
        )
    override def expirationValue: Option[Expiration] =
      scala.Option(impl.expiration()).map(value => value: Expiration)
    override def copySourceVersionIdValue: Option[CopySourceVersionId] = scala
      .Option(impl.copySourceVersionId())
      .map(value => value: CopySourceVersionId)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value => value: SSEKMSEncryptionContext)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyObjectResponse
  ): io.github.vigoo.zioaws.s3.model.CopyObjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
