package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ETag,
  ChecksumSHA256,
  LastModified,
  ChecksumCRC32C,
  ChecksumCRC32,
  ChecksumSHA1
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CopyPartResult(
    eTag: Option[ETag] = None,
    lastModified: Option[LastModified] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CopyPartResult = {
    import CopyPartResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CopyPartResult
      .builder()
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CopyPartResult.wrap(buildAwsValue())
}
object CopyPartResult {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.CopyPartResult] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CopyPartResult =
      io.github.vigoo.zioaws.s3.model.CopyPartResult(
        eTagValue.map(value => value),
        lastModifiedValue.map(value => value),
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value)
      )
    def eTagValue: Option[ETag]
    def lastModifiedValue: Option[LastModified]
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CopyPartResult
  ) extends io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly {
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CopyPartResult
  ): io.github.vigoo.zioaws.s3.model.CopyPartResult.ReadOnly = new Wrapper(impl)
}
