package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBucketConfiguration(
    locationConstraint: Option[
      io.github.vigoo.zioaws.s3.model.BucketLocationConstraint
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketConfiguration = {
    import CreateBucketConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
      .builder()
      .optionallyWith(locationConstraint.map(value => value.unwrap))(
        _.locationConstraint
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration
      .wrap(buildAwsValue())
}
object CreateBucketConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration =
      io.github.vigoo.zioaws.s3.model
        .CreateBucketConfiguration(locationConstraintValue.map(value => value))
    def locationConstraintValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketLocationConstraint]
    def locationConstraint: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketLocationConstraint
    ] =
      AwsError.unwrapOptionField("locationConstraint", locationConstraintValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly {
    override def locationConstraintValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketLocationConstraint] =
      scala
        .Option(impl.locationConstraint())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.BucketLocationConstraint.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketConfiguration
  ): io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly =
    new Wrapper(impl)
}
