package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  GrantRead,
  GrantReadACP,
  ObjectLockEnabledForBucket,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBucketRequest(
    acl: Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL] = None,
    bucket: BucketName,
    createBucketConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration
    ] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWrite: Option[GrantWrite] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    objectLockEnabledForBucket: Option[ObjectLockEnabledForBucket] = None,
    objectOwnership: Option[io.github.vigoo.zioaws.s3.model.ObjectOwnership] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketRequest = {
    import CreateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        createBucketConfiguration.map(value => value.buildAwsValue())
      )(_.createBucketConfiguration)
      .optionallyWith(grantFullControl.map(value => value: java.lang.String))(
        _.grantFullControl
      )
      .optionallyWith(grantRead.map(value => value: java.lang.String))(
        _.grantRead
      )
      .optionallyWith(grantReadACP.map(value => value: java.lang.String))(
        _.grantReadACP
      )
      .optionallyWith(grantWrite.map(value => value: java.lang.String))(
        _.grantWrite
      )
      .optionallyWith(grantWriteACP.map(value => value: java.lang.String))(
        _.grantWriteACP
      )
      .optionallyWith(
        objectLockEnabledForBucket.map(value => value: java.lang.Boolean)
      )(_.objectLockEnabledForBucket)
      .optionallyWith(objectOwnership.map(value => value.unwrap))(
        _.objectOwnership
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.CreateBucketRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CreateBucketRequest.wrap(buildAwsValue())
}
object CreateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CreateBucketRequest =
      io.github.vigoo.zioaws.s3.model.CreateBucketRequest(
        aclValue.map(value => value),
        bucketValue,
        createBucketConfigurationValue.map(value => value.editable),
        grantFullControlValue.map(value => value),
        grantReadValue.map(value => value),
        grantReadACPValue.map(value => value),
        grantWriteValue.map(value => value),
        grantWriteACPValue.map(value => value),
        objectLockEnabledForBucketValue.map(value => value),
        objectOwnershipValue.map(value => value)
      )
    def aclValue: Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL]
    def bucketValue: BucketName
    def createBucketConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly
    ]
    def grantFullControlValue: Option[GrantFullControl]
    def grantReadValue: Option[GrantRead]
    def grantReadACPValue: Option[GrantReadACP]
    def grantWriteValue: Option[GrantWrite]
    def grantWriteACPValue: Option[GrantWriteACP]
    def objectLockEnabledForBucketValue: Option[ObjectLockEnabledForBucket]
    def objectOwnershipValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectOwnership]
    def acl
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", aclValue)
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def createBucketConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "createBucketConfiguration",
      createBucketConfigurationValue
    )
    def grantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControlValue)
    def grantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantReadValue)
    def grantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACPValue)
    def grantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWriteValue)
    def grantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACPValue)
    def objectLockEnabledForBucket
        : ZIO[Any, AwsError, ObjectLockEnabledForBucket] =
      AwsError.unwrapOptionField(
        "objectLockEnabledForBucket",
        objectLockEnabledForBucketValue
      )
    def objectOwnership
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectOwnership] =
      AwsError.unwrapOptionField("objectOwnership", objectOwnershipValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ) extends io.github.vigoo.zioaws.s3.model.CreateBucketRequest.ReadOnly {
    override def aclValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL] = scala
      .Option(impl.acl())
      .map(value => io.github.vigoo.zioaws.s3.model.BucketCannedACL.wrap(value))
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def createBucketConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.ReadOnly
    ] = scala
      .Option(impl.createBucketConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.CreateBucketConfiguration.wrap(value)
      )
    override def grantFullControlValue: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => value: GrantFullControl)
    override def grantReadValue: Option[GrantRead] =
      scala.Option(impl.grantRead()).map(value => value: GrantRead)
    override def grantReadACPValue: Option[GrantReadACP] =
      scala.Option(impl.grantReadACP()).map(value => value: GrantReadACP)
    override def grantWriteValue: Option[GrantWrite] =
      scala.Option(impl.grantWrite()).map(value => value: GrantWrite)
    override def grantWriteACPValue: Option[GrantWriteACP] =
      scala.Option(impl.grantWriteACP()).map(value => value: GrantWriteACP)
    override def objectLockEnabledForBucketValue
        : Option[ObjectLockEnabledForBucket] = scala
      .Option(impl.objectLockEnabledForBucket())
      .map(value => value: ObjectLockEnabledForBucket)
    override def objectOwnershipValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectOwnership] = scala
      .Option(impl.objectOwnership())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectOwnership.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketRequest
  ): io.github.vigoo.zioaws.s3.model.CreateBucketRequest.ReadOnly = new Wrapper(
    impl
  )
}
