package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Location
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBucketResponse(location: Option[Location] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateBucketResponse = {
    import CreateBucketResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateBucketResponse
      .builder()
      .optionallyWith(location.map(value => value: java.lang.String))(
        _.location
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CreateBucketResponse.wrap(buildAwsValue())
}
object CreateBucketResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.CreateBucketResponse =
      io.github.vigoo.zioaws.s3.model
        .CreateBucketResponse(locationValue.map(value => value))
    def locationValue: Option[Location]
    def location: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", locationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ) extends io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly {
    override def locationValue: Option[Location] =
      scala.Option(impl.location()).map(value => value: Location)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateBucketResponse
  ): io.github.vigoo.zioaws.s3.model.CreateBucketResponse.ReadOnly =
    new Wrapper(impl)
}
