package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AbortRuleId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  ObjectKey,
  BucketName,
  SSEKMSKeyId,
  AbortDate,
  BucketKeyEnabled,
  MultipartUploadId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateMultipartUploadResponse(
    abortDate: Option[AbortDate] = None,
    abortRuleId: Option[AbortRuleId] = None,
    bucket: Option[BucketName] = None,
    key: Option[ObjectKey] = None,
    uploadId: Option[MultipartUploadId] = None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse = {
    import CreateMultipartUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
      .builder()
      .optionallyWith(abortDate.map(value => value: Instant))(_.abortDate)
      .optionallyWith(abortRuleId.map(value => value: java.lang.String))(
        _.abortRuleId
      )
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(uploadId.map(value => value: java.lang.String))(
        _.uploadId
      )
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(
        ssekmsEncryptionContext.map(value => value: java.lang.String)
      )(_.ssekmsEncryptionContext)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse
      .wrap(buildAwsValue())
}
object CreateMultipartUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse =
      io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse(
        abortDateValue.map(value => value),
        abortRuleIdValue.map(value => value),
        bucketValue.map(value => value),
        keyValue.map(value => value),
        uploadIdValue.map(value => value),
        serverSideEncryptionValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        ssekmsEncryptionContextValue.map(value => value),
        bucketKeyEnabledValue.map(value => value),
        requestChargedValue.map(value => value),
        checksumAlgorithmValue.map(value => value)
      )
    def abortDateValue: Option[AbortDate]
    def abortRuleIdValue: Option[AbortRuleId]
    def bucketValue: Option[BucketName]
    def keyValue: Option[ObjectKey]
    def uploadIdValue: Option[MultipartUploadId]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def abortDate: ZIO[Any, AwsError, AbortDate] =
      AwsError.unwrapOptionField("abortDate", abortDateValue)
    def abortRuleId: ZIO[Any, AwsError, AbortRuleId] =
      AwsError.unwrapOptionField("abortRuleId", abortRuleIdValue)
    def bucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucket", bucketValue)
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def uploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadIdValue)
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def ssekmsEncryptionContext: ZIO[Any, AwsError, SSEKMSEncryptionContext] =
      AwsError.unwrapOptionField(
        "ssekmsEncryptionContext",
        ssekmsEncryptionContextValue
      )
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ) extends io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly {
    override def abortDateValue: Option[AbortDate] =
      scala.Option(impl.abortDate()).map(value => value: AbortDate)
    override def abortRuleIdValue: Option[AbortRuleId] =
      scala.Option(impl.abortRuleId()).map(value => value: AbortRuleId)
    override def bucketValue: Option[BucketName] =
      scala.Option(impl.bucket()).map(value => value: BucketName)
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def uploadIdValue: Option[MultipartUploadId] =
      scala.Option(impl.uploadId()).map(value => value: MultipartUploadId)
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value => value: SSEKMSEncryptionContext)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse
  ): io.github.vigoo.zioaws.s3.model.CreateMultipartUploadResponse.ReadOnly =
    new Wrapper(impl)
}
