package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{Years, Days}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DefaultRetention(
    mode: Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode] =
      None,
    days: Option[Days] = None,
    years: Option[Years] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DefaultRetention = {
    import DefaultRetention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DefaultRetention
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(days.map(value => value: Integer))(_.days)
      .optionallyWith(years.map(value => value: Integer))(_.years)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DefaultRetention.wrap(buildAwsValue())
}
object DefaultRetention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DefaultRetention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.DefaultRetention =
      io.github.vigoo.zioaws.s3.model.DefaultRetention(
        modeValue.map(value => value),
        daysValue.map(value => value),
        yearsValue.map(value => value)
      )
    def modeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode]
    def daysValue: Option[Days]
    def yearsValue: Option[Years]
    def mode: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode
    ] = AwsError.unwrapOptionField("mode", modeValue)
    def days: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("days", daysValue)
    def years: ZIO[Any, AwsError, Years] =
      AwsError.unwrapOptionField("years", yearsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DefaultRetention
  ) extends io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly {
    override def modeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode] =
      scala
        .Option(impl.mode())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode.wrap(value)
        )
    override def daysValue: Option[Days] =
      scala.Option(impl.days()).map(value => value: Days)
    override def yearsValue: Option[Years] =
      scala.Option(impl.years()).map(value => value: Years)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DefaultRetention
  ): io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly = new Wrapper(
    impl
  )
}
