package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Quiet
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Delete(
    objects: Iterable[io.github.vigoo.zioaws.s3.model.ObjectIdentifier],
    quiet: Option[Quiet] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Delete = {
    import Delete.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Delete
      .builder()
      .objects(objects.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(quiet.map(value => value: java.lang.Boolean))(_.quiet)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Delete.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Delete.wrap(buildAwsValue())
}
object Delete {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Delete] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Delete =
      io.github.vigoo.zioaws.s3.model.Delete(
        objectsValue.map { item =>
          item.editable
        },
        quietValue.map(value => value)
      )
    def objectsValue
        : List[io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly]
    def quietValue: Option[Quiet]
    def objects: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly
    ]] = ZIO.succeed(objectsValue)
    def quiet: ZIO[Any, AwsError, Quiet] =
      AwsError.unwrapOptionField("quiet", quietValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Delete)
      extends io.github.vigoo.zioaws.s3.model.Delete.ReadOnly {
    override def objectsValue
        : List[io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly] = impl
      .objects()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.ObjectIdentifier.wrap(item)
      }
      .toList
    override def quietValue: Option[Quiet] =
      scala.Option(impl.quiet()).map(value => value: Quiet)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Delete
  ): io.github.vigoo.zioaws.s3.model.Delete.ReadOnly = new Wrapper(impl)
}
