package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  IntelligentTieringId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteBucketIntelligentTieringConfigurationRequest(
    bucket: BucketName,
    id: IntelligentTieringId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest = {
    import DeleteBucketIntelligentTieringConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketIntelligentTieringConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest =
      io.github.vigoo.zioaws.s3.model
        .DeleteBucketIntelligentTieringConfigurationRequest(
          bucketValue,
          idValue
        )
    def bucketValue: BucketName
    def idValue: IntelligentTieringId
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(idValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: IntelligentTieringId = impl.id(): IntelligentTieringId
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketIntelligentTieringConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteBucketIntelligentTieringConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
