package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  InventoryId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeleteBucketInventoryConfigurationRequest(
    bucket: BucketName,
    id: InventoryId,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest = {
    import DeleteBucketInventoryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteBucketInventoryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest(
        bucketValue,
        idValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: InventoryId
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(idValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: InventoryId = impl.id(): InventoryId
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.DeleteBucketInventoryConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.DeleteBucketInventoryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
